/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome.layers;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.ConfigProvider;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.generator.biome.ArraysCache;
import com.pg85.otg.generator.biome.layers.Layer;
import com.pg85.otg.util.minecraftTypes.DefaultBiome;

public class LayerMix
extends Layer {
    private ConfigProvider configs;
    private int[] riverBiomes;

    public LayerMix(long seed, Layer childLayer, ConfigProvider configs, LocalWorld world) {
        super(seed);
        this.child = childLayer;
        this.configs = configs;
        this.riverBiomes = new int[world.getMaxBiomesCount()];
        for (int id = 0; id < this.riverBiomes.length; ++id) {
            LocalBiome biome;
            LocalBiome localBiome = biome = OTG.isForge ? OTG.getBiomeAllWorlds(id) : configs.getBiomeByIdOrNull(id);
            if (biome == null || biome.getBiomeConfig().riverBiome.isEmpty()) {
                this.riverBiomes[id] = -1;
                continue;
            }
            LocalBiome riverBiome = OTG.isForge ? OTG.getBiomeAllWorlds(biome.getBiomeConfig().riverBiome) : world.getBiomeByNameOrNull(biome.getBiomeConfig().riverBiome);
            this.riverBiomes[id] = riverBiome.getIds().getGenerationId();
        }
    }

    @Override
    public int[] getInts(ArraysCache cache, int x, int z, int xSize, int zSize) {
        switch (cache.outputType) {
            case FULL: {
                return this.getFull(cache, x, z, xSize, zSize);
            }
            case WITHOUT_RIVERS: {
                return this.getWithoutRivers(cache, x, z, xSize, zSize);
            }
            case ONLY_RIVERS: {
                return this.getOnlyRivers(cache, x, z, xSize, zSize);
            }
        }
        throw new UnsupportedOperationException("Unknown/invalid output type: " + (Object)((Object)cache.outputType));
    }

    private int[] getFull(ArraysCache cache, int x, int z, int xSize, int zSize) {
        int[] childInts = this.child.getInts(cache, x, z, xSize, zSize);
        int[] thisInts = cache.getArray(xSize * zSize);
        WorldConfig worldConfig = this.configs.getWorldConfig();
        for (int zi = 0; zi < zSize; ++zi) {
            for (int xi = 0; xi < xSize; ++xi) {
                int currentPiece = childInts[xi + zi * xSize];
                int cachedId = (currentPiece & 0x400) != 0 ? currentPiece & 0x3FF : (worldConfig.FrozenOcean && (currentPiece & 0x1000) != 0 ? DefaultBiome.FROZEN_OCEAN.Id : DefaultBiome.OCEAN.Id);
                LocalBiome biome = OTG.isForge ? OTG.getBiomeAllWorlds(cachedId) : this.configs.getBiomeByIdOrNull(cachedId);
                currentPiece = worldConfig.riversEnabled && (currentPiece & 0x300000) != 0 && !biome.getBiomeConfig().riverBiome.isEmpty() ? this.riverBiomes[cachedId] : cachedId;
                thisInts[xi + zi * xSize] = currentPiece;
            }
        }
        return thisInts;
    }

    private int[] getWithoutRivers(ArraysCache cache, int x, int z, int xSize, int zSize) {
        int[] childInts = this.child.getInts(cache, x, z, xSize, zSize);
        int[] thisInts = cache.getArray(xSize * zSize);
        WorldConfig worldConfig = this.configs.getWorldConfig();
        for (int zi = 0; zi < zSize; ++zi) {
            for (int xi = 0; xi < xSize; ++xi) {
                int currentPiece = childInts[xi + zi * xSize];
                int cachedId = (currentPiece & 0x400) != 0 ? currentPiece & 0x3FF : (worldConfig.FrozenOcean && (currentPiece & 0x1000) != 0 ? DefaultBiome.FROZEN_OCEAN.Id : DefaultBiome.OCEAN.Id);
                thisInts[xi + zi * xSize] = currentPiece = cachedId;
            }
        }
        return thisInts;
    }

    private int[] getOnlyRivers(ArraysCache cache, int x, int z, int xSize, int zSize) {
        int[] childInts = this.child.getInts(cache, x, z, xSize, zSize);
        int[] thisInts = cache.getArray(xSize * zSize);
        WorldConfig worldConfig = this.configs.getWorldConfig();
        for (int zi = 0; zi < zSize; ++zi) {
            for (int xi = 0; xi < xSize; ++xi) {
                int currentPiece = childInts[xi + zi * xSize];
                int cachedId = (currentPiece & 0x400) != 0 ? currentPiece & 0x3FF : (worldConfig.FrozenOcean && (currentPiece & 0x1000) != 0 ? DefaultBiome.FROZEN_OCEAN.Id : DefaultBiome.OCEAN.Id);
                LocalBiome biome = OTG.isForge ? OTG.getBiomeAllWorlds(cachedId) : this.configs.getBiomeByIdOrNull(cachedId);
                currentPiece = worldConfig.riversEnabled && (currentPiece & 0x300000) != 0 && !biome.getBiomeConfig().riverBiome.isEmpty() ? 1 : 0;
                thisInts[xi + zi * xSize] = currentPiece;
            }
        }
        return thisInts;
    }
}

