/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.util;

import com.pg85.otg.OTG;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.generator.OTGBiome;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraftforge.common.DimensionManager;

public abstract class WorldHelper {
    public static boolean isVanillaWorld(World world) {
        int dimensionId = world.field_73011_w.getDimension();
        return dimensionId == 0 || dimensionId == 1 || dimensionId == -1;
    }

    public static int getGenerationId(Biome biomeBase) {
        if (biomeBase instanceof OTGBiome) {
            return ((OTGBiome)biomeBase).generationId;
        }
        return ((ForgeEngine)OTG.getEngine()).getBiomeRegistryId(biomeBase);
    }

    public static String getName(World world) {
        if (world.field_73011_w.getDimension() > 1 && (world.func_72912_H() instanceof DerivedWorldInfo && ((DerivedWorldInfo)world.func_72912_H()).field_76115_a.func_82571_y().equals("OpenTerrainGenerator") || world.func_72912_H().func_82571_y().equals("OpenTerrainGenerator"))) {
            return DimensionManager.getProviderType((int)world.field_73011_w.getDimension()).func_186065_b();
        }
        WorldServer defaultWorld = DimensionManager.getWorld((int)0);
        if (WorldHelper.isVanillaWorld(world) || defaultWorld != null && world.func_72912_H() != null && world.func_72860_G() != defaultWorld.func_72860_G()) {
            return world.func_72912_H().func_76065_j();
        }
        return world.field_73011_w.getSaveFolder();
    }

    private WorldHelper() {
    }
}

