/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.util;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.WeightedMobSpawnGroup;
import com.pg85.otg.configuration.standard.MojangSettings;
import com.pg85.otg.logging.LogMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class MobSpawnGroupHelper {
    private static EnumCreatureType toEnumCreatureType(MojangSettings.EntityCategory type) {
        switch (type) {
            case MONSTER: {
                return EnumCreatureType.MONSTER;
            }
            case CREATURE: {
                return EnumCreatureType.CREATURE;
            }
            case AMBIENT_CREATURE: {
                return EnumCreatureType.AMBIENT;
            }
            case WATER_CREATURE: {
                return EnumCreatureType.WATER_CREATURE;
            }
        }
        throw new AssertionError((Object)("Unknown mob type: " + (Object)((Object)type)));
    }

    private static WeightedMobSpawnGroup fromMinecraftGroup(Biome.SpawnListEntry biomeMeta) {
        String mobName = MobSpawnGroupHelper.fromMinecraftClass(biomeMeta.field_76300_b);
        if (mobName == null) {
            return null;
        }
        return new WeightedMobSpawnGroup(mobName, biomeMeta.field_76292_a, biomeMeta.field_76301_c, biomeMeta.field_76299_d);
    }

    public static List<WeightedMobSpawnGroup> getListFromMinecraftBiome(Biome biome, MojangSettings.EntityCategory type) {
        List mobList = biome.func_76747_a(MobSpawnGroupHelper.toEnumCreatureType(type));
        return MobSpawnGroupHelper.fromMinecraftList(mobList);
    }

    static List<WeightedMobSpawnGroup> fromMinecraftList(Collection<Biome.SpawnListEntry> biomeMetas) {
        ArrayList<WeightedMobSpawnGroup> result = new ArrayList<WeightedMobSpawnGroup>();
        for (Biome.SpawnListEntry meta : biomeMetas) {
            WeightedMobSpawnGroup wMSG = MobSpawnGroupHelper.fromMinecraftGroup(meta);
            if (wMSG == null) continue;
            result.add(wMSG);
        }
        return result;
    }

    public static List<Biome.SpawnListEntry> toMinecraftlist(Collection<WeightedMobSpawnGroup> weightedMobSpawnGroups) {
        ArrayList<Biome.SpawnListEntry> biomeList = new ArrayList<Biome.SpawnListEntry>();
        for (WeightedMobSpawnGroup mobGroup : weightedMobSpawnGroups) {
            Class<? extends EntityLiving> entityClass = MobSpawnGroupHelper.toMinecraftClass(mobGroup.getInternalName());
            if (entityClass != null) {
                biomeList.add(new Biome.SpawnListEntry(entityClass, mobGroup.getWeight(), mobGroup.getMin(), mobGroup.getMax()));
                continue;
            }
            entityClass = MobSpawnGroupHelper.getEntityByClassName(mobGroup.getInternalName());
            if (entityClass != null || !OTG.getPluginConfig().SpawnLog) continue;
            OTG.log(LogMarker.WARN, "Mob type {} not found", mobGroup.getInternalName());
        }
        return biomeList;
    }

    private static Class<? extends EntityLiving> getEntityByClassName(String mobClassName) {
        List entityClasses = ForgeRegistries.ENTITIES.getValues();
        Class mob = null;
        for (EntityEntry entityClass : entityClasses) {
            String entityName = entityClass.getEntityClass().getSimpleName();
            if (!entityName.toLowerCase().trim().replace("entity", "").replace("_", "").replace(" ", "").equals(mobClassName.toLowerCase().trim().replace("entity", "").replace("_", "").replace(" ", ""))) continue;
            mob = entityClass.getEntityClass();
            break;
        }
        return mob;
    }

    public static Class<? extends EntityLiving> toMinecraftClass(String mobName) {
        Set mobNames = EntityList.func_180124_b();
        Class mob = null;
        for (ResourceLocation mobName1 : mobNames) {
            if (!mobName1.func_110623_a().toLowerCase().trim().replace("entity", "").replace("_", "").replace(" ", "").equals(mobName.toLowerCase().trim().replace("entity", "").replace("_", "").replace(" ", ""))) continue;
            mob = EntityList.getClass((ResourceLocation)mobName1);
            break;
        }
        if (mob == null) {
            mob = MobSpawnGroupHelper.getEntityByClassName(mobName);
        }
        return mob;
    }

    private static String fromMinecraftClass(Class<? extends Entity> entityClass) {
        ResourceLocation mobName = EntityList.func_191306_a(entityClass);
        if (mobName != null) {
            return mobName.func_110623_a();
        }
        OTG.log(LogMarker.DEBUG, "No EntityRegistry entry found for class: " + entityClass, new Object[0]);
        return null;
    }
}

