/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network;

import com.pg85.otg.forge.network.DimensionSyncPacket;
import com.pg85.otg.forge.network.ParticlesPacket;
import java.lang.reflect.Field;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetworkManager;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDispatcher {
    private static byte packetId = 0;
    private static final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("openterraingenerator");

    public static final void registerPackets() {
        PacketDispatcher.registerMessage(DimensionSyncPacket.Handler.class, DimensionSyncPacket.class, Side.CLIENT);
        PacketDispatcher.registerMessage(ParticlesPacket.Handler.class, ParticlesPacket.class, Side.CLIENT);
    }

    private static final void registerMessage(Class handlerClass, Class messageClass, Side side) {
        byte by = packetId;
        packetId = (byte)(by + 1);
        dispatcher.registerMessage(handlerClass, messageClass, (int)by, side);
    }

    public static final void sendTo(IMessage message, NetworkManager manager) {
        EnumMap channels = null;
        try {
            Field[] fields;
            for (Field field : fields = SimpleNetworkWrapper.class.getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(EnumMap.class)) continue;
                field.setAccessible(true);
                channels = (EnumMap)field.get(dispatcher);
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (channels == null) {
            throw new RuntimeException();
        }
        ((FMLEmbeddedChannel)channels.get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DISPATCHER);
        ((FMLEmbeddedChannel)channels.get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(manager.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
        ((FMLEmbeddedChannel)channels.get(Side.SERVER)).writeOutbound(new Object[]{message});
    }

    public static final void sendTo(IMessage message, EntityPlayerMP player) {
        dispatcher.sendTo(message, player);
    }

    public static final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        dispatcher.sendToAllAround(message, point);
    }

    public static final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketDispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        PacketDispatcher.sendToAllAround(message, player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static final void sendToDimension(IMessage message, int dimensionId) {
        dispatcher.sendToDimension(message, dimensionId);
    }

    public static final void sendToServer(IMessage message) {
        dispatcher.sendToServer(message);
    }
}

