/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator.structure;

import com.google.common.base.Preconditions;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.generator.SpawnableObject;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public final class MojangStructurePart
implements SpawnableObject {
    private final Template spawnObject;
    private final String name;

    public MojangStructurePart(String name, Template spawnObject) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)spawnObject, (Object)"spawnObject");
        this.name = name;
        this.spawnObject = spawnObject;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, com.pg85.otg.util.Rotation rotation, int x, int y, int z) {
        World worldMc = ((ForgeWorld)world).getWorld();
        BlockPos blockPos = new BlockPos(x, y, z);
        Rotation rotationMc = this.toMinecraftRotation(rotation);
        PlacementSettings spawnSettings = new PlacementSettings().func_186220_a(rotationMc).func_186218_a(new ChunkPos(blockPos));
        this.spawnObject.func_186253_b(worldMc, blockPos, spawnSettings);
        return true;
    }

    private Rotation toMinecraftRotation(com.pg85.otg.util.Rotation rotation) {
        switch (rotation) {
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case NORTH: {
                return Rotation.NONE;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException("Unknown rotation: " + (Object)((Object)rotation));
    }

    @Override
    public String getName() {
        return this.name;
    }
}

