/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.OTG;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.dimensions.OTGTeleporter;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.NamedBinaryTag;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class Cartographer {
    public static int CartographerDimension = 0;
    static long lastUpdateTime = System.currentTimeMillis();
    static Long2ObjectMap<Teleporter.PortalPosition> destinationCoordinateCache = null;

    public static void UpdateWorldMap() {
        WorldServer worldServer = DimensionManager.getWorld((int)0);
        if (((ForgeEngine)OTG.getEngine()).getCartographerEnabled() && worldServer.func_72912_H().func_82571_y().equals("OpenTerrainGenerator") && System.currentTimeMillis() - lastUpdateTime > 1000L) {
            destinationCoordinateCache = null;
            ForgeWorld world = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld((World)worldServer);
            ForgeWorld cartographerWorld = (ForgeWorld)OTG.getWorld("DIM-Cartographer");
            if (cartographerWorld == null) {
                DimensionManager.initDimension((int)CartographerDimension);
                cartographerWorld = (ForgeWorld)OTG.getWorld("DIM-Cartographer");
            }
            if (cartographerWorld == null) {
                throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
            }
            if (world == null || cartographerWorld == null || cartographerWorld == world) {
                return;
            }
            lastUpdateTime = System.currentTimeMillis();
            Long2ObjectMap<Teleporter.PortalPosition> destinationCoordinateCache = Cartographer.getPortals();
            for (Teleporter.PortalPosition portalPos : destinationCoordinateCache.values()) {
                portalPos.field_85087_d = worldServer.func_82737_E();
            }
            BlockPos spawnPoint = world.getSpawnPoint();
            BlockPos cartographerSpawnPoint = cartographerWorld.getSpawnPoint();
            ChunkCoordinate spawnChunk = ChunkCoordinate.fromBlockCoords(spawnPoint.func_177958_n(), spawnPoint.func_177952_p());
            HashMap entitiesPerBlock = new HashMap();
            for (Entity entity : cartographerWorld.getWorld().func_175644_a(Entity.class, EntitySelectors.field_180132_d)) {
                if (entity instanceof EntityEnderPearl || !(entity instanceof EntityAreaEffectCloud) && !(entity instanceof EntityItem) && !(entity instanceof EntityLiving) && !(entity instanceof EntityArrow) && !(entity instanceof EntityFireball) && !(entity instanceof EntityBoat) && !(entity instanceof EntityMinecart) && !(entity instanceof EntityFireworkRocket) && !(entity instanceof EntityThrowable) && !(entity instanceof EntityTNTPrimed) && !(entity instanceof EntityShulkerBullet) && !(entity instanceof EntityXPOrb)) continue;
                ChunkCoordinate chunkCoord1 = ChunkCoordinate.fromChunkCoords(entity.func_180425_c().func_177958_n() - cartographerSpawnPoint.func_177958_n(), entity.func_180425_c().func_177952_p() - cartographerSpawnPoint.func_177952_p());
                if (entitiesPerBlock.containsKey(chunkCoord1)) {
                    ((ArrayList)entitiesPerBlock.get(chunkCoord1)).add(entity);
                    continue;
                }
                ArrayList<Entity> items = new ArrayList<Entity>();
                items.add(entity);
                entitiesPerBlock.put(chunkCoord1, items);
            }
            ArrayList<ChunkCoordinate> chunksDone = new ArrayList<ChunkCoordinate>();
            int minDist = world.getWorld().func_73046_m().func_184103_al().func_72395_o();
            for (int x = -minDist; x < minDist; ++x) {
                for (int z = -minDist; z < minDist; ++z) {
                    ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(x, z);
                    if (chunksDone.contains(chunkCoord)) continue;
                    ArrayList entities = (ArrayList)entitiesPerBlock.get(chunkCoord);
                    chunksDone.add(chunkCoord);
                    if (entities == null) continue;
                    Cartographer.TeleportEntityFromMap(cartographerWorld, entities, true);
                }
            }
            minDist = 2;
            for (Teleporter.PortalPosition portalPos : destinationCoordinateCache.values()) {
                ChunkCoordinate portalChunk = ChunkCoordinate.fromBlockCoords(portalPos.func_177958_n() - spawnPoint.func_177958_n(), portalPos.func_177952_p() - spawnPoint.func_177952_p());
                for (int x = portalChunk.getChunkX() - minDist; x < portalChunk.getChunkX() + minDist; ++x) {
                    for (int z = portalChunk.getChunkZ() - minDist; z < portalChunk.getChunkZ() + minDist; ++z) {
                        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(x, z);
                        if (chunksDone.contains(chunkCoord)) continue;
                        ArrayList entities = (ArrayList)entitiesPerBlock.get(chunkCoord);
                        chunksDone.add(chunkCoord);
                        if (entities == null) continue;
                        Cartographer.TeleportEntityFromMap(cartographerWorld, entities, true);
                    }
                }
            }
            int viewDist = world.getWorld().func_73046_m().func_184103_al().func_72395_o();
            ArrayList<ChunkCoordinate> chunksDonePlayers = new ArrayList<ChunkCoordinate>();
            for (EntityPlayer player : world.getWorld().field_73010_i) {
                if (player.field_71093_bK != 0) continue;
                ChunkCoordinate playerChunk = ChunkCoordinate.fromBlockCoords((int)Math.floor(player.field_70165_t) - spawnPoint.func_177958_n(), (int)Math.floor(player.field_70161_v) - spawnPoint.func_177952_p());
                for (int x = playerChunk.getChunkX() - viewDist; x < playerChunk.getChunkX() + viewDist; ++x) {
                    for (int z = playerChunk.getChunkZ() - viewDist; z < playerChunk.getChunkZ() + viewDist; ++z) {
                        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(x, z);
                        if (chunksDonePlayers.contains(chunkCoord)) continue;
                        if (!chunksDone.contains(chunkCoord)) {
                            ArrayList entities = (ArrayList)entitiesPerBlock.get(chunkCoord);
                            chunksDone.add(chunkCoord);
                            if (entities != null) {
                                Cartographer.TeleportEntityFromMap(cartographerWorld, entities, true);
                            }
                        }
                        chunksDonePlayers.add(chunkCoord);
                        ChunkCoordinate realChunkCoord = ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + spawnChunk.getChunkX(), chunkCoord.getChunkZ() + spawnChunk.getChunkZ());
                        if (!worldServer.func_72863_F().func_73149_a(realChunkCoord.getChunkX(), realChunkCoord.getChunkZ()) || !worldServer.func_72863_F().func_186025_d(realChunkCoord.getChunkX(), realChunkCoord.getChunkZ()).func_177419_t()) continue;
                        Cartographer.CreateBlockWorldMapAtSpawn(realChunkCoord, false);
                    }
                }
            }
            Object var3_3 = null;
        }
    }

    public static boolean TeleportPlayerFromMap(EntityPlayer player) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        entities.add((Entity)player);
        ForgeWorld cartographerWorld = (ForgeWorld)OTG.getWorld("DIM-Cartographer");
        if (cartographerWorld == null) {
            DimensionManager.initDimension((int)CartographerDimension);
            cartographerWorld = (ForgeWorld)OTG.getWorld("DIM-Cartographer");
        }
        if (cartographerWorld == null) {
            throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
        }
        return Cartographer.TeleportEntityFromMap(cartographerWorld, entities, false);
    }

    private static Long2ObjectMap<Teleporter.PortalPosition> getPortals() {
        if (destinationCoordinateCache == null) {
            MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer worldserver1 = mcServer.func_71218_a(0);
            try {
                Field[] fields;
                for (Field field : fields = worldserver1.func_85176_s().getClass().getDeclaredFields()) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(Long2ObjectMap.class)) continue;
                    field.setAccessible(true);
                    destinationCoordinateCache = (Long2ObjectMap)field.get(worldserver1.func_85176_s());
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return destinationCoordinateCache;
    }

    private static boolean TeleportEntityFromMap(ForgeWorld cartographerworld, ArrayList<Entity> entities, boolean excludePlayers) {
        int zDiff;
        Entity entity = entities.get(0);
        WorldServer overWorldServer = DimensionManager.getWorld((int)0);
        if (!overWorldServer.func_72912_H().func_82571_y().equals("OpenTerrainGenerator")) {
            return false;
        }
        ForgeWorld overWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld((World)overWorldServer);
        BlockPos spawnPoint = overWorld.getSpawnPoint();
        ChunkCoordinate spawnChunk = ChunkCoordinate.fromBlockCoords(spawnPoint.func_177958_n(), spawnPoint.func_177952_p());
        BlockPos cartographerSpawnPoint = cartographerworld.getSpawnPoint();
        ChunkCoordinate destinationChunk = ChunkCoordinate.fromChunkCoords((int)Math.floor(entity.field_70165_t) - cartographerSpawnPoint.func_177958_n() + spawnChunk.getChunkX(), (int)Math.floor(entity.field_70161_v) - cartographerSpawnPoint.func_177952_p() + spawnChunk.getChunkZ());
        int newX = destinationChunk.getBlockXCenter();
        int newZ = destinationChunk.getBlockZCenter();
        int minDistSq = overWorld.getWorld().func_73046_m().func_184103_al().func_72395_o() * overWorld.getWorld().func_73046_m().func_184103_al().func_72395_o();
        int xDiff = destinationChunk.getChunkX() - spawnChunk.getChunkX();
        float distInChunksSq = xDiff * xDiff + (zDiff = destinationChunk.getChunkZ() - spawnChunk.getChunkZ()) * zDiff;
        if (distInChunksSq <= (float)minDistSq) {
            for (Entity entityToTeleport : entities) {
                if (entityToTeleport instanceof EntityPlayer && !entityToTeleport.field_70133_I && (!(entityToTeleport instanceof EntityPlayer) || excludePlayers)) continue;
                int newY = overWorld.getHighestBlockYAt(newX, newZ);
                entity.func_70634_a((double)newX, (double)newY, (double)newZ);
                if (entity instanceof EntityPlayerMP) {
                    OTGTeleporter.changeDimension(0, (EntityPlayerMP)entity);
                    continue;
                }
                OTGTeleporter.changeDimension(0, entity);
            }
            return true;
        }
        boolean portalInRange = false;
        boolean portalInChunk = false;
        Long2ObjectMap<Teleporter.PortalPosition> destinationCoordinateCache = Cartographer.getPortals();
        minDistSq = 4;
        for (Teleporter.PortalPosition portalPos : destinationCoordinateCache.values()) {
            ChunkCoordinate portalChunk = ChunkCoordinate.fromBlockCoords(portalPos.func_177958_n(), portalPos.func_177952_p());
            xDiff = destinationChunk.getChunkX() - portalChunk.getChunkX();
            zDiff = destinationChunk.getChunkZ() - portalChunk.getChunkZ();
            distInChunksSq = xDiff * xDiff + zDiff * zDiff;
            if (portalInRange || distInChunksSq <= (float)minDistSq) {
                portalInRange = true;
                break;
            }
            if (!portalChunk.equals(destinationChunk)) continue;
            portalInChunk = true;
            break;
        }
        if (portalInRange || portalInChunk) {
            int newY = overWorld.getHighestBlockYAt(newX, newZ);
            entity.func_70634_a((double)newX, (double)newY, (double)newZ);
            if (entity instanceof EntityPlayerMP) {
                OTGTeleporter.changeDimension(0, (EntityPlayerMP)entity);
            } else {
                OTGTeleporter.changeDimension(0, entity);
            }
            return true;
        }
        minDistSq = overWorld.getWorld().func_73046_m().func_184103_al().func_72395_o() * overWorld.getWorld().func_73046_m().func_184103_al().func_72395_o();
        boolean playerInRange = false;
        ArrayList<EntityPlayer> playersInChunk = new ArrayList<EntityPlayer>();
        for (EntityPlayer player : overWorld.getWorld().field_73010_i) {
            ChunkCoordinate playerChunk = ChunkCoordinate.fromBlockCoords((int)player.field_70165_t, (int)player.field_70161_v);
            xDiff = destinationChunk.getChunkX() - playerChunk.getChunkX();
            zDiff = destinationChunk.getChunkZ() - playerChunk.getChunkZ();
            distInChunksSq = xDiff * xDiff + zDiff * zDiff;
            if (playerInRange || distInChunksSq <= (float)minDistSq) {
                playerInRange = true;
                break;
            }
            if (!playerChunk.equals(destinationChunk)) continue;
            playersInChunk.add(player);
            break;
        }
        if (portalInRange || portalInChunk) {
            int newY = overWorld.getHighestBlockYAt(newX, newZ);
            entity.func_70634_a((double)newX, (double)newY, (double)newZ);
            if (entity instanceof EntityPlayerMP) {
                OTGTeleporter.changeDimension(0, (EntityPlayerMP)entity);
            } else {
                OTGTeleporter.changeDimension(0, entity);
            }
            return true;
        }
        return false;
    }

    public static void CreateBlockWorldMapAtSpawn(ChunkCoordinate chunkCoord, boolean unloading) {
        WorldServer worldServer = DimensionManager.getWorld((int)0);
        if (worldServer.func_72912_H().func_82571_y().equals("OpenTerrainGenerator")) {
            NamedBinaryTag tag;
            int zDiff;
            int highestBlockY;
            ForgeWorld world = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld((World)worldServer);
            ForgeWorld cartographerWorld = (ForgeWorld)OTG.getWorld("DIM-Cartographer");
            if (cartographerWorld == null) {
                DimensionManager.initDimension((int)CartographerDimension);
                cartographerWorld = (ForgeWorld)OTG.getWorld("DIM-Cartographer");
            }
            if (cartographerWorld == null) {
                throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
            }
            if (world == null || cartographerWorld == null || world == cartographerWorld) {
                return;
            }
            DefaultMaterial replaceByMaterial = DefaultMaterial.STAINED_CLAY;
            BlockPos spawnPoint = world.getSpawnPoint();
            ChunkCoordinate spawnChunk = ChunkCoordinate.fromBlockCoords(spawnPoint.func_177958_n(), spawnPoint.func_177952_p());
            BlockPos spawnPointCartographer = cartographerWorld.getSpawnPoint();
            int newX = spawnPointCartographer.func_177958_n() + (chunkCoord.getChunkX() - spawnChunk.getChunkX());
            int newZ = spawnPointCartographer.func_177952_p() + (chunkCoord.getChunkZ() - spawnChunk.getChunkZ());
            LocalMaterialData material = null;
            LocalMaterialData topMaterial = null;
            int baseHeight = spawnPoint.func_177956_o();
            int minY = baseHeight - (int)Math.floor((double)spawnPoint.func_177956_o() / 16.0);
            int maxY = baseHeight + (int)Math.floor((double)(255 - spawnPoint.func_177956_o()) / 16.0);
            for (highestBlockY = world.getHighestBlockYAt(chunkCoord.getBlockXCenter(), chunkCoord.getBlockZCenter()); material == null && highestBlockY >= 0; --highestBlockY) {
                LocalMaterialData materialToReplace = world.getMaterial(chunkCoord.getBlockXCenter(), highestBlockY, chunkCoord.getBlockZCenter(), true);
                DefaultMaterial replaceByMaterialTop = replaceByMaterial;
                if (materialToReplace != null) {
                    DefaultMaterial defaultMaterialToReplace = materialToReplace.toDefaultMaterial();
                    if (defaultMaterialToReplace.equals((Object)DefaultMaterial.WATER) || defaultMaterialToReplace.equals((Object)DefaultMaterial.STATIONARY_WATER) || defaultMaterialToReplace.equals((Object)DefaultMaterial.LAVA) || defaultMaterialToReplace.equals((Object)DefaultMaterial.STATIONARY_LAVA) || defaultMaterialToReplace.equals((Object)DefaultMaterial.MAGMA) || defaultMaterialToReplace.equals((Object)DefaultMaterial.ICE) || defaultMaterialToReplace.equals((Object)DefaultMaterial.FIRE)) {
                        replaceByMaterialTop = DefaultMaterial.STAINED_GLASS;
                    }
                    if (defaultMaterialToReplace.equals((Object)DefaultMaterial.LEAVES) || defaultMaterialToReplace.equals((Object)DefaultMaterial.LEAVES_2) || defaultMaterialToReplace.equals((Object)DefaultMaterial.LOG) || defaultMaterialToReplace.equals((Object)DefaultMaterial.LOG_2) || defaultMaterialToReplace.equals((Object)DefaultMaterial.WOOD) || defaultMaterialToReplace.equals((Object)DefaultMaterial.WOOD_DOUBLE_STEP) || defaultMaterialToReplace.equals((Object)DefaultMaterial.WOOD_STEP) || defaultMaterialToReplace.equals((Object)DefaultMaterial.SPRUCE_WOOD_STAIRS) || defaultMaterialToReplace.equals((Object)DefaultMaterial.BIRCH_WOOD_STAIRS) || defaultMaterialToReplace.equals((Object)DefaultMaterial.JUNGLE_WOOD_STAIRS) || defaultMaterialToReplace.equals((Object)DefaultMaterial.ACACIA_STAIRS) || defaultMaterialToReplace.equals((Object)DefaultMaterial.DARK_OAK_STAIRS)) {
                        replaceByMaterialTop = DefaultMaterial.WOOL;
                    }
                }
                topMaterial = Cartographer.GetReplaceByMaterial(materialToReplace, replaceByMaterialTop);
                material = Cartographer.GetReplaceByMaterial(materialToReplace, replaceByMaterial);
                if (material == null) continue;
                if (topMaterial != null) break;
                topMaterial = Cartographer.GetReplaceByMaterial(materialToReplace, replaceByMaterialTop);
                break;
            }
            if (highestBlockY < 0) {
                highestBlockY = world.getHighestBlockYAt(chunkCoord.getBlockXCenter(), chunkCoord.getBlockZCenter()) - 1;
                material = OTG.toLocalMaterialData(replaceByMaterial, 15);
            }
            int heightDiff = (int)Math.floor((double)(highestBlockY + 1 - spawnPoint.func_177956_o()) / 16.0);
            int viewDistSq = world.getWorld().func_73046_m().func_184103_al().func_72395_o() * world.getWorld().func_73046_m().func_184103_al().func_72395_o();
            int xDiff = spawnChunk.getChunkX() - chunkCoord.getChunkX();
            float distInChunksSq = xDiff * xDiff + (zDiff = spawnChunk.getChunkZ() - chunkCoord.getChunkZ()) * zDiff;
            boolean spawnInRange = distInChunksSq <= (float)viewDistSq;
            boolean portalInRange = false;
            boolean portalInChunk = false;
            Long2ObjectMap<Teleporter.PortalPosition> destinationCoordinateCache = Cartographer.getPortals();
            int minDistSq = 4;
            for (Teleporter.PortalPosition portalPos : destinationCoordinateCache.values()) {
                ChunkCoordinate portalChunk = ChunkCoordinate.fromBlockCoords(portalPos.func_177958_n(), portalPos.func_177952_p());
                xDiff = portalChunk.getChunkX() - chunkCoord.getChunkX();
                zDiff = portalChunk.getChunkZ() - chunkCoord.getChunkZ();
                distInChunksSq = xDiff * xDiff + zDiff * zDiff;
                if (portalInRange || distInChunksSq <= (float)minDistSq) {
                    portalInRange = true;
                }
                if (!portalChunk.equals(chunkCoord)) continue;
                portalInChunk = true;
                break;
            }
            boolean playerInRange = false;
            ArrayList<EntityPlayer> playersInChunk = new ArrayList<EntityPlayer>();
            for (EntityPlayer player : world.getWorld().field_73010_i) {
                if (player.field_71093_bK != 0) continue;
                ChunkCoordinate playerChunk = ChunkCoordinate.fromChunkCoords(player.field_70176_ah, player.field_70164_aj);
                xDiff = playerChunk.getChunkX() - chunkCoord.getChunkX();
                zDiff = playerChunk.getChunkZ() - chunkCoord.getChunkZ();
                distInChunksSq = xDiff * xDiff + zDiff * zDiff;
                if (playerInRange || distInChunksSq <= (float)viewDistSq) {
                    playerInRange = true;
                }
                if (!playerChunk.equals(chunkCoord)) continue;
                playersInChunk.add(player);
            }
            int newY = baseHeight + heightDiff - minY;
            cartographerWorld.setBlock(newX, newY, newZ, topMaterial, null, true);
            while (newY < maxY - minY) {
                if (!playerInRange && !portalInRange || cartographerWorld.isNullOrAir(newX, ++newY, newZ, true)) continue;
                cartographerWorld.setBlock(newX, newY, newZ, OTG.toLocalMaterialData(DefaultMaterial.AIR, 0), null, true);
            }
            newY = baseHeight + heightDiff - minY;
            while (newY > 0) {
                cartographerWorld.setBlock(newX, --newY, newZ, material, null, true);
            }
            newY = baseHeight + heightDiff + 1 - minY;
            if (chunkCoord.equals(spawnChunk)) {
                tag = new NamedBinaryTag(NamedBinaryTag.Type.TAG_List, "BlockEntityTag", new NamedBinaryTag[]{new NamedBinaryTag(NamedBinaryTag.Type.TAG_Int, "Base", 15)});
                cartographerWorld.setBlock(newX, newY, newZ, OTG.toLocalMaterialData(DefaultMaterial.STANDING_BANNER, 0), tag, true);
            } else if (portalInChunk) {
                tag = new NamedBinaryTag(NamedBinaryTag.Type.TAG_List, "BlockEntityTag", new NamedBinaryTag[]{new NamedBinaryTag(NamedBinaryTag.Type.TAG_Int, "Base", 13)});
                cartographerWorld.setBlock(newX, newY, newZ, OTG.toLocalMaterialData(DefaultMaterial.STANDING_BANNER, 0), tag, true);
            } else if (unloading && !portalInRange && !spawnInRange || !playerInRange && !portalInRange && !spawnInRange) {
                cartographerWorld.setBlock(newX, newY, newZ, OTG.toLocalMaterialData(DefaultMaterial.STAINED_GLASS, 15), null, true);
            }
            if (!unloading && playersInChunk.size() > 0) {
                int playerSignHeightOffset = 0;
                for (EntityPlayer player : playersInChunk) {
                    if ((newY = baseHeight + heightDiff + ++playerSignHeightOffset - minY) + 2 >= maxY - minY || newY < 0) continue;
                    LocalMaterialData playerHead = OTG.toLocalMaterialData(DefaultMaterial.SKULL, 3);
                    String playerHeadName = "MHF_Blaze";
                    NamedBinaryTag tag2 = new NamedBinaryTag(NamedBinaryTag.Type.TAG_List, "BlockEntityTag", new NamedBinaryTag[]{new NamedBinaryTag(NamedBinaryTag.Type.TAG_String, "SkullOwner", playerHeadName), new NamedBinaryTag(NamedBinaryTag.Type.TAG_String, "ExtraType", ""), new NamedBinaryTag(NamedBinaryTag.Type.TAG_Byte, "SkullType", (byte)3)});
                    BlockPos pos = new BlockPos(newX, newY, newZ);
                    cartographerWorld.setBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerHead, tag2, true);
                    cartographerWorld.getWorld().func_180501_a(pos, Blocks.field_150465_bP.func_176223_P().func_177226_a((IProperty)BlockSkull.field_176418_a, (Comparable)EnumFacing.UP), 11);
                    int rotation = MathHelper.func_76128_c((double)((double)((player.field_70177_z - 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
                    TileEntity tileentity = cartographerWorld.getWorld().func_175625_s(pos);
                    TileEntitySkull tileentityskull = (TileEntitySkull)tileentity;
                    tileentityskull.func_145903_a(rotation);
                }
                int rotation = MathHelper.func_76128_c((double)((double)(((EntityPlayer)playersInChunk.get((int)0)).field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
                NamedBinaryTag tag3 = new NamedBinaryTag(NamedBinaryTag.Type.TAG_List, "BlockEntityTag", new NamedBinaryTag[]{new NamedBinaryTag(NamedBinaryTag.Type.TAG_Int, "Base", chunkCoord.equals(spawnChunk) ? 15 : (portalInChunk ? 13 : 10))});
                cartographerWorld.setBlock(newX, baseHeight + heightDiff + playerSignHeightOffset + 1 - minY, newZ, OTG.toLocalMaterialData(DefaultMaterial.STANDING_BANNER, rotation), tag3, true);
            }
        }
    }

    private static LocalMaterialData GetReplaceByMaterial(LocalMaterialData materialToReplace, DefaultMaterial replaceByMaterial) {
        DefaultMaterial[] TransparentBlocks = new DefaultMaterial[]{};
        DefaultMaterial[] WhiteBlocks = new DefaultMaterial[]{DefaultMaterial.SNOW, DefaultMaterial.SNOW_BLOCK, DefaultMaterial.QUARTZ_BLOCK, DefaultMaterial.QUARTZ_STAIRS};
        DefaultMaterial[] OrangeBlocks = new DefaultMaterial[]{DefaultMaterial.FIRE, DefaultMaterial.SAND, DefaultMaterial.RED_SANDSTONE, DefaultMaterial.HARD_CLAY, DefaultMaterial.RED_SANDSTONE_STAIRS};
        DefaultMaterial[] MagentaBlocks = new DefaultMaterial[]{DefaultMaterial.PURPUR_BLOCK, DefaultMaterial.PURPUR_PILLAR, DefaultMaterial.PURPUR_STAIRS, DefaultMaterial.PURPUR_DOUBLE_SLAB, DefaultMaterial.PURPUR_SLAB};
        DefaultMaterial[] LightBlueBlocks = new DefaultMaterial[]{DefaultMaterial.PACKED_ICE};
        DefaultMaterial[] YellowBlocks = new DefaultMaterial[]{DefaultMaterial.SAND, DefaultMaterial.SANDSTONE, DefaultMaterial.SANDSTONE_STAIRS};
        DefaultMaterial[] LimeBlocks = new DefaultMaterial[]{DefaultMaterial.LEAVES, DefaultMaterial.LEAVES_2};
        DefaultMaterial[] PinkBlocks = new DefaultMaterial[]{DefaultMaterial.NETHERRACK, DefaultMaterial.MYCEL};
        DefaultMaterial[] GrayBlocks = new DefaultMaterial[]{DefaultMaterial.COBBLESTONE, DefaultMaterial.COBBLESTONE_STAIRS, DefaultMaterial.MOSSY_COBBLESTONE, DefaultMaterial.STONE_SLAB2, DefaultMaterial.DOUBLE_STONE_SLAB2, DefaultMaterial.STEP, DefaultMaterial.DOUBLE_STEP, DefaultMaterial.BRICK, DefaultMaterial.BRICK_STAIRS, DefaultMaterial.SMOOTH_BRICK, DefaultMaterial.SMOOTH_STAIRS};
        DefaultMaterial[] LightGrayBlocks = new DefaultMaterial[]{DefaultMaterial.STONE, DefaultMaterial.GRAVEL, DefaultMaterial.CLAY, DefaultMaterial.EMERALD_ORE, DefaultMaterial.EMERALD_BLOCK, DefaultMaterial.REDSTONE_ORE, DefaultMaterial.GLOWING_REDSTONE_ORE, DefaultMaterial.DIAMOND_ORE, DefaultMaterial.DIAMOND_BLOCK, DefaultMaterial.GOLD_ORE, DefaultMaterial.IRON_ORE, DefaultMaterial.COAL_ORE, DefaultMaterial.COAL_BLOCK, DefaultMaterial.LAPIS_ORE, DefaultMaterial.LAPIS_BLOCK, DefaultMaterial.GOLD_BLOCK, DefaultMaterial.IRON_BLOCK, DefaultMaterial.REDSTONE_BLOCK, DefaultMaterial.QUARTZ_ORE};
        DefaultMaterial[] CyanBlocks = new DefaultMaterial[]{DefaultMaterial.FROSTED_ICE, DefaultMaterial.ICE};
        DefaultMaterial[] PurpleBlocks = new DefaultMaterial[]{DefaultMaterial.NETHER_BRICK, DefaultMaterial.NETHER_BRICK_STAIRS};
        DefaultMaterial[] BlueBlocks = new DefaultMaterial[]{DefaultMaterial.WATER, DefaultMaterial.STATIONARY_WATER};
        DefaultMaterial[] BrownBlocks = new DefaultMaterial[]{DefaultMaterial.DIRT, DefaultMaterial.WOOD, DefaultMaterial.WOOD_DOUBLE_STEP, DefaultMaterial.WOOD_STEP, DefaultMaterial.SPRUCE_WOOD_STAIRS, DefaultMaterial.BIRCH_WOOD_STAIRS, DefaultMaterial.JUNGLE_WOOD_STAIRS, DefaultMaterial.ACACIA_STAIRS, DefaultMaterial.DARK_OAK_STAIRS, DefaultMaterial.LOG, DefaultMaterial.LOG_2, DefaultMaterial.SOIL, DefaultMaterial.SOUL_SAND, DefaultMaterial.HUGE_MUSHROOM_1, DefaultMaterial.HUGE_MUSHROOM_2};
        DefaultMaterial[] GreenBlocks = new DefaultMaterial[]{DefaultMaterial.GRASS, DefaultMaterial.GRASS_PATH};
        DefaultMaterial[] RedBlocks = new DefaultMaterial[]{DefaultMaterial.LAVA, DefaultMaterial.STATIONARY_LAVA, DefaultMaterial.MAGMA};
        DefaultMaterial[] BlackBlocks = new DefaultMaterial[]{DefaultMaterial.BEDROCK, DefaultMaterial.OBSIDIAN};
        DefaultMaterial[] ColoredBlocks = new DefaultMaterial[]{DefaultMaterial.STAINED_CLAY};
        for (DefaultMaterial replacematerial : TransparentBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(DefaultMaterial.GLASS, 0);
        }
        for (DefaultMaterial replacematerial : WhiteBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 0);
        }
        for (DefaultMaterial replacematerial : OrangeBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial()) || replacematerial.equals((Object)DefaultMaterial.SAND) && materialToReplace.getBlockData() != 1) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 1);
        }
        for (DefaultMaterial replacematerial : MagentaBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 2);
        }
        for (DefaultMaterial replacematerial : LightBlueBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 3);
        }
        for (DefaultMaterial replacematerial : YellowBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 4);
        }
        for (DefaultMaterial replacematerial : LimeBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial()) || replaceByMaterial == DefaultMaterial.WOOL) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 5);
        }
        for (DefaultMaterial replacematerial : PinkBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 6);
        }
        for (DefaultMaterial replacematerial : GrayBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 7);
        }
        for (DefaultMaterial replacematerial : LightGrayBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 8);
        }
        for (DefaultMaterial replacematerial : CyanBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 9);
        }
        for (DefaultMaterial replacematerial : PurpleBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 10);
        }
        for (DefaultMaterial replacematerial : BlueBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 11);
        }
        for (DefaultMaterial replacematerial : BrownBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 12);
        }
        for (DefaultMaterial replacematerial : GreenBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial()) && (replaceByMaterial != DefaultMaterial.WOOL || !materialToReplace.toDefaultMaterial().equals((Object)DefaultMaterial.LEAVES) && !materialToReplace.toDefaultMaterial().equals((Object)DefaultMaterial.LEAVES_2))) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 13);
        }
        for (DefaultMaterial replacematerial : RedBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 14);
        }
        for (DefaultMaterial replacematerial : BlackBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, 15);
        }
        for (DefaultMaterial replacematerial : ColoredBlocks) {
            if (!replacematerial.equals((Object)materialToReplace.toDefaultMaterial())) continue;
            return OTG.toLocalMaterialData(replaceByMaterial, materialToReplace.getBlockData());
        }
        return null;
    }

    public static void CreateCartographerDimension() {
        if (((ForgeEngine)OTG.getEngine()).getCartographerEnabled() && !OTGDimensionManager.isDimensionNameRegistered("DIM-Cartographer")) {
            CartographerDimension = OTGDimensionManager.createDimension("DIM-Cartographer", false, true, false);
            ForgeWorld world = (ForgeWorld)OTG.getWorld("DIM-Cartographer");
            world.getWorld().func_82736_K().func_82764_b("doEntityDrops", "false");
            world.getWorld().func_82736_K().func_82764_b("doFireTick", "false");
            world.getWorld().func_82736_K().func_82764_b("doMobSpawning", "false");
            world.getWorld().func_82736_K().func_82764_b("doTileDrops", "false");
            world.getWorld().func_82736_K().func_82764_b("keepInventory", "true");
            world.getWorld().func_82736_K().func_82764_b("randomTickSpeed", "0");
            world.getWorld().func_82736_K().func_82764_b("spawnRadius", "0");
            world.getWorld().func_82736_K().func_82764_b("doWeatherCycle", "false");
            world.getWorld().func_82736_K().func_82764_b("falldamage", "false");
        }
    }
}

