/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events;

import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.ConfigToNetworkSender;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.dimensions.DimensionData;
import com.pg85.otg.forge.dimensions.OTGDimensionInfo;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.dimensions.WorldProviderOTG;
import com.pg85.otg.forge.network.DimensionSyncPacket;
import com.pg85.otg.forge.network.PacketDispatcher;
import com.pg85.otg.forge.network.ParticlesPacket;
import com.pg85.otg.logging.LogMarker;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShulkerBox;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerTracker {
    @SubscribeEvent
    public void onConnectionCreated(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        ByteBuf nettyBuffer = PlayerTracker.createWorldAndBiomeConfigsPacket();
        if (nettyBuffer != null) {
            PacketDispatcher.sendTo((IMessage)new DimensionSyncPacket(nettyBuffer), event.getManager());
            PacketDispatcher.sendTo((IMessage)new ParticlesPacket(), event.getManager());
        } else {
            OTG.log(LogMarker.WARN, "Could not find an OTG overworld, OTG is disabled. It is currently not possible to use OTG with a non-OTG overworld. To enable OTG make sure that level-type=OTG is configured in the server.properties file.", new Object[0]);
        }
    }

    public static void SendAllWorldAndBiomeConfigsToAllPlayers(MinecraftServer server) {
        ByteBuf nettyBuffer = PlayerTracker.createWorldAndBiomeConfigsPacket();
        if (nettyBuffer != null) {
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                PacketDispatcher.sendTo((IMessage)new DimensionSyncPacket(nettyBuffer), player);
            }
        }
    }

    private static ByteBuf createWorldAndBiomeConfigsPacket() {
        OTGDimensionInfo otgDimData = OTGDimensionManager.GetOrderedDimensionData();
        ByteBuf nettyBuffer = Unpooled.buffer();
        ByteBufOutputStream stream = new ByteBufOutputStream(nettyBuffer);
        try {
            stream.writeInt(5);
            stream.writeInt(0);
            stream.writeInt(otgDimData.orderedDimensions.size() + 1);
            LocalWorld localWorld = ((ForgeEngine)OTG.getEngine()).getOverWorld();
            if (localWorld == null) {
                stream.close();
                return null;
            }
            try {
                stream.writeInt(0);
                ConfigToNetworkSender.writeConfigsToStream(localWorld.getConfigs(), (DataOutput)stream, false);
            }
            catch (IOException e) {
                OTG.printStackTrace(LogMarker.FATAL, e);
            }
            for (int i = 0; i <= otgDimData.highestOrder; ++i) {
                if (!otgDimData.orderedDimensions.containsKey(i)) continue;
                DimensionData dimData = otgDimData.orderedDimensions.get(i);
                localWorld = OTG.getWorld(dimData.dimensionName);
                if (localWorld == null) {
                    localWorld = OTG.getUnloadedWorld(dimData.dimensionName);
                }
                try {
                    stream.writeInt(dimData.dimensionId);
                    ConfigToNetworkSender.writeConfigsToStream(localWorld.getConfigs(), (DataOutput)stream, false);
                    continue;
                }
                catch (IOException e) {
                    OTG.printStackTrace(LogMarker.FATAL, e);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return nettyBuffer;
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            WorldConfig worldConfig;
            if (((WorldProviderOTG)event.player.field_70170_p.field_73011_w).getWelcomeMessage() != null && ((WorldProviderOTG)event.player.field_70170_p.field_73011_w).getWelcomeMessage().trim().length() > 0) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(((WorldProviderOTG)event.player.field_70170_p.field_73011_w).getWelcomeMessage()));
            }
            String itemsToRemoveString = (worldConfig = ((WorldProviderOTG)event.player.field_70170_p.field_73011_w).GetWorldConfig()) != null ? worldConfig.itemsToRemoveOnJoinDimension : WorldStandardValues.ITEMS_TO_REMOVE_ON_JOIN_DIMENSION.getDefaultValue();
            boolean itemsRemoved = this.RemoveItemsFromPlayer(itemsToRemoveString, event.player);
            String itemsToAddString = worldConfig != null ? worldConfig.itemsToAddOnJoinDimension : WorldStandardValues.ITEMS_TO_ADD_ON_JOIN_DIMENSION.getDefaultValue();
            boolean itemsAdded = this.GiveItemsToPlayer(itemsToAddString, event.player);
            if (itemsRemoved) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been removed from your inventory"));
            }
            if (itemsAdded) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been added to your inventory"));
            }
        }
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            WorldConfig worldConfig;
            if (((WorldProviderOTG)event.player.field_70170_p.field_73011_w).getDepartMessage() != null && ((WorldProviderOTG)event.player.field_70170_p.field_73011_w).getDepartMessage().trim().length() > 0) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(((WorldProviderOTG)event.player.field_70170_p.field_73011_w).getDepartMessage()));
            }
            String itemsToRemoveString = (worldConfig = ((WorldProviderOTG)event.player.field_70170_p.field_73011_w).GetWorldConfig()) != null ? worldConfig.itemsToRemoveOnLeaveDimension : WorldStandardValues.ITEMS_TO_REMOVE_ON_LEAVE_DIMENSION.getDefaultValue();
            boolean itemsRemoved = this.RemoveItemsFromPlayer(itemsToRemoveString, event.player);
            String itemsToAddString = worldConfig != null ? worldConfig.itemsToAddOnLeaveDimension : WorldStandardValues.ITEMS_TO_ADD_ON_LEAVE_DIMENSION.getDefaultValue();
            boolean itemsAdded = this.GiveItemsToPlayer(itemsToAddString, event.player);
            if (itemsRemoved) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been removed from your inventory"));
            }
            if (itemsAdded) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been added to your inventory"));
            }
        }
    }

    @SubscribeEvent
    public void playerRespawned(PlayerEvent.PlayerRespawnEvent event) {
        WorldConfig worldConfig;
        String itemsToAddString;
        boolean itemsAdded;
        if (event.player.field_70170_p.field_73011_w instanceof WorldProviderOTG && (itemsAdded = this.GiveItemsToPlayer(itemsToAddString = (worldConfig = ((WorldProviderOTG)event.player.field_70170_p.field_73011_w).GetWorldConfig()) != null ? worldConfig.itemsToAddOnRespawn : WorldStandardValues.ITEMS_TO_ADD_ON_RESPAWN.getDefaultValue(), event.player))) {
            event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been added to your inventory"));
        }
    }

    @SubscribeEvent
    public void playerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        WorldServer fromWorld = DimensionManager.getWorld((int)event.fromDim);
        if (fromWorld != null && fromWorld.field_73011_w instanceof WorldProviderOTG) {
            WorldConfig worldConfig;
            if (((WorldProviderOTG)fromWorld.field_73011_w).getDepartMessage() != null && ((WorldProviderOTG)fromWorld.field_73011_w).getDepartMessage().trim().length() > 0) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(((WorldProviderOTG)fromWorld.field_73011_w).getDepartMessage()));
            }
            String itemsToRemoveString = (worldConfig = ((WorldProviderOTG)fromWorld.field_73011_w).GetWorldConfig()) != null ? worldConfig.itemsToRemoveOnLeaveDimension : WorldStandardValues.ITEMS_TO_REMOVE_ON_LEAVE_DIMENSION.getDefaultValue();
            boolean itemsRemoved = this.RemoveItemsFromPlayer(itemsToRemoveString, event.player);
            String itemsToAddString = worldConfig != null ? worldConfig.itemsToAddOnLeaveDimension : WorldStandardValues.ITEMS_TO_ADD_ON_LEAVE_DIMENSION.getDefaultValue();
            boolean itemsAdded = this.GiveItemsToPlayer(itemsToAddString, event.player);
            if (itemsRemoved) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been removed from your inventory"));
            }
            if (itemsAdded) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been added to your inventory"));
            }
        }
        WorldServer toWorld = DimensionManager.getWorld((int)event.toDim);
        if (toWorld.field_73011_w instanceof WorldProviderOTG) {
            WorldConfig worldConfig;
            if (((WorldProviderOTG)toWorld.field_73011_w).getWelcomeMessage() != null && ((WorldProviderOTG)toWorld.field_73011_w).getWelcomeMessage().trim().length() > 0) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(((WorldProviderOTG)toWorld.field_73011_w).getWelcomeMessage()));
            }
            String itemsToRemoveString = (worldConfig = ((WorldProviderOTG)toWorld.field_73011_w).GetWorldConfig()) != null ? worldConfig.itemsToRemoveOnJoinDimension : WorldStandardValues.ITEMS_TO_REMOVE_ON_JOIN_DIMENSION.getDefaultValue();
            boolean itemsRemoved = this.RemoveItemsFromPlayer(itemsToRemoveString, event.player);
            String itemsToAddString = worldConfig != null ? worldConfig.itemsToAddOnJoinDimension : WorldStandardValues.ITEMS_TO_ADD_ON_JOIN_DIMENSION.getDefaultValue();
            boolean itemsAdded = this.GiveItemsToPlayer(itemsToAddString, event.player);
            if (itemsRemoved) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been removed from your inventory"));
            }
            if (itemsAdded) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been added to your inventory"));
            }
        }
    }

    boolean GiveItemsToPlayer(String itemsToAddString, EntityPlayer player) {
        boolean itemsAdded = false;
        if (itemsToAddString != null && (itemsToAddString = itemsToAddString.trim()).length() > 0) {
            int i;
            if (itemsToAddString.charAt(0) == '[' && itemsToAddString.charAt(itemsToAddString.length() - 1) == ']') {
                itemsToAddString = itemsToAddString.substring(1, itemsToAddString.length() - 1);
            }
            ArrayList<String> params = new ArrayList<String>();
            int paramStartIndex = 0;
            boolean foundParam = false;
            for (i = 0; i < itemsToAddString.length(); ++i) {
                if (itemsToAddString.charAt(i) != '\"') continue;
                if (!foundParam) {
                    paramStartIndex = i;
                    foundParam = true;
                    continue;
                }
                params.add(itemsToAddString.substring(paramStartIndex + 1, i));
                foundParam = false;
            }
            for (i = 0; i < params.size(); i += 4) {
                this.GiveItemToPlayer(player, (String)params.get(i + 0), (String)params.get(i + 1), (String)params.get(i + 2), (String)params.get(i + 3));
                itemsAdded = true;
            }
        }
        return itemsAdded;
    }

    void GiveItemToPlayer(EntityPlayer entityplayer, String itemName, String amountString, String metaDataString, String nbtDataString) {
        boolean flag;
        int amount;
        Item item;
        try {
            item = CommandBase.func_147179_f(null, (String)itemName);
        }
        catch (NumberInvalidException e1) {
            e1.printStackTrace();
            return;
        }
        try {
            amount = CommandBase.func_175764_a((String)amountString, (int)1, (int)item.func_77639_j());
        }
        catch (NumberInvalidException e1) {
            e1.printStackTrace();
            return;
        }
        int meta = 0;
        if (metaDataString != null && metaDataString.length() > 0) {
            try {
                meta = CommandBase.func_175755_a((String)metaDataString);
            }
            catch (NumberInvalidException e1) {
                e1.printStackTrace();
                return;
            }
        }
        ItemStack itemstack = new ItemStack(item, amount, meta);
        if (nbtDataString != null && nbtDataString.length() > 0) {
            try {
                itemstack.func_77982_d(JsonToNBT.func_180713_a((String)nbtDataString));
            }
            catch (NBTException nbtexception) {
                try {
                    throw new CommandException("commands.give.tagError", new Object[]{nbtexception.getMessage()});
                }
                catch (CommandException e) {
                    e.printStackTrace();
                }
            }
        }
        if (flag = entityplayer.field_71071_by.func_70441_a(itemstack)) {
            entityplayer.field_70170_p.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((entityplayer.func_70681_au().nextFloat() - entityplayer.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayer.field_71069_bz.func_75142_b();
        }
        if (flag && itemstack.func_190926_b()) {
            itemstack.func_190920_e(1);
            EntityItem entityitem1 = entityplayer.func_71019_a(itemstack, false);
            if (entityitem1 != null) {
                entityitem1.func_174870_v();
            }
        } else {
            EntityItem entityitem = entityplayer.func_71019_a(itemstack, false);
            if (entityitem != null) {
                entityitem.func_174868_q();
                entityitem.func_145797_a(entityplayer.func_70005_c_());
            }
        }
    }

    boolean RemoveItemsFromPlayer(String itemsToRemoveString, EntityPlayer player) {
        boolean itemsRemoved = false;
        if (itemsToRemoveString != null && (itemsToRemoveString = itemsToRemoveString.trim()).length() > 0) {
            int i;
            if (itemsToRemoveString.charAt(0) == '[' && itemsToRemoveString.charAt(itemsToRemoveString.length() - 1) == ']') {
                itemsToRemoveString = itemsToRemoveString.substring(1, itemsToRemoveString.length() - 1);
            }
            ArrayList<String> params = new ArrayList<String>();
            int paramStartIndex = 0;
            boolean foundParam = false;
            for (i = 0; i < itemsToRemoveString.length(); ++i) {
                if (itemsToRemoveString.charAt(i) != '\"') continue;
                if (!foundParam) {
                    paramStartIndex = i;
                    foundParam = true;
                    continue;
                }
                params.add(itemsToRemoveString.substring(paramStartIndex + 1, i));
                foundParam = false;
            }
            for (i = 0; i < params.size(); i += 4) {
                this.RemoveItemFromPlayer(player, (String)params.get(i + 0), (String)params.get(i + 1), (String)params.get(i + 2), (String)params.get(i + 3));
                itemsRemoved = true;
            }
        }
        return itemsRemoved;
    }

    void RemoveItemFromPlayer(EntityPlayer entityplayer, String itemName, String amountString, String metaDataString, String nbtDataString) {
        int amount;
        Item item;
        try {
            item = CommandBase.func_147179_f(null, (String)itemName);
        }
        catch (NumberInvalidException e1) {
            e1.printStackTrace();
            return;
        }
        try {
            amount = CommandBase.func_175764_a((String)amountString, (int)-1, (int)item.func_77639_j());
        }
        catch (NumberInvalidException e1) {
            e1.printStackTrace();
            return;
        }
        int meta = 0;
        if (metaDataString != null && metaDataString.length() > 0) {
            try {
                meta = CommandBase.func_175755_a((String)metaDataString);
            }
            catch (NumberInvalidException e1) {
                e1.printStackTrace();
                return;
            }
        }
        NBTTagCompound nbtTagCompound = null;
        if (nbtDataString != null && nbtDataString.length() > 0) {
            try {
                nbtTagCompound = JsonToNBT.func_180713_a((String)nbtDataString);
            }
            catch (NBTException nbtexception) {
                try {
                    throw new CommandException("commands.give.tagError", new Object[]{nbtexception.getMessage()});
                }
                catch (CommandException e) {
                    e.printStackTrace();
                }
            }
        }
        int amountRemoved = this.clearMatchingItems(entityplayer.field_71071_by, item, meta, amount, nbtTagCompound);
        if (amount == -1 || amountRemoved < amount) {
            amountRemoved += this.clearMatchingItemsEnderChest(entityplayer.func_71005_bN(), item, meta, amount, nbtTagCompound);
        }
    }

    int clearMatchingItems(InventoryPlayer _this, @Nullable Item itemIn, int metadataIn, int removeCount, @Nullable NBTTagCompound itemNBT) {
        int i = 0;
        for (int j = 0; j < _this.func_70302_i_(); ++j) {
            NBTTagCompound BlockEntityTag;
            NBTTagList itemsTag;
            ItemStack itemstack = _this.func_70301_a(j);
            if (itemstack.func_77973_b() instanceof ItemShulkerBox && itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74775_l("BlockEntityTag") != null && (itemsTag = (BlockEntityTag = itemstack.func_77978_p().func_74775_l("BlockEntityTag")).func_150295_c("Items", 10)) != null) {
                for (int l = 0; l < itemsTag.func_74745_c(); ++l) {
                    NBTTagCompound item = itemsTag.func_150305_b(l);
                    String id = item.func_74779_i("id");
                    int count = itemstack.func_190916_E();
                    NBTTagCompound nbtTag = item.func_74775_l("tag");
                    if (!id.equals(itemIn.getRegistryName().toString()) || !nbtTag.equals((Object)itemNBT)) continue;
                    if (count - removeCount <= 0) {
                        itemsTag.func_74744_a(l);
                        i += count;
                        continue;
                    }
                    itemstack.func_190920_e(count - removeCount);
                    return removeCount;
                }
            }
            if (itemstack.func_190926_b() || itemIn != null && itemstack.func_77973_b() != itemIn || metadataIn > -1 && itemstack.func_77960_j() != metadataIn || itemNBT != null && !NBTUtil.func_181123_a((NBTBase)itemNBT, (NBTBase)itemstack.func_77978_p(), (boolean)true)) continue;
            int k = removeCount <= 0 ? itemstack.func_190916_E() : Math.min(removeCount - i, itemstack.func_190916_E());
            i += k;
            if (removeCount == 0) continue;
            itemstack.func_190918_g(k);
            if (itemstack.func_190926_b()) {
                _this.func_70299_a(j, ItemStack.field_190927_a);
            }
            if (removeCount <= 0 || i < removeCount) continue;
            return i;
        }
        if (!_this.func_70445_o().func_190926_b()) {
            if (itemIn != null && _this.func_70445_o().func_77973_b() != itemIn) {
                return i;
            }
            if (metadataIn > -1 && _this.func_70445_o().func_77960_j() != metadataIn) {
                return i;
            }
            if (itemNBT != null && !NBTUtil.func_181123_a((NBTBase)itemNBT, (NBTBase)_this.func_70445_o().func_77978_p(), (boolean)true)) {
                return i;
            }
            int l = removeCount <= 0 ? _this.func_70445_o().func_190916_E() : Math.min(removeCount - i, _this.func_70445_o().func_190916_E());
            i += l;
            if (removeCount != 0) {
                _this.func_70445_o().func_190918_g(l);
                if (_this.func_70445_o().func_190926_b()) {
                    _this.func_70437_b(ItemStack.field_190927_a);
                }
                if (removeCount > 0 && i >= removeCount) {
                    return i;
                }
            }
        }
        return i;
    }

    int clearMatchingItemsEnderChest(InventoryEnderChest inventory, @Nullable Item itemIn, int metadataIn, int removeCount, @Nullable NBTTagCompound itemNBT) {
        int i = 0;
        for (int j = 0; j < inventory.func_70302_i_(); ++j) {
            NBTTagCompound BlockEntityTag;
            NBTTagList itemsTag;
            ItemStack itemstack = inventory.func_70301_a(j);
            if (itemstack.func_77973_b() instanceof ItemShulkerBox && itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74775_l("BlockEntityTag") != null && (itemsTag = (BlockEntityTag = itemstack.func_77978_p().func_74775_l("BlockEntityTag")).func_150295_c("Items", 10)) != null) {
                for (int l = 0; l < itemsTag.func_74745_c(); ++l) {
                    NBTTagCompound item = itemsTag.func_150305_b(l);
                    String id = item.func_74779_i("id");
                    int count = itemstack.func_190916_E();
                    NBTTagCompound nbtTag = item.func_74775_l("tag");
                    if (!id.equals(itemIn.getRegistryName().toString()) || !nbtTag.equals((Object)itemNBT)) continue;
                    if (count - removeCount <= 0) {
                        itemsTag.func_74744_a(l);
                        i += count;
                        continue;
                    }
                    itemstack.func_190920_e(count - removeCount);
                    return removeCount;
                }
            }
            if (itemstack.func_190926_b() || itemIn != null && itemstack.func_77973_b() != itemIn || metadataIn > -1 && itemstack.func_77960_j() != metadataIn || itemNBT != null && !NBTUtil.func_181123_a((NBTBase)itemNBT, (NBTBase)itemstack.func_77978_p(), (boolean)true)) continue;
            int k = removeCount <= 0 ? itemstack.func_190916_E() : Math.min(removeCount - i, itemstack.func_190916_E());
            i += k;
            if (removeCount == 0) continue;
            itemstack.func_190918_g(k);
            if (itemstack.func_190926_b()) {
                inventory.func_70299_a(j, ItemStack.field_190927_a);
            }
            if (removeCount <= 0 || i < removeCount) continue;
            return i;
        }
        return i;
    }
}

