/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.configuration.CustomObjectConfigFunction;
import com.pg85.otg.customobjects.CustomObjectCoordinate;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.BO3Loader;
import com.pg85.otg.customobjects.bo3.BlockFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.NamedBinaryTag;
import com.pg85.otg.util.Rotation;
import java.util.List;
import java.util.Random;

public class RandomBlockFunction
extends BlockFunction {
    public LocalMaterialData[] blocks;
    byte[] blockChances;
    String[] metaDataNames;
    NamedBinaryTag[] metaDataTags;
    public int blockCount = 0;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -100, 100);
        this.z = this.readInt(args.get(2), -100, 100);
        int i = 3;
        int size = args.size();
        this.blocks = new LocalMaterialData[size / 2 + 1];
        this.blockChances = new byte[size / 2 + 1];
        this.metaDataNames = new String[size / 2 + 1];
        this.metaDataTags = new NamedBinaryTag[size / 2 + 1];
        while (i < size) {
            this.blocks[this.blockCount] = this.readMaterial(args.get(i));
            if (++i >= size) {
                throw new InvalidConfigException("Missing chance parameter");
            }
            try {
                this.blockChances[this.blockCount] = (byte)this.readInt(args.get(i), 1, 100);
            }
            catch (InvalidConfigException e) {
                NamedBinaryTag metaData = BO3Loader.loadMetadata(args.get(i), ((BO3Config)this.getHolder()).getFile());
                if (metaData != null) {
                    this.metaDataNames[this.blockCount] = args.get(i);
                    this.metaDataTags[this.blockCount] = metaData;
                }
                if (++i >= size) {
                    throw new InvalidConfigException("Missing chance parameter");
                }
                this.blockChances[this.blockCount] = (byte)this.readInt(args.get(i), 1, 100);
            }
            ++i;
            ++this.blockCount;
        }
    }

    @Override
    public String makeString() {
        String text = "RandomBlock(" + this.x + "," + this.y + "," + this.z;
        for (int i = 0; i < this.blockCount; ++i) {
            text = this.metaDataTags[i] == null ? text + "," + this.blocks[i] + "," + this.blockChances[i] : text + "," + this.blocks[i] + "," + this.metaDataNames[i] + "," + this.blockChances[i];
        }
        return text + ")";
    }

    @Override
    public RandomBlockFunction rotate() {
        RandomBlockFunction rotatedBlock = new RandomBlockFunction();
        rotatedBlock.x = this.z;
        rotatedBlock.y = this.y;
        rotatedBlock.z = -this.x;
        rotatedBlock.blockCount = this.blockCount;
        rotatedBlock.blocks = new LocalMaterialData[this.blockCount];
        for (int i = 0; i < this.blockCount; ++i) {
            rotatedBlock.blocks[i] = this.blocks[i].rotate();
        }
        rotatedBlock.blockChances = this.blockChances;
        rotatedBlock.metaDataTags = this.metaDataTags;
        rotatedBlock.metaDataNames = this.metaDataNames;
        return rotatedBlock;
    }

    @Override
    public BlockFunction rotate(Rotation rotation) {
        RandomBlockFunction rotatedBlock = new RandomBlockFunction();
        CustomObjectCoordinate rotatedCoords = CustomObjectCoordinate.getRotatedBO3CoordsJustified(this.x, this.y, this.z, rotation);
        rotatedBlock.x = rotatedCoords.getX();
        rotatedBlock.y = rotatedCoords.getY();
        rotatedBlock.z = rotatedCoords.getZ();
        rotatedBlock.blocks = this.blocks;
        if (this.material != null) {
            throw new RuntimeException();
        }
        LocalMaterialData[] rotatedBlockBlocks = new LocalMaterialData[this.blockCount];
        for (int a2 = 0; a2 < this.blockCount; ++a2) {
            rotatedBlockBlocks[a2] = rotatedBlock.blocks[a2];
            if (rotation.getRotationId() == 3) {
                rotatedBlockBlocks[a2] = rotatedBlockBlocks[a2].rotate();
            }
            if (rotation.getRotationId() == 2) {
                rotatedBlockBlocks[a2] = rotatedBlockBlocks[a2].rotate();
                rotatedBlockBlocks[a2] = rotatedBlockBlocks[a2].rotate();
            }
            if (rotation.getRotationId() != 1) continue;
            rotatedBlockBlocks[a2] = rotatedBlockBlocks[a2].rotate();
            rotatedBlockBlocks[a2] = rotatedBlockBlocks[a2].rotate();
            rotatedBlockBlocks[a2] = rotatedBlockBlocks[a2].rotate();
        }
        rotatedBlock.blocks = rotatedBlockBlocks;
        rotatedBlock.blockCount = this.blockCount;
        rotatedBlock.blockChances = this.blockChances;
        rotatedBlock.metaDataTag = this.metaDataTag;
        rotatedBlock.metaDataTags = this.metaDataTags;
        rotatedBlock.metaDataName = this.metaDataName;
        rotatedBlock.metaDataNames = this.metaDataNames;
        return rotatedBlock;
    }

    @Override
    public void spawn(LocalWorld world, Random random, int x, int y, int z, boolean allowOutsidePopulatingArea) {
        for (int i = 0; i < this.blockCount; ++i) {
            if (random.nextInt(100) >= this.blockChances[i]) continue;
            world.setBlock(x, y, z, this.blocks[i], this.metaDataTags[i], allowOutsidePopulatingArea);
            break;
        }
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<BO3Config> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        RandomBlockFunction block = (RandomBlockFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z;
    }
}

