/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3;

import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.util.Rotation;

public class BranchNode
implements Comparable<BranchNode> {
    int branchDepth;
    boolean isRequiredBranch;
    boolean isWeightedBranch;
    private Rotation rotation;
    private double chance;
    private CustomObject customObject;
    public String customObjectName;
    public String branchGroup;

    public BranchNode(int branchDepth, boolean isRequiredBranch, boolean isWeightedBranch, Rotation rotation, double chance, CustomObject customObject, String customObjectName, String branchGroup) {
        this.branchDepth = branchDepth;
        this.rotation = rotation;
        this.chance = chance;
        this.customObjectName = customObject != null ? customObject.getName() : (customObjectName != null && customObjectName.length() > 0 ? customObjectName : null);
        this.customObject = customObject;
        this.isRequiredBranch = isRequiredBranch;
        this.isWeightedBranch = isWeightedBranch;
        this.branchGroup = branchGroup;
    }

    public BranchNode(Rotation rotation, double chance, CustomObject branch, String customObjectName) {
        this.rotation = rotation;
        this.chance = chance;
        this.customObject = branch;
        this.customObjectName = branch != null ? branch.getName() : (customObjectName != null && customObjectName.length() > 0 ? customObjectName : null);
    }

    public double getChance() {
        return this.chance;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public CustomObject getCustomObject(boolean lazyLoad, LocalWorld world) {
        if (this.customObject != null || !lazyLoad) {
            return this.customObject;
        }
        this.customObject = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(this.customObjectName, world.getName());
        this.customObjectName = this.customObject != null ? this.customObject.getName() : null;
        return this.customObject;
    }

    public String toBranchString() {
        return ',' + this.customObjectName + ',' + this.rotation.name() + ',' + this.chance + ',' + this.branchDepth;
    }

    @Override
    public int compareTo(BranchNode that) {
        return (int)(this.chance - that.chance);
    }
}

