/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3;

import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.CustomObjectConfigFunction;
import com.pg85.otg.customobjects.Branch;
import com.pg85.otg.customobjects.CustomObjectCoordinate;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.BO3Function;
import com.pg85.otg.customobjects.bo3.BranchNode;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.Rotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;

public class BranchFunction
extends BO3Function
implements Branch {
    public int x;
    public int y;
    public int z;
    public SortedSet<BranchNode> branches;
    public ArrayList<BranchNode> branchesOTGPlus;
    public double totalChance = 100.0;
    public boolean totalChanceSet = false;
    public String branchGroup = "";
    public boolean isRequiredBranch = false;
    boolean isOTGPlus;

    @Override
    public BranchFunction rotate() {
        if (this.isOTGPlus) {
            throw new RuntimeException();
        }
        BranchFunction rotatedBranch = new BranchFunction();
        rotatedBranch.x = this.z;
        rotatedBranch.y = this.y;
        rotatedBranch.z = -this.x;
        rotatedBranch.branches = new TreeSet<BranchNode>();
        rotatedBranch.totalChance = this.totalChance;
        rotatedBranch.totalChanceSet = this.totalChanceSet;
        for (BranchNode holder : this.branches) {
            rotatedBranch.branches.add(new BranchNode(holder.getRotation().next(), holder.getChance(), holder.getCustomObject(false, null), holder.customObjectName));
        }
        return rotatedBranch;
    }

    public BranchFunction rotate(Rotation rotation) {
        if (!this.isOTGPlus) {
            throw new RuntimeException();
        }
        BranchFunction rotatedBranch = new BranchFunction();
        rotatedBranch.isOTGPlus = this.isOTGPlus;
        rotatedBranch.x = this.x;
        rotatedBranch.y = this.y;
        rotatedBranch.z = this.z;
        rotatedBranch.totalChance = this.totalChance;
        rotatedBranch.totalChanceSet = this.totalChanceSet;
        rotatedBranch.branchGroup = this.branchGroup;
        rotatedBranch.isRequiredBranch = this.isRequiredBranch;
        rotatedBranch.branchesOTGPlus = this.branchesOTGPlus;
        rotatedBranch.holder = this.holder;
        rotatedBranch.valid = this.valid;
        rotatedBranch.inputName = this.inputName;
        rotatedBranch.inputArgs = this.inputArgs;
        rotatedBranch.error = this.error;
        int newX = rotatedBranch.x;
        int newZ = rotatedBranch.z;
        for (int i = 0; i < rotation.getRotationId(); ++i) {
            newX = rotatedBranch.z;
            newZ = -rotatedBranch.x;
            rotatedBranch.x = newX;
            rotatedBranch.y = rotatedBranch.y;
            rotatedBranch.z = newZ;
            ArrayList<BranchNode> rotatedBranchBranches = new ArrayList<BranchNode>();
            for (BranchNode holder : rotatedBranch.branchesOTGPlus) {
                rotatedBranchBranches.add(new BranchNode(holder.branchDepth, holder.isRequiredBranch, holder.isWeightedBranch, holder.getRotation().next(), holder.getChance(), holder.getCustomObject(false, null), holder.customObjectName, holder.branchGroup));
            }
            rotatedBranch.branchesOTGPlus = rotatedBranchBranches;
        }
        return rotatedBranch;
    }

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.branches = new TreeSet<BranchNode>();
        this.branchesOTGPlus = new ArrayList();
        this.readArgs(args, false);
    }

    @Override
    public String makeString() {
        StringBuilder output = new StringBuilder(this.getConfigName()).append('(').append(this.x).append(',').append(this.y).append(',').append(this.z).append(',');
        if (this.isOTGPlus) {
            output.append(this.isRequiredBranch);
            Iterator<BranchNode> it = this.branchesOTGPlus.iterator();
            while (it.hasNext()) {
                output.append(it.next().toBranchString());
            }
        } else {
            Iterator it = this.branches.iterator();
            while (it.hasNext()) {
                output.append(((BranchNode)it.next()).toBranchString());
            }
        }
        if (this.totalChanceSet) {
            output.append(',').append(this.totalChance);
        }
        return output.append(')').toString();
    }

    @Override
    public CustomObjectCoordinate toCustomObjectCoordinate(LocalWorld world, Random random, Rotation rotation, int x, int y, int z, String startBO3Name) {
        if (world.getConfigs().getWorldConfig().IsOTGPlus) {
            for (BranchNode branch : this.branchesOTGPlus) {
                double randomChance = random.nextDouble() * this.totalChance;
                if (!(randomChance <= branch.getChance())) continue;
                CustomObjectCoordinate rotatedCoords = CustomObjectCoordinate.getRotatedCoord(this.x, this.y, this.z, rotation);
                Rotation newRotation = Rotation.getRotation((rotation.getRotationId() + branch.getRotation().getRotationId()) % 4);
                return new CustomObjectCoordinate(world, branch.getCustomObject(false, world), branch.customObjectName, newRotation, x + rotatedCoords.getX(), y + rotatedCoords.getY(), z + rotatedCoords.getZ(), true, branch.branchDepth, branch.isRequiredBranch, branch.isWeightedBranch, branch.branchGroup);
            }
        } else {
            for (BranchNode branch : this.branches) {
                double randomChance = random.nextDouble() * this.totalChance;
                if (!(randomChance < branch.getChance())) continue;
                return new CustomObjectCoordinate(world, branch.getCustomObject(false, world), branch.customObjectName, branch.getRotation(), x + this.x, y + this.y, z + this.z);
            }
        }
        return null;
    }

    protected String getConfigName() {
        return "Branch";
    }

    protected double readArgs(List<String> args, boolean accumulateChances) throws InvalidConfigException {
        double cumulativeChance = 0.0;
        this.isOTGPlus = ((BO3Config)this.getHolder()).isOTGPlus;
        if (this.isOTGPlus) {
            String totalChanceOrBranchGroup;
            int i;
            this.assureSize(8, args);
            this.x = this.readInt(args.get(0), -32, 32);
            this.y = this.readInt(args.get(1), -255, 255);
            this.z = this.readInt(args.get(2), -32, 32);
            this.isRequiredBranch = this.readBoolean(args.get(3));
            for (i = 4; i < args.size() - 3; i += 4) {
                double branchChance = this.readDouble(args.get(i + 2), 0.0, Double.MAX_VALUE);
                if (this.isRequiredBranch && args.size() > 9) {
                    if (OTG.getPluginConfig().SpawnLog) {
                        String branchString = "";
                        for (String arg : args) {
                            branchString = branchString + ", " + arg;
                        }
                        OTG.log(LogMarker.WARN, "isRequired:true branches cannot have multiple BO3's with a rarity, only one BO3 per isRequired:true branch is allowed and the branch automatically has a 100% chance to spawn. Using only the first BO3 for branch: Branch(" + branchString.substring(0, branchString.length() - 1) + ")", new Object[0]);
                    }
                    this.branchesOTGPlus.add(new BranchNode(this.readInt(args.get(i + 3), -32, 32), this.isRequiredBranch, false, Rotation.getRotation(args.get(i + 1)), 100.0, null, args.get(i), null));
                    break;
                }
                this.branchesOTGPlus.add(new BranchNode(this.readInt(args.get(i + 3), -32, 32), this.isRequiredBranch, false, Rotation.getRotation(args.get(i + 1)), branchChance, null, args.get(i), null));
            }
            if (!this.isRequiredBranch && i < args.size() && (totalChanceOrBranchGroup = args.get(i)) != null && totalChanceOrBranchGroup.length() > 0) {
                try {
                    Double.parseDouble(totalChanceOrBranchGroup);
                    this.totalChanceSet = true;
                    this.totalChance = this.readDouble(args.get(i), 0.0, Double.MAX_VALUE);
                    ++i;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (i < args.size() && (totalChanceOrBranchGroup = args.get(i)) != null && totalChanceOrBranchGroup.length() > 0) {
                this.branchGroup = args.get(i);
                for (BranchNode branch : this.branchesOTGPlus) {
                    branch.branchGroup = this.branchGroup;
                }
            }
        } else {
            int i;
            this.assureSize(6, args);
            this.x = this.readInt(args.get(0), -32, 32);
            this.y = this.readInt(args.get(1), -64, 64);
            this.z = this.readInt(args.get(2), -32, 32);
            for (i = 3; i < args.size() - 2; i += 3) {
                double branchChance = this.readDouble(args.get(i + 2), 0.0, Double.MAX_VALUE);
                if (accumulateChances) {
                    this.branches.add(new BranchNode(0, this.isRequiredBranch, false, Rotation.getRotation(args.get(i + 1)), cumulativeChance += branchChance, null, args.get(i), null));
                    continue;
                }
                this.branches.add(new BranchNode(0, this.isRequiredBranch, false, Rotation.getRotation(args.get(i + 1)), branchChance, null, args.get(i), null));
            }
            if (i < args.size()) {
                this.totalChanceSet = true;
                this.totalChance = this.readDouble(args.get(i), 0.0, Double.MAX_VALUE);
            }
        }
        return cumulativeChance;
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<BO3Config> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        BranchFunction branch = (BranchFunction)other;
        return branch.x == this.x && branch.y == this.y && branch.z == this.z;
    }
}

