/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.configuration.io.SettingsReaderOTGPlus;
import com.pg85.otg.configuration.settingType.Setting;
import com.pg85.otg.configuration.settingType.Settings;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.util.BoundingBox;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.Rotation;
import com.pg85.otg.util.minecraftTypes.TreeType;
import java.util.Map;
import java.util.Random;

public class TreeObject
implements CustomObject {
    private TreeType type;
    private int minHeight = 0;
    private int maxHeight = 256;

    @Override
    public boolean trySpawnAt(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        if (y < this.minHeight || y > this.maxHeight) {
            return false;
        }
        return this.spawnForced(world, random, rotation, x, y, z);
    }

    @Override
    public boolean process(LocalWorld world, Random random, ChunkCoordinate chunkCoord) {
        int x = chunkCoord.getBlockXCenter() + random.nextInt(16);
        int z = chunkCoord.getBlockZCenter() + random.nextInt(16);
        int y = world.getHighestBlockYAt(x, z);
        return this.trySpawnAt(world, random, Rotation.NORTH, x, y, z);
    }

    public TreeObject(TreeType type) {
        this.type = type;
    }

    @Override
    public void onEnable(Map<String, CustomObject> otherObjectsInDirectory) {
    }

    public TreeObject(TreeType type, SettingsReaderOTGPlus settings) {
        this.type = type;
        this.minHeight = settings.getSetting(TreeSettings.MIN_HEIGHT, TreeSettings.MIN_HEIGHT.getDefaultValue());
        this.maxHeight = settings.getSetting(TreeSettings.MAX_HEIGHT, TreeSettings.MAX_HEIGHT.getDefaultValue());
    }

    @Override
    public String getName() {
        return this.type.name();
    }

    @Override
    public boolean canSpawnAsTree() {
        return true;
    }

    @Override
    public boolean canSpawnAsObject() {
        return false;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        return world.placeTree(this.type, random, x, y, z);
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z) {
        throw new RuntimeException();
    }

    @Override
    public CustomObject applySettings(SettingsReaderOTGPlus settings) {
        return new TreeObject(this.type, settings);
    }

    @Override
    public boolean hasPreferenceToSpawnIn(LocalBiome biome) {
        return true;
    }

    @Override
    public boolean canRotateRandomly() {
        return false;
    }

    @Override
    public int getMaxBranchDepth() {
        throw new RuntimeException();
    }

    @Override
    public BoundingBox getBoundingBox(Rotation rotation) {
        return BoundingBox.newEmptyBox();
    }

    private static class TreeSettings
    extends Settings {
        static final Setting<Integer> MIN_HEIGHT = TreeSettings.intSetting("MinHeight", 0, 0, 256);
        static final Setting<Integer> MAX_HEIGHT = TreeSettings.intSetting("MaxHeight", 256, 0, 256);

        private TreeSettings() {
        }
    }
}

