/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.customobjects.Branch;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectCoordinate;
import com.pg85.otg.customobjects.StructurePartSpawnHeight;
import com.pg85.otg.customobjects.StructuredCustomObject;
import com.pg85.otg.customobjects.bo3.BO3;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.BO3Settings;
import com.pg85.otg.customobjects.bo3.BlockFunction;
import com.pg85.otg.customobjects.bo3.EntityFunction;
import com.pg85.otg.customobjects.bo3.ModDataFunction;
import com.pg85.otg.customobjects.bo3.ParticleFunction;
import com.pg85.otg.customobjects.bo3.RandomBlockFunction;
import com.pg85.otg.customobjects.bo3.SpawnerFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.CustomStructureGen;
import com.pg85.otg.generator.surface.MesaSurfaceGenerator;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.NamedBinaryTag;
import com.pg85.otg.util.Rotation;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;

public class CustomObjectStructure {
    public HashSet<ModDataFunction> modData = new HashSet();
    public HashSet<SpawnerFunction> spawnerData = new HashSet();
    public HashSet<ParticleFunction> particleData = new HashSet();
    public boolean saveRequired = true;
    protected LocalWorld World;
    protected Random Random;
    public CustomObjectCoordinate Start;
    public Map<ChunkCoordinate, Stack<CustomObjectCoordinate>> ObjectsToSpawn = new HashMap<ChunkCoordinate, Stack<CustomObjectCoordinate>>();
    public Map<ChunkCoordinate, String> ObjectsToSpawnInfo = new HashMap<ChunkCoordinate, String>();
    public boolean IsSpawned;
    public boolean CannotSpawn;
    public boolean IsStructureAtSpawn = false;
    int MinY;
    boolean IsOTGPlus = false;
    Map<ChunkCoordinate, ArrayList<Object[]>> SmoothingAreasToSpawn = new HashMap<ChunkCoordinate, ArrayList<Object[]>>();
    Map<ChunkCoordinate, ArrayList<Object[]>> SmoothingAreasToSpawnPerDiagonalLineOrigin = new HashMap<ChunkCoordinate, ArrayList<Object[]>>();
    Map<ChunkCoordinate, ArrayList<Object[]>> SmoothingAreasToSpawnPerDiagonalLineDestination = new HashMap<ChunkCoordinate, ArrayList<Object[]>>();
    Map<ChunkCoordinate, ArrayList<Object[]>> SmoothingAreasToSpawnPerLineOrigin = new HashMap<ChunkCoordinate, ArrayList<Object[]>>();
    Map<ChunkCoordinate, ArrayList<Object[]>> SmoothingAreasToSpawnPerLineDestination = new HashMap<ChunkCoordinate, ArrayList<Object[]>>();
    public boolean startChunkBlockChecksDone = false;
    int branchesTried = 0;
    public Stack<BranchDataItem> AllBranchesBranchData = new Stack();
    public HashMap<ChunkCoordinate, Stack<BranchDataItem>> AllBranchesBranchDataByChunk = new HashMap();
    public HashSet<Integer> AllBranchesBranchDataHash = new HashSet();
    private boolean ProcessingDone = false;
    private boolean SpawningCanOverrideBranches = false;
    int Cycle = 0;
    BranchDataItem currentSpawningRequiredChildrenForOptionalBranch;
    boolean SpawningRequiredChildrenForOptionalBranch = false;
    boolean SpawningRequiredBranchesOnly = true;
    boolean SpawnedBranchThisCycle = false;
    boolean SpawnedBranchLastCycle = false;
    protected StructurePartSpawnHeight height;
    private Map<ChunkCoordinate, Set<CustomObjectCoordinate>> objectsToSpawn;
    private int maxBranchDepth;

    public CustomObjectStructure(LocalWorld world, CustomObjectCoordinate structureStart, Map<ChunkCoordinate, Stack<CustomObjectCoordinate>> objectsToSpawn, Map<ChunkCoordinate, ArrayList<Object[]>> smoothingAreasToSpawn, int minY) {
        this(world, structureStart, false, false);
        this.ObjectsToSpawn = objectsToSpawn;
        this.SmoothingAreasToSpawn = smoothingAreasToSpawn;
        this.MinY = minY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean DoStartChunkBlockChecks() {
        if (this.startChunkBlockChecksDone) return true;
        this.saveRequired = true;
        this.startChunkBlockChecksDone = true;
        int startY = 0;
        if (((BO3)this.Start.getObject()).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestBlock || ((BO3)this.Start.getObject()).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock) {
            if (((BO3)this.Start.getObject()).getSettings().SpawnAtWaterLevel) {
                LocalBiome biome = this.World.getBiome(this.Start.getX() + 8, this.Start.getZ() + 7);
                startY = biome.getBiomeConfig().useWorldWaterLevel ? this.World.getConfigs().getWorldConfig().waterLevelMax : biome.getBiomeConfig().waterLevelMax;
            } else {
                int highestBlock = 0;
                highestBlock = !((BO3)this.Start.getObject()).getSettings().SpawnUnderWater ? this.World.getHighestBlockYAt(this.Start.getX() + 8, this.Start.getZ() + 7, true, true, false, true) : this.World.getHighestBlockYAt(this.Start.getX() + 8, this.Start.getZ() + 7, true, false, true, true);
                if (highestBlock < 1) {
                    if (((BO3)this.Start.getObject()).getSettings().heightOffset <= 0) return false;
                    highestBlock = ((BO3)this.Start.getObject()).getSettings().heightOffset;
                } else {
                    startY = highestBlock + 1;
                }
            }
        } else {
            startY = ((BO3)this.Start.getObject()).getSettings().maxHeight != ((BO3)this.Start.getObject()).getSettings().minHeight ? ((BO3)this.Start.getObject()).getSettings().minHeight + new Random().nextInt(((BO3)this.Start.getObject()).getSettings().maxHeight - ((BO3)this.Start.getObject()).getSettings().minHeight) : ((BO3)this.Start.getObject()).getSettings().minHeight;
        }
        if (startY < ((BO3)this.Start.getObject()).getSettings().minHeight || startY > ((BO3)this.Start.getObject()).getSettings().maxHeight) {
            return false;
        }
        if ((startY += ((BO3)this.Start.getObject()).getSettings().heightOffset) < 0 || startY >= 256) {
            return false;
        }
        for (ChunkCoordinate chunkCoord : this.ObjectsToSpawn.keySet()) {
            for (CustomObjectCoordinate BO32 : this.ObjectsToSpawn.get(chunkCoord)) {
                BO32.y += startY;
            }
        }
        HashMap<ChunkCoordinate, ArrayList<Object[]>> SmoothingAreasToSpawn2 = new HashMap<ChunkCoordinate, ArrayList<Object[]>>();
        SmoothingAreasToSpawn2.putAll(this.SmoothingAreasToSpawn);
        this.SmoothingAreasToSpawn.clear();
        for (ChunkCoordinate chunkCoord2 : SmoothingAreasToSpawn2.keySet()) {
            ArrayList<Object[]> coords = new ArrayList<Object[]>();
            for (Object[] coord : (ArrayList)SmoothingAreasToSpawn2.get(chunkCoord2)) {
                Object[] coordToAdd;
                if (coord.length == 18) {
                    coordToAdd = new Object[]{(Integer)coord[0], (Integer)coord[1] + this.Start.getY(), (Integer)coord[2], (Integer)coord[3], (Integer)coord[4] + this.Start.getY(), (Integer)coord[5], (Integer)coord[6], -1, (Integer)coord[8], (Integer)coord[9], -1, (Integer)coord[11], (Integer)coord[12], (Integer)coord[13] + this.Start.getY(), (Integer)coord[14], (Integer)coord[15], -1, (Integer)coord[17]};
                    coords.add(coordToAdd);
                    continue;
                }
                if (coord.length != 12) throw new RuntimeException();
                coordToAdd = new Object[]{(Integer)coord[0], (Integer)coord[1] + this.Start.getY(), (Integer)coord[2], (Integer)coord[3], (Integer)coord[4] + this.Start.getY(), (Integer)coord[5], (Integer)coord[6], (Integer)coord[7] + this.Start.getY(), (Integer)coord[8], (Integer)coord[9], -1, (Integer)coord[11]};
                coords.add(coordToAdd);
            }
            this.SmoothingAreasToSpawn.put(ChunkCoordinate.fromChunkCoords(chunkCoord2.getChunkX(), chunkCoord2.getChunkZ()), coords);
        }
        this.Start.y = startY;
        return true;
    }

    public CustomObjectStructure(LocalWorld world, CustomObjectCoordinate start, boolean spawn, boolean isStructureAtSpawn) {
        this.World = world;
        this.IsStructureAtSpawn = isStructureAtSpawn;
        this.IsOTGPlus = true;
        if (start == null) {
            return;
        }
        if (!(start.getObject() instanceof StructuredCustomObject)) {
            throw new IllegalArgumentException("Start object must be a structure!");
        }
        this.Start = start;
        this.Random = RandomHelper.getRandomForCoords(start.getX() + 8, start.getY(), start.getZ() + 7, world.getSeed());
        if (spawn) {
            CustomObjectStructure existingObject;
            this.branchesTried = 0;
            long startTime = System.currentTimeMillis();
            if (!this.DoStartChunkBlockChecks()) {
                return;
            }
            if (!(((BO3)this.Start.getObject()).getSettings().spawnHeight != BO3Settings.SpawnHeightEnum.highestBlock && ((BO3)this.Start.getObject()).getSettings().spawnHeight != BO3Settings.SpawnHeightEnum.highestSolidBlock || !this.World.getConfigs().getWorldConfig().disableBedrock && ((BO3)this.Start.getObject()).getSettings().minHeight <= 1 && ((BO3)this.Start.getObject()).getSettings().maxHeight >= 256 || this.DoStartChunkBlockChecks())) {
                return;
            }
            if (!((BO3)this.Start.getObject()).getSettings().CanSpawnOnWater) {
                if (!this.DoStartChunkBlockChecks()) {
                    return;
                }
                int highestBlocky = world.getHighestBlockYAt(this.Start.getX() + 8, this.Start.getZ() + 7, true, true, false, true);
                if (this.Start.y - 1 > 0 && this.Start.y - 1 < 256 && world.getMaterial(this.Start.getX() + 8, highestBlocky, this.Start.getZ() + 7, this.IsOTGPlus).isLiquid()) {
                    return;
                }
            }
            if (((BO3)this.Start.getObject()).getSettings().SpawnOnWaterOnly) {
                if (!this.DoStartChunkBlockChecks()) {
                    return;
                }
                if (!(world.getMaterial(this.Start.getX(), this.Start.y - 1, this.Start.getZ(), this.IsOTGPlus).isLiquid() && world.getMaterial(this.Start.getX(), this.Start.y - 1, this.Start.getZ() + 15, this.IsOTGPlus).isLiquid() && world.getMaterial(this.Start.getX() + 15, this.Start.y - 1, this.Start.getZ(), this.IsOTGPlus).isLiquid() && world.getMaterial(this.Start.getX() + 15, this.Start.y - 1, this.Start.getZ() + 15, this.IsOTGPlus).isLiquid())) {
                    return;
                }
            }
            try {
                this.CalculateBranches(false);
            }
            catch (InvalidConfigException ex) {
                OTG.log(LogMarker.ERROR, "An unknown error occurred while calculating branches for BO3 " + this.Start.BO3Name + ". This is probably an error in the BO3's branch configuration, not a bug. If you can track this down, please tell me what caused it!", new Object[0]);
                throw new RuntimeException();
            }
            for (Map.Entry<ChunkCoordinate, Stack<CustomObjectCoordinate>> entry : this.ObjectsToSpawn.entrySet()) {
                Object structureInfo = "";
                for (CustomObjectCoordinate customObjectCoord : entry.getValue()) {
                    structureInfo = (String)structureInfo + customObjectCoord.getObject().getName() + ":" + (Object)((Object)customObjectCoord.getRotation()) + ", ";
                }
                if (((String)structureInfo).length() <= 0) continue;
                structureInfo = ((String)structureInfo).substring(0, ((String)structureInfo).length() - 2);
                this.ObjectsToSpawnInfo.put(entry.getKey(), "Branches in chunk X" + entry.getKey().getChunkX() + " Z" + entry.getKey().getChunkZ() + " : " + (String)structureInfo);
            }
            for (Map.Entry<ChunkCoordinate, Stack<CustomObjectCoordinate>> entry : this.ObjectsToSpawn.entrySet()) {
                for (CustomObjectCoordinate coordObject : entry.getValue()) {
                    String[] BO3sToReplace;
                    BO3Config objectConfig = ((BO3)coordObject.getObject()).getSettings();
                    if (objectConfig.replacesBO3 == null || objectConfig.replacesBO3.length() <= 0) continue;
                    for (String BO3ToReplace : BO3sToReplace = objectConfig.replacesBO3.split(",")) {
                        for (CustomObjectCoordinate coordObjectToReplace : entry.getValue()) {
                            if (!((BO3)coordObjectToReplace.getObject()).getName().trim().equals(BO3ToReplace.trim()) || !this.CheckCollision(coordObject, coordObjectToReplace)) continue;
                            coordObjectToReplace.isSpawned = true;
                        }
                    }
                }
            }
            this.SmoothingAreasToSpawn = this.CalculateSmoothingAreas();
            this.SmoothingAreasToSpawnPerDiagonalLineOrigin.clear();
            this.SmoothingAreasToSpawnPerDiagonalLineDestination.clear();
            this.SmoothingAreasToSpawnPerLineOrigin.clear();
            this.SmoothingAreasToSpawnPerLineDestination.clear();
            for (Map.Entry<ChunkCoordinate, AbstractList> entry : this.SmoothingAreasToSpawn.entrySet()) {
                ArrayList values = (ArrayList)entry.getValue();
                for (Object[] smoothingAreaLine : values) {
                    int originPointZ2;
                    int originPointX2 = (Integer)smoothingAreaLine[6];
                    ChunkCoordinate originChunk = ChunkCoordinate.fromBlockCoords(originPointX2, originPointZ2 = ((Integer)smoothingAreaLine[8]).intValue());
                    ArrayList<Object[]> lineInOriginChunkSaved2 = this.SmoothingAreasToSpawnPerLineOrigin.get(originChunk);
                    if (lineInOriginChunkSaved2 == null) {
                        ArrayList<Object[]> smoothingAreaLines = new ArrayList<Object[]>();
                        smoothingAreaLines.add(smoothingAreaLine);
                        this.SmoothingAreasToSpawnPerLineOrigin.put(ChunkCoordinate.fromChunkCoords(originPointX2, originPointZ2), smoothingAreaLines);
                    } else {
                        lineInOriginChunkSaved2.add(smoothingAreaLine);
                    }
                    int finalDestinationPointX2 = (Integer)smoothingAreaLine[9];
                    int finalDestinationPointZ2 = (Integer)smoothingAreaLine[11];
                    originChunk = ChunkCoordinate.fromBlockCoords(finalDestinationPointX2, finalDestinationPointZ2);
                    ArrayList<Object[]> lineInOriginChunkSaved3 = this.SmoothingAreasToSpawnPerLineDestination.get(originChunk);
                    if (lineInOriginChunkSaved3 == null) {
                        ArrayList<Object[]> smoothingAreaLines = new ArrayList<Object[]>();
                        smoothingAreaLines.add(smoothingAreaLine);
                        this.SmoothingAreasToSpawnPerLineDestination.put(ChunkCoordinate.fromChunkCoords(finalDestinationPointX2, finalDestinationPointZ2), smoothingAreaLines);
                    } else {
                        lineInOriginChunkSaved3.add(smoothingAreaLine);
                    }
                    if (smoothingAreaLine.length <= 17) continue;
                    int diagonalLineFinalOriginPointX2 = (Integer)smoothingAreaLine[12];
                    int diagonalLineFinalOriginPointZ2 = (Integer)smoothingAreaLine[14];
                    int diagonalLineFinalDestinationPointX2 = (Integer)smoothingAreaLine[15];
                    int diagonalLineFinalDestinationPointZ2 = (Integer)smoothingAreaLine[17];
                    originChunk = ChunkCoordinate.fromBlockCoords(diagonalLineFinalOriginPointX2, diagonalLineFinalOriginPointZ2);
                    ArrayList<Object[]> lineInOriginChunkSaved4 = this.SmoothingAreasToSpawnPerDiagonalLineOrigin.get(originChunk);
                    if (lineInOriginChunkSaved4 == null) {
                        ArrayList<Object[]> smoothingAreaLines = new ArrayList<Object[]>();
                        smoothingAreaLines.add(smoothingAreaLine);
                        this.SmoothingAreasToSpawnPerDiagonalLineOrigin.put(ChunkCoordinate.fromChunkCoords(diagonalLineFinalOriginPointX2, diagonalLineFinalOriginPointZ2), smoothingAreaLines);
                    } else {
                        lineInOriginChunkSaved4.add(smoothingAreaLine);
                    }
                    originChunk = ChunkCoordinate.fromBlockCoords(diagonalLineFinalDestinationPointX2, diagonalLineFinalDestinationPointZ2);
                    ArrayList<Object[]> lineInOriginChunkSaved = this.SmoothingAreasToSpawnPerDiagonalLineDestination.get(originChunk);
                    if (lineInOriginChunkSaved == null) {
                        ArrayList<Object[]> smoothingAreaLines = new ArrayList<Object[]>();
                        smoothingAreaLines.add(smoothingAreaLine);
                        this.SmoothingAreasToSpawnPerDiagonalLineDestination.put(ChunkCoordinate.fromChunkCoords(diagonalLineFinalDestinationPointX2, diagonalLineFinalDestinationPointZ2), smoothingAreaLines);
                        continue;
                    }
                    lineInOriginChunkSaved.add(smoothingAreaLine);
                }
            }
            for (ChunkCoordinate chunkCoordinate : this.ObjectsToSpawn.keySet()) {
                this.World.getStructureCache().structureCache.put(chunkCoordinate, this);
                this.World.getStructureCache().structuresPerChunk.put(chunkCoordinate, new ArrayList());
                if (this.World.getStructureCache().worldInfoChunks.containsKey(chunkCoordinate)) {
                    existingObject = this.World.getStructureCache().worldInfoChunks.get(chunkCoordinate);
                    this.modData.addAll(existingObject.modData);
                    this.particleData.addAll(existingObject.particleData);
                    this.spawnerData.addAll(existingObject.spawnerData);
                }
                this.World.getStructureCache().worldInfoChunks.put(chunkCoordinate, this);
            }
            for (ChunkCoordinate chunkCoordinate : this.SmoothingAreasToSpawn.keySet()) {
                this.World.getStructureCache().structureCache.put(chunkCoordinate, this);
                this.World.getStructureCache().structuresPerChunk.put(chunkCoordinate, new ArrayList());
                if (this.World.getStructureCache().worldInfoChunks.containsKey(chunkCoordinate)) {
                    existingObject = this.World.getStructureCache().worldInfoChunks.get(chunkCoordinate);
                    this.modData.addAll(existingObject.modData);
                    this.particleData.addAll(existingObject.particleData);
                    this.spawnerData.addAll(existingObject.spawnerData);
                }
                this.World.getStructureCache().worldInfoChunks.put(chunkCoordinate, this);
            }
            if (this.ObjectsToSpawn.size() > 0) {
                this.IsSpawned = true;
                if (OTG.getPluginConfig().SpawnLog) {
                    int totalBO3sSpawned = 0;
                    for (ChunkCoordinate entry : this.ObjectsToSpawn.keySet()) {
                        totalBO3sSpawned += this.ObjectsToSpawn.get(entry).size();
                    }
                    OTG.log(LogMarker.INFO, this.Start.getObject().getName() + " " + totalBO3sSpawned + " object(s) plotted in " + (System.currentTimeMillis() - startTime) + " Ms and " + this.Cycle + " cycle(s), " + (this.branchesTried + 1) + " object(s) tried.", new Object[0]);
                }
            }
        }
    }

    public Object[] GetMinimumSize() throws InvalidConfigException {
        ChunkCoordinate startChunk;
        if (((BO3)this.Start.getObject()).getSettings().MinimumSizeTop != -1 && ((BO3)this.Start.getObject()).getSettings().MinimumSizeBottom != -1 && ((BO3)this.Start.getObject()).getSettings().MinimumSizeLeft != -1 && ((BO3)this.Start.getObject()).getSettings().MinimumSizeRight != -1) {
            Object[] returnValue = new Object[]{((BO3)this.Start.getObject()).getSettings().MinimumSizeTop, ((BO3)this.Start.getObject()).getSettings().MinimumSizeRight, ((BO3)this.Start.getObject()).getSettings().MinimumSizeBottom, ((BO3)this.Start.getObject()).getSettings().MinimumSizeLeft};
            return returnValue;
        }
        this.CalculateBranches(true);
        ChunkCoordinate top = startChunk = ChunkCoordinate.fromBlockCoords(this.Start.getX(), this.Start.getZ());
        ChunkCoordinate left = startChunk;
        ChunkCoordinate bottom = startChunk;
        ChunkCoordinate right = startChunk;
        for (ChunkCoordinate chunkCoord : this.ObjectsToSpawn.keySet()) {
            if (chunkCoord.getChunkX() > right.getChunkX()) {
                right = chunkCoord;
            }
            if (chunkCoord.getChunkZ() > bottom.getChunkZ()) {
                bottom = chunkCoord;
            }
            if (chunkCoord.getChunkX() < left.getChunkX()) {
                left = chunkCoord;
            }
            if (chunkCoord.getChunkZ() < top.getChunkZ()) {
                top = chunkCoord;
            }
            for (CustomObjectCoordinate struct : this.ObjectsToSpawn.get(chunkCoord)) {
                if (struct.getY() >= this.MinY) continue;
                this.MinY = struct.getY();
            }
        }
        this.MinY += ((BO3)this.Start.getObject()).getSettings().heightOffset;
        int smoothingRadiusInChunks = (int)Math.ceil((double)((BO3)this.Start.getObject()).getSettings().smoothRadius / 16.0);
        ((BO3)this.Start.getObject()).getSettings().MinimumSizeTop = Math.abs(startChunk.getChunkZ() - top.getChunkZ()) + smoothingRadiusInChunks;
        ((BO3)this.Start.getObject()).getSettings().MinimumSizeRight = Math.abs(startChunk.getChunkX() - right.getChunkX()) + smoothingRadiusInChunks;
        ((BO3)this.Start.getObject()).getSettings().MinimumSizeBottom = Math.abs(startChunk.getChunkZ() - bottom.getChunkZ()) + smoothingRadiusInChunks;
        ((BO3)this.Start.getObject()).getSettings().MinimumSizeLeft = Math.abs(startChunk.getChunkX() - left.getChunkX()) + smoothingRadiusInChunks;
        Object[] returnValue = new Object[]{((BO3)this.Start.getObject()).getSettings().MinimumSizeTop, ((BO3)this.Start.getObject()).getSettings().MinimumSizeRight, ((BO3)this.Start.getObject()).getSettings().MinimumSizeBottom, ((BO3)this.Start.getObject()).getSettings().MinimumSizeLeft};
        if (OTG.getPluginConfig().SpawnLog) {
            OTG.log(LogMarker.INFO, "", new Object[0]);
            OTG.log(LogMarker.INFO, this.Start.getObject().getName() + " minimum size: Width " + ((Integer)returnValue[1] + (Integer)returnValue[3] + 1) + " Length " + ((Integer)returnValue[0] + (Integer)returnValue[2] + 1) + " top " + (Integer)returnValue[0] + " right " + (Integer)returnValue[1] + " bottom " + (Integer)returnValue[2] + " left " + (Integer)returnValue[3], new Object[0]);
        }
        this.ObjectsToSpawn.clear();
        return returnValue;
    }

    private Map<ChunkCoordinate, ArrayList<Object[]>> CalculateSmoothingAreas() {
        HashMap<ChunkCoordinate, ArrayList<Object[]>> smoothToBlocksPerChunk = new HashMap<ChunkCoordinate, ArrayList<Object[]>>();
        for (Map.Entry<ChunkCoordinate, Stack<CustomObjectCoordinate>> chunkCoordSet : this.ObjectsToSpawn.entrySet()) {
            ChunkCoordinate chunkCoord = chunkCoordSet.getKey();
            Stack<CustomObjectCoordinate> bO3sInChunk = chunkCoordSet.getValue();
            ArrayList<Object[]> smoothToBlocks = new ArrayList<Object[]>();
            for (CustomObjectCoordinate objectInChunk : bO3sInChunk) {
                int smoothRadius;
                if (objectInChunk.isSpawned) continue;
                BO3 bO3InChunk = (BO3)objectInChunk.getObject();
                boolean SmoothStartTop = ((BO3)this.Start.getObject()).getSettings().overrideChildSettings && bO3InChunk.getSettings().overrideChildSettings ? ((BO3)this.Start.getObject()).getSettings().smoothStartTop : bO3InChunk.getSettings().smoothStartTop;
                int n = smoothRadius = ((BO3)this.Start.getObject()).getSettings().overrideChildSettings && bO3InChunk.getSettings().overrideChildSettings ? ((BO3)this.Start.getObject()).getSettings().smoothRadius : bO3InChunk.getSettings().smoothRadius;
                if (smoothRadius == -1 || bO3InChunk.getSettings().smoothRadius == -1) {
                    smoothRadius = 0;
                }
                if (smoothRadius <= 0) continue;
                Map<ChunkCoordinate, BlockFunction> heightMap = bO3InChunk.getSettings().getHeightMap((BO3)this.Start.getObject());
                for (int x = 0; x <= 15; ++x) {
                    for (int z = 0; z <= 15; ++z) {
                        Object[] smoothDirections;
                        CustomObjectCoordinate blockCoords;
                        int smoothRadius1;
                        int normalizedBlockToCheckZ;
                        int normalizedBlockToCheckY;
                        int normalizedBlockToCheckX;
                        CustomObjectCoordinate blockToCheckCoords;
                        BlockFunction blockToCheck;
                        Map<ChunkCoordinate, BlockFunction> neighbouringBO3HeightMap;
                        Stack<CustomObjectCoordinate> bO3sInNeighbouringBlockChunk;
                        ChunkCoordinate searchTarget;
                        ChunkCoordinate neighbouringBlockChunk;
                        int normalizedNeigbouringBlockZ;
                        int normalizedNeigbouringBlockY;
                        int normalizedNeigbouringBlockX;
                        CustomObjectCoordinate neighbouringBlockCoords;
                        BlockFunction block = heightMap.get(ChunkCoordinate.fromChunkCoords(x, z));
                        if (block == null) continue;
                        boolean bFoundNeighbour1 = false;
                        boolean bFoundNeighbour2 = false;
                        boolean bFoundNeighbour3 = false;
                        boolean bFoundNeighbour4 = false;
                        if (heightMap.get(ChunkCoordinate.fromChunkCoords(block.x - 1, block.z)) != null) {
                            bFoundNeighbour1 = true;
                        }
                        if (heightMap.get(ChunkCoordinate.fromChunkCoords(block.x + 1, block.z)) != null) {
                            bFoundNeighbour2 = true;
                        }
                        if (heightMap.get(ChunkCoordinate.fromChunkCoords(block.x, block.z - 1)) != null) {
                            bFoundNeighbour3 = true;
                        }
                        if (heightMap.get(ChunkCoordinate.fromChunkCoords(block.x, block.z + 1)) != null) {
                            bFoundNeighbour4 = true;
                        }
                        if (!bFoundNeighbour1 && block.x - 1 < 0) {
                            neighbouringBlockCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(block.x - 1, block.y, block.z, objectInChunk.getRotation());
                            normalizedNeigbouringBlockX = neighbouringBlockCoords.getX() + objectInChunk.getX();
                            normalizedNeigbouringBlockY = neighbouringBlockCoords.getY() + objectInChunk.getY();
                            normalizedNeigbouringBlockZ = neighbouringBlockCoords.getZ() + objectInChunk.getZ();
                            neighbouringBlockChunk = null;
                            searchTarget = ChunkCoordinate.fromBlockCoords(normalizedNeigbouringBlockX, normalizedNeigbouringBlockZ);
                            for (ChunkCoordinate chunkInStructure : this.ObjectsToSpawn.keySet()) {
                                if (chunkInStructure.getChunkX() != searchTarget.getChunkX() || chunkInStructure.getChunkZ() != searchTarget.getChunkZ()) continue;
                                neighbouringBlockChunk = chunkInStructure;
                                break;
                            }
                            if (neighbouringBlockChunk != null && (bO3sInNeighbouringBlockChunk = this.ObjectsToSpawn.get(neighbouringBlockChunk)) != null) {
                                for (CustomObjectCoordinate bO3ToCheck : bO3sInNeighbouringBlockChunk) {
                                    if (bO3ToCheck == objectInChunk) continue;
                                    neighbouringBO3HeightMap = ((BO3)bO3ToCheck.getObject()).getSettings().getHeightMap((BO3)this.Start.getObject());
                                    for (Map.Entry<ChunkCoordinate, BlockFunction> blockToCheckEntry : neighbouringBO3HeightMap.entrySet()) {
                                        blockToCheck = blockToCheckEntry.getValue();
                                        blockToCheckCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(blockToCheck.x, blockToCheck.y, blockToCheck.z, bO3ToCheck.getRotation());
                                        normalizedBlockToCheckX = blockToCheckCoords.getX() + bO3ToCheck.getX();
                                        normalizedBlockToCheckY = blockToCheckCoords.getY() + bO3ToCheck.getY();
                                        normalizedBlockToCheckZ = blockToCheckCoords.getZ() + bO3ToCheck.getZ();
                                        if (normalizedNeigbouringBlockX != normalizedBlockToCheckX || normalizedNeigbouringBlockY != normalizedBlockToCheckY && !SmoothStartTop || normalizedNeigbouringBlockZ != normalizedBlockToCheckZ || !this.isMaterialSmoothingAnchor(blockToCheck, bO3ToCheck)) continue;
                                        bFoundNeighbour1 = true;
                                        break;
                                    }
                                    if (!bFoundNeighbour1) continue;
                                    break;
                                }
                            }
                        }
                        if (!bFoundNeighbour2 && block.x + 1 > 15) {
                            neighbouringBlockCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(block.x + 1, block.y, block.z, objectInChunk.getRotation());
                            normalizedNeigbouringBlockX = neighbouringBlockCoords.getX() + objectInChunk.getX();
                            normalizedNeigbouringBlockY = neighbouringBlockCoords.getY() + objectInChunk.getY();
                            normalizedNeigbouringBlockZ = neighbouringBlockCoords.getZ() + objectInChunk.getZ();
                            neighbouringBlockChunk = null;
                            searchTarget = ChunkCoordinate.fromBlockCoords(normalizedNeigbouringBlockX, normalizedNeigbouringBlockZ);
                            for (ChunkCoordinate chunkInStructure : this.ObjectsToSpawn.keySet()) {
                                if (chunkInStructure.getChunkX() != searchTarget.getChunkX() || chunkInStructure.getChunkZ() != searchTarget.getChunkZ()) continue;
                                neighbouringBlockChunk = chunkInStructure;
                                break;
                            }
                            if (neighbouringBlockChunk != null && (bO3sInNeighbouringBlockChunk = this.ObjectsToSpawn.get(neighbouringBlockChunk)) != null) {
                                for (CustomObjectCoordinate bO3ToCheck : bO3sInNeighbouringBlockChunk) {
                                    if (bO3ToCheck == objectInChunk) continue;
                                    neighbouringBO3HeightMap = ((BO3)bO3ToCheck.getObject()).getSettings().getHeightMap((BO3)this.Start.getObject());
                                    for (Map.Entry<ChunkCoordinate, BlockFunction> blockToCheckEntry : neighbouringBO3HeightMap.entrySet()) {
                                        blockToCheck = blockToCheckEntry.getValue();
                                        blockToCheckCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(blockToCheck.x, blockToCheck.y, blockToCheck.z, bO3ToCheck.getRotation());
                                        normalizedBlockToCheckX = blockToCheckCoords.getX() + bO3ToCheck.getX();
                                        normalizedBlockToCheckY = blockToCheckCoords.getY() + bO3ToCheck.getY();
                                        normalizedBlockToCheckZ = blockToCheckCoords.getZ() + bO3ToCheck.getZ();
                                        if (normalizedNeigbouringBlockX != normalizedBlockToCheckX || normalizedNeigbouringBlockY != normalizedBlockToCheckY && !SmoothStartTop || normalizedNeigbouringBlockZ != normalizedBlockToCheckZ || !this.isMaterialSmoothingAnchor(blockToCheck, bO3ToCheck)) continue;
                                        bFoundNeighbour2 = true;
                                        break;
                                    }
                                    if (!bFoundNeighbour2) continue;
                                    break;
                                }
                            }
                        }
                        if (!bFoundNeighbour3 && block.z - 1 < 0) {
                            neighbouringBlockCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(block.x, block.y, block.z - 1, objectInChunk.getRotation());
                            normalizedNeigbouringBlockX = neighbouringBlockCoords.getX() + objectInChunk.getX();
                            normalizedNeigbouringBlockY = neighbouringBlockCoords.getY() + objectInChunk.getY();
                            normalizedNeigbouringBlockZ = neighbouringBlockCoords.getZ() + objectInChunk.getZ();
                            neighbouringBlockChunk = null;
                            searchTarget = ChunkCoordinate.fromBlockCoords(normalizedNeigbouringBlockX, normalizedNeigbouringBlockZ);
                            for (ChunkCoordinate chunkInStructure : this.ObjectsToSpawn.keySet()) {
                                if (chunkInStructure.getChunkX() != searchTarget.getChunkX() || chunkInStructure.getChunkZ() != searchTarget.getChunkZ()) continue;
                                neighbouringBlockChunk = chunkInStructure;
                                break;
                            }
                            if (neighbouringBlockChunk != null && (bO3sInNeighbouringBlockChunk = this.ObjectsToSpawn.get(neighbouringBlockChunk)) != null) {
                                for (CustomObjectCoordinate bO3ToCheck : bO3sInNeighbouringBlockChunk) {
                                    if (bO3ToCheck == objectInChunk) continue;
                                    neighbouringBO3HeightMap = ((BO3)bO3ToCheck.getObject()).getSettings().getHeightMap((BO3)this.Start.getObject());
                                    for (Map.Entry<ChunkCoordinate, BlockFunction> blockToCheckEntry : neighbouringBO3HeightMap.entrySet()) {
                                        blockToCheck = blockToCheckEntry.getValue();
                                        blockToCheckCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(blockToCheck.x, blockToCheck.y, blockToCheck.z, bO3ToCheck.getRotation());
                                        normalizedBlockToCheckX = blockToCheckCoords.getX() + bO3ToCheck.getX();
                                        normalizedBlockToCheckY = blockToCheckCoords.getY() + bO3ToCheck.getY();
                                        normalizedBlockToCheckZ = blockToCheckCoords.getZ() + bO3ToCheck.getZ();
                                        if (normalizedNeigbouringBlockX != normalizedBlockToCheckX || normalizedNeigbouringBlockY != normalizedBlockToCheckY && !SmoothStartTop || normalizedNeigbouringBlockZ != normalizedBlockToCheckZ || !this.isMaterialSmoothingAnchor(blockToCheck, bO3ToCheck)) continue;
                                        bFoundNeighbour3 = true;
                                        break;
                                    }
                                    if (!bFoundNeighbour3) continue;
                                    break;
                                }
                            }
                        }
                        if (!bFoundNeighbour4 && block.z + 1 > 15) {
                            neighbouringBlockCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(block.x, block.y, block.z + 1, objectInChunk.getRotation());
                            normalizedNeigbouringBlockX = neighbouringBlockCoords.getX() + objectInChunk.getX();
                            normalizedNeigbouringBlockY = neighbouringBlockCoords.getY() + objectInChunk.getY();
                            normalizedNeigbouringBlockZ = neighbouringBlockCoords.getZ() + objectInChunk.getZ();
                            neighbouringBlockChunk = null;
                            searchTarget = ChunkCoordinate.fromBlockCoords(normalizedNeigbouringBlockX, normalizedNeigbouringBlockZ);
                            for (ChunkCoordinate chunkInStructure : this.ObjectsToSpawn.keySet()) {
                                if (chunkInStructure.getChunkX() != searchTarget.getChunkX() || chunkInStructure.getChunkZ() != searchTarget.getChunkZ()) continue;
                                neighbouringBlockChunk = chunkInStructure;
                                break;
                            }
                            if (neighbouringBlockChunk != null && (bO3sInNeighbouringBlockChunk = this.ObjectsToSpawn.get(neighbouringBlockChunk)) != null) {
                                for (CustomObjectCoordinate bO3ToCheck : bO3sInNeighbouringBlockChunk) {
                                    if (bO3ToCheck == objectInChunk) continue;
                                    neighbouringBO3HeightMap = ((BO3)bO3ToCheck.getObject()).getSettings().getHeightMap((BO3)this.Start.getObject());
                                    for (Map.Entry<ChunkCoordinate, BlockFunction> blockToCheckEntry : neighbouringBO3HeightMap.entrySet()) {
                                        blockToCheck = blockToCheckEntry.getValue();
                                        blockToCheckCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(blockToCheck.x, blockToCheck.y, blockToCheck.z, bO3ToCheck.getRotation());
                                        normalizedBlockToCheckX = blockToCheckCoords.getX() + bO3ToCheck.getX();
                                        normalizedBlockToCheckY = blockToCheckCoords.getY() + bO3ToCheck.getY();
                                        normalizedBlockToCheckZ = blockToCheckCoords.getZ() + bO3ToCheck.getZ();
                                        if (normalizedNeigbouringBlockX != normalizedBlockToCheckX || normalizedNeigbouringBlockY != normalizedBlockToCheckY && !SmoothStartTop || normalizedNeigbouringBlockZ != normalizedBlockToCheckZ || !this.isMaterialSmoothingAnchor(blockToCheck, bO3ToCheck)) continue;
                                        bFoundNeighbour4 = true;
                                        break;
                                    }
                                    if (!bFoundNeighbour4) continue;
                                    break;
                                }
                            }
                        }
                        if (bFoundNeighbour1 && bFoundNeighbour2 && bFoundNeighbour3 && bFoundNeighbour4) continue;
                        int xOffset = 0;
                        int yOffset = 0;
                        int zOffset = 0;
                        int smoothHeightOffset = ((BO3)this.Start.getObject()).getSettings().overrideChildSettings && bO3InChunk.getSettings().overrideChildSettings ? ((BO3)this.Start.getObject()).getSettings().smoothHeightOffset : bO3InChunk.getSettings().smoothHeightOffset;
                        yOffset += smoothHeightOffset;
                        int n2 = bO3InChunk.getSettings().smoothRadius == -1 ? 0 : (smoothRadius1 = (((BO3)this.Start.getObject()).getSettings().overrideChildSettings && bO3InChunk.getSettings().overrideChildSettings ? ((BO3)this.Start.getObject()).getSettings().smoothRadius : bO3InChunk.getSettings().smoothRadius) - 1);
                        int smoothRadius2 = bO3InChunk.getSettings().smoothRadius == -1 ? 0 : (int)Math.ceil((double)((((BO3)this.Start.getObject()).getSettings().overrideChildSettings && bO3InChunk.getSettings().overrideChildSettings ? ((BO3)this.Start.getObject()).getSettings().smoothRadius : bO3InChunk.getSettings().smoothRadius) - 1) * Math.sin(0.7853981634));
                        int xOffset1 = 0;
                        int zOffset1 = 0;
                        if (!bFoundNeighbour1) {
                            xOffset = -1;
                            blockCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(block.x + xOffset + xOffset1, block.y + yOffset, block.z + zOffset1, objectInChunk.getRotation());
                            smoothDirections = this.RotateSmoothDirections(true, false, false, false, objectInChunk.getRotation());
                            smoothToBlocks.add(new Object[]{objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1});
                            if (!bFoundNeighbour3) {
                                zOffset = -1;
                                blockCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(block.x + xOffset + xOffset1, block.y + yOffset, block.z + zOffset + zOffset1, objectInChunk.getRotation());
                                smoothDirections = this.RotateSmoothDirections(true, false, true, false, objectInChunk.getRotation());
                                this.PlotDiagonalLine(smoothToBlocksPerChunk, new Object[]{objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1, smoothRadius2});
                            }
                            if (!bFoundNeighbour4) {
                                zOffset = 1;
                                blockCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(block.x + xOffset + xOffset1, block.y + yOffset, block.z + zOffset + zOffset1, objectInChunk.getRotation());
                                smoothDirections = this.RotateSmoothDirections(true, false, false, true, objectInChunk.getRotation());
                                this.PlotDiagonalLine(smoothToBlocksPerChunk, new Object[]{objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1, smoothRadius2});
                            }
                        }
                        if (!bFoundNeighbour2) {
                            xOffset = 1;
                            blockCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(block.x + xOffset + xOffset1, block.y + yOffset, block.z + zOffset1, objectInChunk.getRotation());
                            smoothDirections = this.RotateSmoothDirections(false, true, false, false, objectInChunk.getRotation());
                            smoothToBlocks.add(new Object[]{objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1});
                            if (!bFoundNeighbour3) {
                                zOffset = -1;
                                blockCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(block.x + xOffset + xOffset1, block.y + yOffset, block.z + zOffset + zOffset1, objectInChunk.getRotation());
                                smoothDirections = this.RotateSmoothDirections(false, true, true, false, objectInChunk.getRotation());
                                this.PlotDiagonalLine(smoothToBlocksPerChunk, new Object[]{objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1, smoothRadius2});
                            }
                            if (!bFoundNeighbour4) {
                                zOffset = 1;
                                blockCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(block.x + xOffset + xOffset1, block.y + yOffset, block.z + zOffset + zOffset1, objectInChunk.getRotation());
                                smoothDirections = this.RotateSmoothDirections(false, true, false, true, objectInChunk.getRotation());
                                this.PlotDiagonalLine(smoothToBlocksPerChunk, new Object[]{objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1, smoothRadius2});
                            }
                        }
                        if (!bFoundNeighbour3) {
                            zOffset = -1;
                            blockCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(block.x + xOffset1, block.y + yOffset, block.z + zOffset + zOffset1, objectInChunk.getRotation());
                            smoothDirections = this.RotateSmoothDirections(false, false, true, false, objectInChunk.getRotation());
                            smoothToBlocks.add(new Object[]{objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1});
                        }
                        if (bFoundNeighbour4) continue;
                        zOffset = 1;
                        blockCoords = CustomObjectCoordinate.getRotatedSmoothingCoords(block.x + xOffset1, block.y + yOffset, block.z + zOffset + zOffset1, objectInChunk.getRotation());
                        smoothDirections = this.RotateSmoothDirections(false, false, false, true, objectInChunk.getRotation());
                        smoothToBlocks.add(new Object[]{objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1});
                    }
                }
            }
            if (!smoothToBlocksPerChunk.containsKey(chunkCoord)) {
                smoothToBlocksPerChunk.put(chunkCoord, smoothToBlocks);
                continue;
            }
            ((ArrayList)smoothToBlocksPerChunk.get(chunkCoord)).addAll(smoothToBlocks);
        }
        return this.CalculateBeginAndEndPointsPerChunk(smoothToBlocksPerChunk);
    }

    Object[] RotateSmoothDirections(Boolean smoothDirection1, Boolean smoothDirection2, Boolean smoothDirection3, Boolean smoothDirection4, Rotation rotation) {
        if (rotation == Rotation.NORTH) {
            return new Object[]{smoothDirection1, smoothDirection2, smoothDirection3, smoothDirection4};
        }
        if (rotation == Rotation.EAST) {
            return new Object[]{smoothDirection4, smoothDirection3, smoothDirection1, smoothDirection2};
        }
        if (rotation == Rotation.SOUTH) {
            return new Object[]{smoothDirection2, smoothDirection1, smoothDirection4, smoothDirection3};
        }
        return new Object[]{smoothDirection3, smoothDirection4, smoothDirection2, smoothDirection1};
    }

    private boolean isMaterialSmoothingAnchor(BlockFunction blockToCheck, CustomObjectCoordinate bO3ToCheck) {
        boolean isSmoothAreaAnchor = false;
        if (blockToCheck instanceof RandomBlockFunction) {
            for (LocalMaterialData material : ((RandomBlockFunction)blockToCheck).blocks) {
                if (material == null || !material.isSmoothAreaAnchor(((BO3)this.Start.getObject()).getSettings().overrideChildSettings && ((BO3)bO3ToCheck.getObject()).getSettings().overrideChildSettings ? ((BO3)this.Start.getObject()).getSettings().smoothStartWood : ((BO3)bO3ToCheck.getObject()).getSettings().smoothStartWood, ((BO3)this.Start.getObject()).getSettings().SpawnUnderWater)) continue;
                isSmoothAreaAnchor = true;
                break;
            }
        }
        return isSmoothAreaAnchor || !(blockToCheck instanceof RandomBlockFunction) && blockToCheck.material.isSmoothAreaAnchor(((BO3)this.Start.getObject()).getSettings().overrideChildSettings && ((BO3)bO3ToCheck.getObject()).getSettings().overrideChildSettings ? ((BO3)this.Start.getObject()).getSettings().smoothStartWood : ((BO3)bO3ToCheck.getObject()).getSettings().smoothStartWood, ((BO3)this.Start.getObject()).getSettings().SpawnUnderWater);
    }

    private void PlotDiagonalLine(Map<ChunkCoordinate, ArrayList<Object[]>> smoothToBlocksPerChunk, Object[] blockCoordsAndNeighbours) {
        ArrayList beginAndEndPoints;
        ChunkCoordinate chunkcontainingSmoothArea;
        ArrayList<Object[]> beginningAndEndpoints;
        ChunkCoordinate nextBlocksChunkCoord;
        ChunkCoordinate destinationChunk;
        int normalizedSmoothEndPointBlockZ;
        int normalizedSmoothEndPointBlockX;
        int i;
        int beginPointZ;
        int beginPointY;
        int beginPointX;
        int normalizedSmoothFinalEndPointBlockZ1;
        int normalizedSmoothFinalEndPointBlockX1;
        HashMap smoothingAreasToSpawn = new HashMap();
        int normalizedSmoothFinalEndPointBlockY1 = -1;
        CustomObjectCoordinate bO3 = (CustomObjectCoordinate)blockCoordsAndNeighbours[0];
        int blockX = (Integer)blockCoordsAndNeighbours[1];
        int blockY = (Integer)blockCoordsAndNeighbours[2];
        int blockZ = (Integer)blockCoordsAndNeighbours[3];
        boolean smoothInDirection1 = (Boolean)blockCoordsAndNeighbours[4];
        boolean smoothInDirection2 = (Boolean)blockCoordsAndNeighbours[5];
        boolean smoothInDirection3 = (Boolean)blockCoordsAndNeighbours[6];
        boolean smoothInDirection4 = (Boolean)blockCoordsAndNeighbours[7];
        int smoothRadius = (Integer)blockCoordsAndNeighbours[8];
        int smoothRadiusDiagonal = (Integer)blockCoordsAndNeighbours[9];
        if (smoothInDirection1 && smoothInDirection3) {
            normalizedSmoothFinalEndPointBlockX1 = blockX - smoothRadiusDiagonal + bO3.getX();
            normalizedSmoothFinalEndPointBlockZ1 = blockZ - smoothRadiusDiagonal + bO3.getZ();
            beginPointX = blockX + bO3.getX();
            beginPointY = blockY + bO3.getY();
            beginPointZ = blockZ + bO3.getZ();
            for (i = 0; i <= smoothRadiusDiagonal; ++i) {
                normalizedSmoothEndPointBlockX = blockX - i + bO3.getX();
                destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ = blockZ - i + bO3.getZ());
                if (destinationChunk.equals(nextBlocksChunkCoord = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX - 1, normalizedSmoothEndPointBlockZ - 1)) && i != smoothRadiusDiagonal) continue;
                beginningAndEndpoints = new ArrayList<Object[]>();
                beginningAndEndpoints.add(new Object[]{beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1});
                for (Map.Entry chunkcontainingSmoothAreaSet : smoothingAreasToSpawn.entrySet()) {
                    chunkcontainingSmoothArea = (ChunkCoordinate)chunkcontainingSmoothAreaSet.getKey();
                    if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                    beginAndEndPoints = (ArrayList)chunkcontainingSmoothAreaSet.getValue();
                    beginAndEndPoints.add(new Object[]{beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1});
                    break;
                }
                smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                beginPointX = normalizedSmoothEndPointBlockX - 1;
                beginPointZ = normalizedSmoothEndPointBlockZ - 1;
            }
        }
        if (smoothInDirection1 && smoothInDirection4) {
            normalizedSmoothFinalEndPointBlockX1 = blockX - smoothRadiusDiagonal + bO3.getX();
            normalizedSmoothFinalEndPointBlockZ1 = blockZ + smoothRadiusDiagonal + bO3.getZ();
            beginPointX = blockX + bO3.getX();
            beginPointY = blockY + bO3.getY();
            beginPointZ = blockZ + bO3.getZ();
            for (i = 0; i <= smoothRadiusDiagonal; ++i) {
                normalizedSmoothEndPointBlockX = blockX - i + bO3.getX();
                destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ = blockZ + i + bO3.getZ());
                if (destinationChunk.equals(nextBlocksChunkCoord = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX - 1, normalizedSmoothEndPointBlockZ + 1)) && i != smoothRadiusDiagonal) continue;
                beginningAndEndpoints = new ArrayList();
                beginningAndEndpoints.add(new Object[]{beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1});
                for (Map.Entry chunkcontainingSmoothAreaSet : smoothingAreasToSpawn.entrySet()) {
                    chunkcontainingSmoothArea = (ChunkCoordinate)chunkcontainingSmoothAreaSet.getKey();
                    if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                    beginAndEndPoints = (ArrayList)chunkcontainingSmoothAreaSet.getValue();
                    beginAndEndPoints.add(new Object[]{beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1});
                    break;
                }
                smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                beginPointX = normalizedSmoothEndPointBlockX - 1;
                beginPointZ = normalizedSmoothEndPointBlockZ + 1;
            }
        }
        if (smoothInDirection2 && smoothInDirection3) {
            normalizedSmoothFinalEndPointBlockX1 = blockX + smoothRadiusDiagonal + bO3.getX();
            normalizedSmoothFinalEndPointBlockZ1 = blockZ - smoothRadiusDiagonal + bO3.getZ();
            beginPointX = blockX + bO3.getX();
            beginPointY = blockY + bO3.getY();
            beginPointZ = blockZ + bO3.getZ();
            for (i = 0; i <= smoothRadiusDiagonal; ++i) {
                normalizedSmoothEndPointBlockX = blockX + i + bO3.getX();
                destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ = blockZ - i + bO3.getZ());
                if (destinationChunk.equals(nextBlocksChunkCoord = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX + 1, normalizedSmoothEndPointBlockZ - 1)) && i != smoothRadiusDiagonal) continue;
                beginningAndEndpoints = new ArrayList();
                beginningAndEndpoints.add(new Object[]{beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1});
                for (Map.Entry chunkcontainingSmoothAreaSet : smoothingAreasToSpawn.entrySet()) {
                    chunkcontainingSmoothArea = (ChunkCoordinate)chunkcontainingSmoothAreaSet.getKey();
                    if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                    beginAndEndPoints = (ArrayList)chunkcontainingSmoothAreaSet.getValue();
                    beginAndEndPoints.add(new Object[]{beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1});
                    break;
                }
                smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                beginPointX = normalizedSmoothEndPointBlockX + 1;
                beginPointZ = normalizedSmoothEndPointBlockZ - 1;
            }
        }
        if (smoothInDirection2 && smoothInDirection4) {
            normalizedSmoothFinalEndPointBlockX1 = blockX + smoothRadiusDiagonal + bO3.getX();
            normalizedSmoothFinalEndPointBlockZ1 = blockZ + smoothRadiusDiagonal + bO3.getZ();
            beginPointX = blockX + bO3.getX();
            beginPointY = blockY + bO3.getY();
            beginPointZ = blockZ + bO3.getZ();
            for (i = 0; i <= smoothRadiusDiagonal; ++i) {
                normalizedSmoothEndPointBlockX = blockX + i + bO3.getX();
                destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ = blockZ + i + bO3.getZ());
                if (destinationChunk.equals(nextBlocksChunkCoord = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX + 1, normalizedSmoothEndPointBlockZ + 1)) && i != smoothRadiusDiagonal) continue;
                beginningAndEndpoints = new ArrayList();
                beginningAndEndpoints.add(new Object[]{beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1});
                for (Map.Entry chunkcontainingSmoothAreaSet : smoothingAreasToSpawn.entrySet()) {
                    chunkcontainingSmoothArea = (ChunkCoordinate)chunkcontainingSmoothAreaSet.getKey();
                    if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                    beginAndEndPoints = (ArrayList)chunkcontainingSmoothAreaSet.getValue();
                    beginAndEndPoints.add(new Object[]{beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1});
                    break;
                }
                smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                beginPointX = normalizedSmoothEndPointBlockX + 1;
                beginPointZ = normalizedSmoothEndPointBlockZ + 1;
            }
        }
        int diagonalBlockSmoothRadius = 0;
        int diagonalBlockSmoothRadius2 = 0;
        for (Map.Entry smoothingAreaInChunk : smoothingAreasToSpawn.entrySet()) {
            for (Object[] smoothingBeginAndEndPoints : (ArrayList)smoothingAreaInChunk.getValue()) {
                int distanceFromStart = 0;
                BlockFunction beginPoint = new BlockFunction();
                beginPoint.x = (Integer)smoothingBeginAndEndPoints[0];
                beginPoint.y = (Integer)smoothingBeginAndEndPoints[1];
                beginPoint.z = (Integer)smoothingBeginAndEndPoints[2];
                BlockFunction endPoint = new BlockFunction();
                endPoint.x = (Integer)smoothingBeginAndEndPoints[3];
                endPoint.y = (Integer)smoothingBeginAndEndPoints[4];
                endPoint.z = (Integer)smoothingBeginAndEndPoints[5];
                int originPointX = (Integer)smoothingBeginAndEndPoints[6];
                int originPointY = (Integer)smoothingBeginAndEndPoints[7];
                int originPointZ = (Integer)smoothingBeginAndEndPoints[8];
                int finalDestinationPointX = (Integer)smoothingBeginAndEndPoints[9];
                int finalDestinationPointY = (Integer)smoothingBeginAndEndPoints[10];
                int finalDestinationPointZ = (Integer)smoothingBeginAndEndPoints[11];
                diagonalBlockSmoothRadius = smoothRadius;
                distanceFromStart = Math.abs(beginPoint.x - originPointX);
                for (int i2 = 0; i2 <= Math.abs(beginPoint.z - endPoint.z); ++i2) {
                    BlockFunction filler = new BlockFunction();
                    if (smoothInDirection2) {
                        filler.x = beginPoint.x + i2;
                    }
                    if (smoothInDirection1) {
                        filler.x = beginPoint.x - i2;
                    }
                    if (smoothInDirection4) {
                        filler.z = beginPoint.z + i2;
                    }
                    if (smoothInDirection3) {
                        filler.z = beginPoint.z - i2;
                    }
                    filler.y = beginPoint.y;
                    ArrayList<Object[]> smoothToBlocks = new ArrayList<Object[]>();
                    bO3 = new CustomObjectCoordinate(this.World, null, null, null, 0, 0, 0, false, 0, false, false, null);
                    diagonalBlockSmoothRadius2 = (int)Math.round(Math.sqrt(diagonalBlockSmoothRadius * diagonalBlockSmoothRadius - (distanceFromStart + i2) * (distanceFromStart + i2)) - (double)(distanceFromStart + i2));
                    destinationChunk = ChunkCoordinate.fromBlockCoords(beginPoint.x, endPoint.x);
                    if (smoothInDirection1) {
                        smoothToBlocks.add(new Object[]{bO3, filler.x, filler.y, filler.z, true, false, false, false, diagonalBlockSmoothRadius2, originPointX, originPointY, originPointZ, finalDestinationPointX, finalDestinationPointY, finalDestinationPointZ});
                    }
                    if (smoothInDirection2) {
                        smoothToBlocks.add(new Object[]{bO3, filler.x, filler.y, filler.z, false, true, false, false, diagonalBlockSmoothRadius2, originPointX, originPointY, originPointZ, finalDestinationPointX, finalDestinationPointY, finalDestinationPointZ});
                    }
                    if (smoothInDirection3) {
                        smoothToBlocks.add(new Object[]{bO3, filler.x, filler.y, filler.z, false, false, true, false, diagonalBlockSmoothRadius2, originPointX, originPointY, originPointZ, finalDestinationPointX, finalDestinationPointY, finalDestinationPointZ});
                    }
                    if (smoothInDirection4) {
                        smoothToBlocks.add(new Object[]{bO3, filler.x, filler.y, filler.z, false, false, false, true, diagonalBlockSmoothRadius2, originPointX, originPointY, originPointZ, finalDestinationPointX, finalDestinationPointY, finalDestinationPointZ});
                    }
                    if (!smoothToBlocksPerChunk.containsKey(destinationChunk)) {
                        smoothToBlocksPerChunk.put(destinationChunk, smoothToBlocks);
                        continue;
                    }
                    smoothToBlocksPerChunk.get(destinationChunk).addAll(smoothToBlocks);
                }
            }
        }
    }

    private Map<ChunkCoordinate, ArrayList<Object[]>> CalculateBeginAndEndPointsPerChunk(Map<ChunkCoordinate, ArrayList<Object[]>> smoothToBlocksPerChunk) {
        HashMap<ChunkCoordinate, ArrayList<Object[]>> smoothingAreasToSpawn = new HashMap<ChunkCoordinate, ArrayList<Object[]>>();
        int originPointX = 0;
        int originPointY = 0;
        int originPointZ = 0;
        int finalDestinationPointX = 0;
        int finalDestinationPointY = 0;
        int finalDestinationPointZ = 0;
        for (Map.Entry<ChunkCoordinate, ArrayList<Object[]>> chunkCoordSet : smoothToBlocksPerChunk.entrySet()) {
            for (Object[] blockCoordsAndNeighbours : chunkCoordSet.getValue()) {
                ArrayList beginAndEndPoints;
                ChunkCoordinate chunkcontainingSmoothArea;
                Object[] objectToAdd;
                ArrayList<Object[]> beginningAndEndpoints;
                int endPointZ;
                int endPointY;
                int endPointX;
                int beginPointZ;
                int beginPointY;
                int beginPointX;
                boolean bFound;
                ChunkCoordinate destinationChunk;
                int normalizedSmoothEndPointBlockZ;
                int normalizedSmoothEndPointBlockY;
                int normalizedSmoothEndPointBlockX;
                int i;
                ArrayList<ChunkCoordinate> smoothingAreasToSpawnForThisBlock;
                ChunkCoordinate finalDestinationChunk;
                int normalizedSmoothFinalEndPointBlockY1;
                int normalizedSmoothFinalEndPointBlockZ1;
                int normalizedSmoothFinalEndPointBlockX1;
                CustomObjectCoordinate bO3 = (CustomObjectCoordinate)blockCoordsAndNeighbours[0];
                int blockX = (Integer)blockCoordsAndNeighbours[1];
                int blockY = (Integer)blockCoordsAndNeighbours[2];
                int blockZ = (Integer)blockCoordsAndNeighbours[3];
                boolean smoothInDirection1 = (Boolean)blockCoordsAndNeighbours[4];
                boolean smoothInDirection2 = (Boolean)blockCoordsAndNeighbours[5];
                boolean smoothInDirection3 = (Boolean)blockCoordsAndNeighbours[6];
                boolean smoothInDirection4 = (Boolean)blockCoordsAndNeighbours[7];
                int smoothRadius = (Integer)blockCoordsAndNeighbours[8];
                if (blockCoordsAndNeighbours.length > 14) {
                    originPointX = (Integer)blockCoordsAndNeighbours[9];
                    originPointY = (Integer)blockCoordsAndNeighbours[10];
                    originPointZ = (Integer)blockCoordsAndNeighbours[11];
                    finalDestinationPointX = (Integer)blockCoordsAndNeighbours[12];
                    finalDestinationPointY = (Integer)blockCoordsAndNeighbours[13];
                    finalDestinationPointZ = (Integer)blockCoordsAndNeighbours[14];
                }
                if (smoothRadius != 0 || blockCoordsAndNeighbours.length < 15) {
                    // empty if block
                }
                if (smoothInDirection1) {
                    normalizedSmoothFinalEndPointBlockX1 = blockX - smoothRadius + bO3.getX();
                    normalizedSmoothFinalEndPointBlockZ1 = blockZ + bO3.getZ();
                    normalizedSmoothFinalEndPointBlockY1 = -1;
                    finalDestinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockZ1);
                    smoothingAreasToSpawnForThisBlock = new ArrayList<ChunkCoordinate>();
                    for (i = 0; i <= smoothRadius; ++i) {
                        normalizedSmoothEndPointBlockX = blockX - i + bO3.getX();
                        normalizedSmoothEndPointBlockY = blockY + bO3.getY();
                        normalizedSmoothEndPointBlockZ = blockZ + bO3.getZ();
                        destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ);
                        bFound = false;
                        for (ChunkCoordinate chunkCoordinate : smoothingAreasToSpawnForThisBlock) {
                            if (destinationChunk.getChunkX() != chunkCoordinate.getChunkX() || destinationChunk.getChunkZ() != chunkCoordinate.getChunkZ()) continue;
                            bFound = true;
                            break;
                        }
                        if (bFound) continue;
                        beginPointX = normalizedSmoothEndPointBlockX;
                        beginPointY = normalizedSmoothEndPointBlockY;
                        beginPointZ = normalizedSmoothEndPointBlockZ;
                        endPointX = normalizedSmoothEndPointBlockX;
                        endPointY = normalizedSmoothEndPointBlockY;
                        endPointZ = normalizedSmoothEndPointBlockZ;
                        endPointX = finalDestinationChunk.getChunkX() != destinationChunk.getChunkX() || finalDestinationChunk.getChunkZ() != destinationChunk.getChunkZ() ? destinationChunk.getChunkX() * 16 : (normalizedSmoothEndPointBlockX -= smoothRadius - i);
                        beginningAndEndpoints = new ArrayList();
                        objectToAdd = blockCoordsAndNeighbours.length > 14 ? new Object[]{beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), -1, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1, originPointX + bO3.getX(), originPointY, originPointZ + bO3.getZ(), finalDestinationPointX + bO3.getX(), finalDestinationPointY, finalDestinationPointZ + bO3.getZ()} : new Object[]{beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1};
                        beginningAndEndpoints.add(objectToAdd);
                        for (Map.Entry entry : smoothingAreasToSpawn.entrySet()) {
                            chunkcontainingSmoothArea = (ChunkCoordinate)entry.getKey();
                            if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                            bFound = true;
                            beginAndEndPoints = (ArrayList)entry.getValue();
                            beginAndEndPoints.add(objectToAdd);
                            break;
                        }
                        if (!bFound) {
                            smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                        }
                        smoothingAreasToSpawnForThisBlock.add(destinationChunk);
                    }
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                }
                if (smoothInDirection2) {
                    normalizedSmoothFinalEndPointBlockX1 = blockX + smoothRadius + bO3.getX();
                    normalizedSmoothFinalEndPointBlockZ1 = blockZ + bO3.getZ();
                    normalizedSmoothFinalEndPointBlockY1 = -1;
                    finalDestinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockZ1);
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                    for (i = 0; i <= smoothRadius; ++i) {
                        normalizedSmoothEndPointBlockX = blockX + i + bO3.getX();
                        normalizedSmoothEndPointBlockY = blockY + bO3.getY();
                        normalizedSmoothEndPointBlockZ = blockZ + bO3.getZ();
                        destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ);
                        bFound = false;
                        for (ChunkCoordinate chunkCoordinate : smoothingAreasToSpawnForThisBlock) {
                            if (destinationChunk.getChunkX() != chunkCoordinate.getChunkX() || destinationChunk.getChunkZ() != chunkCoordinate.getChunkZ()) continue;
                            bFound = true;
                            break;
                        }
                        if (bFound) continue;
                        beginPointX = normalizedSmoothEndPointBlockX;
                        beginPointY = normalizedSmoothEndPointBlockY;
                        beginPointZ = normalizedSmoothEndPointBlockZ;
                        endPointX = normalizedSmoothEndPointBlockX;
                        endPointY = normalizedSmoothEndPointBlockY;
                        endPointZ = normalizedSmoothEndPointBlockZ;
                        endPointX = finalDestinationChunk.getChunkX() != destinationChunk.getChunkX() || finalDestinationChunk.getChunkZ() != destinationChunk.getChunkZ() ? destinationChunk.getChunkX() * 16 + 15 : (normalizedSmoothEndPointBlockX += smoothRadius - i);
                        beginningAndEndpoints = new ArrayList();
                        objectToAdd = blockCoordsAndNeighbours.length > 14 ? new Object[]{beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), -1, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1, originPointX + bO3.getX(), originPointY, originPointZ + bO3.getZ(), finalDestinationPointX + bO3.getX(), finalDestinationPointY, finalDestinationPointZ + bO3.getZ()} : new Object[]{beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1};
                        beginningAndEndpoints.add(objectToAdd);
                        for (Map.Entry entry : smoothingAreasToSpawn.entrySet()) {
                            chunkcontainingSmoothArea = (ChunkCoordinate)entry.getKey();
                            if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                            bFound = true;
                            beginAndEndPoints = (ArrayList)entry.getValue();
                            beginAndEndPoints.add(objectToAdd);
                            break;
                        }
                        if (!bFound) {
                            smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                        }
                        smoothingAreasToSpawnForThisBlock.add(destinationChunk);
                    }
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                }
                if (smoothInDirection3) {
                    normalizedSmoothFinalEndPointBlockX1 = blockX + bO3.getX();
                    normalizedSmoothFinalEndPointBlockZ1 = blockZ - smoothRadius + bO3.getZ();
                    normalizedSmoothFinalEndPointBlockY1 = -1;
                    finalDestinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockZ1);
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                    for (i = 0; i <= smoothRadius; ++i) {
                        normalizedSmoothEndPointBlockX = blockX + bO3.getX();
                        normalizedSmoothEndPointBlockY = blockY + bO3.getY();
                        normalizedSmoothEndPointBlockZ = blockZ - i + bO3.getZ();
                        destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ);
                        bFound = false;
                        for (ChunkCoordinate chunkCoordinate : smoothingAreasToSpawnForThisBlock) {
                            if (destinationChunk.getChunkX() != chunkCoordinate.getChunkX() || destinationChunk.getChunkZ() != chunkCoordinate.getChunkZ()) continue;
                            bFound = true;
                            break;
                        }
                        if (bFound) continue;
                        beginPointX = normalizedSmoothEndPointBlockX;
                        beginPointY = normalizedSmoothEndPointBlockY;
                        beginPointZ = normalizedSmoothEndPointBlockZ;
                        endPointX = normalizedSmoothEndPointBlockX;
                        endPointY = normalizedSmoothEndPointBlockY;
                        endPointZ = normalizedSmoothEndPointBlockZ;
                        endPointZ = finalDestinationChunk.getChunkX() != destinationChunk.getChunkX() || finalDestinationChunk.getChunkZ() != destinationChunk.getChunkZ() ? destinationChunk.getChunkZ() * 16 : (normalizedSmoothEndPointBlockZ -= smoothRadius - i);
                        beginningAndEndpoints = new ArrayList();
                        objectToAdd = blockCoordsAndNeighbours.length > 14 ? new Object[]{beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), -1, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1, originPointX + bO3.getX(), originPointY, originPointZ + bO3.getZ(), finalDestinationPointX + bO3.getX(), finalDestinationPointY, finalDestinationPointZ + bO3.getZ()} : new Object[]{beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1};
                        beginningAndEndpoints.add(objectToAdd);
                        for (Map.Entry entry : smoothingAreasToSpawn.entrySet()) {
                            chunkcontainingSmoothArea = (ChunkCoordinate)entry.getKey();
                            if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                            bFound = true;
                            beginAndEndPoints = (ArrayList)entry.getValue();
                            beginAndEndPoints.add(objectToAdd);
                            break;
                        }
                        if (!bFound) {
                            smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                        }
                        smoothingAreasToSpawnForThisBlock.add(destinationChunk);
                    }
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                }
                if (smoothInDirection4) {
                    normalizedSmoothFinalEndPointBlockX1 = blockX + bO3.getX();
                    normalizedSmoothFinalEndPointBlockZ1 = blockZ + smoothRadius + bO3.getZ();
                    normalizedSmoothFinalEndPointBlockY1 = -1;
                    finalDestinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockZ1);
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                    for (i = 0; i <= smoothRadius; ++i) {
                        normalizedSmoothEndPointBlockX = blockX + bO3.getX();
                        normalizedSmoothEndPointBlockY = blockY + bO3.getY();
                        normalizedSmoothEndPointBlockZ = blockZ + i + bO3.getZ();
                        destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ);
                        bFound = false;
                        for (ChunkCoordinate chunkCoordinate : smoothingAreasToSpawnForThisBlock) {
                            if (destinationChunk.getChunkX() != chunkCoordinate.getChunkX() || destinationChunk.getChunkZ() != chunkCoordinate.getChunkZ()) continue;
                            bFound = true;
                            break;
                        }
                        if (bFound) continue;
                        beginPointX = normalizedSmoothEndPointBlockX;
                        beginPointY = normalizedSmoothEndPointBlockY;
                        beginPointZ = normalizedSmoothEndPointBlockZ;
                        endPointX = normalizedSmoothEndPointBlockX;
                        endPointY = normalizedSmoothEndPointBlockY;
                        endPointZ = normalizedSmoothEndPointBlockZ;
                        endPointZ = finalDestinationChunk.getChunkX() != destinationChunk.getChunkX() || finalDestinationChunk.getChunkZ() != destinationChunk.getChunkZ() ? destinationChunk.getChunkZ() * 16 + 15 : (normalizedSmoothEndPointBlockZ += smoothRadius - i);
                        beginningAndEndpoints = new ArrayList();
                        objectToAdd = blockCoordsAndNeighbours.length > 14 ? new Object[]{beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), -1, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1, originPointX + bO3.getX(), originPointY, originPointZ + bO3.getZ(), finalDestinationPointX + bO3.getX(), finalDestinationPointY, finalDestinationPointZ + bO3.getZ()} : new Object[]{beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1};
                        beginningAndEndpoints.add(objectToAdd);
                        for (Map.Entry entry : smoothingAreasToSpawn.entrySet()) {
                            chunkcontainingSmoothArea = (ChunkCoordinate)entry.getKey();
                            if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                            bFound = true;
                            beginAndEndPoints = (ArrayList)entry.getValue();
                            beginAndEndPoints.add(objectToAdd);
                            break;
                        }
                        if (!bFound) {
                            smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                        }
                        smoothingAreasToSpawnForThisBlock.add(destinationChunk);
                    }
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                }
                if (smoothInDirection1 || smoothInDirection2 || smoothInDirection3 || smoothInDirection4) continue;
                normalizedSmoothFinalEndPointBlockX1 = blockX + bO3.getX();
                normalizedSmoothFinalEndPointBlockZ1 = blockZ + bO3.getZ();
                normalizedSmoothFinalEndPointBlockY1 = -1;
                finalDestinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockZ1);
                smoothingAreasToSpawnForThisBlock = new ArrayList();
                normalizedSmoothEndPointBlockX = blockX + bO3.getX();
                normalizedSmoothEndPointBlockY = blockY + bO3.getY();
                normalizedSmoothEndPointBlockZ = blockZ + bO3.getZ();
                destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ);
                bFound = false;
                for (ChunkCoordinate chunkCoordinate : smoothingAreasToSpawnForThisBlock) {
                    if (destinationChunk.getChunkX() != chunkCoordinate.getChunkX() || destinationChunk.getChunkZ() != chunkCoordinate.getChunkZ()) continue;
                    bFound = true;
                    break;
                }
                if (!bFound) {
                    beginPointX = normalizedSmoothEndPointBlockX;
                    beginPointY = normalizedSmoothEndPointBlockY;
                    beginPointZ = normalizedSmoothEndPointBlockZ;
                    endPointX = normalizedSmoothEndPointBlockX;
                    endPointY = normalizedSmoothEndPointBlockY;
                    endPointZ = normalizedSmoothEndPointBlockZ;
                    beginningAndEndpoints = new ArrayList<Object[]>();
                    objectToAdd = blockCoordsAndNeighbours.length > 14 ? new Object[]{beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), -1, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1, originPointX + bO3.getX(), originPointY, originPointZ + bO3.getZ(), finalDestinationPointX + bO3.getX(), finalDestinationPointY, finalDestinationPointZ + bO3.getZ()} : new Object[]{beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1};
                    if (normalizedSmoothFinalEndPointBlockY1 != -1) {
                        throw new RuntimeException();
                    }
                    beginningAndEndpoints.add(objectToAdd);
                    for (Map.Entry entry : smoothingAreasToSpawn.entrySet()) {
                        chunkcontainingSmoothArea = (ChunkCoordinate)entry.getKey();
                        if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                        bFound = true;
                        beginAndEndPoints = (ArrayList)entry.getValue();
                        beginAndEndPoints.add(objectToAdd);
                        break;
                    }
                    if (!bFound) {
                        smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                    }
                    smoothingAreasToSpawnForThisBlock.add(destinationChunk);
                }
                smoothingAreasToSpawnForThisBlock = new ArrayList();
            }
        }
        return smoothingAreasToSpawn;
    }

    public void CalculateBranches(boolean minimumSize) throws InvalidConfigException {
        if (OTG.getPluginConfig().SpawnLog) {
            String sminimumSize = minimumSize ? " (minimumSize)" : "";
            OTG.log(LogMarker.INFO, "", new Object[0]);
            OTG.log(LogMarker.INFO, "-------- CalculateBranches " + this.Start.BO3Name + sminimumSize + " --------", new Object[0]);
        }
        BranchDataItem branchData = new BranchDataItem(this.World, this.Random, null, this.Start, null, 0, 0, minimumSize);
        if (OTG.getPluginConfig().SpawnLog) {
            OTG.log(LogMarker.INFO, "", new Object[0]);
            OTG.log(LogMarker.INFO, "---- Cycle 0 ----", new Object[0]);
            OTG.log(LogMarker.INFO, "Plotted X" + branchData.ChunkCoordinate.getChunkX() + " Z" + branchData.ChunkCoordinate.getChunkZ() + " - " + branchData.Branch.getObject().getName(), new Object[0]);
        }
        this.AllBranchesBranchData.add(branchData);
        this.AllBranchesBranchDataHash.add(branchData.branchNumber);
        Stack<BranchDataItem> branchDataItemStack = this.AllBranchesBranchDataByChunk.get(branchData.ChunkCoordinate);
        if (branchDataItemStack != null) {
            branchDataItemStack.add(branchData);
        } else {
            branchDataItemStack = new Stack();
            branchDataItemStack.add(branchData);
            this.AllBranchesBranchDataByChunk.put(branchData.ChunkCoordinate, branchDataItemStack);
        }
        this.Cycle = 0;
        boolean canOverrideBranchesSpawned = false;
        this.SpawningCanOverrideBranches = false;
        while (!this.ProcessingDone) {
            this.SpawnedBranchLastCycle = this.SpawnedBranchThisCycle;
            this.SpawnedBranchThisCycle = false;
            ++this.Cycle;
            if (OTG.getPluginConfig().SpawnLog) {
                OTG.log(LogMarker.INFO, "", new Object[0]);
                OTG.log(LogMarker.INFO, "---- Cycle " + this.Cycle + " ----", new Object[0]);
            }
            this.TraverseAndSpawnChildBranches(branchData, minimumSize);
            if (OTG.getPluginConfig().SpawnLog) {
                OTG.log(LogMarker.INFO, "All branch groups with required branches only have been processed for cycle " + this.Cycle + ", plotting branch groups with optional branches.", new Object[0]);
            }
            this.SpawningRequiredBranchesOnly = false;
            this.TraverseAndSpawnChildBranches(branchData, minimumSize);
            this.SpawningRequiredBranchesOnly = true;
            this.ProcessingDone = true;
            for (BranchDataItem branchDataItem3 : this.AllBranchesBranchData) {
                if (branchDataItem3.DoneSpawning) continue;
                this.ProcessingDone = false;
                break;
            }
            if (this.ProcessingDone && !canOverrideBranchesSpawned) {
                canOverrideBranchesSpawned = true;
                this.SpawningCanOverrideBranches = true;
                this.ProcessingDone = false;
                for (BranchDataItem branchDataItem3 : this.AllBranchesBranchData) {
                    for (BranchDataItem childBranch : branchDataItem3.getChildren(false)) {
                        if (childBranch.Branch.isRequiredBranch || !((BO3)childBranch.Branch.getObject()).getSettings().canOverride) continue;
                        branchDataItem3.DoneSpawning = false;
                        childBranch.DoneSpawning = false;
                        childBranch.CannotSpawn = false;
                        if (branchDataItem3.wasDeleted) {
                            throw new RuntimeException();
                        }
                        if (!childBranch.wasDeleted) continue;
                        throw new RuntimeException();
                    }
                }
            }
            if (!branchData.CannotSpawn) continue;
            if (minimumSize) {
                OTG.log(LogMarker.INFO, "Error: Branching BO3 " + this.Start.BO3Name + " could not be spawned in minimum configuration (isRequiredBranch branches only).", new Object[0]);
                throw new InvalidConfigException("");
            }
            return;
        }
        for (BranchDataItem branchToAdd : this.AllBranchesBranchData) {
            if (branchToAdd.CannotSpawn) continue;
            if (branchToAdd.Branch == null) {
                throw new RuntimeException();
            }
            this.AddToChunk(branchToAdd.Branch, branchToAdd.ChunkCoordinate, this.ObjectsToSpawn);
        }
    }

    private void TraverseAndSpawnChildBranches(BranchDataItem branchData, boolean minimumSize) {
        if (!branchData.DoneSpawning) {
            this.AddBranches(branchData, minimumSize, false);
        } else if (!branchData.CannotSpawn) {
            for (BranchDataItem branchDataItem2 : branchData.getChildren(false)) {
                if (branchDataItem2.CannotSpawn || !branchData.DoneSpawning) continue;
                this.TraverseAndSpawnChildBranches(branchDataItem2, minimumSize);
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void AddBranches(BranchDataItem branchDataItem, boolean minimumSize, boolean traverseOnlySpawnedChildren) {
        if (!this.SpawningCanOverrideBranches) {
            for (Object branchDataItem3 : branchDataItem.getChildren(false)) {
                if (((BranchDataItem)branchDataItem3).CannotSpawn && ((BranchDataItem)branchDataItem3).DoneSpawning || !((BO3)((BranchDataItem)branchDataItem3).Branch.getObject()).getSettings().canOverride || ((BranchDataItem)branchDataItem3).Branch.isRequiredBranch) continue;
                ((BranchDataItem)branchDataItem3).CannotSpawn = true;
                ((BranchDataItem)branchDataItem3).DoneSpawning = true;
            }
        }
        if (this.SpawningRequiredChildrenForOptionalBranch && traverseOnlySpawnedChildren) {
            throw new RuntimeException();
        }
        if (!this.SpawningRequiredBranchesOnly) {
            branchDataItem.DoneSpawning = true;
        } else {
            boolean hasOnlyRequiredBranches = true;
            for (BranchDataItem branchDataItem3 : branchDataItem.getChildren(false)) {
                if (branchDataItem3.Branch.isRequiredBranch || branchDataItem3.DoneSpawning || branchDataItem3.CannotSpawn) continue;
                hasOnlyRequiredBranches = false;
                break;
            }
            if (hasOnlyRequiredBranches) {
                branchDataItem.DoneSpawning = true;
            }
        }
        if (!branchDataItem.CannotSpawn) {
            for (BranchDataItem childBranchDataItem : branchDataItem.getChildren(false)) {
                if (!this.AllBranchesBranchDataHash.contains(childBranchDataItem.branchNumber) && !childBranchDataItem.SpawnDelayed) {
                    int smoothRadius;
                    boolean canSpawn = true;
                    boolean collidedWithParentOrSibling = false;
                    boolean wasntBelowOther = false;
                    boolean wasntInsideOther = false;
                    boolean cannotSpawnInsideOther = false;
                    boolean wasntOnWater = false;
                    boolean wasOnWater = false;
                    boolean spaceIsOccupied = false;
                    boolean chunkIsIneligible = false;
                    boolean startChunkBlockChecksPassed = true;
                    boolean isInsideWorldBorder = true;
                    boolean branchFrequencyNotPassed = false;
                    boolean branchFrequencyGroupNotPassed = false;
                    BO3 bo3 = (BO3)childBranchDataItem.Branch.getObject();
                    if (bo3 == null || bo3.isInvalidConfig) {
                        childBranchDataItem.DoneSpawning = true;
                        childBranchDataItem.CannotSpawn = true;
                        if (bo3 == null) {
                            OTG.log(LogMarker.ERROR, "Error: Could not find BO3 file: " + childBranchDataItem.Branch.BO3Name + ".BO3 which is a branch of " + branchDataItem.Branch.BO3Name + ".BO3", new Object[0]);
                        }
                    }
                    if (childBranchDataItem.DoneSpawning || childBranchDataItem.CannotSpawn) continue;
                    if (this.SpawningRequiredBranchesOnly) {
                        if (!childBranchDataItem.Branch.isRequiredBranch) continue;
                        boolean hasOnlyRequiredBranches = true;
                        if (childBranchDataItem.Branch.branchGroup != null && childBranchDataItem.Branch.branchGroup.length() > 0) {
                            for (BranchDataItem branchDataItem3 : branchDataItem.getChildren(false)) {
                                if (branchDataItem3.Branch.isRequiredBranch || branchDataItem3.Branch.branchGroup == null || branchDataItem3.Branch.branchGroup.length() <= 0 || !childBranchDataItem.Branch.branchGroup.equals(branchDataItem3.Branch.branchGroup) || branchDataItem3.wasDeleted || branchDataItem3.CannotSpawn || branchDataItem3.DoneSpawning) continue;
                                hasOnlyRequiredBranches = false;
                                break;
                            }
                        }
                        if (!hasOnlyRequiredBranches) continue;
                    }
                    if (canSpawn && (childBranchDataItem.MaxDepth == 0 || childBranchDataItem.CurrentDepth > childBranchDataItem.MaxDepth) && !childBranchDataItem.Branch.isRequiredBranch) {
                        canSpawn = false;
                    }
                    ++this.branchesTried;
                    if (minimumSize && childBranchDataItem.Branch.isWeightedBranch) {
                        childBranchDataItem.DoneSpawning = true;
                        childBranchDataItem.CannotSpawn = true;
                        continue;
                    }
                    int n = smoothRadius = ((BO3)this.Start.getObject()).getSettings().overrideChildSettings && bo3.getSettings().overrideChildSettings ? ((BO3)this.Start.getObject()).getSettings().smoothRadius : bo3.getSettings().smoothRadius;
                    if (smoothRadius == -1 || bo3.getSettings().smoothRadius == -1) {
                        smoothRadius = 0;
                    }
                    ChunkCoordinate worldBorderCenterPoint = this.World.GetWorldSession().getWorldBorderCenterPoint();
                    if (canSpawn && !minimumSize && this.World.GetWorldSession().getWorldBorderRadius() > 0 && (smoothRadius == 0 && !this.World.IsInsideWorldBorder(ChunkCoordinate.fromChunkCoords(childBranchDataItem.Branch.getChunkX(), childBranchDataItem.Branch.getChunkZ()), true) || smoothRadius > 0 && ((double)childBranchDataItem.Branch.getChunkX() - Math.ceil((double)smoothRadius / 16.0) < (double)(worldBorderCenterPoint.getChunkX() - (this.World.GetWorldSession().getWorldBorderRadius() - 1)) || (double)childBranchDataItem.Branch.getChunkX() + Math.ceil((double)smoothRadius / 16.0) > (double)(worldBorderCenterPoint.getChunkX() + (this.World.GetWorldSession().getWorldBorderRadius() - 1) - 1) || (double)childBranchDataItem.Branch.getChunkZ() - Math.ceil((double)smoothRadius / 16.0) < (double)(worldBorderCenterPoint.getChunkZ() - (this.World.GetWorldSession().getWorldBorderRadius() - 1)) || (double)childBranchDataItem.Branch.getChunkZ() + Math.ceil((double)smoothRadius / 16.0) > (double)(worldBorderCenterPoint.getChunkZ() + (this.World.GetWorldSession().getWorldBorderRadius() - 1) - 1)))) {
                        canSpawn = false;
                        isInsideWorldBorder = false;
                    }
                    if (!this.DoStartChunkBlockChecks()) {
                        canSpawn = false;
                        startChunkBlockChecksPassed = false;
                    } else if (childBranchDataItem.Branch.getY() < 0 && !minimumSize) {
                        canSpawn = false;
                    }
                    Stack<BranchDataItem> collidingObjects = null;
                    if (canSpawn) {
                        if (!(!bo3.getSettings().SpawnOnWaterOnly || minimumSize || this.World.getMaterial(childBranchDataItem.ChunkCoordinate.getBlockX(), this.World.getHighestBlockYAt(childBranchDataItem.ChunkCoordinate.getBlockX(), childBranchDataItem.ChunkCoordinate.getBlockZ(), true, true, false, true), childBranchDataItem.ChunkCoordinate.getBlockZ(), this.IsOTGPlus).isLiquid() && this.World.getMaterial(childBranchDataItem.ChunkCoordinate.getBlockX(), this.World.getHighestBlockYAt(childBranchDataItem.ChunkCoordinate.getBlockX(), childBranchDataItem.ChunkCoordinate.getBlockZ() + 15, true, true, false, true), childBranchDataItem.ChunkCoordinate.getBlockZ() + 15, this.IsOTGPlus).isLiquid() && this.World.getMaterial(childBranchDataItem.ChunkCoordinate.getBlockX() + 15, this.World.getHighestBlockYAt(childBranchDataItem.ChunkCoordinate.getBlockX() + 15, childBranchDataItem.ChunkCoordinate.getBlockZ(), true, true, false, true), childBranchDataItem.ChunkCoordinate.getBlockZ(), this.IsOTGPlus).isLiquid() && this.World.getMaterial(childBranchDataItem.ChunkCoordinate.getBlockX() + 15, this.World.getHighestBlockYAt(childBranchDataItem.ChunkCoordinate.getBlockX() + 15, childBranchDataItem.ChunkCoordinate.getBlockZ() + 15, true, true, false, true), childBranchDataItem.ChunkCoordinate.getBlockZ() + 15, this.IsOTGPlus).isLiquid())) {
                            wasntOnWater = true;
                            canSpawn = false;
                        }
                        if (!bo3.getSettings().CanSpawnOnWater && !minimumSize && this.World.getMaterial(childBranchDataItem.ChunkCoordinate.getBlockX() + 8, this.World.getHighestBlockYAt(childBranchDataItem.ChunkCoordinate.getBlockX() + 8, childBranchDataItem.ChunkCoordinate.getBlockZ() + 7, true, true, false, true), childBranchDataItem.ChunkCoordinate.getBlockZ() + 7, this.IsOTGPlus).isLiquid()) {
                            wasOnWater = true;
                            canSpawn = false;
                        }
                        if (canSpawn && bo3.getSettings().mustBeBelowOther) {
                            boolean bFound = false;
                            if (this.AllBranchesBranchDataByChunk.containsKey(childBranchDataItem.ChunkCoordinate)) {
                                for (Object branchDataItem2 : this.AllBranchesBranchDataByChunk.get(childBranchDataItem.ChunkCoordinate)) {
                                    if (!branchDataItem2.ChunkCoordinate.equals(childBranchDataItem.ChunkCoordinate) || ((BO3)branchDataItem2.Branch.getObject()).getSettings().canOverride || branchDataItem2.Branch.getY() < childBranchDataItem.Branch.getY()) continue;
                                    bFound = true;
                                    break;
                                }
                            }
                            if (!bFound) {
                                wasntBelowOther = true;
                                canSpawn = false;
                            }
                        }
                        if (canSpawn && bo3.getSettings().mustBeInside != null && bo3.getSettings().mustBeInside.length() > 0) {
                            String[] mustBeInsideBO3s = bo3.getSettings().mustBeInside.split(",");
                            boolean foundSpwanRequirement = false;
                            for (String mustBeInsideBO3Group : mustBeInsideBO3s) {
                                String[] mustBeInsideBO3sByGroup = mustBeInsideBO3Group.trim().split(" ");
                                boolean foundAllSpwanRequirementParts = true;
                                for (Object mustBeInsideBO32 : mustBeInsideBO3sByGroup) {
                                    String[] mustBeInsideBO3NameAndRotation = ((String)mustBeInsideBO32).split(":");
                                    String mustBeInsideBO3Name = mustBeInsideBO3NameAndRotation[0];
                                    String mustBeInsideBO3Rotation = mustBeInsideBO3NameAndRotation.length > 1 ? mustBeInsideBO3NameAndRotation[1] : null;
                                    boolean bFoundPart = false;
                                    if (this.AllBranchesBranchDataByChunk.containsKey(childBranchDataItem.ChunkCoordinate)) {
                                        for (BranchDataItem branchDataItem3 : this.AllBranchesBranchDataByChunk.get(childBranchDataItem.ChunkCoordinate)) {
                                            if (branchDataItem3 == childBranchDataItem || branchDataItem3 == childBranchDataItem.Parent) continue;
                                            for (String branchName : ((BO3)branchDataItem3.Branch.getObject()).getSettings().getInheritedBO3s()) {
                                                if (!branchName.equals(mustBeInsideBO3Name.trim())) continue;
                                                int rotation = branchDataItem3.Branch.getRotation().getRotationId() - childBranchDataItem.Branch.getRotation().getRotationId();
                                                if (rotation < 0) {
                                                    rotation += 4;
                                                }
                                                if (mustBeInsideBO3Rotation != null && rotation != Rotation.FromString(mustBeInsideBO3Rotation).getRotationId() || !this.CheckCollision(childBranchDataItem.Branch, branchDataItem3.Branch)) continue;
                                                bFoundPart = true;
                                                break;
                                            }
                                            if (!bFoundPart) continue;
                                            break;
                                        }
                                    }
                                    if (bFoundPart) continue;
                                    foundAllSpwanRequirementParts = false;
                                    break;
                                }
                                if (!foundAllSpwanRequirementParts) continue;
                                foundSpwanRequirement = true;
                                break;
                            }
                            if (!foundSpwanRequirement) {
                                wasntInsideOther = true;
                                canSpawn = false;
                            }
                        }
                        if (canSpawn && bo3.getSettings().cannotBeInside != null && bo3.getSettings().cannotBeInside.length() > 0) {
                            String[] mustBeInsideBO3s = bo3.getSettings().cannotBeInside.split(",");
                            boolean foundSpwanBlocker = false;
                            for (String mustBeInsideBO3 : mustBeInsideBO3s) {
                                String mustBeInsideBO3Rotation;
                                String[] mustBeInsideBO3NameAndRotation = mustBeInsideBO3.split(":");
                                String mustBeInsideBO3Name = mustBeInsideBO3NameAndRotation[0];
                                String string = mustBeInsideBO3Rotation = mustBeInsideBO3NameAndRotation.length > 1 ? mustBeInsideBO3NameAndRotation[1] : null;
                                if (!this.AllBranchesBranchDataByChunk.containsKey(childBranchDataItem.ChunkCoordinate)) continue;
                                for (BranchDataItem branchDataItem3 : this.AllBranchesBranchDataByChunk.get(childBranchDataItem.ChunkCoordinate)) {
                                    Object mustBeInsideBO32;
                                    if (branchDataItem3 == childBranchDataItem || branchDataItem3 == childBranchDataItem.Parent) continue;
                                    mustBeInsideBO32 = ((BO3)branchDataItem3.Branch.getObject()).getSettings().getInheritedBO3s().iterator();
                                    while (mustBeInsideBO32.hasNext()) {
                                        String branchName = (String)mustBeInsideBO32.next();
                                        if (!branchName.equals(mustBeInsideBO3Name.trim())) continue;
                                        int rotation = branchDataItem3.Branch.getRotation().getRotationId() - childBranchDataItem.Branch.getRotation().getRotationId();
                                        if (rotation < 0) {
                                            rotation += 4;
                                        }
                                        if (mustBeInsideBO3Rotation != null && rotation != Rotation.FromString(mustBeInsideBO3Rotation).getRotationId() || !this.CheckCollision(childBranchDataItem.Branch, branchDataItem3.Branch)) continue;
                                        if (OTG.getPluginConfig().SpawnLog) {
                                            OTG.log(LogMarker.INFO, "CannotBeInside branch " + childBranchDataItem.Branch.BO3Name + " was blocked by " + branchDataItem3.Branch.BO3Name, new Object[0]);
                                        }
                                        foundSpwanBlocker = true;
                                        break;
                                    }
                                    if (!foundSpwanBlocker) continue;
                                    break;
                                }
                                if (foundSpwanBlocker) break;
                            }
                            if (foundSpwanBlocker) {
                                cannotSpawnInsideOther = true;
                                canSpawn = false;
                            }
                        }
                        if (canSpawn && (bo3.getSettings().branchFrequency > 0 || bo3.getSettings().branchFrequencyGroup != null && bo3.getSettings().branchFrequencyGroup.length() > 0)) {
                            int radius = bo3.getSettings().branchFrequency;
                            String[] groupStrings = bo3.getSettings().branchFrequencyGroup.trim().length() > 0 ? bo3.getSettings().branchFrequencyGroup.split(",") : null;
                            ArrayList<String> groupNames = new ArrayList<String>();
                            ArrayList<Integer> groupFrequencies = new ArrayList<Integer>();
                            int largestBranchFrequency = radius;
                            if (groupStrings != null && groupStrings.length > 0) {
                                for (int i = 0; i < groupStrings.length; ++i) {
                                    String[] groupString;
                                    String[] stringArray = groupString = groupStrings[i].trim().length() > 0 ? groupStrings[i].split(":") : null;
                                    if (groupString == null || groupString.length != 2) continue;
                                    groupNames.add(groupString[0].trim());
                                    int groupFrequency = Integer.parseInt(groupString[1].trim());
                                    groupFrequencies.add(groupFrequency);
                                    if (groupFrequency <= largestBranchFrequency) continue;
                                    largestBranchFrequency = groupFrequency;
                                }
                            }
                            boolean bFound = false;
                            for (int x = -largestBranchFrequency; x <= largestBranchFrequency; ++x) {
                                for (int z = -largestBranchFrequency; z <= largestBranchFrequency; ++z) {
                                    ChunkCoordinate targetChunk = ChunkCoordinate.fromChunkCoords(childBranchDataItem.Branch.getChunkX() + x, childBranchDataItem.Branch.getChunkZ() + z);
                                    Stack<BranchDataItem> branches = this.AllBranchesBranchDataByChunk.get(targetChunk);
                                    if (branches != null) {
                                        for (BranchDataItem a2 : branches) {
                                            float distanceBetweenStructures = (int)Math.floor(Math.sqrt(Math.pow(childBranchDataItem.Branch.getChunkX() - targetChunk.getChunkX(), 2.0) + Math.pow(childBranchDataItem.Branch.getChunkZ() - targetChunk.getChunkZ(), 2.0)));
                                            if (a2.Branch.BO3Name.equals(childBranchDataItem.Branch.BO3Name)) {
                                                if (a2.Branch == childBranchDataItem.Branch) {
                                                    throw new RuntimeException();
                                                }
                                                if (distanceBetweenStructures <= (float)radius) {
                                                    bFound = true;
                                                    branchFrequencyNotPassed = true;
                                                    break;
                                                }
                                            }
                                            if (groupStrings != null && groupStrings.length > 0) {
                                                BO3 targetBO3 = (BO3)a2.Branch.getObject();
                                                String[] targetGroupStrings = targetBO3.getSettings().branchFrequencyGroup.trim().length() > 0 ? targetBO3.getSettings().branchFrequencyGroup.split(",") : null;
                                                ArrayList<String> targetGroupNames = new ArrayList<String>();
                                                ArrayList<Integer> targetGroupFrequencies = new ArrayList<Integer>();
                                                if (targetGroupStrings != null && targetGroupStrings.length > 0) {
                                                    for (int t = 0; t < targetGroupStrings.length; ++t) {
                                                        String[] groupString;
                                                        String[] stringArray = groupString = targetGroupStrings[t].trim().length() > 0 ? targetGroupStrings[t].split(":") : null;
                                                        if (groupString == null || groupString.length != 2) continue;
                                                        targetGroupNames.add(groupString[0].trim());
                                                        int groupFrequency = Integer.parseInt(groupString[1].trim());
                                                        targetGroupFrequencies.add(groupFrequency);
                                                    }
                                                    for (int i = 0; i < groupNames.size(); ++i) {
                                                        for (int t = 0; t < targetGroupNames.size(); ++t) {
                                                            if (!((String)groupNames.get(i)).equals(targetGroupNames.get(t)) || !(distanceBetweenStructures <= (float)((Integer)groupFrequencies.get(i)).intValue())) continue;
                                                            bFound = true;
                                                            branchFrequencyGroupNotPassed = true;
                                                            break;
                                                        }
                                                        if (bFound) break;
                                                    }
                                                }
                                            }
                                            if (!bFound) continue;
                                            break;
                                        }
                                    }
                                    if (bFound) break;
                                }
                                if (bFound) break;
                            }
                            if (bFound) {
                                canSpawn = false;
                            }
                        }
                        if (canSpawn && (collidingObjects = this.CheckSpawnRequirementsAndCollisions(childBranchDataItem, minimumSize)).size() > 0) {
                            canSpawn = false;
                            collidedWithParentOrSibling = true;
                            for (BranchDataItem collidingObject : collidingObjects) {
                                if (collidingObject == null) {
                                    chunkIsIneligible = true;
                                    collidedWithParentOrSibling = false;
                                    break;
                                }
                                if (branchDataItem.Parent != null && collidingObject.Branch == branchDataItem.Parent.Branch || ((BO3)collidingObject.Branch.getObject()).getSettings().canOverride) continue;
                                boolean siblingFound = false;
                                if (branchDataItem.Parent != null) {
                                    for (BranchDataItem parentSibling : branchDataItem.Parent.getChildren(false)) {
                                        if (collidingObject.Branch != parentSibling.Branch) continue;
                                        siblingFound = true;
                                        break;
                                    }
                                }
                                if (!siblingFound) {
                                    for (BranchDataItem sibling : branchDataItem.getChildren(false)) {
                                        if (collidingObject.Branch != sibling.Branch) continue;
                                        siblingFound = true;
                                        break;
                                    }
                                }
                                if (siblingFound) continue;
                                spaceIsOccupied = true;
                                collidedWithParentOrSibling = false;
                                break;
                            }
                        }
                    }
                    if (canSpawn) {
                        if (OTG.getPluginConfig().SpawnLog) {
                            String allParentsString = "";
                            BranchDataItem tempBranch = childBranchDataItem;
                            while (tempBranch.Parent != null) {
                                allParentsString = allParentsString + " <-- X" + tempBranch.Parent.Branch.getChunkX() + " Z" + tempBranch.Parent.Branch.getChunkZ() + " Y" + tempBranch.Parent.Branch.getY() + " " + tempBranch.Parent.Branch.BO3Name + ":" + (Object)((Object)tempBranch.Parent.Branch.getRotation());
                                tempBranch = tempBranch.Parent;
                            }
                            OTG.log(LogMarker.INFO, "Plotted X" + childBranchDataItem.ChunkCoordinate.getChunkX() + " Z" + childBranchDataItem.ChunkCoordinate.getChunkZ() + (minimumSize ? "" : " Y" + childBranchDataItem.Branch.getY()) + " " + childBranchDataItem.Branch.BO3Name + ":" + (Object)((Object)childBranchDataItem.Branch.getRotation()) + (childBranchDataItem.Branch.isRequiredBranch ? " required" : " optional") + " cycle " + this.Cycle + allParentsString, new Object[0]);
                        }
                        if (childBranchDataItem.getChildren(false).size() == 0) {
                            childBranchDataItem.DoneSpawning = true;
                        }
                        for (BranchDataItem childBranchDataItem2 : branchDataItem.getChildren(false)) {
                            if (childBranchDataItem2 == childBranchDataItem || childBranchDataItem.Branch.branchGroup == null || childBranchDataItem.Branch.branchGroup.length() < 0 || !childBranchDataItem.Branch.branchGroup.equals(childBranchDataItem2.Branch.branchGroup) || !childBranchDataItem2.Branch.isRequiredBranch) continue;
                            childBranchDataItem2.DoneSpawning = true;
                            childBranchDataItem2.CannotSpawn = true;
                        }
                        this.SpawnedBranchThisCycle = true;
                        this.AllBranchesBranchData.add(childBranchDataItem);
                        this.AllBranchesBranchDataHash.add(childBranchDataItem.branchNumber);
                        Stack<BranchDataItem> branchDataItemStack = this.AllBranchesBranchDataByChunk.get(childBranchDataItem.ChunkCoordinate);
                        if (branchDataItemStack != null) {
                            branchDataItemStack.add(childBranchDataItem);
                        } else {
                            branchDataItemStack = new Stack();
                            branchDataItemStack.add(childBranchDataItem);
                            this.AllBranchesBranchDataByChunk.put(childBranchDataItem.ChunkCoordinate, branchDataItemStack);
                        }
                        if (!this.SpawningRequiredChildrenForOptionalBranch && !childBranchDataItem.Branch.isRequiredBranch) {
                            if (OTG.getPluginConfig().SpawnLog) {
                                OTG.log(LogMarker.INFO, "Plotting all required child branches that are not in a branch group with optional branches.", new Object[0]);
                            }
                            this.SpawningRequiredChildrenForOptionalBranch = true;
                            this.currentSpawningRequiredChildrenForOptionalBranch = childBranchDataItem;
                            boolean spawningRequiredBranchesOnly = this.SpawningRequiredBranchesOnly;
                            this.SpawningRequiredBranchesOnly = true;
                            this.TraverseAndSpawnChildBranches(childBranchDataItem, minimumSize);
                            this.SpawningRequiredBranchesOnly = spawningRequiredBranchesOnly;
                            this.SpawningRequiredChildrenForOptionalBranch = false;
                            boolean bFound = false;
                            branchDataItemStack = this.AllBranchesBranchDataByChunk.get(childBranchDataItem.ChunkCoordinate);
                            if (branchDataItemStack != null) {
                                for (BranchDataItem b2 : branchDataItemStack) {
                                    if (b2 != childBranchDataItem) continue;
                                    bFound = true;
                                    break;
                                }
                            }
                            canSpawn = bFound;
                            if (OTG.getPluginConfig().SpawnLog) {
                                OTG.log(LogMarker.INFO, "Done spawning required children for optional branch X" + childBranchDataItem.ChunkCoordinate.getChunkX() + " Z" + childBranchDataItem.ChunkCoordinate.getChunkZ() + (minimumSize ? "" : " Y" + childBranchDataItem.Branch.getY()) + " " + childBranchDataItem.Branch.BO3Name + ":" + (Object)((Object)childBranchDataItem.Branch.getRotation()), new Object[0]);
                            }
                        } else if (traverseOnlySpawnedChildren && !this.SpawningRequiredChildrenForOptionalBranch && childBranchDataItem.Branch.isRequiredBranch) {
                            boolean spawningRequiredBranchesOnly = this.SpawningRequiredBranchesOnly;
                            this.SpawningRequiredBranchesOnly = true;
                            this.TraverseAndSpawnChildBranches(childBranchDataItem, minimumSize);
                            this.SpawningRequiredBranchesOnly = spawningRequiredBranchesOnly;
                        }
                    }
                    if (canSpawn || childBranchDataItem.DoneSpawning || childBranchDataItem.CannotSpawn) continue;
                    if (!wasntBelowOther || !this.SpawnedBranchLastCycle) {
                        childBranchDataItem.DoneSpawning = true;
                        childBranchDataItem.CannotSpawn = true;
                    } else {
                        branchDataItem.DoneSpawning = false;
                        if (branchDataItem.wasDeleted) {
                            throw new RuntimeException();
                        }
                    }
                    boolean bBreak = false;
                    boolean branchGroupFailedSpawning = false;
                    if (childBranchDataItem.Branch.isRequiredBranch) {
                        branchGroupFailedSpawning = true;
                        for (BranchDataItem childBranchDataItem2 : branchDataItem.getChildren(false)) {
                            if (childBranchDataItem2 == childBranchDataItem || childBranchDataItem.Branch.branchGroup == null || childBranchDataItem.Branch.branchGroup.length() < 0 || !childBranchDataItem.Branch.branchGroup.equals(childBranchDataItem2.Branch.branchGroup) || !childBranchDataItem2.Branch.isRequiredBranch || childBranchDataItem2.DoneSpawning || childBranchDataItem2.CannotSpawn) continue;
                            branchGroupFailedSpawning = false;
                            break;
                        }
                    }
                    if (!(collidedWithParentOrSibling || wasntBelowOther && this.SpawnedBranchLastCycle || !branchGroupFailedSpawning)) {
                        if (OTG.getPluginConfig().SpawnLog) {
                            String allParentsString = "";
                            BranchDataItem tempBranch = branchDataItem;
                            while (tempBranch.Parent != null) {
                                allParentsString = allParentsString + " <-- X" + tempBranch.Parent.Branch.getChunkX() + " Z" + tempBranch.Parent.Branch.getChunkZ() + " Y" + tempBranch.Parent.Branch.getY() + " " + tempBranch.Parent.Branch.BO3Name + ":" + (Object)((Object)tempBranch.Parent.Branch.getRotation());
                                tempBranch = tempBranch.Parent;
                            }
                            String occupiedByObjectsString = "";
                            if (spaceIsOccupied) {
                                for (BranchDataItem collidingObject : collidingObjects) {
                                    String occupiedByObjectString = collidingObject.Branch.BO3Name + ":" + (Object)((Object)collidingObject.Branch.getRotation()) + " X" + collidingObject.Branch.getChunkX() + " Z" + collidingObject.Branch.getChunkZ() + " Y" + collidingObject.Branch.getY();
                                    tempBranch = collidingObject;
                                    while (tempBranch.Parent != null) {
                                        occupiedByObjectString = occupiedByObjectString + " <-- X" + tempBranch.Parent.Branch.getChunkX() + " Z" + tempBranch.Parent.Branch.getChunkZ() + " Y" + tempBranch.Parent.Branch.getY() + " " + tempBranch.Parent.Branch.BO3Name + ":" + (Object)((Object)tempBranch.Parent.Branch.getRotation());
                                        tempBranch = tempBranch.Parent;
                                    }
                                    occupiedByObjectsString = occupiedByObjectsString + " " + occupiedByObjectString;
                                }
                            }
                            String reason = (branchFrequencyGroupNotPassed ? "BranchFrequencyGroupNotPassed " : "") + (branchFrequencyNotPassed ? "BranchFrequencyNotPassed " : "") + (!isInsideWorldBorder ? "IsOutsideWorldBorder " : "") + (!startChunkBlockChecksPassed ? "StartChunkBlockChecksNotPassed " : "") + (collidedWithParentOrSibling ? "CollidedWithParentOrSibling " : "") + (wasntBelowOther ? "WasntBelowOther " : "") + (wasntInsideOther ? "WasntInsideOther " : "") + (cannotSpawnInsideOther ? "CannotSpawnInsideOther " : "") + (wasntOnWater ? "WasntOnWater " : "") + (wasOnWater ? "WasOnWater " : "") + (!branchFrequencyGroupNotPassed && !branchFrequencyNotPassed && isInsideWorldBorder && startChunkBlockChecksPassed && !wasntBelowOther && !cannotSpawnInsideOther && !wasntOnWater && !wasOnWater && !wasntBelowOther && !chunkIsIneligible && spaceIsOccupied ? "SpaceIsOccupied by" + occupiedByObjectsString : "") + (wasntBelowOther ? "WasntBelowOther " : "") + (chunkIsIneligible ? "TerrainIsUnsuitable (StartChunkBlockChecks (height or material) not passed or Y < 0 or Frequency/BO3Group checks not passed or BO3 collided with other CustomStructure or smoothing area collided with other CustomStructure or BO3 not in allowed Biome or Smoothing area not in allowed Biome)" : "");
                            OTG.log(LogMarker.INFO, "Rolling back X" + branchDataItem.Branch.getChunkX() + " Z" + branchDataItem.Branch.getChunkZ() + " Y" + branchDataItem.Branch.getY() + " " + branchDataItem.Branch.BO3Name + ":" + (Object)((Object)branchDataItem.Branch.getRotation()) + allParentsString + " because required branch " + childBranchDataItem.Branch.BO3Name + " couldn't spawn. Reason: " + reason, new Object[0]);
                        }
                        this.RollBackBranch(branchDataItem, minimumSize);
                        bBreak = true;
                    } else {
                        for (BranchDataItem childBranchDataItem2 : branchDataItem.getChildren(false)) {
                            if (wasntBelowOther && this.SpawnedBranchLastCycle || childBranchDataItem != childBranchDataItem2 && (childBranchDataItem2.CannotSpawn || childBranchDataItem2.DoneSpawning || !(childBranchDataItem.Branch.getY() < 0 || chunkIsIneligible || wasntBelowOther && ((BO3)childBranchDataItem2.Branch.getObject()).getSettings().mustBeBelowOther || wasntOnWater && ((BO3)childBranchDataItem2.Branch.getObject()).getSettings().SpawnOnWaterOnly) && (!wasOnWater || ((BO3)childBranchDataItem2.Branch.getObject()).getSettings().CanSpawnOnWater) || childBranchDataItem.Branch.getX() != childBranchDataItem2.Branch.getX() || childBranchDataItem.Branch.getY() != childBranchDataItem2.Branch.getY() || childBranchDataItem.Branch.getZ() != childBranchDataItem2.Branch.getZ())) continue;
                            childBranchDataItem2.DoneSpawning = true;
                            childBranchDataItem2.CannotSpawn = true;
                            branchGroupFailedSpawning = false;
                            if (childBranchDataItem2.Branch.isRequiredBranch) {
                                branchGroupFailedSpawning = true;
                                for (BranchDataItem childBranchDataItem3 : branchDataItem.getChildren(false)) {
                                    if (childBranchDataItem3 == childBranchDataItem2 || childBranchDataItem2.Branch.branchGroup == null || childBranchDataItem2.Branch.branchGroup.length() < 0 || !childBranchDataItem2.Branch.branchGroup.equals(childBranchDataItem3.Branch.branchGroup) || !childBranchDataItem3.Branch.isRequiredBranch || childBranchDataItem3.DoneSpawning || childBranchDataItem3.CannotSpawn) continue;
                                    branchGroupFailedSpawning = false;
                                    break;
                                }
                            }
                            if (!branchGroupFailedSpawning || collidedWithParentOrSibling) continue;
                            if (OTG.getPluginConfig().SpawnLog) {
                                String allParentsString = "";
                                BranchDataItem tempBranch = branchDataItem;
                                while (tempBranch.Parent != null) {
                                    allParentsString = allParentsString + " <-- X" + tempBranch.Parent.Branch.getChunkX() + " Z" + tempBranch.Parent.Branch.getChunkZ() + " Y" + tempBranch.Parent.Branch.getY() + " " + tempBranch.Parent.Branch.BO3Name + ":" + (Object)((Object)tempBranch.Parent.Branch.getRotation());
                                    tempBranch = tempBranch.Parent;
                                }
                                String occupiedByObjectsString = "";
                                if (spaceIsOccupied) {
                                    for (BranchDataItem collidingObject : collidingObjects) {
                                        String occupiedByObjectString = collidingObject.Branch.BO3Name + ":" + (Object)((Object)collidingObject.Branch.getRotation()) + " X" + collidingObject.Branch.getChunkX() + " Z" + collidingObject.Branch.getChunkZ() + " Y" + collidingObject.Branch.getY();
                                        tempBranch = collidingObject;
                                        while (tempBranch.Parent != null) {
                                            occupiedByObjectString = occupiedByObjectString + " <-- X" + tempBranch.Parent.Branch.getChunkX() + " Z" + tempBranch.Parent.Branch.getChunkZ() + " Y" + tempBranch.Parent.Branch.getY() + " " + tempBranch.Parent.Branch.BO3Name + ":" + (Object)((Object)tempBranch.Parent.Branch.getRotation());
                                            tempBranch = tempBranch.Parent;
                                        }
                                        occupiedByObjectsString = occupiedByObjectsString + " " + occupiedByObjectString;
                                    }
                                }
                                String reason = (branchFrequencyGroupNotPassed ? "BranchFrequencyGroupNotPassed " : "") + (branchFrequencyNotPassed ? "BranchFrequencyNotPassed " : "") + (!isInsideWorldBorder ? "IsOutsideWorldBorder " : "") + (!startChunkBlockChecksPassed ? "StartChunkBlockChecksNotPassed " : "") + (collidedWithParentOrSibling ? "CollidedWithParentOrSibling " : "") + (wasntBelowOther ? "WasntBelowOther " : "") + (wasntInsideOther ? "WasntInsideOther " : "") + (cannotSpawnInsideOther ? "CannotSpawnInsideOther " : "") + (wasntOnWater ? "WasntOnWater " : "") + (wasOnWater ? "WasOnWater " : "") + (childBranchDataItem.Branch.getY() < 0 ? " WasBelowY0 " : "") + (!branchFrequencyGroupNotPassed && !branchFrequencyNotPassed && isInsideWorldBorder && startChunkBlockChecksPassed && !wasntBelowOther && !cannotSpawnInsideOther && !wasntOnWater && !wasOnWater && !wasntBelowOther && !chunkIsIneligible && spaceIsOccupied ? "SpaceIsOccupied by" + occupiedByObjectsString : "") + (wasntBelowOther ? "WasntBelowOther " : "") + (chunkIsIneligible ? "ChunkIsIneligible: Either the chunk is occupied by another structure or the BO3/smoothing area is not allowed in the Biome)" : "");
                                OTG.log(LogMarker.INFO, "Rolling back X" + branchDataItem.Branch.getChunkX() + " Z" + branchDataItem.Branch.getChunkZ() + " Y" + branchDataItem.Branch.getY() + " " + branchDataItem.Branch.BO3Name + ":" + (Object)((Object)branchDataItem.Branch.getRotation()) + allParentsString + " because required branch " + childBranchDataItem.Branch.BO3Name + " couldn't spawn. Reason: " + reason, new Object[0]);
                            }
                            this.RollBackBranch(branchDataItem, minimumSize);
                            bBreak = true;
                            break;
                        }
                    }
                    if (!bBreak) continue;
                    break;
                }
                if (!childBranchDataItem.SpawnDelayed) continue;
                childBranchDataItem.SpawnDelayed = false;
            }
            if (!(traverseOnlySpawnedChildren || this.SpawningRequiredBranchesOnly || branchDataItem.CannotSpawn)) {
                for (BranchDataItem childBranchDataItem : branchDataItem.getChildren(false)) {
                    if (!this.AllBranchesBranchDataHash.contains(childBranchDataItem.branchNumber) || !childBranchDataItem.Branch.isRequiredBranch && (!this.SpawningCanOverrideBranches || ((BO3)childBranchDataItem.Branch.getObject()).getSettings().canOverride) || childBranchDataItem.CannotSpawn || childBranchDataItem.SpawnDelayed && this.SpawnedBranchLastCycle) continue;
                    this.TraverseAndSpawnChildBranches(childBranchDataItem, minimumSize);
                }
            }
            if (!traverseOnlySpawnedChildren && this.SpawningRequiredBranchesOnly && !branchDataItem.CannotSpawn) {
                for (BranchDataItem childBranchDataItem : branchDataItem.getChildren(false)) {
                    if (!this.AllBranchesBranchDataHash.contains(childBranchDataItem.branchNumber) || !childBranchDataItem.Branch.isRequiredBranch) continue;
                    this.TraverseAndSpawnChildBranches(childBranchDataItem, minimumSize);
                }
            }
        }
    }

    private void RollBackBranch(BranchDataItem branchData, boolean minimumSize) {
        Stack<BranchDataItem> branchDataByChunk;
        Stack<BranchDataItem> allBranchesBranchData2;
        if (this.SpawningRequiredChildrenForOptionalBranch && this.currentSpawningRequiredChildrenForOptionalBranch.Parent == branchData) {
            return;
        }
        branchData.CannotSpawn = true;
        branchData.DoneSpawning = true;
        branchData.wasDeleted = true;
        branchData.isBeingRolledBack = true;
        this.DeleteBranchChildren(branchData, minimumSize);
        if (this.AllBranchesBranchDataHash.contains(branchData.branchNumber)) {
            if (OTG.getPluginConfig().SpawnLog) {
                String allParentsString = "";
                BranchDataItem tempBranch = branchData;
                while (tempBranch.Parent != null) {
                    allParentsString = allParentsString + " <-- X" + tempBranch.Parent.Branch.getChunkX() + " Z" + tempBranch.Parent.Branch.getChunkZ() + " Y" + tempBranch.Parent.Branch.getY() + " " + tempBranch.Parent.Branch.BO3Name + ":" + (Object)((Object)tempBranch.Parent.Branch.getRotation());
                    tempBranch = tempBranch.Parent;
                }
                OTG.log(LogMarker.INFO, "Deleted X" + branchData.Branch.getChunkX() + " Z" + branchData.Branch.getChunkZ() + " Y" + branchData.Branch.getY() + " " + branchData.Branch.BO3Name + ":" + (Object)((Object)branchData.Branch.getRotation()) + (branchData.Branch.isRequiredBranch ? " required" : " optional") + " cycle " + this.Cycle + allParentsString, new Object[0]);
            }
            this.AllBranchesBranchData.remove(branchData);
            this.AllBranchesBranchDataHash.remove(branchData.branchNumber);
            Stack<BranchDataItem> branchDataItemStack = this.AllBranchesBranchDataByChunk.get(branchData.ChunkCoordinate);
            if (branchDataItemStack != null) {
                branchDataItemStack.remove(branchData);
                if (branchDataItemStack.size() == 0) {
                    this.AllBranchesBranchDataByChunk.remove(branchData.ChunkCoordinate);
                }
            }
        }
        if (!((BO3)branchData.Branch.getObject()).getSettings().canOverride) {
            allBranchesBranchData2 = new Stack<BranchDataItem>();
            branchDataByChunk = this.AllBranchesBranchDataByChunk.get(branchData.ChunkCoordinate);
            if (branchDataByChunk != null) {
                allBranchesBranchData2.addAll(branchDataByChunk);
                for (BranchDataItem branchDataItem2 : allBranchesBranchData2) {
                    if (!this.AllBranchesBranchDataHash.contains(branchDataItem2.branchNumber) || branchDataItem2 == branchData || !((BO3)branchDataItem2.Branch.getObject()).getSettings().mustBeBelowOther || !branchDataItem2.ChunkCoordinate.equals(branchData.ChunkCoordinate)) continue;
                    boolean branchAboveFound = false;
                    for (BranchDataItem branchDataItem3 : this.AllBranchesBranchDataByChunk.get(branchDataItem2.ChunkCoordinate)) {
                        if (branchDataItem3 == branchData || ((BO3)branchDataItem3.Branch.getObject()).getSettings().mustBeBelowOther || ((BO3)branchDataItem3.Branch.getObject()).getSettings().canOverride || !branchDataItem3.ChunkCoordinate.equals(branchDataItem2.ChunkCoordinate) || branchDataItem3.Branch.getY() < branchDataItem2.Branch.getY()) continue;
                        branchAboveFound = true;
                        break;
                    }
                    if (branchAboveFound) continue;
                    this.RollBackBranch(branchDataItem2, minimumSize);
                }
            }
        }
        allBranchesBranchData2 = new Stack();
        branchDataByChunk = this.AllBranchesBranchDataByChunk.get(branchData.ChunkCoordinate);
        if (branchDataByChunk != null) {
            allBranchesBranchData2.addAll(branchDataByChunk);
            for (BranchDataItem branchDataItem2 : allBranchesBranchData2) {
                if (!this.AllBranchesBranchDataHash.contains(branchDataItem2.branchNumber) || branchDataItem2 == branchData || ((BO3)branchDataItem2.Branch.getObject()).getSettings().mustBeInside == null || ((BO3)branchDataItem2.Branch.getObject()).getSettings().mustBeInside.length() <= 0 || !branchDataItem2.ChunkCoordinate.equals(branchData.ChunkCoordinate)) continue;
                String[] mustBeInsideBO3s = ((BO3)branchDataItem2.Branch.getObject()).getSettings().mustBeInside.split(",");
                boolean currentBO3Found = false;
                for (String mustBeInsideBO3Group : mustBeInsideBO3s) {
                    String[] mustBeInsideBO3sByGroup;
                    for (String mustBeInsideBO3 : mustBeInsideBO3sByGroup = mustBeInsideBO3Group.trim().split(" ")) {
                        String[] mustBeInsideBO3NameAndRotation = mustBeInsideBO3.split(":");
                        String mustBeInsideBO3Name = mustBeInsideBO3NameAndRotation[0];
                        String mustBeInsideBO3Rotation = mustBeInsideBO3NameAndRotation.length > 1 ? mustBeInsideBO3NameAndRotation[1] : null;
                        for (String branchName : ((BO3)branchData.Branch.getObject()).getSettings().getInheritedBO3s()) {
                            if (!branchName.equals(mustBeInsideBO3Name.trim())) continue;
                            int rotation = branchData.Branch.getRotation().getRotationId() - branchDataItem2.Branch.getRotation().getRotationId();
                            if (rotation < 0) {
                                rotation += 4;
                            }
                            if (mustBeInsideBO3Rotation != null && rotation != Rotation.FromString(mustBeInsideBO3Rotation).getRotationId()) continue;
                            currentBO3Found = true;
                            break;
                        }
                        if (currentBO3Found) break;
                    }
                    if (currentBO3Found) break;
                }
                if (!currentBO3Found) continue;
                boolean foundSpwanRequirement = false;
                for (String mustBeInsideBO3Group : mustBeInsideBO3s) {
                    String[] mustBeInsideBO3sByGroup = mustBeInsideBO3Group.trim().split(" ");
                    boolean foundAllSpwanRequirementParts = true;
                    for (String mustBeInsideBO3 : mustBeInsideBO3sByGroup) {
                        boolean bFoundPart = false;
                        for (BranchDataItem branchDataItem3 : this.AllBranchesBranchDataByChunk.get(branchDataItem2.ChunkCoordinate)) {
                            if (branchDataItem3 == branchData || branchDataItem3 == branchDataItem2 || branchDataItem3 == branchDataItem2.Parent) continue;
                            String[] mustBeInsideBO3NameAndRotation = mustBeInsideBO3.split(":");
                            String mustBeInsideBO3Name = mustBeInsideBO3NameAndRotation[0];
                            String mustBeInsideBO3Rotation = mustBeInsideBO3NameAndRotation.length > 1 ? mustBeInsideBO3NameAndRotation[1] : null;
                            for (String branchName : ((BO3)branchDataItem3.Branch.getObject()).getSettings().getInheritedBO3s()) {
                                if (!branchName.equals(mustBeInsideBO3Name.trim())) continue;
                                int rotation = branchDataItem3.Branch.getRotation().getRotationId() - branchDataItem2.Branch.getRotation().getRotationId();
                                if (rotation < 0) {
                                    rotation += 4;
                                }
                                if (mustBeInsideBO3Rotation != null && rotation != Rotation.FromString(mustBeInsideBO3Rotation).getRotationId() || !this.CheckCollision(branchDataItem2.Branch, branchDataItem3.Branch)) continue;
                                bFoundPart = true;
                                break;
                            }
                            if (!bFoundPart) continue;
                            break;
                        }
                        if (bFoundPart) continue;
                        foundAllSpwanRequirementParts = false;
                        break;
                    }
                    if (!foundAllSpwanRequirementParts) continue;
                    foundSpwanRequirement = true;
                }
                if (foundSpwanRequirement) continue;
                this.RollBackBranch(branchDataItem2, minimumSize);
            }
        }
        if (branchData.Parent != null && !branchData.Parent.isBeingRolledBack) {
            if (branchData.Branch.isRequiredBranch) {
                this.RollBackBranch(branchData.Parent, minimumSize);
            } else {
                boolean parentDoneSpawning = true;
                boolean currentBranchFound = false;
                for (BranchDataItem branchDataItem2 : branchData.Parent.getChildren(false)) {
                    if (currentBranchFound && branchData.Branch.branchGroup != null && branchData.Branch.branchGroup.length() >= 0 && branchData.Branch.branchGroup.equals(branchDataItem2.Branch.branchGroup) && !branchDataItem2.wasDeleted && !this.AllBranchesBranchDataHash.contains(branchDataItem2.branchNumber)) {
                        branchDataItem2.CannotSpawn = false;
                        branchDataItem2.DoneSpawning = false;
                    }
                    if (branchDataItem2 == branchData) {
                        currentBranchFound = true;
                    }
                    if (branchDataItem2.DoneSpawning || branchDataItem2.CannotSpawn) continue;
                    parentDoneSpawning = false;
                }
                if (!(parentDoneSpawning || this.SpawningRequiredChildrenForOptionalBranch && this.currentSpawningRequiredChildrenForOptionalBranch == branchData)) {
                    branchData.Parent.DoneSpawning = false;
                    if (!this.SpawningRequiredChildrenForOptionalBranch) {
                        if (this.SpawningRequiredBranchesOnly) {
                            this.AddBranches(branchData.Parent, minimumSize, false);
                        } else {
                            this.AddBranches(branchData.Parent, minimumSize, true);
                        }
                    } else {
                        if (!this.SpawningRequiredBranchesOnly) {
                            throw new RuntimeException();
                        }
                        this.SpawningRequiredChildrenForOptionalBranch = false;
                        this.AddBranches(branchData.Parent, minimumSize, false);
                        this.SpawningRequiredChildrenForOptionalBranch = true;
                    }
                }
            }
        }
        branchData.isBeingRolledBack = false;
    }

    private void DeleteBranchChildren(BranchDataItem branchData, boolean minimumSize) {
        Stack<BranchDataItem> children = branchData.getChildren(true);
        for (BranchDataItem branchDataItem : children) {
            Stack<BranchDataItem> branchDataByChunk;
            Stack<BranchDataItem> allBranchesBranchData2;
            branchDataItem.CannotSpawn = true;
            branchDataItem.DoneSpawning = true;
            branchDataItem.wasDeleted = true;
            if (branchDataItem.getChildren(true).size() > 0) {
                this.DeleteBranchChildren(branchDataItem, minimumSize);
            }
            if (!this.AllBranchesBranchDataHash.contains(branchDataItem.branchNumber)) continue;
            if (OTG.getPluginConfig().SpawnLog) {
                String allParentsString = "";
                BranchDataItem tempBranch = branchDataItem;
                while (tempBranch.Parent != null) {
                    allParentsString = allParentsString + " <-- X" + tempBranch.Parent.Branch.getChunkX() + " Z" + tempBranch.Parent.Branch.getChunkZ() + " Y" + tempBranch.Parent.Branch.getY() + " " + tempBranch.Parent.Branch.BO3Name + ":" + (Object)((Object)tempBranch.Parent.Branch.getRotation());
                    tempBranch = tempBranch.Parent;
                }
                OTG.log(LogMarker.INFO, "Deleted X" + branchDataItem.Branch.getChunkX() + " Z" + branchDataItem.Branch.getChunkZ() + " Y" + branchDataItem.Branch.getY() + " " + branchDataItem.Branch.BO3Name + ":" + (Object)((Object)branchDataItem.Branch.getRotation()) + (branchDataItem.Branch.isRequiredBranch ? " required" : " optional") + " cycle " + this.Cycle + allParentsString, new Object[0]);
            }
            this.AllBranchesBranchData.remove(branchDataItem);
            this.AllBranchesBranchDataHash.remove(branchDataItem.branchNumber);
            Stack<BranchDataItem> branchDataItemStack = this.AllBranchesBranchDataByChunk.get(branchDataItem.ChunkCoordinate);
            if (branchDataItemStack != null) {
                branchDataItemStack.remove(branchDataItem);
                if (branchDataItemStack.size() == 0) {
                    this.AllBranchesBranchDataByChunk.remove(branchDataItem.ChunkCoordinate);
                }
            }
            if (!((BO3)branchDataItem.Branch.getObject()).getSettings().canOverride) {
                allBranchesBranchData2 = new Stack<BranchDataItem>();
                branchDataByChunk = this.AllBranchesBranchDataByChunk.get(branchDataItem.ChunkCoordinate);
                if (branchDataByChunk != null) {
                    allBranchesBranchData2.addAll(branchDataByChunk);
                    for (BranchDataItem branchDataItem2 : allBranchesBranchData2) {
                        if (!this.AllBranchesBranchDataHash.contains(branchDataItem2.branchNumber) || branchDataItem2 == branchDataItem || !((BO3)branchDataItem2.Branch.getObject()).getSettings().mustBeBelowOther || !branchDataItem2.ChunkCoordinate.equals(branchDataItem.ChunkCoordinate)) continue;
                        boolean branchAboveFound = false;
                        for (BranchDataItem branchDataItem3 : this.AllBranchesBranchDataByChunk.get(branchDataItem2.ChunkCoordinate)) {
                            if (branchDataItem3 == branchDataItem || ((BO3)branchDataItem3.Branch.getObject()).getSettings().mustBeBelowOther || ((BO3)branchDataItem3.Branch.getObject()).getSettings().canOverride || !branchDataItem3.ChunkCoordinate.equals(branchDataItem2.ChunkCoordinate) || branchDataItem3.Branch.getY() < branchDataItem2.Branch.getY()) continue;
                            branchAboveFound = true;
                            break;
                        }
                        if (branchAboveFound) continue;
                        this.RollBackBranch(branchDataItem2, minimumSize);
                    }
                }
            }
            allBranchesBranchData2 = new Stack();
            branchDataByChunk = this.AllBranchesBranchDataByChunk.get(branchDataItem.ChunkCoordinate);
            if (branchDataByChunk == null) continue;
            allBranchesBranchData2.addAll(branchDataByChunk);
            for (BranchDataItem branchDataItem2 : allBranchesBranchData2) {
                if (!this.AllBranchesBranchDataHash.contains(branchDataItem2.branchNumber) || branchDataItem2 == branchDataItem || ((BO3)branchDataItem2.Branch.getObject()).getSettings().mustBeInside == null || ((BO3)branchDataItem2.Branch.getObject()).getSettings().mustBeInside.length() <= 0 || !branchDataItem2.ChunkCoordinate.equals(branchDataItem.ChunkCoordinate)) continue;
                String[] mustBeInsideBO3s = ((BO3)branchDataItem2.Branch.getObject()).getSettings().mustBeInside.split(",");
                boolean currentBO3Found = false;
                for (String mustBeInsideBO3Group : mustBeInsideBO3s) {
                    String[] mustBeInsideBO3sByGroup;
                    for (String mustBeInsideBO3 : mustBeInsideBO3sByGroup = mustBeInsideBO3Group.trim().split(" ")) {
                        String[] mustBeInsideBO3NameAndRotation = mustBeInsideBO3.split(":");
                        String mustBeInsideBO3Name = mustBeInsideBO3NameAndRotation[0];
                        String mustBeInsideBO3Rotation = mustBeInsideBO3NameAndRotation.length > 1 ? mustBeInsideBO3NameAndRotation[1] : null;
                        for (String branchName : ((BO3)branchDataItem.Branch.getObject()).getSettings().getInheritedBO3s()) {
                            if (!branchName.equals(mustBeInsideBO3Name.trim())) continue;
                            int rotation = branchDataItem.Branch.getRotation().getRotationId() - branchDataItem2.Branch.getRotation().getRotationId();
                            if (rotation < 0) {
                                rotation += 4;
                            }
                            if (mustBeInsideBO3Rotation != null && rotation != Rotation.FromString(mustBeInsideBO3Rotation).getRotationId()) continue;
                            currentBO3Found = true;
                            break;
                        }
                        if (currentBO3Found) break;
                    }
                    if (currentBO3Found) break;
                }
                if (!currentBO3Found) continue;
                boolean foundSpwanRequirement = false;
                for (String mustBeInsideBO3Group : mustBeInsideBO3s) {
                    String[] mustBeInsideBO3sByGroup = mustBeInsideBO3Group.trim().split(" ");
                    boolean foundAllSpwanRequirementParts = true;
                    for (String mustBeInsideBO3 : mustBeInsideBO3sByGroup) {
                        boolean bFoundPart = false;
                        for (BranchDataItem branchDataItem3 : this.AllBranchesBranchDataByChunk.get(branchDataItem2.ChunkCoordinate)) {
                            if (branchDataItem3 == branchDataItem || branchDataItem3 == branchDataItem2 || branchDataItem3 == branchDataItem2.Parent) continue;
                            String[] mustBeInsideBO3NameAndRotation = mustBeInsideBO3.split(":");
                            String mustBeInsideBO3Name = mustBeInsideBO3NameAndRotation[0];
                            String mustBeInsideBO3Rotation = mustBeInsideBO3NameAndRotation.length > 1 ? mustBeInsideBO3NameAndRotation[1] : null;
                            for (String branchName : ((BO3)branchDataItem3.Branch.getObject()).getSettings().getInheritedBO3s()) {
                                if (!branchName.equals(mustBeInsideBO3Name.trim())) continue;
                                int rotation = (branchDataItem3.Branch.getRotation().getRotationId() - branchDataItem2.Branch.getRotation().getRotationId()) % 4;
                                if (rotation < 0) {
                                    rotation += 4;
                                }
                                if (mustBeInsideBO3Rotation != null && rotation != Rotation.FromString(mustBeInsideBO3Rotation).getRotationId() || !this.CheckCollision(branchDataItem2.Branch, branchDataItem3.Branch)) continue;
                                bFoundPart = true;
                                break;
                            }
                            if (!bFoundPart) continue;
                            break;
                        }
                        if (bFoundPart) continue;
                        foundAllSpwanRequirementParts = false;
                        break;
                    }
                    if (!foundAllSpwanRequirementParts) continue;
                    foundSpwanRequirement = true;
                }
                if (foundSpwanRequirement) continue;
                this.RollBackBranch(branchDataItem2, minimumSize);
            }
        }
    }

    private Stack<BranchDataItem> CheckSpawnRequirementsAndCollisions(BranchDataItem branchData, boolean minimumSize) {
        Stack<BranchDataItem> collidingObjects = new Stack<BranchDataItem>();
        boolean bFound = false;
        CustomObjectCoordinate coordObject = branchData.Branch;
        if (!minimumSize) {
            int smoothRadius;
            if (!bFound && (this.World.IsInsidePregeneratedRegion(branchData.ChunkCoordinate, true) || this.World.getStructureCache().structureCache.containsKey(branchData.ChunkCoordinate))) {
                collidingObjects.add(null);
                bFound = true;
            }
            if (!bFound && !this.IsStructureAtSpawn) {
                LocalBiome biome3 = this.World.getBiome(branchData.ChunkCoordinate.getChunkX() * 16 + 8, branchData.ChunkCoordinate.getChunkZ() * 16 + 8);
                BiomeConfig biomeConfig3 = biome3.getBiomeConfig();
                ArrayList<String> structuresToSpawn = new ArrayList<String>();
                for (ConfigFunction<BiomeConfig> res : biomeConfig3.resourceSequence) {
                    if (!(res instanceof CustomStructureGen)) continue;
                    for (String bo3Name : ((CustomStructureGen)res).objectNames) {
                        structuresToSpawn.add(bo3Name);
                    }
                }
                ArrayList<String> biomeStructures = structuresToSpawn;
                boolean canSpawnHere = false;
                for (String structureToSpawn : biomeStructures) {
                    if (!structureToSpawn.equals(this.Start.getObject().getName())) continue;
                    canSpawnHere = true;
                    break;
                }
                if (!canSpawnHere) {
                    collidingObjects.add(null);
                    bFound = true;
                }
            }
            if ((smoothRadius = ((BO3)this.Start.getObject()).getSettings().smoothRadius) == -1 || ((BO3)coordObject.getObject()).getSettings().smoothRadius == -1) {
                smoothRadius = 0;
            }
            if (smoothRadius > 0 && !bFound) {
                double radiusInChunks = Math.ceil((double)smoothRadius / 16.0);
                int x = branchData.ChunkCoordinate.getChunkX() - (int)radiusInChunks;
                while ((double)x <= (double)branchData.ChunkCoordinate.getChunkX() + radiusInChunks) {
                    int z = branchData.ChunkCoordinate.getChunkZ() - (int)radiusInChunks;
                    while ((double)z <= (double)branchData.ChunkCoordinate.getChunkZ() + radiusInChunks) {
                        double distanceBetweenStructures = Math.floor((float)Math.sqrt(Math.pow(branchData.ChunkCoordinate.getChunkX() - x, 2.0) + Math.pow(branchData.ChunkCoordinate.getChunkZ() - z, 2.0)));
                        if (distanceBetweenStructures <= radiusInChunks) {
                            if (this.World.IsInsidePregeneratedRegion(ChunkCoordinate.fromChunkCoords(x, z), true) || this.World.getStructureCache().structureCache.containsKey(ChunkCoordinate.fromChunkCoords(x, z))) {
                                collidingObjects.add(null);
                                bFound = true;
                                break;
                            }
                            if (!this.IsStructureAtSpawn) {
                                LocalBiome biome3 = this.World.getBiome(x * 16 + 8, z * 16 + 8);
                                BiomeConfig biomeConfig3 = biome3.getBiomeConfig();
                                ArrayList<String> structuresToSpawn = new ArrayList<String>();
                                for (ConfigFunction<BiomeConfig> res : biomeConfig3.resourceSequence) {
                                    if (!(res instanceof CustomStructureGen)) continue;
                                    for (String bo3Name : ((CustomStructureGen)res).objectNames) {
                                        structuresToSpawn.add(bo3Name);
                                    }
                                }
                                ArrayList<String> biomeStructures = structuresToSpawn;
                                boolean canSpawnHere = false;
                                for (String structureToSpawn : biomeStructures) {
                                    if (!structureToSpawn.equals(this.Start.getObject().getName())) continue;
                                    canSpawnHere = true;
                                    break;
                                }
                                if (!canSpawnHere) {
                                    collidingObjects.add(null);
                                    bFound = true;
                                    break;
                                }
                            }
                        }
                        ++z;
                    }
                    if (bFound) break;
                    ++x;
                }
            }
        }
        if (!bFound && !((BO3)coordObject.getObject()).getSettings().canOverride) {
            Stack<BranchDataItem> existingBranches = new Stack<BranchDataItem>();
            if (this.AllBranchesBranchDataByChunk.containsKey(branchData.ChunkCoordinate)) {
                for (BranchDataItem existingBranchData : this.AllBranchesBranchDataByChunk.get(branchData.ChunkCoordinate)) {
                    if (!branchData.ChunkCoordinate.equals(existingBranchData.ChunkCoordinate) || ((BO3)existingBranchData.Branch.getObject()).getSettings().canOverride) continue;
                    existingBranches.add(existingBranchData);
                }
            }
            if (existingBranches.size() > 0) {
                for (BranchDataItem cachedBranch : existingBranches) {
                    if (!this.CheckCollision(coordObject, cachedBranch.Branch)) continue;
                    collidingObjects.add(cachedBranch);
                }
            }
        }
        return collidingObjects;
    }

    private boolean CheckCollision(CustomObjectCoordinate branchData1Branch, CustomObjectCoordinate branchData2Branch) {
        if (!((BO3)branchData1Branch.getObject()).isCollidable() || !((BO3)branchData2Branch.getObject()).isCollidable()) {
            return false;
        }
        CustomObjectCoordinate branchData1BranchMinRotated = CustomObjectCoordinate.getRotatedBO3CoordsJustified(((BO3)branchData1Branch.getObject()).getSettings().getminX(), ((BO3)branchData1Branch.getObject()).getSettings().getminY(), ((BO3)branchData1Branch.getObject()).getSettings().getminZ(), branchData1Branch.getRotation());
        CustomObjectCoordinate branchData1BranchMaxRotated = CustomObjectCoordinate.getRotatedBO3CoordsJustified(((BO3)branchData1Branch.getObject()).getSettings().getmaxX(), ((BO3)branchData1Branch.getObject()).getSettings().getmaxY(), ((BO3)branchData1Branch.getObject()).getSettings().getmaxZ(), branchData1Branch.getRotation());
        int startX = branchData1Branch.getX() + Math.min(branchData1BranchMinRotated.getX(), branchData1BranchMaxRotated.getX());
        int endX = branchData1Branch.getX() + Math.max(branchData1BranchMinRotated.getX(), branchData1BranchMaxRotated.getX());
        int startY = branchData1Branch.getY() + Math.min(branchData1BranchMinRotated.getY(), branchData1BranchMaxRotated.getY());
        int endY = branchData1Branch.getY() + Math.max(branchData1BranchMinRotated.getY(), branchData1BranchMaxRotated.getY());
        int startZ = branchData1Branch.getZ() + Math.min(branchData1BranchMinRotated.getZ(), branchData1BranchMaxRotated.getZ());
        int endZ = branchData1Branch.getZ() + Math.max(branchData1BranchMinRotated.getZ(), branchData1BranchMaxRotated.getZ());
        CustomObjectCoordinate branchData2BranchMinRotated = CustomObjectCoordinate.getRotatedBO3CoordsJustified(((BO3)branchData2Branch.getObject()).getSettings().getminX(), ((BO3)branchData2Branch.getObject()).getSettings().getminY(), ((BO3)branchData2Branch.getObject()).getSettings().getminZ(), branchData2Branch.getRotation());
        CustomObjectCoordinate branchData2BranchMaxRotated = CustomObjectCoordinate.getRotatedBO3CoordsJustified(((BO3)branchData2Branch.getObject()).getSettings().getmaxX(), ((BO3)branchData2Branch.getObject()).getSettings().getmaxY(), ((BO3)branchData2Branch.getObject()).getSettings().getmaxZ(), branchData2Branch.getRotation());
        int cachedBranchStartX = branchData2Branch.getX() + Math.min(branchData2BranchMinRotated.getX(), branchData2BranchMaxRotated.getX());
        int cachedBranchEndX = branchData2Branch.getX() + Math.max(branchData2BranchMinRotated.getX(), branchData2BranchMaxRotated.getX());
        int cachedBranchStartY = branchData2Branch.getY() + Math.min(branchData2BranchMinRotated.getY(), branchData2BranchMaxRotated.getY());
        int cachedBranchEndY = branchData2Branch.getY() + Math.max(branchData2BranchMinRotated.getY(), branchData2BranchMaxRotated.getY());
        int cachedBranchStartZ = branchData2Branch.getZ() + Math.min(branchData2BranchMinRotated.getZ(), branchData2BranchMaxRotated.getZ());
        int cachedBranchEndZ = branchData2Branch.getZ() + Math.max(branchData2BranchMinRotated.getZ(), branchData2BranchMaxRotated.getZ());
        return cachedBranchEndX >= startX && cachedBranchStartX <= endX && cachedBranchEndY >= startY && cachedBranchStartY <= endY && cachedBranchEndZ >= startZ && cachedBranchStartZ <= endZ;
    }

    private void AddToChunk(CustomObjectCoordinate coordObject, ChunkCoordinate chunkCoordinate, Map<ChunkCoordinate, Stack<CustomObjectCoordinate>> objectList) {
        Stack<CustomObjectCoordinate> objectsInChunk = objectList.get(chunkCoordinate);
        if (objectsInChunk == null) {
            objectsInChunk = new Stack();
        }
        objectsInChunk.add(coordObject);
        objectList.put(chunkCoordinate, objectsInChunk);
    }

    public boolean SpawnForChunk(ChunkCoordinate chunkCoordinate) {
        if (this.Start == null) {
            throw new RuntimeException();
        }
        if (!this.ObjectsToSpawn.containsKey(chunkCoordinate) && !this.SmoothingAreasToSpawn.containsKey(chunkCoordinate)) {
            return true;
        }
        this.saveRequired = true;
        this.DoStartChunkBlockChecks();
        Stack<CustomObjectCoordinate> objectsInChunk = this.ObjectsToSpawn.get(chunkCoordinate);
        if (objectsInChunk != null) {
            BO3Config objectConfig;
            BO3 bo3;
            BO3Config config = ((BO3)this.Start.getObject()).getSettings();
            LocalBiome biome = null;
            BiomeConfig biomeConfig = null;
            if (config.SpawnUnderWater && (biomeConfig = (biome = this.World.getBiome(this.Start.getX() + 8, this.Start.getZ() + 7)).getBiomeConfig()) == null) {
                throw new RuntimeException();
            }
            BO3.originalTopBlocks.clear();
            for (CustomObjectCoordinate coordObject : objectsInChunk) {
                if (coordObject.isSpawned) continue;
                bo3 = (BO3)coordObject.getObject();
                if (bo3 == null) {
                    throw new RuntimeException();
                }
                objectConfig = bo3.getSettings();
                if (coordObject.spawnWithChecks(chunkCoordinate, this.World, this.Random, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceAbove : objectConfig.replaceAbove, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceBelow : objectConfig.replaceBelow, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceWithBiomeBlocks : objectConfig.replaceWithBiomeBlocks, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceWithSurfaceBlock : objectConfig.replaceWithSurfaceBlock, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceWithGroundBlock : objectConfig.replaceWithGroundBlock, config.SpawnUnderWater, !config.SpawnUnderWater ? -1 : (biomeConfig.useWorldWaterLevel ? this.World.getConfigs().getWorldConfig().waterLevelMax : biomeConfig.waterLevelMax), false, true)) continue;
                OTG.log(LogMarker.FATAL, "Could not spawn chunk " + coordObject.BO3Name + " for structure " + this.Start.getObject().getName(), new Object[0]);
                throw new RuntimeException();
            }
            if (!this.SpawnSmoothAreas(chunkCoordinate)) {
                return false;
            }
            for (CustomObjectCoordinate coordObject : objectsInChunk) {
                if (coordObject.isSpawned) continue;
                bo3 = (BO3)coordObject.getObject();
                if (bo3 == null) {
                    throw new RuntimeException();
                }
                objectConfig = bo3.getSettings();
                if (!coordObject.spawnWithChecks(chunkCoordinate, this.World, this.Random, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceAbove : objectConfig.replaceAbove, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceBelow : objectConfig.replaceBelow, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceWithBiomeBlocks : objectConfig.replaceWithBiomeBlocks, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceWithSurfaceBlock : objectConfig.replaceWithSurfaceBlock, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceWithGroundBlock : objectConfig.replaceWithGroundBlock, config.SpawnUnderWater, !config.SpawnUnderWater ? -1 : (biomeConfig.useWorldWaterLevel ? this.World.getConfigs().getWorldConfig().waterLevelMax : biomeConfig.waterLevelMax), false, false)) {
                    OTG.log(LogMarker.FATAL, "Could not spawn chunk " + coordObject.BO3Name + " for structure " + this.Start.getObject().getName(), new Object[0]);
                    throw new RuntimeException();
                }
                ModDataFunction[] blockDataInObject = objectConfig.getModData();
                for (int i = 0; i < blockDataInObject.length; ++i) {
                    ModDataFunction newModData = new ModDataFunction();
                    if (coordObject.getRotation() != Rotation.NORTH) {
                        int rotations = 0;
                        if (coordObject.getRotation() == Rotation.WEST) {
                            rotations = 1;
                        } else if (coordObject.getRotation() == Rotation.SOUTH) {
                            rotations = 2;
                        } else if (coordObject.getRotation() == Rotation.EAST) {
                            rotations = 3;
                        }
                        if (rotations == 0) {
                            newModData.x = blockDataInObject[i].x;
                            newModData.z = blockDataInObject[i].z;
                        }
                        if (rotations == 1) {
                            newModData.x = blockDataInObject[i].z;
                            newModData.z = -blockDataInObject[i].x + 15;
                        }
                        if (rotations == 2) {
                            newModData.x = -blockDataInObject[i].x + 15;
                            newModData.z = -blockDataInObject[i].z + 15;
                        }
                        if (rotations == 3) {
                            newModData.x = -blockDataInObject[i].z + 15;
                            newModData.z = blockDataInObject[i].x;
                        }
                        newModData.y = coordObject.getY() + blockDataInObject[i].y;
                        newModData.x = coordObject.getX() + newModData.x;
                        newModData.z = coordObject.getZ() + newModData.z;
                        newModData.modData = blockDataInObject[i].modData;
                        newModData.modId = blockDataInObject[i].modId;
                        this.modData.add(newModData);
                        if (ChunkCoordinate.fromBlockCoords(newModData.x, newModData.z).equals(chunkCoordinate)) continue;
                        throw new RuntimeException();
                    }
                    newModData.y = coordObject.getY() + blockDataInObject[i].y;
                    newModData.x = coordObject.getX() + blockDataInObject[i].x;
                    newModData.z = coordObject.getZ() + blockDataInObject[i].z;
                    newModData.modData = blockDataInObject[i].modData;
                    newModData.modId = blockDataInObject[i].modId;
                    this.modData.add(newModData);
                    if (ChunkCoordinate.fromBlockCoords(newModData.x, newModData.z).equals(chunkCoordinate)) continue;
                    throw new RuntimeException();
                }
                SpawnerFunction[] spawnerDataInObject = objectConfig.getSpawnerData();
                for (int i = 0; i < spawnerDataInObject.length; ++i) {
                    SpawnerFunction newSpawnerData = new SpawnerFunction();
                    if (coordObject.getRotation() != Rotation.NORTH) {
                        int rotations = 0;
                        if (coordObject.getRotation() == Rotation.WEST) {
                            rotations = 1;
                        } else if (coordObject.getRotation() == Rotation.SOUTH) {
                            rotations = 2;
                        } else if (coordObject.getRotation() == Rotation.EAST) {
                            rotations = 3;
                        }
                        if (rotations == 0) {
                            newSpawnerData.x = spawnerDataInObject[i].x;
                            newSpawnerData.velocityX = spawnerDataInObject[i].velocityX;
                            newSpawnerData.z = spawnerDataInObject[i].z;
                            newSpawnerData.velocityZ = spawnerDataInObject[i].velocityZ;
                            newSpawnerData.velocityXSet = spawnerDataInObject[i].velocityXSet;
                            newSpawnerData.velocityZSet = spawnerDataInObject[i].velocityZSet;
                        }
                        if (rotations == 1) {
                            newSpawnerData.x = spawnerDataInObject[i].z;
                            newSpawnerData.velocityX = spawnerDataInObject[i].velocityZ;
                            newSpawnerData.z = -spawnerDataInObject[i].x + 15;
                            newSpawnerData.velocityZ = -spawnerDataInObject[i].velocityX;
                            newSpawnerData.velocityXSet = spawnerDataInObject[i].velocityZSet;
                            newSpawnerData.velocityZSet = spawnerDataInObject[i].velocityXSet;
                        }
                        if (rotations == 2) {
                            newSpawnerData.x = -spawnerDataInObject[i].x + 15;
                            newSpawnerData.velocityX = -spawnerDataInObject[i].velocityX;
                            newSpawnerData.z = -spawnerDataInObject[i].z + 15;
                            newSpawnerData.velocityZ = -spawnerDataInObject[i].velocityZ;
                            newSpawnerData.velocityXSet = spawnerDataInObject[i].velocityXSet;
                            newSpawnerData.velocityZSet = spawnerDataInObject[i].velocityZSet;
                        }
                        if (rotations == 3) {
                            newSpawnerData.x = -spawnerDataInObject[i].z + 15;
                            newSpawnerData.velocityX = -spawnerDataInObject[i].velocityZ;
                            newSpawnerData.z = spawnerDataInObject[i].x;
                            newSpawnerData.velocityZ = spawnerDataInObject[i].velocityX;
                            newSpawnerData.velocityXSet = spawnerDataInObject[i].velocityZSet;
                            newSpawnerData.velocityZSet = spawnerDataInObject[i].velocityXSet;
                        }
                        newSpawnerData.y = coordObject.getY() + spawnerDataInObject[i].y;
                        newSpawnerData.x = coordObject.getX() + newSpawnerData.x;
                        newSpawnerData.z = coordObject.getZ() + newSpawnerData.z;
                        newSpawnerData.mobName = spawnerDataInObject[i].mobName;
                        newSpawnerData.originalnbtFileName = spawnerDataInObject[i].originalnbtFileName;
                        newSpawnerData.nbtFileName = spawnerDataInObject[i].nbtFileName;
                        newSpawnerData.groupSize = spawnerDataInObject[i].groupSize;
                        newSpawnerData.interval = spawnerDataInObject[i].interval;
                        newSpawnerData.spawnChance = spawnerDataInObject[i].spawnChance;
                        newSpawnerData.maxCount = spawnerDataInObject[i].maxCount;
                        newSpawnerData.despawnTime = spawnerDataInObject[i].despawnTime;
                        newSpawnerData.velocityY = spawnerDataInObject[i].velocityY;
                        newSpawnerData.velocityYSet = spawnerDataInObject[i].velocityYSet;
                        newSpawnerData.yaw = spawnerDataInObject[i].yaw;
                        newSpawnerData.pitch = spawnerDataInObject[i].pitch;
                        this.spawnerData.add(newSpawnerData);
                        if (ChunkCoordinate.fromBlockCoords(newSpawnerData.x, newSpawnerData.z).equals(chunkCoordinate)) continue;
                        throw new RuntimeException();
                    }
                    newSpawnerData.y = coordObject.getY() + spawnerDataInObject[i].y;
                    newSpawnerData.x = coordObject.getX() + spawnerDataInObject[i].x;
                    newSpawnerData.z = coordObject.getZ() + spawnerDataInObject[i].z;
                    newSpawnerData.mobName = spawnerDataInObject[i].mobName;
                    newSpawnerData.originalnbtFileName = spawnerDataInObject[i].originalnbtFileName;
                    newSpawnerData.nbtFileName = spawnerDataInObject[i].nbtFileName;
                    newSpawnerData.groupSize = spawnerDataInObject[i].groupSize;
                    newSpawnerData.interval = spawnerDataInObject[i].interval;
                    newSpawnerData.spawnChance = spawnerDataInObject[i].spawnChance;
                    newSpawnerData.maxCount = spawnerDataInObject[i].maxCount;
                    newSpawnerData.despawnTime = spawnerDataInObject[i].despawnTime;
                    newSpawnerData.velocityX = spawnerDataInObject[i].velocityX;
                    newSpawnerData.velocityY = spawnerDataInObject[i].velocityY;
                    newSpawnerData.velocityZ = spawnerDataInObject[i].velocityZ;
                    newSpawnerData.velocityXSet = spawnerDataInObject[i].velocityXSet;
                    newSpawnerData.velocityYSet = spawnerDataInObject[i].velocityYSet;
                    newSpawnerData.velocityZSet = spawnerDataInObject[i].velocityZSet;
                    newSpawnerData.yaw = spawnerDataInObject[i].yaw;
                    newSpawnerData.pitch = spawnerDataInObject[i].pitch;
                    this.spawnerData.add(newSpawnerData);
                    if (ChunkCoordinate.fromBlockCoords(newSpawnerData.x, newSpawnerData.z).equals(chunkCoordinate)) continue;
                    throw new RuntimeException();
                }
                ParticleFunction[] particleDataInObject = objectConfig.getParticleData();
                for (int i = 0; i < particleDataInObject.length; ++i) {
                    ParticleFunction newParticleData = new ParticleFunction();
                    if (coordObject.getRotation() != Rotation.NORTH) {
                        int rotations = 0;
                        if (coordObject.getRotation() == Rotation.WEST) {
                            rotations = 1;
                        } else if (coordObject.getRotation() == Rotation.SOUTH) {
                            rotations = 2;
                        } else if (coordObject.getRotation() == Rotation.EAST) {
                            rotations = 3;
                        }
                        if (rotations == 0) {
                            newParticleData.x = particleDataInObject[i].x;
                            newParticleData.velocityX = particleDataInObject[i].velocityX;
                            newParticleData.z = particleDataInObject[i].z;
                            newParticleData.velocityZ = particleDataInObject[i].velocityZ;
                            newParticleData.velocityXSet = particleDataInObject[i].velocityXSet;
                            newParticleData.velocityZSet = particleDataInObject[i].velocityZSet;
                        }
                        if (rotations == 1) {
                            newParticleData.x = particleDataInObject[i].z;
                            newParticleData.velocityX = particleDataInObject[i].velocityZ;
                            newParticleData.z = -particleDataInObject[i].x + 15;
                            newParticleData.velocityZ = -particleDataInObject[i].velocityX;
                            newParticleData.velocityXSet = particleDataInObject[i].velocityZSet;
                            newParticleData.velocityZSet = particleDataInObject[i].velocityXSet;
                        }
                        if (rotations == 2) {
                            newParticleData.x = -particleDataInObject[i].x + 15;
                            newParticleData.velocityX = -particleDataInObject[i].velocityX;
                            newParticleData.z = -particleDataInObject[i].z + 15;
                            newParticleData.velocityZ = -particleDataInObject[i].velocityZ;
                            newParticleData.velocityXSet = particleDataInObject[i].velocityXSet;
                            newParticleData.velocityZSet = particleDataInObject[i].velocityZSet;
                        }
                        if (rotations == 3) {
                            newParticleData.x = -particleDataInObject[i].z + 15;
                            newParticleData.velocityX = -particleDataInObject[i].velocityZ;
                            newParticleData.z = particleDataInObject[i].x;
                            newParticleData.velocityZ = particleDataInObject[i].velocityX;
                            newParticleData.velocityXSet = particleDataInObject[i].velocityZSet;
                            newParticleData.velocityZSet = particleDataInObject[i].velocityXSet;
                        }
                        newParticleData.y = coordObject.getY() + particleDataInObject[i].y;
                        newParticleData.x = coordObject.getX() + newParticleData.x;
                        newParticleData.z = coordObject.getZ() + newParticleData.z;
                        newParticleData.particleName = particleDataInObject[i].particleName;
                        newParticleData.interval = particleDataInObject[i].interval;
                        newParticleData.velocityY = particleDataInObject[i].velocityY;
                        newParticleData.velocityYSet = particleDataInObject[i].velocityYSet;
                        this.particleData.add(newParticleData);
                        if (ChunkCoordinate.fromBlockCoords(newParticleData.x, newParticleData.z).equals(chunkCoordinate)) continue;
                        throw new RuntimeException();
                    }
                    newParticleData.y = coordObject.getY() + particleDataInObject[i].y;
                    newParticleData.x = coordObject.getX() + particleDataInObject[i].x;
                    newParticleData.z = coordObject.getZ() + particleDataInObject[i].z;
                    newParticleData.particleName = particleDataInObject[i].particleName;
                    newParticleData.interval = particleDataInObject[i].interval;
                    newParticleData.velocityX = particleDataInObject[i].velocityX;
                    newParticleData.velocityY = particleDataInObject[i].velocityY;
                    newParticleData.velocityZ = particleDataInObject[i].velocityZ;
                    newParticleData.velocityXSet = particleDataInObject[i].velocityXSet;
                    newParticleData.velocityYSet = particleDataInObject[i].velocityYSet;
                    newParticleData.velocityZSet = particleDataInObject[i].velocityZSet;
                    this.particleData.add(newParticleData);
                    if (ChunkCoordinate.fromBlockCoords(newParticleData.x, newParticleData.z).equals(chunkCoordinate)) continue;
                    throw new RuntimeException();
                }
                EntityFunction[] entityDataInObject = objectConfig.getEntityData();
                for (int i = 0; i < entityDataInObject.length; ++i) {
                    EntityFunction newEntityData = new EntityFunction();
                    if (coordObject.getRotation() != Rotation.NORTH) {
                        int rotations = 0;
                        if (coordObject.getRotation() == Rotation.WEST) {
                            rotations = 1;
                        } else if (coordObject.getRotation() == Rotation.SOUTH) {
                            rotations = 2;
                        } else if (coordObject.getRotation() == Rotation.EAST) {
                            rotations = 3;
                        }
                        if (rotations == 0) {
                            newEntityData.x = entityDataInObject[i].x;
                            newEntityData.z = entityDataInObject[i].z;
                        }
                        if (rotations == 1) {
                            newEntityData.x = entityDataInObject[i].z;
                            newEntityData.z = -entityDataInObject[i].x + 15;
                        }
                        if (rotations == 2) {
                            newEntityData.x = -entityDataInObject[i].x + 15;
                            newEntityData.z = -entityDataInObject[i].z + 15;
                        }
                        if (rotations == 3) {
                            newEntityData.x = -entityDataInObject[i].z + 15;
                            newEntityData.z = entityDataInObject[i].x;
                        }
                        newEntityData.y = coordObject.getY() + entityDataInObject[i].y;
                        newEntityData.x = coordObject.getX() + newEntityData.x;
                        newEntityData.z = coordObject.getZ() + newEntityData.z;
                        newEntityData.mobName = entityDataInObject[i].mobName;
                        newEntityData.groupSize = entityDataInObject[i].groupSize;
                        newEntityData.nameTagOrNBTFileName = entityDataInObject[i].nameTagOrNBTFileName;
                        this.World.SpawnEntity(newEntityData);
                        if (ChunkCoordinate.fromBlockCoords(newEntityData.x, newEntityData.z).equals(chunkCoordinate)) continue;
                        throw new RuntimeException();
                    }
                    newEntityData.y = coordObject.getY() + entityDataInObject[i].y;
                    newEntityData.x = coordObject.getX() + entityDataInObject[i].x;
                    newEntityData.z = coordObject.getZ() + entityDataInObject[i].z;
                    newEntityData.mobName = entityDataInObject[i].mobName;
                    newEntityData.groupSize = entityDataInObject[i].groupSize;
                    newEntityData.nameTagOrNBTFileName = entityDataInObject[i].nameTagOrNBTFileName;
                    this.World.SpawnEntity(newEntityData);
                    if (ChunkCoordinate.fromBlockCoords(newEntityData.x, newEntityData.z).equals(chunkCoordinate)) continue;
                    throw new RuntimeException();
                }
                coordObject.isSpawned = true;
            }
            BO3.originalTopBlocks.clear();
        } else if (!this.SpawnSmoothAreas(chunkCoordinate)) {
            return false;
        }
        this.ObjectsToSpawn.remove(chunkCoordinate);
        this.SmoothingAreasToSpawn.remove(chunkCoordinate);
        return true;
    }

    private boolean SpawnSmoothAreas(ChunkCoordinate chunkCoordinate) {
        Map.Entry<ChunkCoordinate, ArrayList<Object[]>> smoothingAreaInChunk = null;
        for (Map.Entry<ChunkCoordinate, ArrayList<Object[]>> smoothingAreaToSpawn : this.SmoothingAreasToSpawn.entrySet()) {
            if (smoothingAreaToSpawn.getKey().getChunkX() != chunkCoordinate.getChunkX() || smoothingAreaToSpawn.getKey().getChunkZ() != chunkCoordinate.getChunkZ()) continue;
            smoothingAreaInChunk = smoothingAreaToSpawn;
            break;
        }
        if (smoothingAreaInChunk != null && smoothingAreaInChunk.getValue() != null) {
            LocalMaterialData material;
            ArrayList<Object[]> blocksToSpawn = this.MergeSmoothingAreas(chunkCoordinate, (ArrayList)smoothingAreaInChunk.getValue());
            if (blocksToSpawn == null) {
                return false;
            }
            boolean isOnBiomeBorder = false;
            LocalBiome biome = this.World.getBiome(chunkCoordinate.getChunkX() * 16, chunkCoordinate.getChunkZ() * 16);
            LocalBiome biome2 = this.World.getBiome(chunkCoordinate.getChunkX() * 16 + 15, chunkCoordinate.getChunkZ() * 16);
            LocalBiome biome3 = this.World.getBiome(chunkCoordinate.getChunkX() * 16, chunkCoordinate.getChunkZ() * 16 + 15);
            LocalBiome biome4 = this.World.getBiome(chunkCoordinate.getChunkX() * 16 + 15, chunkCoordinate.getChunkZ() * 16 + 15);
            if (biome != biome2 || biome != biome3 || biome != biome4) {
                isOnBiomeBorder = true;
            }
            BiomeConfig biomeConfig = biome.getBiomeConfig();
            DefaultMaterial surfaceBlockMaterial = biomeConfig.surfaceBlock.toDefaultMaterial();
            byte surfaceBlockMaterialBlockData = biomeConfig.surfaceBlock.getBlockData();
            DefaultMaterial groundBlockMaterial = biomeConfig.groundBlock.toDefaultMaterial();
            byte groundBlockMaterialBlockData = biomeConfig.groundBlock.getBlockData();
            boolean surfaceBlockSet = false;
            if (((BO3)this.Start.getObject()).getSettings().smoothingSurfaceBlock != null && ((BO3)this.Start.getObject()).getSettings().smoothingSurfaceBlock.trim().length() > 0) {
                try {
                    LocalMaterialData material2 = OTG.readMaterial(((BO3)this.Start.getObject()).getSettings().smoothingSurfaceBlock);
                    surfaceBlockSet = true;
                    surfaceBlockMaterial = material2.toDefaultMaterial();
                    surfaceBlockMaterialBlockData = material2.getBlockData();
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            boolean groundBlockSet = false;
            if (((BO3)this.Start.getObject()).getSettings().smoothingGroundBlock != null && ((BO3)this.Start.getObject()).getSettings().smoothingGroundBlock.trim().length() > 0) {
                try {
                    LocalMaterialData material3 = OTG.readMaterial(((BO3)this.Start.getObject()).getSettings().smoothingGroundBlock);
                    groundBlockSet = true;
                    groundBlockMaterial = material3.toDefaultMaterial();
                    groundBlockMaterialBlockData = material3.getBlockData();
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            if (surfaceBlockMaterial == null || surfaceBlockMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                surfaceBlockMaterial = DefaultMaterial.GRASS;
                surfaceBlockMaterialBlockData = 0;
            }
            if (groundBlockMaterial == null || groundBlockMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                groundBlockMaterial = DefaultMaterial.DIRT;
                groundBlockMaterialBlockData = 0;
            }
            DefaultMaterial replaceAboveMaterial = null;
            byte replaceAboveMaterialBlockData = 0;
            DefaultMaterial replaceBelowMaterial = null;
            if (((BO3)this.Start.getObject()).getSettings().replaceAbove != null && ((BO3)this.Start.getObject()).getSettings().replaceAbove.trim().length() > 0) {
                try {
                    material = OTG.readMaterial(((BO3)this.Start.getObject()).getSettings().replaceAbove);
                    replaceAboveMaterial = material.toDefaultMaterial();
                    replaceAboveMaterialBlockData = material.getBlockData();
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            if (((BO3)this.Start.getObject()).getSettings().replaceBelow != null && ((BO3)this.Start.getObject()).getSettings().replaceBelow.trim().length() > 0) {
                try {
                    material = OTG.readMaterial(((BO3)this.Start.getObject()).getSettings().replaceBelow);
                    replaceBelowMaterial = material.toDefaultMaterial();
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            if (replaceAboveMaterial == null || replaceAboveMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                replaceAboveMaterial = null;
                replaceAboveMaterialBlockData = 0;
            }
            if (replaceBelowMaterial == null || replaceBelowMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                replaceBelowMaterial = null;
            }
            DefaultMaterial materialToSet = null;
            Byte blockDataToSet = 0;
            BlockFunction blockToQueueForSpawn = new BlockFunction();
            HashMap<ChunkCoordinate, LocalMaterialData> originalTopBlocks = new HashMap<ChunkCoordinate, LocalMaterialData>();
            block9: for (Object[] blockItemToSpawn : blocksToSpawn) {
                LocalMaterialData customBlockData;
                DefaultMaterial sourceBlockMaterialAbove;
                LocalMaterialData sourceBlockMaterial;
                int y;
                int yEnd;
                int yStart;
                BlockFunction blockToSpawn = (BlockFunction)blockItemToSpawn[0];
                boolean goingUp = (Boolean)blockItemToSpawn[1];
                boolean secondPass = (Boolean)blockItemToSpawn[3];
                if (blockToSpawn.y > 255) continue;
                if (!originalTopBlocks.containsKey(ChunkCoordinate.fromChunkCoords(blockToSpawn.x, blockToSpawn.z))) {
                    int highestBlockY = this.World.getHighestBlockYAt(blockToSpawn.x, blockToSpawn.z, true, true, false, false);
                    if (highestBlockY > 0) {
                        originalTopBlocks.put(ChunkCoordinate.fromChunkCoords(blockToSpawn.x, blockToSpawn.z), this.World.getMaterial(blockToSpawn.x, highestBlockY, blockToSpawn.z, this.IsOTGPlus));
                    } else {
                        originalTopBlocks.put(ChunkCoordinate.fromChunkCoords(blockToSpawn.x, blockToSpawn.z), null);
                    }
                }
                if (!(!isOnBiomeBorder || surfaceBlockSet && groundBlockSet)) {
                    biome = this.World.getBiome(blockToSpawn.x, blockToSpawn.z);
                    biomeConfig = biome.getBiomeConfig();
                    if (!surfaceBlockSet) {
                        surfaceBlockMaterial = biomeConfig.surfaceBlock.toDefaultMaterial();
                        surfaceBlockMaterialBlockData = biomeConfig.surfaceBlock.getBlockData();
                        if (surfaceBlockMaterial == null || surfaceBlockMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                            surfaceBlockMaterial = DefaultMaterial.GRASS;
                            surfaceBlockMaterialBlockData = 0;
                        }
                    }
                    if (!groundBlockSet) {
                        groundBlockMaterial = biomeConfig.groundBlock.toDefaultMaterial();
                        groundBlockMaterialBlockData = biomeConfig.groundBlock.getBlockData();
                        if (groundBlockMaterial == null || groundBlockMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                            groundBlockMaterial = DefaultMaterial.DIRT;
                            groundBlockMaterialBlockData = 0;
                        }
                    }
                }
                if (!surfaceBlockSet && !(biomeConfig.surfaceAndGroundControl instanceof MesaSurfaceGenerator)) {
                    LocalMaterialData originalSurfaceBlock = (LocalMaterialData)originalTopBlocks.get(ChunkCoordinate.fromChunkCoords(blockToSpawn.x, blockToSpawn.z));
                    if (originalSurfaceBlock == null || originalSurfaceBlock.isLiquid() || originalSurfaceBlock.isAir()) {
                        surfaceBlockMaterial = biomeConfig.surfaceBlock.toDefaultMaterial();
                        surfaceBlockMaterialBlockData = biomeConfig.surfaceBlock.getBlockData();
                    } else {
                        surfaceBlockMaterial = originalSurfaceBlock.toDefaultMaterial();
                        surfaceBlockMaterialBlockData = originalSurfaceBlock.getBlockData();
                    }
                    if (surfaceBlockMaterial == null || surfaceBlockMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                        surfaceBlockMaterial = DefaultMaterial.GRASS;
                        surfaceBlockMaterialBlockData = 0;
                    }
                }
                boolean bBreak = false;
                if (!goingUp) {
                    yStart = blockToSpawn.y;
                    yEnd = 0;
                    for (y = yStart; y > yEnd; --y) {
                        if (y >= 255) continue;
                        sourceBlockMaterial = this.World.getMaterial(blockToSpawn.x, y, blockToSpawn.z, this.IsOTGPlus);
                        if (sourceBlockMaterial.isSolid() && y < blockToSpawn.y) {
                            bBreak = true;
                        }
                        if (y == blockToSpawn.y) {
                            sourceBlockMaterialAbove = this.World.getMaterial(blockToSpawn.x, y + 1, blockToSpawn.z, this.IsOTGPlus).toDefaultMaterial();
                            if (sourceBlockMaterialAbove == null || sourceBlockMaterialAbove == DefaultMaterial.AIR) {
                                materialToSet = surfaceBlockMaterial;
                                blockDataToSet = surfaceBlockMaterialBlockData;
                            } else {
                                materialToSet = groundBlockMaterial;
                                blockDataToSet = groundBlockMaterialBlockData;
                            }
                        } else if (y < blockToSpawn.y) {
                            materialToSet = groundBlockMaterial;
                            blockDataToSet = groundBlockMaterialBlockData;
                        } else {
                            throw new RuntimeException();
                        }
                        if (materialToSet != null && materialToSet != DefaultMaterial.UNKNOWN_BLOCK) {
                            blockToQueueForSpawn = new BlockFunction();
                            blockToQueueForSpawn.x = blockToSpawn.x;
                            blockToQueueForSpawn.y = y;
                            blockToQueueForSpawn.z = blockToSpawn.z;
                            blockToQueueForSpawn.material = OTG.toLocalMaterialData(materialToSet, blockDataToSet.byteValue());
                            if (!blockToQueueForSpawn.material.isAir() && !blockToQueueForSpawn.material.isLiquid() && biomeConfig.surfaceAndGroundControl != null && biomeConfig.surfaceAndGroundControl instanceof MesaSurfaceGenerator && (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeConfig.groundBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeConfig.groundBlock.getBlockData() || blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeConfig.surfaceBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeConfig.surfaceBlock.getBlockData())) {
                                customBlockData = biomeConfig.surfaceAndGroundControl.getCustomBlockData(this.World, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z);
                                if (customBlockData != null) {
                                    blockToQueueForSpawn.material = customBlockData;
                                }
                                this.setBlock(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag);
                            } else if (!sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) || sourceBlockMaterial.getBlockData() != blockToQueueForSpawn.material.getBlockData()) {
                                this.setBlock(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag);
                            }
                        } else {
                            throw new RuntimeException();
                        }
                        if (bBreak) continue block9;
                    }
                    continue;
                }
                if (!goingUp || replaceAboveMaterial == null) continue;
                yStart = this.World.getHighestBlockYAt(blockToSpawn.x, blockToSpawn.z, true, true, false, false);
                yEnd = 0;
                for (y = yStart; y >= yEnd; --y) {
                    if (y >= 255) continue;
                    sourceBlockMaterial = this.World.getMaterial(blockToSpawn.x, y, blockToSpawn.z, this.IsOTGPlus);
                    materialToSet = replaceAboveMaterial;
                    blockDataToSet = replaceAboveMaterialBlockData;
                    if (y < blockToSpawn.y) {
                        if (!sourceBlockMaterial.isLiquid() || secondPass && !((BO3)this.Start.getObject()).getSettings().SpawnUnderWater) continue block9;
                        if (((BO3)this.Start.getObject()).getSettings().SpawnUnderWater) {
                            materialToSet = replaceAboveMaterial;
                            blockDataToSet = replaceAboveMaterialBlockData;
                        } else {
                            sourceBlockMaterialAbove = this.World.getMaterial(blockToSpawn.x, y + 1, blockToSpawn.z, this.IsOTGPlus).toDefaultMaterial();
                            if (sourceBlockMaterialAbove == null || sourceBlockMaterialAbove == DefaultMaterial.AIR) {
                                materialToSet = surfaceBlockMaterial;
                                blockDataToSet = surfaceBlockMaterialBlockData;
                            } else {
                                materialToSet = groundBlockMaterial;
                                blockDataToSet = groundBlockMaterialBlockData;
                            }
                        }
                    }
                    if (y == blockToSpawn.y) {
                        if (sourceBlockMaterial.isSolid() || !secondPass && sourceBlockMaterial.isLiquid() && !((BO3)this.Start.getObject()).getSettings().SpawnUnderWater) {
                            sourceBlockMaterialAbove = this.World.getMaterial(blockToSpawn.x, y + 1, blockToSpawn.z, this.IsOTGPlus).toDefaultMaterial();
                            if (sourceBlockMaterialAbove == null || sourceBlockMaterialAbove == DefaultMaterial.AIR) {
                                sourceBlockMaterialAbove = this.World.getMaterial(blockToSpawn.x, y + 1, blockToSpawn.z, this.IsOTGPlus).toDefaultMaterial();
                                if (sourceBlockMaterialAbove == null || sourceBlockMaterialAbove == DefaultMaterial.AIR) {
                                    materialToSet = surfaceBlockMaterial;
                                    blockDataToSet = surfaceBlockMaterialBlockData;
                                } else {
                                    materialToSet = groundBlockMaterial;
                                    blockDataToSet = groundBlockMaterialBlockData;
                                }
                            } else {
                                materialToSet = groundBlockMaterial;
                                blockDataToSet = groundBlockMaterialBlockData;
                            }
                        } else if (((BO3)this.Start.getObject()).getSettings().SpawnUnderWater) {
                            materialToSet = replaceAboveMaterial;
                            blockDataToSet = replaceAboveMaterialBlockData;
                        } else {
                            if (sourceBlockMaterial.isLiquid() || sourceBlockMaterial.equals((Object)DefaultMaterial.AIR)) continue block9;
                            sourceBlockMaterialAbove = this.World.getMaterial(blockToSpawn.x, y + 1, blockToSpawn.z, this.IsOTGPlus).toDefaultMaterial();
                            if (sourceBlockMaterialAbove == null || sourceBlockMaterialAbove == DefaultMaterial.AIR) {
                                materialToSet = DefaultMaterial.AIR;
                                blockDataToSet = surfaceBlockMaterialBlockData;
                            } else {
                                materialToSet = groundBlockMaterial;
                                blockDataToSet = groundBlockMaterialBlockData;
                            }
                            bBreak = true;
                        }
                    }
                    if (materialToSet.isLiquid() && ((BO3)this.Start.getObject()).getSettings().SpawnUnderWater && y >= (biomeConfig.useWorldWaterLevel ? this.World.getConfigs().getWorldConfig().waterLevelMax : biomeConfig.waterLevelMax)) {
                        materialToSet = DefaultMaterial.AIR;
                        blockDataToSet = 0;
                    }
                    if (materialToSet != null && materialToSet != DefaultMaterial.UNKNOWN_BLOCK) {
                        blockToQueueForSpawn = new BlockFunction();
                        blockToQueueForSpawn.x = blockToSpawn.x;
                        blockToQueueForSpawn.y = y;
                        blockToQueueForSpawn.z = blockToSpawn.z;
                        blockToQueueForSpawn.material = OTG.toLocalMaterialData(materialToSet, blockDataToSet.byteValue());
                        if (!blockToQueueForSpawn.material.isAir() && !blockToQueueForSpawn.material.isLiquid() && biomeConfig.surfaceAndGroundControl != null && biomeConfig.surfaceAndGroundControl instanceof MesaSurfaceGenerator && (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeConfig.groundBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeConfig.groundBlock.getBlockData() || blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeConfig.surfaceBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeConfig.surfaceBlock.getBlockData())) {
                            customBlockData = biomeConfig.surfaceAndGroundControl.getCustomBlockData(this.World, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z);
                            if (customBlockData != null) {
                                blockToQueueForSpawn.material = customBlockData;
                            }
                            this.setBlock(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag);
                        } else if (!sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) || sourceBlockMaterial.getBlockData() != blockToQueueForSpawn.material.getBlockData()) {
                            this.setBlock(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag);
                        }
                    } else {
                        throw new RuntimeException();
                    }
                    if (bBreak) continue block9;
                }
            }
            smoothingAreaInChunk.setValue(null);
        }
        return true;
    }

    private void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag) {
        LocalMaterialData targetBlock;
        HashMap<DefaultMaterial, LocalMaterialData> blocksToReplace = this.World.getConfigs().getWorldConfig().getReplaceBlocksDict();
        if (blocksToReplace != null && blocksToReplace.size() > 0 && (targetBlock = blocksToReplace.get(material)) != null) {
            material = targetBlock;
        }
        this.World.setBlock(x, y, z, material, metaDataTag, this.IsOTGPlus);
    }

    private ArrayList<Object[]> MergeSmoothingAreas(ChunkCoordinate chunkCoordinate, ArrayList<Object[]> smoothingAreas) {
        boolean diagonalLinegoingUp;
        boolean diagonalLinegoingDown;
        LocalMaterialData material;
        int diagonalLineFinalDestinationPointZ;
        int diagonalLineFinalDestinationPointY;
        int diagonalLineFinalDestinationPointX;
        int diagonalLineOriginPointZ;
        int diagonalLineoriginPointY;
        int diagonalLineOriginPointX;
        int finalDestinationPointZ;
        int finalDestinationPointY;
        int finalDestinationPointX;
        int originPointZ;
        int originPointY;
        int originPointX;
        BlockFunction beginPoint;
        ArrayList<Object[]> blocksToSpawn = new ArrayList<Object[]>();
        BlockFunction[] blockColumn = null;
        BlockFunction[] blockColumn2 = null;
        int prevfinalDestinationPointX = 0;
        int prevfinalDestinationPointZ = 0;
        int prevDiagonalLineFinalDestinationPointX = 0;
        int prevDiagonalLineFinalDestinationPointZ = 0;
        boolean isInitialised = false;
        for (Object[] smoothingBeginAndEndPoints : smoothingAreas) {
            Object block;
            beginPoint = new BlockFunction();
            beginPoint.x = (Integer)smoothingBeginAndEndPoints[0];
            beginPoint.y = (Integer)smoothingBeginAndEndPoints[1];
            beginPoint.z = (Integer)smoothingBeginAndEndPoints[2];
            originPointX = (Integer)smoothingBeginAndEndPoints[6];
            originPointY = (Integer)smoothingBeginAndEndPoints[7];
            originPointZ = (Integer)smoothingBeginAndEndPoints[8];
            finalDestinationPointX = (Integer)smoothingBeginAndEndPoints[9];
            finalDestinationPointY = (Integer)smoothingBeginAndEndPoints[10];
            finalDestinationPointZ = (Integer)smoothingBeginAndEndPoints[11];
            diagonalLineOriginPointX = -1;
            diagonalLineoriginPointY = -1;
            diagonalLineOriginPointZ = -1;
            diagonalLineFinalDestinationPointX = -1;
            diagonalLineFinalDestinationPointY = -1;
            diagonalLineFinalDestinationPointZ = -1;
            if (smoothingBeginAndEndPoints.length > 17) {
                diagonalLineOriginPointX = (Integer)smoothingBeginAndEndPoints[12];
                diagonalLineoriginPointY = (Integer)smoothingBeginAndEndPoints[13];
                diagonalLineOriginPointZ = (Integer)smoothingBeginAndEndPoints[14];
                diagonalLineFinalDestinationPointX = (Integer)smoothingBeginAndEndPoints[15];
                diagonalLineFinalDestinationPointY = (Integer)smoothingBeginAndEndPoints[16];
                diagonalLineFinalDestinationPointZ = (Integer)smoothingBeginAndEndPoints[17];
                if (diagonalLineFinalDestinationPointY == -2) continue;
            }
            if (!isInitialised || prevfinalDestinationPointX != finalDestinationPointX || prevfinalDestinationPointZ != finalDestinationPointZ) {
                blockColumn = this.World.getBlockColumn(finalDestinationPointX, finalDestinationPointZ);
                prevfinalDestinationPointX = finalDestinationPointX;
                prevfinalDestinationPointX = finalDestinationPointZ;
            }
            if (!(smoothingBeginAndEndPoints.length <= 17 || isInitialised && prevDiagonalLineFinalDestinationPointX == diagonalLineFinalDestinationPointX && prevDiagonalLineFinalDestinationPointZ == diagonalLineFinalDestinationPointZ)) {
                blockColumn2 = this.World.getBlockColumn(diagonalLineFinalDestinationPointX, diagonalLineFinalDestinationPointZ);
                prevDiagonalLineFinalDestinationPointX = diagonalLineFinalDestinationPointX;
                prevDiagonalLineFinalDestinationPointZ = diagonalLineFinalDestinationPointZ;
            }
            isInitialised = true;
            if (originPointY == -1 && smoothingBeginAndEndPoints.length > 17) {
                if (diagonalLineFinalDestinationPointY == -1) {
                    material = null;
                    for (int i = 255; i > -1; --i) {
                        block = blockColumn2[i];
                        material = ((BlockFunction)block).material;
                        if (material.getName().toLowerCase().equals("air") || (((BlockFunction)block).y > diagonalLineoriginPointY || material.isLiquid()) && (((BlockFunction)block).y <= diagonalLineoriginPointY || ((BO3)this.Start.getObject()).getSettings().SpawnUnderWater && material.isLiquid())) continue;
                        diagonalLineFinalDestinationPointY = ((BlockFunction)block).y;
                        break;
                    }
                }
                if (diagonalLineFinalDestinationPointY == -1) {
                    diagonalLineFinalDestinationPointY = 0;
                }
                diagonalLinegoingDown = false;
                diagonalLinegoingUp = false;
                if (diagonalLineoriginPointY >= diagonalLineFinalDestinationPointY) {
                    diagonalLinegoingDown = true;
                } else if (diagonalLineoriginPointY < diagonalLineFinalDestinationPointY) {
                    diagonalLinegoingUp = true;
                }
                ArrayList<Object[]> smoothingAreasToSpawnPerLineDestination = this.SmoothingAreasToSpawnPerDiagonalLineDestination.get(ChunkCoordinate.fromChunkCoords(diagonalLineFinalDestinationPointX, diagonalLineFinalDestinationPointZ));
                if (smoothingAreasToSpawnPerLineDestination != null) {
                    for (Object[] smoothingBeginAndEndPoints2 : smoothingAreasToSpawnPerLineDestination) {
                        int diagonalLineFinalOriginPointX2 = (Integer)smoothingBeginAndEndPoints2[12];
                        int diagonalLineFinalOriginPointZ2 = (Integer)smoothingBeginAndEndPoints2[14];
                        int diagonalLineFinalDestinationPointY2 = (Integer)smoothingBeginAndEndPoints2[16];
                        if (diagonalLineOriginPointX != diagonalLineFinalOriginPointX2 || diagonalLineOriginPointZ != diagonalLineFinalOriginPointZ2 || diagonalLineFinalDestinationPointY2 == -2) continue;
                        smoothingBeginAndEndPoints2[16] = diagonalLineFinalDestinationPointY;
                    }
                }
                if ((Integer)smoothingBeginAndEndPoints[16] == -2) continue;
                smoothingBeginAndEndPoints[16] = diagonalLineFinalDestinationPointY;
            }
            if (finalDestinationPointY == -1) {
                material = null;
                for (int i = 255; i > -1; --i) {
                    block = blockColumn[i];
                    material = ((BlockFunction)block).material;
                    if (material.getName().toLowerCase().equals("air") || (((BlockFunction)block).y > (diagonalLineoriginPointY > -1 ? diagonalLineoriginPointY : originPointY) || material.isLiquid()) && (((BlockFunction)block).y <= (diagonalLineoriginPointY > -1 ? diagonalLineoriginPointY : originPointY) || ((BO3)this.Start.getObject()).getSettings().SpawnUnderWater && material.isLiquid())) continue;
                    finalDestinationPointY = ((BlockFunction)block).y;
                    smoothingBeginAndEndPoints[10] = finalDestinationPointY;
                    ArrayList<Object[]> smoothingAreasForLine = this.SmoothingAreasToSpawnPerLineOrigin.get(ChunkCoordinate.fromChunkCoords(originPointX, originPointZ));
                    if (smoothingAreasForLine == null) break;
                    for (Object[] smoothingBeginAndEndPoints2 : smoothingAreasForLine) {
                        int finalDestinationPointX2 = (Integer)smoothingBeginAndEndPoints2[9];
                        int finalDestinationPointZ2 = (Integer)smoothingBeginAndEndPoints2[11];
                        if (finalDestinationPointX != finalDestinationPointX2 || finalDestinationPointZ != finalDestinationPointZ2) continue;
                        smoothingBeginAndEndPoints2[10] = finalDestinationPointY;
                    }
                    break;
                }
            }
            if (finalDestinationPointY == -1) {
                finalDestinationPointY = 0;
            }
            if ((Integer)smoothingBeginAndEndPoints[7] != -1) continue;
            diagonalLineOriginPointX = (Integer)smoothingBeginAndEndPoints[12];
            diagonalLineoriginPointY = (Integer)smoothingBeginAndEndPoints[13];
            diagonalLineFinalDestinationPointX = (Integer)smoothingBeginAndEndPoints[15];
            diagonalLineFinalDestinationPointY = (Integer)smoothingBeginAndEndPoints[16];
            originPointY = (int)Math.round((double)Math.abs(diagonalLineoriginPointY - diagonalLineFinalDestinationPointY) * ((double)Math.abs(diagonalLineOriginPointX - originPointX) / (double)Math.abs(diagonalLineOriginPointX - diagonalLineFinalDestinationPointX)));
            originPointY = diagonalLineoriginPointY > diagonalLineFinalDestinationPointY ? diagonalLineoriginPointY - originPointY : (diagonalLineoriginPointY < diagonalLineFinalDestinationPointY ? diagonalLineoriginPointY + originPointY : diagonalLineoriginPointY);
            smoothingBeginAndEndPoints[7] = originPointY;
        }
        block5: for (Object[] smoothingBeginAndEndPoints : smoothingAreas) {
            if (smoothingBeginAndEndPoints.length > 17 && (Integer)smoothingBeginAndEndPoints[16] == -2) continue;
            diagonalLinegoingUp = false;
            diagonalLinegoingDown = false;
            boolean goingUp = false;
            boolean goingDown = false;
            int distanceFromStart = 0;
            beginPoint = new BlockFunction();
            beginPoint.x = (Integer)smoothingBeginAndEndPoints[0];
            beginPoint.y = (Integer)smoothingBeginAndEndPoints[1];
            beginPoint.z = (Integer)smoothingBeginAndEndPoints[2];
            originPointX = (Integer)smoothingBeginAndEndPoints[6];
            originPointY = (Integer)smoothingBeginAndEndPoints[7];
            originPointZ = (Integer)smoothingBeginAndEndPoints[8];
            finalDestinationPointX = (Integer)smoothingBeginAndEndPoints[9];
            finalDestinationPointY = (Integer)smoothingBeginAndEndPoints[10];
            finalDestinationPointZ = (Integer)smoothingBeginAndEndPoints[11];
            diagonalLineOriginPointX = -1;
            diagonalLineoriginPointY = -1;
            diagonalLineOriginPointZ = -1;
            diagonalLineFinalDestinationPointX = -1;
            diagonalLineFinalDestinationPointY = -1;
            diagonalLineFinalDestinationPointZ = -1;
            if (smoothingBeginAndEndPoints.length > 17) {
                diagonalLineOriginPointX = (Integer)smoothingBeginAndEndPoints[12];
                diagonalLineoriginPointY = (Integer)smoothingBeginAndEndPoints[13];
                diagonalLineOriginPointZ = (Integer)smoothingBeginAndEndPoints[14];
                diagonalLineFinalDestinationPointX = (Integer)smoothingBeginAndEndPoints[15];
                diagonalLineFinalDestinationPointY = (Integer)smoothingBeginAndEndPoints[16];
                diagonalLineFinalDestinationPointZ = (Integer)smoothingBeginAndEndPoints[17];
            }
            if (smoothingBeginAndEndPoints.length > 17) {
                if ((Integer)smoothingBeginAndEndPoints[13] >= (Integer)smoothingBeginAndEndPoints[16]) {
                    diagonalLinegoingDown = true;
                } else if ((Integer)smoothingBeginAndEndPoints[13] < (Integer)smoothingBeginAndEndPoints[16]) {
                    diagonalLinegoingUp = true;
                }
            }
            int highestBlock = -1;
            material = null;
            highestBlock = finalDestinationPointY;
            if (prevfinalDestinationPointX != finalDestinationPointX || prevfinalDestinationPointZ != finalDestinationPointZ) {
                blockColumn = this.World.getBlockColumn(finalDestinationPointX, finalDestinationPointZ);
                prevfinalDestinationPointX = finalDestinationPointX;
                prevfinalDestinationPointZ = finalDestinationPointZ;
            }
            for (int i = highestBlock; i > -1; --i) {
                BlockFunction block = blockColumn[i];
                material = block.material;
                if (material.getName().toLowerCase().equals("air") || (block.y > originPointY || material.isLiquid()) && (block.y <= originPointY || ((BO3)this.Start.getObject()).getSettings().SpawnUnderWater && material.isLiquid())) continue;
                finalDestinationPointY = block.y;
                break;
            }
            if (finalDestinationPointY > beginPoint.y) {
                goingUp = true;
            }
            if (finalDestinationPointY <= beginPoint.y) {
                goingDown = true;
            }
            if (diagonalLinegoingUp && !goingUp) {
                finalDestinationPointY = originPointY + 75 < 256 ? originPointY + 75 : 255;
                goingUp = true;
                goingDown = false;
            } else if (diagonalLinegoingDown && !goingDown) {
                goingUp = false;
                goingDown = true;
                int distanceFromOrigin = -1;
                int firstSolidBlock = -1;
                for (int i = originPointY; i > -1; --i) {
                    BlockFunction block = blockColumn[i];
                    distanceFromOrigin = Math.abs(originPointY - block.y);
                    LocalMaterialData materialAbove = blockColumn[i + 1].material;
                    material = blockColumn[block.y].material;
                    if (firstSolidBlock == -1 && !material.getName().toLowerCase().equals("air") && !material.isLiquid()) {
                        firstSolidBlock = block.y;
                    }
                    if (distanceFromOrigin <= 30 && !material.getName().toLowerCase().equals("air") && !material.isLiquid() && (materialAbove.getName().toLowerCase().equals("air") || materialAbove.isLiquid())) {
                        finalDestinationPointY = block.y;
                        break;
                    }
                    if (distanceFromOrigin <= 30 || firstSolidBlock <= -1) continue;
                    finalDestinationPointY = firstSolidBlock;
                    break;
                }
                if (distanceFromOrigin > 30 && firstSolidBlock == -1) {
                    finalDestinationPointY = originPointY;
                }
            }
            int repeats = 1;
            for (int pass2 = 0; pass2 <= repeats; ++pass2) {
                BlockFunction existingBlock;
                boolean dontAdd;
                ArrayList<Object[]> blocksToRemove;
                int originPointZ2;
                int originPointX2;
                BlockFunction filler;
                int surfaceBlockHeight;
                Iterator<Object> materialAbove;
                if (smoothingBeginAndEndPoints.length > 17 && pass2 == 1) {
                    if (diagonalLinegoingDown) {
                        diagonalLineFinalDestinationPointY = diagonalLineoriginPointY + 75 < 256 ? diagonalLineoriginPointY + 75 : 255;
                    } else if (diagonalLinegoingUp) {
                        int distanceFromOrigin = -1;
                        int firstSolidBlock = -1;
                        diagonalLineFinalDestinationPointY = diagonalLineoriginPointY;
                        if (prevDiagonalLineFinalDestinationPointX != diagonalLineFinalDestinationPointX || prevDiagonalLineFinalDestinationPointZ != diagonalLineFinalDestinationPointZ) {
                            blockColumn2 = this.World.getBlockColumn(diagonalLineFinalDestinationPointX, diagonalLineFinalDestinationPointZ);
                            prevDiagonalLineFinalDestinationPointX = diagonalLineFinalDestinationPointX;
                            prevDiagonalLineFinalDestinationPointZ = diagonalLineFinalDestinationPointZ;
                        }
                        for (int i = diagonalLineoriginPointY; i > 0; --i) {
                            BlockFunction block = blockColumn2[i];
                            distanceFromOrigin = Math.abs(diagonalLineoriginPointY - block.y);
                            materialAbove = blockColumn2[i + 1].material;
                            material = block.material;
                            if (firstSolidBlock == -1 && !material.getName().toLowerCase().equals("air") && !material.isLiquid()) {
                                firstSolidBlock = block.y;
                            }
                            if (distanceFromOrigin <= 30 && !material.getName().toLowerCase().equals("air") && !material.isLiquid() && (materialAbove.getName().toLowerCase().equals("air") || materialAbove.isLiquid())) {
                                diagonalLineFinalDestinationPointY = block.y;
                                break;
                            }
                            if (distanceFromOrigin <= 30 || firstSolidBlock <= -1) continue;
                            diagonalLineFinalDestinationPointY = firstSolidBlock;
                            break;
                        }
                    }
                    originPointY = (int)Math.ceil((double)Math.abs(diagonalLineoriginPointY - diagonalLineFinalDestinationPointY) * ((double)Math.abs(diagonalLineOriginPointX - originPointX) / (double)Math.abs(diagonalLineOriginPointX - diagonalLineFinalDestinationPointX)));
                    originPointY = diagonalLineoriginPointY > diagonalLineFinalDestinationPointY ? diagonalLineoriginPointY - originPointY : (diagonalLineoriginPointY < diagonalLineFinalDestinationPointY ? diagonalLineoriginPointY + originPointY : diagonalLineoriginPointY);
                    if (diagonalLinegoingUp) {
                        material = null;
                        for (int i = highestBlock = originPointY; i > -1; --i) {
                            BlockFunction block = blockColumn[i];
                            material = block.material;
                            if (material.getName().toLowerCase().equals("air") || (block.y > originPointY || material.isLiquid()) && (block.y <= originPointY || ((BO3)this.Start.getObject()).getSettings().SpawnUnderWater && material.isLiquid())) continue;
                            finalDestinationPointY = block.y;
                            break;
                        }
                        goingUp = false;
                        goingDown = true;
                    } else if (diagonalLinegoingDown) {
                        finalDestinationPointY = this.World.getHighestBlockYAt(finalDestinationPointX, finalDestinationPointZ, true, true, false, true);
                        if (finalDestinationPointY < diagonalLineoriginPointY) {
                            finalDestinationPointY = diagonalLineoriginPointY + 75 < 256 ? diagonalLineoriginPointY + 75 : 255;
                        }
                        goingUp = true;
                        goingDown = false;
                    }
                }
                if (pass2 == 1 && smoothingBeginAndEndPoints.length < 18) {
                    if (!goingUp) {
                        finalDestinationPointY = originPointY + 75 < 256 ? originPointY + 75 : 255;
                        goingUp = true;
                        goingDown = false;
                    } else if (goingUp) {
                        goingUp = false;
                        goingDown = true;
                        int distanceFromOrigin = -1;
                        int firstSolidBlock = -1;
                        finalDestinationPointY = originPointY;
                        for (int i = originPointY; i > -1; --i) {
                            BlockFunction block = blockColumn[i];
                            distanceFromOrigin = Math.abs(originPointY - block.y);
                            materialAbove = blockColumn[i + 1].material;
                            material = block.material;
                            if (firstSolidBlock == -1 && !material.getName().toLowerCase().equals("air") && !material.isLiquid()) {
                                firstSolidBlock = block.y;
                            }
                            if (distanceFromOrigin <= 30 && !material.getName().toLowerCase().equals("air") && !material.isLiquid() && (materialAbove.getName().toLowerCase().equals("air") || materialAbove.isLiquid())) {
                                finalDestinationPointY = block.y;
                                break;
                            }
                            if (distanceFromOrigin <= 30 || firstSolidBlock <= -1) continue;
                            finalDestinationPointY = firstSolidBlock;
                            break;
                        }
                        if (distanceFromOrigin > 30 && firstSolidBlock == -1) {
                            finalDestinationPointY = originPointY;
                        }
                    }
                    material = null;
                }
                BlockFunction endPoint = new BlockFunction();
                endPoint.x = (Integer)smoothingBeginAndEndPoints[3];
                endPoint.y = finalDestinationPointY;
                endPoint.z = (Integer)smoothingBeginAndEndPoints[5];
                if (originPointX != finalDestinationPointX && originPointZ == finalDestinationPointZ) {
                    double adjustedOriginPointY = 0.0;
                    if (smoothingBeginAndEndPoints.length > 17) {
                        double originPointY2 = (double)Math.abs(diagonalLineoriginPointY - diagonalLineFinalDestinationPointY) * ((double)Math.abs(diagonalLineOriginPointX - originPointX) / (double)Math.abs(diagonalLineOriginPointX - diagonalLineFinalDestinationPointX));
                        originPointY2 = diagonalLineoriginPointY > diagonalLineFinalDestinationPointY ? (double)diagonalLineoriginPointY - originPointY2 : (diagonalLineoriginPointY < diagonalLineFinalDestinationPointY ? (double)diagonalLineoriginPointY + originPointY2 : (double)diagonalLineoriginPointY);
                        adjustedOriginPointY = Math.abs(originPointY2 - (double)finalDestinationPointY) * ((double)Math.abs(originPointX - diagonalLineOriginPointX) / (double)Math.abs(originPointX - finalDestinationPointX));
                        adjustedOriginPointY = originPointY2 > (double)finalDestinationPointY ? originPointY2 + adjustedOriginPointY : originPointY2 - adjustedOriginPointY;
                    }
                    for (int i = 0; i <= Math.abs(beginPoint.x - endPoint.x); ++i) {
                        distanceFromStart = Math.abs(beginPoint.x - originPointX) + i;
                        if (smoothingBeginAndEndPoints.length > 17 && diagonalLineOriginPointX != originPointX) {
                            distanceFromStart = Math.abs(beginPoint.x - diagonalLineOriginPointX) + i;
                            double surfaceBlockHeight2 = Math.abs(adjustedOriginPointY - (double)finalDestinationPointY) * ((double)distanceFromStart / (double)Math.abs(diagonalLineOriginPointX - finalDestinationPointX));
                            surfaceBlockHeight = adjustedOriginPointY > (double)finalDestinationPointY ? (int)Math.round(adjustedOriginPointY - surfaceBlockHeight2) : (int)Math.round(adjustedOriginPointY + surfaceBlockHeight2);
                        } else {
                            surfaceBlockHeight = (int)Math.round((double)Math.abs(originPointY - finalDestinationPointY) * ((double)distanceFromStart / (double)Math.abs(originPointX - finalDestinationPointX)));
                            surfaceBlockHeight = originPointY > finalDestinationPointY ? originPointY - surfaceBlockHeight : originPointY + surfaceBlockHeight;
                        }
                        filler = new BlockFunction();
                        if (originPointX < finalDestinationPointX) {
                            filler.x = beginPoint.x + i;
                            filler.y = surfaceBlockHeight;
                            filler.z = beginPoint.z;
                        }
                        if (originPointX > finalDestinationPointX) {
                            filler.x = beginPoint.x - i;
                            filler.y = surfaceBlockHeight;
                            filler.z = beginPoint.z;
                        }
                        boolean abort = false;
                        for (Object[] smoothingBeginAndEndPoints2 : smoothingAreas) {
                            if (smoothingBeginAndEndPoints2.length >= 18) continue;
                            originPointX2 = (Integer)smoothingBeginAndEndPoints2[6];
                            originPointZ2 = (Integer)smoothingBeginAndEndPoints2[8];
                            if (originPointX2 != filler.x || originPointZ2 != filler.z || originPointX == originPointX2 && originPointZ == originPointZ2 || !goingUp) continue;
                            abort = true;
                            break;
                        }
                        if (abort) break;
                        blocksToRemove = new ArrayList();
                        dontAdd = false;
                        for (Object[] existingBlockItem : blocksToSpawn) {
                            existingBlock = (BlockFunction)existingBlockItem[0];
                            if (existingBlock.x != filler.x || existingBlock.z != filler.z) continue;
                            if (filler.y < existingBlock.y && goingUp && ((Boolean)existingBlockItem[1]).booleanValue()) {
                                blocksToRemove.add(existingBlockItem);
                            } else {
                                if (filler.y >= existingBlock.y && goingUp && ((Boolean)existingBlockItem[1]).booleanValue()) {
                                    dontAdd = true;
                                    break;
                                }
                                if (filler.y >= existingBlock.y || goingUp || !((Boolean)existingBlockItem[1]).booleanValue()) {
                                    if (filler.y > existingBlock.y && !goingUp && ((Boolean)existingBlockItem[1]).booleanValue()) {
                                        blocksToRemove.add(existingBlockItem);
                                    } else if (filler.y != existingBlock.y || goingUp || ((Boolean)existingBlockItem[1]).booleanValue()) {
                                        // empty if block
                                    }
                                }
                            }
                            if (filler.y < existingBlock.y && goingUp && !((Boolean)existingBlockItem[1]).booleanValue()) {
                                dontAdd = true;
                                break;
                            }
                            if (filler.y >= existingBlock.y && goingUp && !((Boolean)existingBlockItem[1]).booleanValue()) continue;
                            if (filler.y < existingBlock.y && !goingUp && !((Boolean)existingBlockItem[1]).booleanValue()) {
                                dontAdd = true;
                                break;
                            }
                            if (filler.y < existingBlock.y || goingUp || ((Boolean)existingBlockItem[1]).booleanValue()) continue;
                            blocksToRemove.add(existingBlockItem);
                        }
                        if (dontAdd) continue;
                        if (blocksToRemove.size() > 0) {
                            for (Object[] blockToRemove : blocksToRemove) {
                                blocksToSpawn.remove(blockToRemove);
                            }
                        }
                        blocksToSpawn.add(new Object[]{filler, goingUp, goingDown, pass2 == 1});
                    }
                }
                if (originPointX == finalDestinationPointX && originPointZ != finalDestinationPointZ) {
                    double adjustedOriginPointY = 0.0;
                    if (smoothingBeginAndEndPoints.length > 17) {
                        double originPointY2 = (double)Math.abs(diagonalLineoriginPointY - diagonalLineFinalDestinationPointY) * ((double)Math.abs(diagonalLineOriginPointX - originPointX) / (double)Math.abs(diagonalLineOriginPointX - diagonalLineFinalDestinationPointX));
                        originPointY2 = diagonalLineoriginPointY > diagonalLineFinalDestinationPointY ? (double)diagonalLineoriginPointY - originPointY2 : (diagonalLineoriginPointY < diagonalLineFinalDestinationPointY ? (double)diagonalLineoriginPointY + originPointY2 : (double)diagonalLineoriginPointY);
                        adjustedOriginPointY = Math.abs(originPointY2 - (double)finalDestinationPointY) * ((double)Math.abs(originPointZ - diagonalLineOriginPointZ) / (double)Math.abs(originPointZ - finalDestinationPointZ));
                        adjustedOriginPointY = originPointY2 > (double)finalDestinationPointY ? originPointY2 + adjustedOriginPointY : originPointY2 - adjustedOriginPointY;
                    }
                    for (int i = 0; i <= Math.abs(beginPoint.z - endPoint.z); ++i) {
                        distanceFromStart = Math.abs(beginPoint.z - originPointZ) + i;
                        if (smoothingBeginAndEndPoints.length > 17 && diagonalLineOriginPointZ != originPointZ) {
                            distanceFromStart = Math.abs(beginPoint.z - diagonalLineOriginPointZ) + i;
                            double surfaceBlockHeight2 = Math.abs(adjustedOriginPointY - (double)finalDestinationPointY) * ((double)distanceFromStart / (double)Math.abs(diagonalLineOriginPointZ - finalDestinationPointZ));
                            surfaceBlockHeight = adjustedOriginPointY > (double)finalDestinationPointY ? (int)Math.round(adjustedOriginPointY - surfaceBlockHeight2) : (int)Math.round(adjustedOriginPointY + surfaceBlockHeight2);
                        } else {
                            surfaceBlockHeight = (int)Math.round((double)Math.abs(originPointY - finalDestinationPointY) * ((double)distanceFromStart / (double)Math.abs(originPointZ - finalDestinationPointZ)));
                            surfaceBlockHeight = originPointY > finalDestinationPointY ? originPointY - surfaceBlockHeight : originPointY + surfaceBlockHeight;
                        }
                        filler = new BlockFunction();
                        if (originPointZ < finalDestinationPointZ) {
                            filler.x = beginPoint.x;
                            filler.y = surfaceBlockHeight;
                            filler.z = beginPoint.z + i;
                        }
                        if (originPointZ > finalDestinationPointZ) {
                            filler.x = beginPoint.x;
                            filler.y = surfaceBlockHeight;
                            filler.z = beginPoint.z - i;
                        }
                        boolean abort = false;
                        for (Object[] smoothingBeginAndEndPoints2 : smoothingAreas) {
                            if (smoothingBeginAndEndPoints2.length >= 18) continue;
                            originPointX2 = (Integer)smoothingBeginAndEndPoints2[6];
                            originPointZ2 = (Integer)smoothingBeginAndEndPoints2[8];
                            if (originPointX2 != filler.x || originPointZ2 != filler.z || originPointX == originPointX2 && originPointZ == originPointZ2 || !goingUp) continue;
                            abort = true;
                            break;
                        }
                        if (abort) break;
                        dontAdd = false;
                        blocksToRemove = new ArrayList();
                        for (Object[] existingBlockItem : blocksToSpawn) {
                            existingBlock = (BlockFunction)existingBlockItem[0];
                            if (existingBlock.x != filler.x || existingBlock.z != filler.z) continue;
                            if (filler.y < existingBlock.y && goingUp && ((Boolean)existingBlockItem[1]).booleanValue()) {
                                blocksToRemove.add(existingBlockItem);
                            } else {
                                if (filler.y >= existingBlock.y && goingUp && ((Boolean)existingBlockItem[1]).booleanValue()) {
                                    dontAdd = true;
                                    break;
                                }
                                if (filler.y >= existingBlock.y || goingUp || !((Boolean)existingBlockItem[1]).booleanValue()) {
                                    if (filler.y > existingBlock.y && !goingUp && ((Boolean)existingBlockItem[1]).booleanValue()) {
                                        blocksToRemove.add(existingBlockItem);
                                    } else if (filler.y != existingBlock.y || goingUp || ((Boolean)existingBlockItem[1]).booleanValue()) {
                                        // empty if block
                                    }
                                }
                            }
                            if (filler.y < existingBlock.y && goingUp && !((Boolean)existingBlockItem[1]).booleanValue()) {
                                dontAdd = true;
                                break;
                            }
                            if (filler.y >= existingBlock.y && goingUp && !((Boolean)existingBlockItem[1]).booleanValue()) continue;
                            if (filler.y < existingBlock.y && !goingUp && !((Boolean)existingBlockItem[1]).booleanValue()) {
                                dontAdd = true;
                                break;
                            }
                            if (filler.y < existingBlock.y || goingUp || ((Boolean)existingBlockItem[1]).booleanValue()) continue;
                            blocksToRemove.add(existingBlockItem);
                        }
                        if (dontAdd) continue;
                        if (blocksToRemove.size() > 0) {
                            for (Object[] blockToRemove : blocksToRemove) {
                                blocksToSpawn.remove(blockToRemove);
                            }
                        }
                        blocksToSpawn.add(new Object[]{filler, goingUp, goingDown, pass2 == 1});
                    }
                }
                if (originPointX != finalDestinationPointX || originPointZ != finalDestinationPointZ) continue;
                filler = new BlockFunction();
                filler.x = finalDestinationPointX;
                filler.y = finalDestinationPointY;
                filler.z = finalDestinationPointZ;
                if (!goingUp && !goingDown) {
                    goingDown = true;
                }
                boolean abort = false;
                for (Object[] smoothingBeginAndEndPoints2 : smoothingAreas) {
                    if (smoothingBeginAndEndPoints2.length >= 18) continue;
                    int originPointX22 = (Integer)smoothingBeginAndEndPoints2[6];
                    int originPointZ22 = (Integer)smoothingBeginAndEndPoints2[8];
                    if (originPointX22 != filler.x || originPointZ22 != filler.z || originPointX == originPointX22 && originPointZ == originPointZ22 || !goingUp) continue;
                    abort = true;
                    break;
                }
                if (abort) continue block5;
                dontAdd = false;
                blocksToRemove = new ArrayList<Object[]>();
                for (Object[] existingBlockItem : blocksToSpawn) {
                    existingBlock = (BlockFunction)existingBlockItem[0];
                    if (existingBlock.x != filler.x || existingBlock.z != filler.z) continue;
                    if (filler.y < existingBlock.y && goingUp && ((Boolean)existingBlockItem[1]).booleanValue()) {
                        blocksToRemove.add(existingBlockItem);
                    } else {
                        if (filler.y >= existingBlock.y && goingUp && ((Boolean)existingBlockItem[1]).booleanValue()) {
                            dontAdd = true;
                            break;
                        }
                        if (filler.y >= existingBlock.y || goingUp || !((Boolean)existingBlockItem[1]).booleanValue()) {
                            if (filler.y > existingBlock.y && !goingUp && ((Boolean)existingBlockItem[1]).booleanValue()) {
                                blocksToRemove.add(existingBlockItem);
                            } else if (filler.y != existingBlock.y || goingUp || ((Boolean)existingBlockItem[1]).booleanValue()) {
                                // empty if block
                            }
                        }
                    }
                    if (filler.y < existingBlock.y && goingUp && !((Boolean)existingBlockItem[1]).booleanValue()) {
                        dontAdd = true;
                        break;
                    }
                    if (filler.y >= existingBlock.y && goingUp && !((Boolean)existingBlockItem[1]).booleanValue()) continue;
                    if (filler.y < existingBlock.y && !goingUp && !((Boolean)existingBlockItem[1]).booleanValue()) {
                        dontAdd = true;
                        break;
                    }
                    if (filler.y < existingBlock.y || goingUp || ((Boolean)existingBlockItem[1]).booleanValue()) continue;
                    blocksToRemove.add(existingBlockItem);
                }
                if (dontAdd) continue;
                if (blocksToRemove.size() > 0) {
                    for (Object[] blockToRemove : blocksToRemove) {
                        blocksToSpawn.remove(blockToRemove);
                    }
                }
                blocksToSpawn.add(new Object[]{filler, goingUp, goingDown, pass2 == 1});
            }
        }
        return blocksToSpawn;
    }

    public CustomObjectStructure(CustomObjectCoordinate start) {
        this.IsOTGPlus = false;
        this.Start = start;
    }

    CustomObjectStructure(LocalWorld world, CustomObjectCoordinate start) {
        this.IsOTGPlus = false;
        StructuredCustomObject object = (StructuredCustomObject)start.getObject();
        this.World = world;
        this.Start = start;
        this.height = object.getStructurePartSpawnHeight();
        this.maxBranchDepth = object.getMaxBranchDepth();
        this.Random = RandomHelper.getRandomForCoords(start.getX(), start.getY(), start.getZ(), world.getSeed());
        this.objectsToSpawn = new LinkedHashMap<ChunkCoordinate, Set<CustomObjectCoordinate>>();
        this.addToSpawnList(start, object);
        this.addBranches(start, 1);
    }

    private void addBranches(CustomObjectCoordinate coordObject, int depth) {
        CustomObject object = coordObject.getObject();
        if (object != null) {
            for (Branch branch : this.getBranches(object, coordObject.getRotation())) {
                CustomObjectCoordinate childCoordObject = branch.toCustomObjectCoordinate(this.World, this.Random, coordObject.getRotation(), coordObject.getX(), coordObject.getY(), coordObject.getZ(), null);
                if (childCoordObject == null) continue;
                this.addToSpawnList(childCoordObject, object);
                if (depth >= this.maxBranchDepth) continue;
                this.addBranches(childCoordObject, depth + 1);
            }
        }
    }

    private Branch[] getBranches(CustomObject customObject, Rotation rotation) {
        return ((BO3)customObject).getBranches(rotation);
    }

    private void addToSpawnList(CustomObjectCoordinate coordObject, CustomObject parent) {
        ChunkCoordinate chunkCoordinate = coordObject.getPopulatingChunk();
        if (chunkCoordinate != null) {
            Set<CustomObjectCoordinate> objectsInChunk = this.objectsToSpawn.get(chunkCoordinate);
            if (objectsInChunk == null) {
                objectsInChunk = new LinkedHashSet<CustomObjectCoordinate>();
                this.objectsToSpawn.put(chunkCoordinate, objectsInChunk);
            }
            objectsInChunk.add(coordObject);
        } else if (OTG.getPluginConfig().SpawnLog) {
            OTG.log(LogMarker.WARN, "Error reading branch in BO3 " + parent.getName() + " Could not find BO3: " + coordObject.BO3Name, new Object[0]);
        }
    }

    public void spawnForChunk(ChunkCoordinate chunkCoordinate) {
        Set<CustomObjectCoordinate> objectsInChunk = this.objectsToSpawn.get(chunkCoordinate);
        if (objectsInChunk != null) {
            for (CustomObjectCoordinate coordObject : objectsInChunk) {
                coordObject.spawnWithChecks(this, this.World, this.height, this.Random);
            }
        }
    }

    public class BranchDataItem {
        boolean wasDeleted = false;
        boolean isBeingRolledBack = false;
        int branchNumber = -1;
        boolean MinimumSize = false;
        public CustomObjectCoordinate Branch;
        public ChunkCoordinate ChunkCoordinate;
        public BranchDataItem Parent;
        public boolean DoneSpawning = false;
        public boolean SpawnDelayed = false;
        public boolean CannotSpawn = false;
        int CurrentDepth = 0;
        int MaxDepth = 0;
        LocalWorld World;
        Random Random;
        private Stack<BranchDataItem> Children = new Stack();

        public Stack<BranchDataItem> getChildren(boolean dontSpawn) {
            if (this.World == null) {
                throw new RuntimeException();
            }
            if (!dontSpawn && this.Children.size() == 0) {
                Branch[] branches;
                for (Branch branch1 : branches = this.Branch.getStructuredObject().getBranches()) {
                    BO3 childBO3;
                    CustomObjectCoordinate childCoordObject = branch1.toCustomObjectCoordinate(this.World, this.Random, this.Branch.getRotation(), this.Branch.getX(), this.Branch.getY(), this.Branch.getZ(), this.Branch.StartBO3Name != null ? this.Branch.StartBO3Name : this.Branch.BO3Name);
                    if (childCoordObject == null || (childBO3 = (BO3)childCoordObject.getObject()) == null) continue;
                    if (childCoordObject.branchGroup != null && childCoordObject.branchGroup.trim().length() > 0 && childBO3.getSettings().canOverride && !childCoordObject.isRequiredBranch) {
                        if (!OTG.getPluginConfig().SpawnLog) continue;
                        OTG.log(LogMarker.INFO, "canOverride optional branches cannot be in a branch group, ignoring branch: " + childBO3.getName() + " in BO3: " + this.Branch.BO3Name, new Object[0]);
                        continue;
                    }
                    if (childBO3.getSettings().overrideParentHeight) {
                        if (childBO3.getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestBlock || childBO3.getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock || childBO3.getSettings().SpawnAtWaterLevel) {
                            childCoordObject.y = this.World.getHighestBlockYAt(childCoordObject.getX(), childCoordObject.getZ(), true, childBO3.getSettings().spawnHeight != BO3Settings.SpawnHeightEnum.highestSolidBlock || childBO3.getSettings().SpawnAtWaterLevel, childBO3.getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock && !childBO3.getSettings().SpawnAtWaterLevel, true);
                        } else if (childBO3.getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.randomY) {
                            childCoordObject.y = RandomHelper.numberInRange(this.Random, childBO3.getSettings().minHeight, childBO3.getSettings().maxHeight);
                        }
                    }
                    childCoordObject.y += childBO3.getSettings().heightOffset;
                    int currentDepth1 = childCoordObject.isRequiredBranch ? this.CurrentDepth : this.CurrentDepth + 1;
                    int maxDepth1 = this.MaxDepth;
                    if (childCoordObject.branchDepth > 0 && !this.MinimumSize) {
                        currentDepth1 = 0;
                        maxDepth1 = childCoordObject.branchDepth;
                    }
                    if (this.MinimumSize) {
                        maxDepth1 = 0;
                    }
                    if ((maxDepth1 <= 0 || currentDepth1 > maxDepth1) && !childCoordObject.isRequiredBranch) continue;
                    this.Children.add(new BranchDataItem(this.World, this.Random, this, childCoordObject, this.Branch.StartBO3Name != null ? this.Branch.StartBO3Name : this.Branch.BO3Name, currentDepth1, maxDepth1, this.MinimumSize));
                }
            }
            return this.Children;
        }

        public boolean getHasOptionalBranches() {
            Branch[] branches;
            for (Branch branch1 : branches = this.Branch.getStructuredObject().getBranches()) {
                boolean hasRandomBranches;
                CustomObjectCoordinate childCoordObject = branch1.toCustomObjectCoordinate(this.World, this.Random, this.Branch.getRotation(), this.Branch.getX(), this.Branch.getY(), this.Branch.getZ(), this.Branch.StartBO3Name != null ? this.Branch.StartBO3Name : this.Branch.BO3Name);
                if (childCoordObject == null) continue;
                if (!childCoordObject.isRequiredBranch && this.MaxDepth > 0) {
                    return true;
                }
                if (!childCoordObject.isRequiredBranch) continue;
                BranchDataItem parent = this.Parent;
                Boolean bInfinite = false;
                while (parent != null && parent.Branch.isRequiredBranch) {
                    if (parent.Branch.getObject().getName().equals(childCoordObject.getObject().getName())) {
                        bInfinite = true;
                        break;
                    }
                    parent = parent.Parent;
                }
                if (bInfinite.booleanValue()) continue;
                int currentDepth1 = childCoordObject.isRequiredBranch ? this.CurrentDepth : this.CurrentDepth + 1;
                int maxDepth1 = this.MaxDepth;
                if (childCoordObject.branchDepth > 0 && !this.MinimumSize) {
                    currentDepth1 = 0;
                    maxDepth1 = childCoordObject.branchDepth;
                }
                if (this.MinimumSize) {
                    maxDepth1 = 0;
                }
                if (!(hasRandomBranches = new BranchDataItem(this.World, this.Random, this, childCoordObject, this.Branch.StartBO3Name != null ? this.Branch.StartBO3Name : this.Branch.BO3Name, currentDepth1, maxDepth1, this.MinimumSize).getHasOptionalBranches())) continue;
                return true;
            }
            return false;
        }

        public BranchDataItem() {
            throw new RuntimeException();
        }

        public BranchDataItem(LocalWorld world, Random random, BranchDataItem parent, CustomObjectCoordinate branch, String startBO3Name, int currentDepth, int maxDepth, boolean minimumSize) {
            this.World = world;
            this.Random = random;
            this.Parent = parent;
            this.Branch = branch;
            this.Branch.StartBO3Name = startBO3Name;
            this.CurrentDepth = currentDepth;
            this.MaxDepth = maxDepth;
            this.MinimumSize = minimumSize;
            this.ChunkCoordinate = com.pg85.otg.util.ChunkCoordinate.fromBlockCoords(this.Branch.getX(), this.Branch.getZ());
            BranchDataItemCounter.branchDataItemCounter = BranchDataItemCounter.branchDataItemCounter + 1;
            this.branchNumber = BranchDataItemCounter.branchDataItemCounter;
        }
    }

    public static class BranchDataItemCounter {
        private static int branchDataItemCounter = -1;
    }
}

