/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.util;

import com.pg85.otg.OTG;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.NamedBinaryTag;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.server.v1_12_R1.NBTBase;
import net.minecraft.server.v1_12_R1.NBTTagByte;
import net.minecraft.server.v1_12_R1.NBTTagByteArray;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.NBTTagDouble;
import net.minecraft.server.v1_12_R1.NBTTagFloat;
import net.minecraft.server.v1_12_R1.NBTTagInt;
import net.minecraft.server.v1_12_R1.NBTTagIntArray;
import net.minecraft.server.v1_12_R1.NBTTagList;
import net.minecraft.server.v1_12_R1.NBTTagLong;
import net.minecraft.server.v1_12_R1.NBTTagShort;
import net.minecraft.server.v1_12_R1.NBTTagString;

public class NBTHelper {
    public static NamedBinaryTag getNBTFromNMSTagCompound(String name, NBTTagCompound nmsTag) {
        NamedBinaryTag compoundTag = new NamedBinaryTag(NamedBinaryTag.Type.TAG_Compound, name, new NamedBinaryTag[]{new NamedBinaryTag(NamedBinaryTag.Type.TAG_End, null, null)});
        Map nmsChildTags = null;
        try {
            Field mapField = NBTTagCompound.class.getDeclaredField("map");
            mapField.setAccessible(true);
            nmsChildTags = (Map)mapField.get(nmsTag);
        }
        catch (Exception e) {
            OTG.printStackTrace(LogMarker.FATAL, e);
        }
        if (nmsChildTags == null) {
            return compoundTag;
        }
        for (Map.Entry entry : nmsChildTags.entrySet()) {
            NBTBase nmsChildTag = (NBTBase)entry.getValue();
            NamedBinaryTag.Type type = NamedBinaryTag.Type.values()[nmsChildTag.getTypeId()];
            switch (type) {
                case TAG_End: {
                    break;
                }
                case TAG_Byte: 
                case TAG_Short: 
                case TAG_Int: 
                case TAG_Long: 
                case TAG_Float: 
                case TAG_Double: 
                case TAG_Byte_Array: 
                case TAG_String: 
                case TAG_Int_Array: {
                    compoundTag.addTag(new NamedBinaryTag(type, (String)entry.getKey(), NBTHelper.getValueFromNms(nmsChildTag)));
                    break;
                }
                case TAG_List: {
                    NamedBinaryTag listChildTag = NBTHelper.getNBTFromNMSTagList((String)entry.getKey(), (NBTTagList)nmsChildTag);
                    if (listChildTag == null) break;
                    compoundTag.addTag(listChildTag);
                    break;
                }
                case TAG_Compound: {
                    compoundTag.addTag(NBTHelper.getNBTFromNMSTagCompound((String)entry.getKey(), (NBTTagCompound)nmsChildTag));
                    break;
                }
            }
        }
        return compoundTag;
    }

    private static NamedBinaryTag getNBTFromNMSTagList(String name, NBTTagList nmsListTag) {
        if (nmsListTag.size() == 0) {
            return null;
        }
        NamedBinaryTag.Type listType = NamedBinaryTag.Type.values()[nmsListTag.g()];
        NamedBinaryTag listTag = new NamedBinaryTag(name, listType);
        block7: for (int i = 0; i < nmsListTag.size(); ++i) {
            switch (listType) {
                case TAG_Int_Array: {
                    listTag.addTag(new NamedBinaryTag(listType, null, nmsListTag.d(i)));
                    continue block7;
                }
                case TAG_Float: {
                    listTag.addTag(new NamedBinaryTag(listType, null, Float.valueOf(nmsListTag.g(i))));
                    continue block7;
                }
                case TAG_Double: {
                    listTag.addTag(new NamedBinaryTag(listType, null, nmsListTag.f(i)));
                    continue block7;
                }
                case TAG_String: {
                    listTag.addTag(new NamedBinaryTag(listType, null, nmsListTag.getString(i)));
                    continue block7;
                }
                case TAG_Compound: {
                    listTag.addTag(NBTHelper.getNBTFromNMSTagCompound(null, nmsListTag.get(i)));
                    continue block7;
                }
                default: {
                    OTG.log(LogMarker.DEBUG, "Cannot convert list subtype {} from it's NMS value", new Object[]{listType});
                }
            }
        }
        return listTag;
    }

    private static Object getValueFromNms(NBTBase nmsTag) {
        NamedBinaryTag.Type type = NamedBinaryTag.Type.values()[nmsTag.getTypeId()];
        switch (type) {
            case TAG_Byte: {
                byte theByte = ((NBTTagByte)nmsTag).g();
                return theByte;
            }
            case TAG_Short: {
                short theShort = ((NBTTagShort)nmsTag).f();
                return theShort;
            }
            case TAG_Int: {
                int theInt = ((NBTTagInt)nmsTag).e();
                return theInt;
            }
            case TAG_Long: {
                long theLong = ((NBTTagLong)nmsTag).d();
                return theLong;
            }
            case TAG_Float: {
                float theFloat = ((NBTTagFloat)nmsTag).i();
                return Float.valueOf(theFloat);
            }
            case TAG_Double: {
                double theDouble = ((NBTTagDouble)nmsTag).asDouble();
                return theDouble;
            }
            case TAG_Byte_Array: {
                byte[] theByteArray = ((NBTTagByteArray)nmsTag).c();
                return theByteArray;
            }
            case TAG_String: {
                String theString = ((NBTTagString)nmsTag).c_();
                return theString;
            }
            case TAG_Int_Array: {
                int[] theIntArray = ((NBTTagIntArray)nmsTag).d();
                return theIntArray;
            }
        }
        throw new IllegalArgumentException((Object)((Object)type) + "doesn't have a simple value!");
    }

    public static NBTTagCompound getNMSFromNBTTagCompound(NamedBinaryTag compoundTag) {
        NamedBinaryTag[] childTags;
        NBTTagCompound nmsTag = new NBTTagCompound();
        block6: for (NamedBinaryTag tag : childTags = (NamedBinaryTag[])compoundTag.getValue()) {
            switch (tag.getType()) {
                case TAG_End: {
                    continue block6;
                }
                case TAG_Byte: 
                case TAG_Short: 
                case TAG_Int: 
                case TAG_Long: 
                case TAG_Float: 
                case TAG_Double: 
                case TAG_Byte_Array: 
                case TAG_String: 
                case TAG_Int_Array: {
                    nmsTag.set(tag.getName(), NBTHelper.createTagNms(tag.getType(), tag.getValue()));
                    continue block6;
                }
                case TAG_List: {
                    nmsTag.set(tag.getName(), (NBTBase)NBTHelper.getNMSFromNBTTagList(tag));
                    continue block6;
                }
                case TAG_Compound: {
                    nmsTag.set(tag.getName(), (NBTBase)NBTHelper.getNMSFromNBTTagCompound(tag));
                    continue block6;
                }
            }
        }
        return nmsTag;
    }

    private static NBTTagList getNMSFromNBTTagList(NamedBinaryTag listTag) {
        NamedBinaryTag[] childTags;
        NBTTagList nmsTag = new NBTTagList();
        block6: for (NamedBinaryTag tag : childTags = (NamedBinaryTag[])listTag.getValue()) {
            switch (tag.getType()) {
                case TAG_End: {
                    continue block6;
                }
                case TAG_Byte: 
                case TAG_Short: 
                case TAG_Int: 
                case TAG_Long: 
                case TAG_Float: 
                case TAG_Double: 
                case TAG_Byte_Array: 
                case TAG_String: 
                case TAG_Int_Array: {
                    nmsTag.add(NBTHelper.createTagNms(tag.getType(), tag.getValue()));
                    continue block6;
                }
                case TAG_List: {
                    nmsTag.add((NBTBase)NBTHelper.getNMSFromNBTTagList(tag));
                    continue block6;
                }
                case TAG_Compound: {
                    nmsTag.add((NBTBase)NBTHelper.getNMSFromNBTTagCompound(tag));
                    continue block6;
                }
            }
        }
        return nmsTag;
    }

    private static NBTBase createTagNms(NamedBinaryTag.Type type, Object value) {
        switch (type) {
            case TAG_Byte: {
                return new NBTTagByte(((Byte)value).byteValue());
            }
            case TAG_Short: {
                return new NBTTagShort(((Short)value).shortValue());
            }
            case TAG_Int: {
                return new NBTTagInt(((Integer)value).intValue());
            }
            case TAG_Long: {
                return new NBTTagLong(((Long)value).longValue());
            }
            case TAG_Float: {
                return new NBTTagFloat(((Float)value).floatValue());
            }
            case TAG_Double: {
                return new NBTTagDouble(((Double)value).doubleValue());
            }
            case TAG_Byte_Array: {
                return new NBTTagByteArray((byte[])value);
            }
            case TAG_String: {
                return new NBTTagString((String)value);
            }
            case TAG_Int_Array: {
                return new NBTTagIntArray((int[])value);
            }
        }
        throw new IllegalArgumentException((Object)((Object)type) + "doesn't have a simple value!");
    }
}

