/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.commands.runnable;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.bukkit.commands.BaseCommand;
import com.pg85.otg.bukkit.util.WorldHelper;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.logging.LogMarker;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.World;
import org.bukkit.command.CommandSender;

public class MapWriter
implements Runnable {
    public static final int[] defaultColors = new int[]{0x3333FF, 0x999900, 0xFFCC33, 0x333300, 65280, 30464, 0x99CC66, 52428, 0, 0, 0xFFFFFF, 0x66FFFF, 0xCCCCCC, 0xCC9966, 0xFF33CC, 0xFF9999, 0xFFFF00, 0x996600, 39168, 13056, 0x666600};
    public static boolean isWorking = false;
    private World world;
    private int size;
    private CommandSender sender;
    private Angle angle;
    private int offsetX;
    private int offsetZ;
    private String label;

    public MapWriter(World _world, int _size, Angle _angle, CommandSender _sender, int _offsetX, int _offsetZ, String _label) {
        this.world = _world;
        this.size = _size;
        this.sender = _sender;
        this.angle = _angle;
        this.offsetX = _offsetX;
        this.offsetZ = _offsetZ;
        this.label = _label;
    }

    private int[] getColors(World world) {
        OTG.log(LogMarker.TRACE, "BukkitWorld::UUID:: {}", world.getDataManager().getUUID());
        LocalWorld bukkitWorld = WorldHelper.toLocalWorld(world);
        if (bukkitWorld == null) {
            OTG.log(LogMarker.ERROR, "BukkitWorld is null :: Make sure you add `{}` to bukkit.yml", world.getWorld().getName());
            return defaultColors;
        }
        LocalBiome[] biomes = bukkitWorld.getConfigs().getBiomeArray();
        int[] colors = new int[biomes.length];
        OTG.log(LogMarker.TRACE, "BukkitWorld settings biomes.length::{}", biomes.length);
        for (LocalBiome biome : biomes) {
            int color;
            if (biome == null) continue;
            BiomeConfig biomeConfig = biome.getBiomeConfig();
            colors[biome.getIds().getGenerationId()] = color = biomeConfig.biomeColor;
        }
        return colors;
    }

    @Override
    public void run() {
        if (isWorking) {
            this.sender.sendMessage(BaseCommand.ERROR_COLOR + "Another instance of map writer is running");
            return;
        }
        isWorking = true;
        int height = this.size;
        int width = this.size;
        LocalWorld localWorld = WorldHelper.toLocalWorld(this.world);
        int[] colors = this.getColors(this.world);
        this.sender.sendMessage(BaseCommand.MESSAGE_COLOR + "Generating map...");
        BiomeBase[] biomeBuffer = new BiomeBase[256];
        long time = System.currentTimeMillis();
        BufferedImage biomeImage = new BufferedImage(height * 16, width * 16, 1);
        BufferedImage temperatureImage = new BufferedImage(height * 16, width * 16, 1);
        int imageX = 0;
        int imageY = 0;
        for (int x = -height / 2; x < height / 2; ++x) {
            for (int z = -width / 2; z < width / 2; ++z) {
                long time2 = System.currentTimeMillis();
                if (time2 < time) {
                    time = time2;
                }
                if (time2 > time + 2000L) {
                    this.sender.sendMessage(BaseCommand.MESSAGE_COLOR + (x + height / 2) * 100 / height + "%");
                    time = time2;
                }
                biomeBuffer = this.world.getWorldChunkManager().getBiomeBlock(biomeBuffer, this.offsetX + x * 16, this.offsetZ + z * 16, 16, 16);
                for (int x1 = 0; x1 < 16; ++x1) {
                    for (int z1 = 0; z1 < 16; ++z1) {
                        switch (this.angle) {
                            case d0: {
                                imageX = (x + height / 2) * 16 + x1;
                                imageY = (z + width / 2) * 16 + z1;
                                break;
                            }
                            case d90: {
                                imageX = width * 16 - ((z + width / 2) * 16 + z1 + 1);
                                imageY = (x + height / 2) * 16 + x1;
                                break;
                            }
                            case d180: {
                                imageX = height * 16 - ((x + height / 2) * 16 + x1 + 1);
                                imageY = width * 16 - ((z + width / 2) * 16 + z1 + 1);
                                break;
                            }
                            case d270: {
                                imageX = (z + width / 2) * 16 + z1;
                                imageY = height * 16 - ((x + height / 2) * 16 + x1 + 1);
                            }
                        }
                        int arrayPosition = x1 + 16 * z1;
                        int biomeId = WorldHelper.getGenerationId(biomeBuffer[arrayPosition]);
                        try {
                            biomeImage.setRGB(imageX, imageY, colors[biomeId]);
                            Color temperatureColor = this.getBiomeTemperatureColor(biomeBuffer[arrayPosition], localWorld);
                            temperatureImage.setRGB(imageX, imageY, temperatureColor.getRGB());
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            OTG.log(LogMarker.TRACE, "BiomeBuff Idx::{}<{}x/{}z>, Len::{}, ID::{} | Colors Len::{}", arrayPosition, x1, z1, biomeBuffer.length, WorldHelper.getGenerationId(biomeBuffer[arrayPosition]), colors.length);
                        }
                    }
                }
            }
        }
        this.sender.sendMessage(BaseCommand.MESSAGE_COLOR + "Writing images...");
        try {
            ImageIO.write((RenderedImage)biomeImage, "png", new File(this.label + this.world.worldData.getName() + "_biome.png"));
            ImageIO.write((RenderedImage)temperatureImage, "png", new File(this.label + this.world.worldData.getName() + "_temperature.png"));
            this.sender.sendMessage(BaseCommand.MESSAGE_COLOR + "Done");
        }
        catch (IOException e) {
            this.sender.sendMessage(BaseCommand.ERROR_COLOR + "Exception while writing images: " + e.getLocalizedMessage());
            OTG.log(LogMarker.ERROR, "Failed to write image.", new Object[0]);
            OTG.printStackTrace(LogMarker.ERROR, e);
        }
        isWorking = false;
    }

    private Color getBiomeTemperatureColor(BiomeBase biome, LocalWorld world) {
        float temperature = world != null ? world.getBiomeById((int)WorldHelper.getGenerationId((BiomeBase)biome)).getBiomeConfig().biomeTemperature : biome.getTemperature();
        float cappedTemperature = Math.min(1.0f, temperature);
        return Color.getHSBColor(0.7f - cappedTemperature * 0.7f, 0.9f, temperature * 0.7f + 0.3f);
    }

    public static enum Angle {
        d0,
        d90,
        d180,
        d270;

    }
}

