/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.commands;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.bukkit.OTGPerm;
import com.pg85.otg.bukkit.OTGPlugin;
import com.pg85.otg.bukkit.commands.BaseCommand;
import com.pg85.otg.util.ChunkCoordinate;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TPCommand
extends BaseCommand {
    public TPCommand(OTGPlugin _plugin) {
        super(_plugin);
        this.name = "tp";
        this.perm = OTGPerm.CMD_TP.node;
        this.usage = "tp <biome name or id>";
        this.workOnConsole = false;
    }

    @Override
    public boolean onCommand(CommandSender sender, List<String> args) {
        Location location = this.getLocation(sender);
        int playerX = location.getBlockX();
        int playerZ = location.getBlockZ();
        LocalWorld world = this.getWorld(sender, "");
        if (world == null) {
            sender.sendMessage(ERROR_COLOR + "Plugin is not enabled for this world.");
            return true;
        }
        String biomeName = "";
        for (int i = 0; i < args.size(); ++i) {
            biomeName = biomeName + args.get(i);
        }
        if (biomeName != null && biomeName.length() > 0) {
            int biomeId = -1;
            try {
                biomeId = Integer.parseInt(biomeName.replace(" ", ""));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ChunkCoordinate playerChunk = ChunkCoordinate.fromBlockCoords(playerX, playerZ);
            Player player = (Player)sender;
            Location playerLoc = player.getLocation();
            int maxRadius = 1000;
            for (int cycle = 1; cycle < maxRadius; ++cycle) {
                for (int x1 = playerX - cycle; x1 <= playerX + cycle; ++x1) {
                    for (int z1 = playerZ - cycle; z1 <= playerZ + cycle; ++z1) {
                        ChunkCoordinate chunkCoord;
                        LocalBiome biome;
                        if (x1 != playerX - cycle && x1 != playerX + cycle || z1 != playerZ - cycle && z1 != playerZ + cycle || (biome = world.getBiome((chunkCoord = ChunkCoordinate.fromChunkCoords(playerChunk.getChunkX() + (x1 - playerX), playerChunk.getChunkZ() + (z1 - playerZ))).getBlockXCenter(), chunkCoord.getBlockZCenter())) == null || (biomeId != -1 || !biome.getName().toLowerCase().replace(" ", "").equals(biomeName.toLowerCase().replace(" ", ""))) && (biomeId == -1 || biome.getIds().getGenerationId() != biomeId)) continue;
                        Location loc = new Location(playerLoc.getWorld(), (double)chunkCoord.getBlockXCenter(), (double)world.getHighestBlockYAt(chunkCoord.getBlockXCenter(), chunkCoord.getBlockZCenter()), (double)chunkCoord.getBlockZCenter());
                        player.teleport(loc);
                        return true;
                    }
                }
            }
            sender.sendMessage(ERROR_COLOR + "Could not find biome \"" + biomeName + "\".");
        }
        return true;
    }
}

