/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.bukkit.BukkitMaterialData;
import com.pg85.otg.bukkit.util.MobSpawnGroupHelper;
import com.pg85.otg.configuration.WeightedMobSpawnGroup;
import com.pg85.otg.configuration.standard.MojangSettings;
import java.util.List;
import net.minecraft.server.v1_12_R1.BiomeBase;

public final class BukkitMojangSettings
implements MojangSettings {
    private final BiomeBase biomeBase;

    public static MojangSettings fromId(int biomeId) {
        return BukkitMojangSettings.fromBiomeBase(BiomeBase.getBiome((int)biomeId));
    }

    public static MojangSettings fromBiomeBase(BiomeBase biomeBase) {
        return new BukkitMojangSettings(biomeBase);
    }

    private BukkitMojangSettings(BiomeBase biomeBase) {
        this.biomeBase = biomeBase;
    }

    @Override
    public float getTemperature() {
        return this.biomeBase.getTemperature();
    }

    @Override
    public float getWetness() {
        return this.biomeBase.getHumidity();
    }

    @Override
    public float getSurfaceHeight() {
        return this.biomeBase.j();
    }

    @Override
    public float getSurfaceVolatility() {
        return this.biomeBase.m();
    }

    @Override
    public LocalMaterialData getSurfaceBlock() {
        return BukkitMaterialData.ofMinecraftBlockData(this.biomeBase.q);
    }

    @Override
    public LocalMaterialData getGroundBlock() {
        return BukkitMaterialData.ofMinecraftBlockData(this.biomeBase.r);
    }

    @Override
    public List<WeightedMobSpawnGroup> getMobSpawnGroup(MojangSettings.EntityCategory mobType) {
        return MobSpawnGroupHelper.getListFromMinecraftBiome(this.biomeBase, mobType);
    }
}

