/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.configuration.ConfigFunctionsManager;
import com.pg85.otg.configuration.CustomObjectConfigFunctionsManager;
import com.pg85.otg.configuration.PluginConfig;
import com.pg85.otg.configuration.io.FileSettingsReader;
import com.pg85.otg.configuration.io.FileSettingsWriter;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectManager;
import com.pg85.otg.events.EventHandler;
import com.pg85.otg.events.EventPriority;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.biome.BiomeModeManager;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.logging.Logger;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class OTGEngine {
    private BiomeModeManager biomeManagers;
    private List<EventHandler> cancelableEventHandlers = new ArrayList<EventHandler>(5);
    private ConfigFunctionsManager configFunctionsManager;
    private CustomObjectConfigFunctionsManager customObjectConfigFunctionsManager;
    private CustomObjectManager customObjectManager;
    private List<EventHandler> monitoringEventHandlers = new ArrayList<EventHandler>(5);
    private PluginConfig pluginConfig;
    private Logger logger;

    public void ReloadCustomObjectFiles() {
        this.customObjectManager.ReloadCustomObjectFiles();
    }

    public OTGEngine(Logger logger) {
        this.logger = logger;
    }

    public boolean fireCanCustomObjectSpawnEvent(CustomObject object, LocalWorld world, int x, int y, int z) {
        boolean success = true;
        for (EventHandler handler : this.cancelableEventHandlers) {
            if (handler.canCustomObjectSpawn(object, world, x, y, z, !success)) continue;
            success = false;
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.canCustomObjectSpawn(object, world, x, y, z, !success);
        }
        return success;
    }

    public void firePopulationEndEvent(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        for (EventHandler handler : this.cancelableEventHandlers) {
            handler.onPopulateEnd(world, random, villageInChunk, chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.onPopulateEnd(world, random, villageInChunk, chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        }
    }

    public void firePopulationStartEvent(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        for (EventHandler handler : this.cancelableEventHandlers) {
            handler.onPopulateStart(world, random, villageInChunk, chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.onPopulateStart(world, random, villageInChunk, chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        }
    }

    public boolean fireResourceProcessEvent(Resource resource, LocalWorld world, Random random, boolean villageInChunk, int chunkX, int chunkZ) {
        boolean success = true;
        for (EventHandler handler : this.cancelableEventHandlers) {
            if (handler.onResourceProcess(resource, world, random, villageInChunk, chunkX, chunkZ, !success)) continue;
            success = false;
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.onResourceProcess(resource, world, random, villageInChunk, chunkX, chunkZ, !success);
        }
        return success;
    }

    public BiomeModeManager getBiomeModeManager() {
        return this.biomeManagers;
    }

    public ConfigFunctionsManager getConfigFunctionsManager() {
        return this.configFunctionsManager;
    }

    public CustomObjectConfigFunctionsManager getCustomObjectConfigFunctionsManager() {
        return this.customObjectConfigFunctionsManager;
    }

    public CustomObjectManager getCustomObjectManager() {
        return this.customObjectManager;
    }

    public abstract File getGlobalObjectsDirectory();

    public Logger getLogger() {
        return this.logger;
    }

    public PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    public abstract File getTCDataFolder();

    public abstract LocalWorld getWorld(String var1);

    public abstract LocalWorld getUnloadedWorld(String var1);

    public abstract ArrayList<LocalWorld> getAllWorlds();

    public void onShutdown() {
        this.customObjectManager.shutdown();
        this.customObjectManager = null;
        this.configFunctionsManager = null;
        this.customObjectConfigFunctionsManager = null;
        this.biomeManagers = null;
        this.pluginConfig = null;
        this.cancelableEventHandlers.clear();
        this.monitoringEventHandlers.clear();
        this.cancelableEventHandlers = null;
        this.monitoringEventHandlers = null;
    }

    public void onStart() {
        File worldsDir;
        File globalBiomesDir;
        this.configFunctionsManager = new ConfigFunctionsManager();
        this.customObjectConfigFunctionsManager = new CustomObjectConfigFunctionsManager();
        this.customObjectManager = new CustomObjectManager();
        this.biomeManagers = new BiomeModeManager();
        File pluginConfigFile = new File(this.getTCDataFolder(), "OTG.ini");
        this.pluginConfig = new PluginConfig(FileSettingsReader.read("PluginConfig", pluginConfigFile));
        FileSettingsWriter.writeToFile(this.pluginConfig.getSettingsAsMap(), pluginConfigFile, this.pluginConfig.SettingsMode);
        this.logger.setLevel(this.pluginConfig.getLogLevel().getLevel());
        File globalObjectsDir = new File(this.getTCDataFolder(), "GlobalObjects");
        if (!globalObjectsDir.exists()) {
            globalObjectsDir.mkdirs();
        }
        if (!(globalBiomesDir = new File(this.getTCDataFolder(), "GlobalBiomes")).exists()) {
            globalBiomesDir.mkdirs();
        }
        if (!(worldsDir = new File(this.getTCDataFolder(), "worlds")).exists()) {
            worldsDir.mkdirs();
        }
        for (EventHandler handler : this.cancelableEventHandlers) {
            handler.onStart();
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.onStart();
        }
    }

    public void registerEventHandler(EventHandler handler) {
        this.cancelableEventHandlers.add(handler);
    }

    public void registerEventHandler(EventHandler handler, EventPriority priority) {
        if (priority == EventPriority.CANCELABLE) {
            this.cancelableEventHandlers.add(handler);
        } else {
            this.monitoringEventHandlers.add(handler);
        }
    }

    public abstract LocalMaterialData readMaterial(String var1) throws InvalidConfigException;

    public abstract LocalMaterialData toLocalMaterialData(DefaultMaterial var1, int var2);
}

