/*
 * Decompiled with CFR 0.152.
 */
package com.mmyzd.nmsot.rule;

import com.mmyzd.nmsot.IntegerRange;
import com.mmyzd.nmsot.SpawningEntry;
import com.mmyzd.nmsot.rule.Rule;
import com.mmyzd.nmsot.rule.RuleSet;
import java.util.LinkedList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import org.apache.logging.log4j.LogManager;

public class RuleLight
extends Rule {
    private int type = 0;
    private int lhs;
    private int rhs;

    public RuleLight(LinkedList<Character> s) throws Exception {
        RuleSet.nextPart(s);
        IntegerRange range = new IntegerRange(s);
        this.lhs = range.lhs;
        this.rhs = range.rhs;
        if (RuleSet.getTokenEqualsIgnoreCase(s, ",")) {
            String token = RuleSet.getToken(s).toLowerCase();
            if (token.equals("sky")) {
                this.type = 1;
            } else if (token.equals("block")) {
                this.type = 2;
            } else if (token.equals("mixed")) {
                this.type = 0;
            } else {
                LogManager.getLogger((String)"nmsot").warn("No such light type: " + token);
            }
        }
    }

    @Override
    public boolean apply(SpawningEntry entry) {
        BlockPos footPos = entry.pos.func_177984_a();
        if (this.type == 0) {
            int skyLightSub = entry.world.func_72967_a(1.0f);
            int skyLight = entry.world.func_175642_b(EnumSkyBlock.SKY, footPos) - skyLightSub;
            int blockLight = entry.world.func_175642_b(EnumSkyBlock.BLOCK, footPos);
            int mixedLight = Math.max(blockLight, skyLight);
            return this.lhs <= mixedLight && mixedLight <= this.rhs;
        }
        if (this.type == 1) {
            int skyLightSub = entry.world.func_72967_a(1.0f);
            int skyLight = entry.world.func_175642_b(EnumSkyBlock.SKY, footPos) - skyLightSub;
            return this.lhs <= skyLight && skyLight <= this.rhs;
        }
        if (this.type == 2) {
            int blockLight = entry.world.func_175642_b(EnumSkyBlock.BLOCK, footPos);
            return this.lhs <= blockLight && blockLight <= this.rhs;
        }
        return false;
    }
}

