/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Bound<T extends Number> {
    @Nonnull
    public static final Bound<Double> MAX_BOUND = Bound.of(Double.MIN_VALUE, Double.MAX_VALUE);
    @Nonnull
    public final T min;
    @Nonnull
    public final T max;

    @Nonnull
    public static <T extends Number> Bound<T> of(@Nonnull T min, @Nonnull T max) {
        return new Bound<T>(min, max);
    }

    private Bound(@Nonnull T min, @Nonnull T max) {
        this.min = min;
        this.max = max;
    }

    @Nonnull
    public T getMin() {
        return this.min;
    }

    @Nonnull
    public T getMax() {
        return this.max;
    }

    @Nonnull
    public T clamp(@Nonnull T val) {
        return ((Comparable)val).compareTo(this.min) < 0 ? this.min : (((Comparable)val).compareTo(this.max) > 0 ? this.max : val);
    }

    public boolean equals(Object o) {
        T other$max;
        T other$min;
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bound)) {
            return false;
        }
        Bound other = (Bound)o;
        T this$min = this.getMin();
        if (!this$min.equals(other$min = other.getMin())) {
            return false;
        }
        T this$max = this.getMax();
        return this$max.equals(other$max = other.getMax());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $min = this.getMin();
        result = result * 59 + $min.hashCode();
        T $max = this.getMax();
        result = result * 59 + $max.hashCode();
        return result;
    }

    public String toString() {
        return "Bound(min=" + this.getMin() + ", max=" + this.getMax() + ")";
    }

    @Nonnull
    public Bound<T> withMin(@Nonnull T newMin) {
        return this.min == newMin ? this : new Bound<T>(newMin, this.max);
    }

    @Nonnull
    public Bound<T> withMax(@Nonnull T newMax) {
        return this.max == newMax ? this : new Bound<T>(this.min, newMax);
    }
}

