/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network.mc;

import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.mc.MCNetworkState;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.NetworkSerializer;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="signals")
public class NetworkStorage
extends WorldSavedData {
    public static final String DATA_KEY = "SignalsRailNetwork";
    public static World overworld;
    private RailNetwork<MCPos> network;
    private MCNetworkState state;
    private final boolean clientSide;

    public NetworkStorage(String name) {
        this(false, name);
    }

    public NetworkStorage(boolean clientSide, String name) {
        super(name);
        this.clientSide = clientSide;
        this.network = RailNetworkManager.getInstance(clientSide).getNetwork();
        this.state = RailNetworkManager.getInstance(clientSide).getState();
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            overworld = event.getWorld();
            overworld.func_72943_a(NetworkStorage.class, DATA_KEY);
        }
    }

    public static NetworkStorage getInstance(boolean clientSide) {
        if (clientSide) {
            return new NetworkStorage(clientSide, DATA_KEY);
        }
        if (overworld != null) {
            NetworkStorage manager = (NetworkStorage)overworld.func_72943_a(NetworkStorage.class, DATA_KEY);
            if (manager == null) {
                manager = new NetworkStorage(clientSide, DATA_KEY);
                overworld.func_72823_a(DATA_KEY, (WorldSavedData)manager);
            }
            return manager;
        }
        throw new IllegalStateException("Overworld not initialized");
    }

    public void setNetwork(RailNetwork<MCPos> network) {
        this.network = network;
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound tag) {
        this.network = new NetworkSerializer().loadNetworkFromTag(tag);
        this.state = MCNetworkState.fromNBT(RailNetworkManager.getInstance(this.clientSide), tag);
        RailNetworkManager.getInstance(this.clientSide).loadNetwork(this.network, this.state);
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        new NetworkSerializer().writeToTag(this.network, tag);
        this.state.writeToNBT(tag);
        return tag;
    }
}

