/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network.mc;

import com.google.common.collect.ImmutableMap;
import com.minemaarten.signals.rail.network.INetworkObject;
import com.minemaarten.signals.rail.network.NetworkObject;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.mc.ISerializableNetworkObject;
import com.minemaarten.signals.rail.network.mc.MCNetworkRail;
import com.minemaarten.signals.rail.network.mc.MCNetworkRailLink;
import com.minemaarten.signals.rail.network.mc.MCNetworkSignal;
import com.minemaarten.signals.rail.network.mc.MCNetworkStation;
import com.minemaarten.signals.rail.network.mc.MCNetworkTeleportRail;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.NetworkRemovalMarker;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NetworkSerializer {
    private ISerializableNetworkObject asSerializable(INetworkObject<MCPos> obj) {
        if (obj instanceof ISerializableNetworkObject) {
            return (ISerializableNetworkObject)((Object)obj);
        }
        throw new IllegalStateException("Object " + obj + " of type " + obj.getClass() + " does not implement ISerializableNetworkObject!");
    }

    public void writeToTag(RailNetwork<MCPos> network, NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (INetworkObject obj : network.railObjects.getAllNetworkObjects().values()) {
            NBTTagCompound t = new NBTTagCompound();
            this.writeToTag(obj, t);
            list.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("objects", (NBTBase)list);
    }

    public RailNetwork<MCPos> loadNetworkFromTag(NBTTagCompound tag) {
        if (tag.func_74764_b("objects")) {
            ArrayList objects = new ArrayList();
            NBTTagList list = tag.func_150295_c("objects", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                objects.add(this.loadFromTag(list.func_150305_b(i)));
            }
            return new RailNetwork<MCPos>(objects);
        }
        return new RailNetwork<MCPos>(ImmutableMap.of());
    }

    private void writeToTag(INetworkObject<MCPos> obj, NBTTagCompound tag) {
        this.writeToTag(this.asSerializable(obj), tag);
    }

    private void writeToTag(ISerializableNetworkObject obj, NBTTagCompound tag) {
        tag.func_74774_a("id", (byte)obj.getType().ordinal());
        obj.writeToNBT(tag);
    }

    private NetworkObject<MCPos> loadFromTag(NBTTagCompound tag) {
        EnumNetworkObject type = EnumNetworkObject.VALUES[tag.func_74771_c("id")];
        switch (type) {
            case RAIL: {
                return MCNetworkRail.fromTag(tag);
            }
            case SIGNAL: {
                return MCNetworkSignal.fromTag(tag);
            }
            case REMOVAL_MARKER: {
                return NetworkRemovalMarker.fromTag(tag);
            }
            case RAIL_LINK: {
                return MCNetworkRailLink.fromTag(tag);
            }
            case STATION: {
                return MCNetworkStation.fromTag(tag);
            }
            case TELEPORT_RAIL: {
                return MCNetworkTeleportRail.fromTag(tag);
            }
        }
        throw new IllegalStateException("Unsupported type: " + (Object)((Object)type));
    }

    public void writeToBuf(Collection<INetworkObject<MCPos>> objects, ByteBuf b) {
        b.writeInt(objects.size());
        for (INetworkObject<MCPos> obj : objects) {
            this.writeToBuf(obj, b);
        }
    }

    public List<INetworkObject<MCPos>> readFromByteBuf(ByteBuf b) {
        int count = b.readInt();
        ArrayList<INetworkObject<MCPos>> ret = new ArrayList<INetworkObject<MCPos>>(count);
        for (int i = 0; i < count; ++i) {
            ret.add(this.loadFromBuf(b));
        }
        return ret;
    }

    private void writeToBuf(INetworkObject<MCPos> obj, ByteBuf b) {
        this.writeToBuf(this.asSerializable(obj), b);
    }

    private void writeToBuf(ISerializableNetworkObject obj, ByteBuf b) {
        b.writeByte(obj.getType().ordinal());
        obj.writeToBuf(b);
    }

    private INetworkObject<MCPos> loadFromBuf(ByteBuf b) {
        EnumNetworkObject type = EnumNetworkObject.VALUES[b.readByte()];
        switch (type) {
            case RAIL: {
                return MCNetworkRail.fromByteBuf(b);
            }
            case SIGNAL: {
                return MCNetworkSignal.fromByteBuf(b);
            }
            case REMOVAL_MARKER: {
                return NetworkRemovalMarker.fromByteBuf(b);
            }
            case RAIL_LINK: {
                return MCNetworkRailLink.fromByteBuf(b);
            }
            case STATION: {
                return MCNetworkStation.fromByteBuf(b);
            }
            case TELEPORT_RAIL: {
                return MCNetworkTeleportRail.fromByteBuf(b);
            }
        }
        throw new IllegalStateException("Unsupported type: " + (Object)((Object)type));
    }

    public static enum EnumNetworkObject {
        RAIL,
        SIGNAL,
        REMOVAL_MARKER,
        RAIL_LINK,
        STATION,
        TELEPORT_RAIL;

        public static final EnumNetworkObject[] VALUES;

        static {
            VALUES = EnumNetworkObject.values();
        }
    }
}

