/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network.mc;

import com.minemaarten.signals.lib.HeadingUtils;
import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.IPosition;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class MCPos
implements IPosition<MCPos> {
    private final BlockPos pos;
    private final int dimID;

    public MCPos(World world, BlockPos pos) {
        this(world.field_73011_w.getDimension(), pos);
    }

    public MCPos(int dimID, BlockPos pos) {
        this.dimID = dimID;
        this.pos = pos;
    }

    public MCPos(NBTTagCompound tag) {
        this.dimID = tag.func_74762_e("d");
        this.pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public MCPos(ByteBuf b) {
        this.dimID = b.readInt();
        this.pos = new BlockPos(b.readInt(), b.readInt(), b.readInt());
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("d", this.dimID);
        tag.func_74768_a("x", this.pos.func_177958_n());
        tag.func_74768_a("y", this.pos.func_177956_o());
        tag.func_74768_a("z", this.pos.func_177952_p());
    }

    public void writeToBuf(ByteBuf b) {
        b.writeInt(this.dimID);
        b.writeInt(this.pos.func_177958_n());
        b.writeInt(this.pos.func_177956_o());
        b.writeInt(this.pos.func_177952_p());
    }

    @Nullable
    public World getWorld() {
        return DimensionManager.getWorld((int)this.dimID);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getX() {
        return this.pos.func_177958_n();
    }

    public int getY() {
        return this.pos.func_177956_o();
    }

    public int getZ() {
        return this.pos.func_177952_p();
    }

    public int getDimID() {
        return this.dimID;
    }

    public TileEntity getLoadedTileEntity() {
        World world = this.getWorld();
        return world != null && world.func_175667_e(this.getPos()) ? world.func_175625_s(this.getPos()) : null;
    }

    public IBlockState getLoadedBlockState() {
        World world = this.getWorld();
        return world != null ? world.func_180495_p(this.getPos()) : null;
    }

    @Override
    public int compareTo(MCPos o) {
        int xComp = Integer.compare(this.pos.func_177958_n(), o.pos.func_177958_n());
        if (xComp != 0) {
            return xComp;
        }
        int yComp = Integer.compare(this.pos.func_177956_o(), o.pos.func_177956_o());
        if (yComp != 0) {
            return yComp;
        }
        int zComp = Integer.compare(this.pos.func_177952_p(), o.pos.func_177952_p());
        if (zComp != 0) {
            return zComp;
        }
        return Integer.compare(this.dimID, o.dimID);
    }

    @Override
    public double distanceSq(MCPos other) {
        if (this.dimID != other.dimID) {
            return 0.0;
        }
        return this.pos.func_177951_i((Vec3i)other.pos);
    }

    @Override
    public EnumHeading getRelativeHeading(MCPos from) {
        if (this.dimID != from.dimID) {
            return null;
        }
        int xDiff = this.pos.func_177958_n() - from.pos.func_177958_n();
        int zDiff = this.pos.func_177952_p() - from.pos.func_177952_p();
        if (zDiff == 0) {
            if (xDiff == 1) {
                return EnumHeading.EAST;
            }
            if (xDiff == -1) {
                return EnumHeading.WEST;
            }
        } else if (xDiff == 0) {
            if (zDiff == 1) {
                return EnumHeading.SOUTH;
            }
            if (zDiff == -1) {
                return EnumHeading.NORTH;
            }
        }
        return null;
    }

    @Override
    public MCPos offset(EnumHeading heading) {
        return this.offset(HeadingUtils.toFacing(heading));
    }

    public MCPos offset(EnumFacing facing) {
        return new MCPos(this.dimID, this.pos.func_177972_a(facing));
    }

    @Override
    public List<MCPos> allHorizontalNeighbors() {
        ArrayList<MCPos> neighbors = new ArrayList<MCPos>(4);
        for (EnumHeading heading : EnumHeading.VALUES) {
            neighbors.add(this.offset(heading));
        }
        return neighbors;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MCPos) {
            MCPos other = (MCPos)obj;
            return other.dimID == this.dimID && other.pos.equals((Object)this.pos);
        }
        return false;
    }

    public int hashCode() {
        return this.pos.hashCode() * 13 + this.dimID;
    }

    public String toString() {
        return "(" + this.pos + ", dim:" + this.dimID + ")";
    }

    @Override
    public MCPos min(MCPos other) {
        if (this.dimID != other.dimID) {
            return null;
        }
        return new MCPos(this.dimID, new BlockPos(Math.min(this.getX(), other.getX()), Math.min(this.getY(), other.getY()), Math.min(this.getZ(), other.getZ())));
    }

    @Override
    public MCPos max(MCPos other) {
        if (this.dimID != other.dimID) {
            return null;
        }
        return new MCPos(this.dimID, new BlockPos(Math.max(this.getX(), other.getX()), Math.max(this.getY(), other.getY()), Math.max(this.getZ(), other.getZ())));
    }

    @Override
    public boolean isInAABB(MCPos min, MCPos max) {
        boolean xOk = min.getX() <= this.getX() && this.getX() <= max.getX();
        boolean yOk = min.getY() <= this.getY() && this.getY() <= max.getY();
        boolean zOk = min.getZ() <= this.getZ() && this.getZ() <= max.getZ();
        return xOk && yOk && zOk;
    }

    @Override
    public boolean intersects(MCPos pos1Min, MCPos pos1Max, MCPos pos2Min, MCPos pos2Max) {
        return pos1Min.getX() <= pos2Max.getX() && pos1Max.getX() >= pos2Min.getX() && pos1Min.getY() <= pos2Max.getY() && pos1Max.getY() >= pos2Min.getY() && pos1Min.getZ() <= pos2Max.getZ() && pos1Max.getZ() >= pos2Min.getZ();
    }
}

