/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.google.common.collect.ImmutableSet;
import com.minemaarten.signals.lib.IdentityHashSet;
import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.NetworkSignal;
import com.minemaarten.signals.rail.network.NetworkState;
import com.minemaarten.signals.rail.network.PosAABB;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.RailRoute;
import com.minemaarten.signals.rail.network.RailSection;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class Train<TPos extends IPosition<TPos>> {
    private static int curID = 0;
    public final int id;
    private RailRoute<TPos> path;
    private int curIntersection;
    protected ImmutableSet<TPos> positions = ImmutableSet.of();
    protected Set<RailSection<TPos>> claimedSections = Collections.emptySet();
    private TObjectIntMap<TPos> railLinkHolds = new TObjectIntHashMap();
    private IdentityHashSet<RailSection<TPos>> curSections = new IdentityHashSet();
    private TPos lastPathfindLocation;
    private int pathfindTimeout;
    private static final int PATHFIND_TIMEOUT = 20;
    private boolean firstUpdate = true;

    public Train() {
        this(curID++);
    }

    public Train(int id) {
        this.id = id;
    }

    public boolean shouldPathfind(TPos pos) {
        if (!pos.equals(this.lastPathfindLocation) || this.pathfindTimeout-- <= 0) {
            this.lastPathfindLocation = pos;
            this.pathfindTimeout = 20;
            return true;
        }
        return false;
    }

    public abstract RailRoute<TPos> pathfind(TPos var1, EnumHeading var2);

    protected abstract void updateIntersection(RailRoute.RailRouteNode<TPos> var1);

    public final ImmutableSet<TPos> getPositions() {
        return this.positions;
    }

    public boolean isInAABB(PosAABB<TPos> aabb) {
        return this.isInAABB(aabb, false);
    }

    public boolean isInAABB(PosAABB<TPos> aabb, boolean includeRailLinkHolds) {
        for (IPosition pos2 : this.getPositions()) {
            if (!aabb.isInAABB(pos2)) continue;
            return true;
        }
        if (includeRailLinkHolds) {
            return this.getRailLinkHolds().stream().anyMatch(pos -> aabb.isInAABB((IPosition)pos));
        }
        return false;
    }

    public final Set<TPos> getRailLinkHolds() {
        return this.railLinkHolds.keySet();
    }

    public final boolean setPositions(RailNetwork<TPos> network, NetworkState<TPos> state, ImmutableSet<TPos> positions) {
        if (!this.positions.equals(positions) || this.firstUpdate) {
            this.firstUpdate = false;
            this.positions = positions;
            this.updateIntersections();
            this.updateClaimedSections(network);
            this.onPositionChanged(network, state);
            return true;
        }
        return false;
    }

    public void addRailLinkHold(TPos pos, int timeout) {
        this.railLinkHolds.put(pos, timeout);
    }

    public void invalidate(NetworkState<TPos> state) {
        state.updateTrainAtSections(this, this.curSections.keySet(), Collections.emptyList());
    }

    public boolean updatePositions(NetworkState<TPos> state) {
        if (!this.railLinkHolds.isEmpty()) {
            TObjectIntIterator iterator = this.railLinkHolds.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                if (iterator.value() == 1) {
                    iterator.remove();
                    continue;
                }
                iterator.setValue(iterator.value() - 1);
            }
        }
        return false;
    }

    protected void onPositionChanged(RailNetwork<TPos> network, NetworkState<TPos> state) {
        if (network == null || state == null) {
            return;
        }
        if (this.curSections.size() == 1 && this.positions.size() == 1) {
            IPosition position = (IPosition)this.positions.iterator().next();
            RailSection section = (RailSection)this.curSections.keySet().iterator().next();
            if (section.containsRail(position)) {
                return;
            }
        }
        IdentityHashSet<RailSection<IPosition>> newSections = new IdentityHashSet<RailSection<IPosition>>();
        for (IPosition pos : this.positions) {
            RailSection<IPosition> section = network.findSection(pos);
            if (section == null) continue;
            newSections.add(section);
        }
        state.updateTrainAtSections(this, this.curSections.keySet(), newSections.keySet());
        this.curSections = newSections;
    }

    protected void updateIntersections() {
        if (this.path != null && this.curIntersection < this.path.routeNodes.size() && !this.positions.isEmpty()) {
            RailRoute.RailRouteNode curNode = (RailRoute.RailRouteNode)this.path.routeNodes.get(this.curIntersection);
            double minDistSq = this.positions.stream().mapToDouble(((IPosition)curNode.pos)::distanceSq).min().getAsDouble();
            if (minDistSq < 4.0) {
                this.updateIntersection(curNode);
                ++this.curIntersection;
            }
        }
    }

    protected void updateClaimedSections(RailNetwork<TPos> network) {
        if (!this.claimedSections.isEmpty()) {
            Set curSections = this.positions.stream().map(network::findSection).collect(Collectors.toSet());
            this.claimedSections.removeAll(curSections);
        }
    }

    public RailRoute<TPos> getCurRoute() {
        return this.path;
    }

    public boolean tryUpdatePath(RailNetwork<TPos> network, NetworkState<TPos> state, RailRoute<TPos> path) {
        if (this.trySetClaims(network, state, path)) {
            this.setPath(path);
            return true;
        }
        this.setPath(null);
        return false;
    }

    public void setPath(RailRoute<TPos> path) {
        this.path = path;
        this.curIntersection = 0;
        if (path == null) {
            this.clearClaims();
        }
    }

    public void clearClaims() {
        this.claimedSections = Collections.emptySet();
    }

    protected boolean trySetClaims(RailNetwork<TPos> network, NetworkState<TPos> state, RailRoute<TPos> path) {
        if (path != null) {
            this.claimedSections = new HashSet<RailSection<TPos>>();
            for (NetworkSignal signal : path.routeSignals) {
                RailSection<TPos> section = signal.getNextRailSection(network);
                if (section != null) {
                    Train<TPos> claimingTrain = state.getClaimingTrain(section);
                    if (claimingTrain == null || claimingTrain.equals(this)) {
                        this.claimedSections.add(section);
                    } else {
                        this.claimedSections = Collections.emptySet();
                        return false;
                    }
                }
                if (signal.type != NetworkSignal.EnumSignalType.BLOCK) continue;
                break;
            }
        } else {
            this.claimedSections = Collections.emptySet();
        }
        return true;
    }

    public Set<RailSection<TPos>> getClaimedSections() {
        return this.claimedSections;
    }

    protected boolean isActive() {
        return true;
    }
}

