/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimaps;
import com.google.common.reflect.TypeToken;
import com.minemaarten.signals.lib.StreamUtils;
import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.INetworkObject;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.IRailLink;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.NetworkSignal;
import com.minemaarten.signals.rail.network.NetworkStation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RailObjectHolder<TPos extends IPosition<TPos>>
implements Iterable<INetworkObject<TPos>> {
    private final ImmutableMap<TPos, INetworkObject<TPos>> allNetworkObjects;
    private ImmutableListMultimap<TPos, IRailLink<TPos>> destinationsToRailLinks;
    private final Map<Class<? extends INetworkObject<TPos>>, ImmutableList<? extends INetworkObject<TPos>>> objectTypeCache = new HashMap<Class<? extends INetworkObject<TPos>>, ImmutableList<? extends INetworkObject<TPos>>>();

    public RailObjectHolder(Collection<INetworkObject<TPos>> allINetworkObjects) {
        this(allINetworkObjects.stream());
    }

    public RailObjectHolder(Stream<INetworkObject<TPos>> allINetworkObjects) {
        this((ImmutableMap)allINetworkObjects.collect(ImmutableMap.toImmutableMap(n -> (IPosition)n.getPos(), (Function)Functions.identity())));
    }

    public RailObjectHolder(ImmutableMap<TPos, INetworkObject<TPos>> allINetworkObjects) {
        this.allNetworkObjects = allINetworkObjects;
    }

    public ImmutableMap<TPos, INetworkObject<TPos>> getAllNetworkObjects() {
        return this.allNetworkObjects;
    }

    public RailObjectHolder<TPos> filterInvalidSignals() {
        HashSet toRemove = new HashSet();
        this.getSignals().forEach(signal -> {
            INetworkObject railObj = this.get(signal.getRailPos());
            if (railObj instanceof NetworkRail) {
                NetworkRail rail = (NetworkRail)railObj;
                List neighbors = rail.getSectionNeighborRails(this).collect(Collectors.toList());
                if (neighbors.size() > 2) {
                    toRemove.add(signal.getPos());
                } else {
                    EnumHeading signalHeading = signal.heading;
                    if (neighbors.stream().map(n -> ((IPosition)n.getPos()).getRelativeHeading(rail.getPos())).anyMatch(h -> h != signalHeading && h != signalHeading.getOpposite())) {
                        toRemove.add(signal.getPos());
                    }
                }
            } else {
                toRemove.add(signal.getPos());
            }
        });
        if (toRemove.isEmpty()) {
            return this;
        }
        return new RailObjectHolder<TPos>(this.allNetworkObjects.values().stream().filter(o -> !toRemove.contains(o.getPos())));
    }

    public RailObjectHolder<TPos> subSelectionForPos(Collection<TPos> rails) {
        return this.subSelection(this.getNeighborRails(rails).collect(Collectors.toList()));
    }

    public RailObjectHolder<TPos> subSelection(Collection<NetworkRail<TPos>> rails) {
        HashSet selection = new HashSet(rails);
        for (NetworkRail rail : rails) {
            rail.getPotentialNeighborObjectLocations().stream().map(n -> this.get(n)).filter(n -> n != null).forEach(n -> {
                if (!(n instanceof NetworkRail || n instanceof NetworkSignal && !((NetworkSignal)n).getRailPos().equals(rail.getPos()))) {
                    selection.add((INetworkObject)n);
                }
            });
        }
        return new RailObjectHolder<TPos>(selection);
    }

    public RailObjectHolder<TPos> combine(RailObjectHolder<TPos> other) {
        HashMap<TPos, INetworkObject<TPos>> map = new HashMap<TPos, INetworkObject<TPos>>(this.allNetworkObjects.size() + other.allNetworkObjects.size());
        map.putAll((Map<TPos, INetworkObject<TPos>>)this.allNetworkObjects);
        map.putAll((Map<TPos, INetworkObject<TPos>>)other.allNetworkObjects);
        return new RailObjectHolder<TPos>(ImmutableMap.copyOf(map));
    }

    public INetworkObject<TPos> get(TPos pos) {
        return (INetworkObject)this.allNetworkObjects.get(pos);
    }

    private Collection<IRailLink<TPos>> findRailLinksConnectingTo(TPos pos) {
        if (this.destinationsToRailLinks == null) {
            this.destinationsToRailLinks = Multimaps.index(this.getRailLinks().iterator(), IRailLink::getDestinationPos);
        }
        return this.destinationsToRailLinks.get(pos);
    }

    public Stream<NetworkRail<TPos>> findRailsLinkingTo(TPos pos) {
        return this.findRailLinksConnectingTo(pos).stream().flatMap(l -> l.getNeighborRails(this)).distinct();
    }

    public NetworkRail<TPos> getRail(TPos pos) {
        INetworkObject<TPos> obj = this.get(pos);
        return obj instanceof NetworkRail ? (NetworkRail)obj : null;
    }

    public int getNeighborRailCount(Collection<TPos> potentialNeighbors) {
        int count = 0;
        for (IPosition neighbor : potentialNeighbors) {
            if (!(this.allNetworkObjects.get((Object)neighbor) instanceof NetworkRail)) continue;
            ++count;
        }
        return count;
    }

    public <T extends INetworkObject<TPos>> Stream<T> networkObjectsOfType(Class<T> clazz) {
        return StreamUtils.ofType(clazz, this.allNetworkObjects.values().stream());
    }

    public <T extends INetworkObject<TPos>> ImmutableList<T> networkObjectsOfType(TypeToken<T> token) {
        Class<?> type = StreamUtils.getRawType(token);
        ImmutableList list = this.objectTypeCache.get(type);
        if (list == null) {
            list = (ImmutableList)StreamUtils.ofType(token, this.allNetworkObjects.values().stream()).collect(ImmutableList.toImmutableList());
            this.objectTypeCache.put(type, list);
        }
        return list;
    }

    public List<NetworkRail<TPos>> getRails() {
        return this.networkObjectsOfType(new TypeToken<NetworkRail<TPos>>(){});
    }

    public Stream<NetworkRail<TPos>> getNeighborRails(Collection<TPos> potentialNeighbors) {
        return StreamUtils.ofType(new TypeToken<NetworkRail<TPos>>(){}, potentialNeighbors.stream().map(n -> (INetworkObject)this.allNetworkObjects.get(n)));
    }

    public List<NetworkSignal<TPos>> getSignals() {
        return this.networkObjectsOfType(new TypeToken<NetworkSignal<TPos>>(){});
    }

    public Stream<NetworkSignal<TPos>> getNeighborSignals(Collection<TPos> potentialNeighbors) {
        return StreamUtils.ofType(new TypeToken<NetworkSignal<TPos>>(){}, potentialNeighbors.stream().map(n -> (INetworkObject)this.allNetworkObjects.get(n)));
    }

    public List<IRailLink<TPos>> getRailLinks() {
        return this.networkObjectsOfType(new TypeToken<IRailLink<TPos>>(){});
    }

    public Stream<IRailLink<TPos>> getNeighborRailLinks(Collection<TPos> potentialNeighbors) {
        return StreamUtils.ofType(new TypeToken<IRailLink<TPos>>(){}, potentialNeighbors.stream().map(n -> (INetworkObject)this.allNetworkObjects.get(n)));
    }

    public List<NetworkStation<TPos>> getStations() {
        return this.networkObjectsOfType(new TypeToken<NetworkStation<TPos>>(){});
    }

    public boolean equals(Object other) {
        if (other instanceof RailObjectHolder) {
            return ((RailObjectHolder)other).allNetworkObjects.equals(this.allNetworkObjects);
        }
        return false;
    }

    public int hashCode() {
        return this.allNetworkObjects.hashCode();
    }

    @Override
    public Iterator<INetworkObject<TPos>> iterator() {
        return this.allNetworkObjects.values().iterator();
    }
}

