/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.minemaarten.signals.rail.network.INetworkObject;
import com.minemaarten.signals.rail.network.INetworkObjectProvider;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.IRemovalMarker;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.RailNetworkClient;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class NetworkUpdater<TPos extends IPosition<TPos>> {
    private static final int MAX_UPDATES_PER_TICK = 500;
    private final INetworkObjectProvider<TPos> objectProvider;
    private final Set<TPos> dirtyPositions = new HashSet<TPos>();
    private boolean wasVeryBusy;
    private boolean isVeryBusy;
    private Map<TPos, INetworkObject<TPos>> changedObjects = new HashMap<TPos, INetworkObject<TPos>>();
    private Set<TPos> allPositions = new HashSet<TPos>();

    public NetworkUpdater(INetworkObjectProvider<TPos> objectProvider) {
        this.objectProvider = objectProvider;
    }

    public void markDirty(TPos pos) {
        this.dirtyPositions.add(pos);
    }

    public boolean didJustTurnBusy() {
        if (!this.wasVeryBusy && this.isVeryBusy) {
            this.wasVeryBusy = true;
            return true;
        }
        return false;
    }

    public boolean didJustTurnIdle() {
        if (this.wasVeryBusy && !this.isVeryBusy) {
            this.wasVeryBusy = false;
            return true;
        }
        return false;
    }

    public Collection<INetworkObject<TPos>> getNetworkUpdates(RailNetwork<TPos> network) {
        IPosition curPos;
        if (this.dirtyPositions.isEmpty()) {
            return Collections.emptyList();
        }
        this.changedObjects.clear();
        ImmutableSet curAllPositions = network.unfilteredRailObjects.getAllNetworkObjects().keySet();
        if (this.allPositions.hashCode() != curAllPositions.hashCode() || !this.allPositions.equals(curAllPositions)) {
            this.allPositions.clear();
            this.allPositions.addAll((Collection<TPos>)curAllPositions);
        }
        for (IPosition dirtyPos : this.dirtyPositions) {
            if (!this.allPositions.remove(dirtyPos)) continue;
            this.changedObjects.put(dirtyPos, this.objectProvider.provideRemovalMarker(dirtyPos));
        }
        Stack<IPosition> toEvaluate = new Stack<IPosition>();
        HashSet<IPosition> lazyRails = new HashSet<IPosition>();
        this.dirtyPositions.forEach(pos -> toEvaluate.push((IPosition)pos));
        int updates = 0;
        while (!toEvaluate.isEmpty()) {
            curPos = (IPosition)toEvaluate.pop();
            if (this.allPositions.contains(curPos) || lazyRails.contains(curPos)) continue;
            INetworkObject<IPosition> networkObject = this.objectProvider.provide(curPos);
            if (networkObject != null) {
                Object rail;
                if (networkObject instanceof NetworkRail && !this.isNextToNetwork((NetworkRail<TPos>)(rail = (NetworkRail)networkObject), network, this.changedObjects.keySet())) {
                    lazyRails.add(curPos);
                    continue;
                }
                this.allPositions.add(curPos);
                rail = networkObject.getNetworkNeighbors().iterator();
                while (rail.hasNext()) {
                    IPosition neighborPos = (IPosition)rail.next();
                    toEvaluate.push(neighborPos);
                    lazyRails.remove(neighborPos);
                }
                INetworkObject<IPosition> prevObj = network.railObjects.get(curPos);
                if (!networkObject.equals(prevObj)) {
                    this.changedObjects.put(curPos, networkObject);
                    ++updates;
                } else {
                    this.changedObjects.remove(curPos);
                }
            }
            if (updates < 500) continue;
            break;
        }
        this.dirtyPositions.clear();
        while (!toEvaluate.isEmpty()) {
            curPos = (IPosition)toEvaluate.pop();
            this.dirtyPositions.add(curPos);
        }
        if (this.dirtyPositions.isEmpty()) {
            this.isVeryBusy = false;
        } else if (this.dirtyPositions.size() > 10000) {
            this.isVeryBusy = true;
        }
        return this.changedObjects.values();
    }

    private boolean isNextToNetwork(NetworkRail<TPos> rail, RailNetwork<TPos> network, Set<TPos> changedPositions) {
        for (IPosition neighbor : rail.getPotentialNeighborRailLocations()) {
            if (network.unfilteredRailObjects.get(neighbor) == null && !changedPositions.contains(neighbor)) continue;
            return true;
        }
        return false;
    }

    public RailNetwork<TPos> applyUpdates(RailNetwork<TPos> network, Collection<INetworkObject<TPos>> changedObjects) {
        if (changedObjects.isEmpty()) {
            return network;
        }
        HashMap allObjects = new HashMap(network.unfilteredRailObjects.getAllNetworkObjects());
        for (INetworkObject<TPos> changedObject : changedObjects) {
            if (changedObject instanceof IRemovalMarker) {
                allObjects.remove(changedObject.getPos());
                continue;
            }
            allObjects.put(changedObject.getPos(), changedObject);
        }
        if (network instanceof RailNetworkClient) {
            return new RailNetworkClient(ImmutableMap.copyOf(allObjects));
        }
        return new RailNetwork(ImmutableMap.copyOf(allObjects));
    }
}

