/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.google.common.collect.Streams;
import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.NetworkObject;
import com.minemaarten.signals.rail.network.RailObjectHolder;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class NetworkRail<TPos extends IPosition<TPos>>
extends NetworkObject<TPos> {
    public NetworkRail(TPos pos) {
        super(pos);
    }

    @Nonnull
    public abstract Object getRailType();

    @Override
    public List<TPos> getNetworkNeighbors() {
        return this.getPotentialNeighborRailLocations();
    }

    public abstract List<TPos> getPotentialNeighborRailLocations();

    public abstract EnumSet<EnumHeading> getPotentialNeighborRailHeadings();

    public abstract List<TPos> getPotentialNeighborObjectLocations();

    public abstract EnumSet<EnumHeading> getPathfindHeading(@Nullable EnumHeading var1);

    public abstract Collection<TPos> getPotentialNeighborRailLocations(EnumHeading var1);

    public Stream<NetworkRail<TPos>> getRailLinkConnectedRails(RailObjectHolder<TPos> railObjects) {
        Stream<NetworkRail> linkedToNeighbors = railObjects.getNeighborRailLinks(this.getPotentialNeighborObjectLocations()).filter(l -> l.getDestinationPos() != null && l.canRailConnect((IPosition)this.getPos())).map(l -> railObjects.get((IPosition)l.getDestinationPos())).filter(r -> r instanceof NetworkRail).map(r -> (NetworkRail)r);
        return Streams.concat((Stream[])new Stream[]{linkedToNeighbors, railObjects.findRailsLinkingTo((IPosition)this.getPos())});
    }

    public Stream<NetworkRail<TPos>> getSectionNeighborRails(RailObjectHolder<TPos> railObjects) {
        Stream<NetworkRail<TPos>> normalNeighbors = railObjects.getNeighborRails(this.getPotentialNeighborRailLocations());
        return Streams.concat((Stream[])new Stream[]{normalNeighbors, this.getRailLinkConnectedRails(railObjects)});
    }

    public EnumSet<EnumHeading> getActualNeighborRailHeadings(RailObjectHolder<TPos> railObjects) {
        EnumSet<EnumHeading> headings = EnumSet.noneOf(EnumHeading.class);
        block0: for (EnumHeading heading : this.getPotentialNeighborRailHeadings()) {
            for (IPosition neighborPos : this.getPotentialNeighborRailLocations(heading)) {
                if (!(railObjects.get(neighborPos) instanceof NetworkRail)) continue;
                headings.add(heading);
                continue block0;
            }
        }
        return headings;
    }

    @Override
    public int getColor() {
        return -10066330;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof NetworkRail && ((NetworkRail)obj).getRailType().equals(this.getRailType());
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.getRailType().hashCode();
    }
}

