/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.network;

import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketUpdateTextfieldEntity
extends AbstractPacket<PacketUpdateTextfieldEntity> {
    private int textFieldID;
    private int entityId;
    private String text;

    public PacketUpdateTextfieldEntity() {
    }

    public PacketUpdateTextfieldEntity(EntityMinecart cart, int textfieldID) {
        this.textFieldID = textfieldID;
        this.entityId = cart.func_145782_y();
        this.text = ((CapabilityMinecartDestination)cart.getCapability(CapabilityMinecartDestination.INSTANCE, null)).getText(textfieldID);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.textFieldID);
        buffer.writeInt(this.entityId);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.text);
    }

    public void fromBytes(ByteBuf buffer) {
        this.textFieldID = buffer.readInt();
        this.entityId = buffer.readInt();
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        Entity entity = player.field_70170_p.func_73045_a(this.entityId);
        if (entity instanceof EntityMinecart) {
            ((CapabilityMinecartDestination)entity.getCapability(CapabilityMinecartDestination.INSTANCE, null)).setText(this.textFieldID, this.text);
        }
    }
}

