/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.network;

import com.minemaarten.signals.api.access.ISignal;
import com.minemaarten.signals.network.AbstractPacket;
import com.minemaarten.signals.rail.NetworkController;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class PacketUpdateSignals
extends AbstractPacket<PacketUpdateSignals> {
    private Map<MCPos, ISignal.EnumLampStatus> changedSignals;

    public PacketUpdateSignals() {
    }

    public PacketUpdateSignals(Map<MCPos, ISignal.EnumLampStatus> changedSignals) {
        this.changedSignals = changedSignals;
    }

    public void toBytes(ByteBuf b) {
        b.writeInt(this.changedSignals.size());
        for (Map.Entry<MCPos, ISignal.EnumLampStatus> entry : this.changedSignals.entrySet()) {
            entry.getKey().writeToBuf(b);
            b.writeByte(entry.getValue().ordinal());
        }
    }

    public void fromBytes(ByteBuf b) {
        int size = b.readInt();
        this.changedSignals = new HashMap<MCPos, ISignal.EnumLampStatus>(size);
        for (int i = 0; i < size; ++i) {
            MCPos pos = new MCPos(b);
            ISignal.EnumLampStatus lampStatus = ISignal.EnumLampStatus.VALUES[b.readByte()];
            this.changedSignals.put(pos, lampStatus);
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        RailNetworkManager.getClientInstance().getState().setSignalStatusses(this.changedSignals);
        for (Map.Entry<MCPos, ISignal.EnumLampStatus> entry : this.changedSignals.entrySet()) {
            NetworkController.getInstance(entry.getKey().getDimID()).updateColor(entry.getValue().color, entry.getKey().getPos());
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

