/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.event;

import com.minemaarten.signals.Signals;
import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.chunkloading.ChunkLoadManager;
import com.minemaarten.signals.config.SignalsConfig;
import com.minemaarten.signals.init.ModItems;
import com.minemaarten.signals.item.ItemTicket;
import com.minemaarten.signals.proxy.CommonProxy;
import com.minemaarten.signals.rail.RailManager;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandler
implements IWorldEventListener {
    @SubscribeEvent
    public void onCapabilityAttachmentEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityMinecart) {
            event.addCapability(new ResourceLocation("signals", "minecartDestinationCapability"), (ICapabilityProvider)new CapabilityMinecartDestination.Provider());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCapabilityAttachmentTile(AttachCapabilitiesEvent<TileEntity> event) {
        RailManager.getInstance().onTileEntityCapabilityAttachEvent(event);
    }

    @SubscribeEvent
    public void onCapabilityAttachmentStack(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() == ModItems.TICKET) {
            event.addCapability(new ResourceLocation("signals", "ticketDestinationCapability"), (ICapabilityProvider)new CapabilityMinecartDestination.Provider());
        }
    }

    @SubscribeEvent
    public void onMinecartInteraction(MinecartInteractEvent event) {
        CapabilityMinecartDestination cap;
        ItemStack heldItem;
        if (!event.getMinecart().field_70170_p.field_72995_K && !(heldItem = event.getPlayer().func_184614_ca()).func_190926_b() && (cap = (CapabilityMinecartDestination)event.getMinecart().getCapability(CapabilityMinecartDestination.INSTANCE, null)) != null) {
            if (heldItem.func_77973_b() == ModItems.CART_ENGINE && !cap.isMotorized()) {
                if (SignalsConfig.CartBlacklists.isBlacklisted(event.getMinecart(), SignalsConfig.cartBlacklists.cartEngines)) {
                    event.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.cart_engine_blacklisted", new Object[0]));
                } else {
                    if (!event.getPlayer().func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    cap.setMotorized();
                    event.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.cart_engine_installed", new Object[0]));
                    event.setCanceled(true);
                }
            } else if (heldItem.func_77973_b() == ModItems.CHUNKLOADER_UPGRADE && !cap.isChunkLoading()) {
                if (cap.setChunkloading(event.getPlayer(), event.getMinecart())) {
                    if (!event.getPlayer().func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    event.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.chunkloader_installed", new Object[0]));
                } else {
                    event.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.chunkloader_install_failed", new Object[0]));
                }
                event.setCanceled(true);
            } else if (heldItem.func_77973_b() == ModItems.RAIL_CONFIGURATOR) {
                event.getPlayer().openGui((Object)Signals.instance, CommonProxy.EnumGuiId.MINECART_DESTINATION.ordinal(), ((EntityPlayerMP)event.getPlayer()).field_70170_p, event.getMinecart().func_145782_y(), -1, cap.isMotorized() ? 1 : 0);
                event.setCanceled(true);
            } else if (heldItem.func_77973_b() == ModItems.TICKET) {
                if (event.getPlayer().func_70093_af()) {
                    ItemTicket.setDestinations(heldItem, Arrays.asList(cap.getDestinations()));
                    event.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.destinations_saved", new Object[]{TextFormatting.GOLD + ItemTicket.getConcattedDestinations(heldItem) + TextFormatting.WHITE}));
                } else {
                    ItemTicket.applyDestinations(event.getMinecart(), heldItem);
                    event.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.destinations_set", new Object[]{TextFormatting.GOLD + ItemTicket.getConcattedDestinations(heldItem) + TextFormatting.WHITE}));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onMinecartUpdate(MinecartUpdateEvent event) {
        EntityMinecart cart = event.getMinecart();
        CapabilityMinecartDestination cap = (CapabilityMinecartDestination)cart.getCapability(CapabilityMinecartDestination.INSTANCE, null);
        if (cap != null) {
            cap.onCartUpdate(event);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDimensionChange(EntityTravelToDimensionEvent event) {
        CapabilityMinecartDestination cap = (CapabilityMinecartDestination)event.getEntity().getCapability(CapabilityMinecartDestination.INSTANCE, null);
        if (cap != null) {
            cap.travelingBetweenDimensions = !event.isCanceled();
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayer) {
            RailNetworkManager.getInstance(event.getWorld().field_72995_K).onPlayerJoin((EntityPlayerMP)event.getEntity());
        }
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityMinecart) {
            RailNetworkManager.getInstance(event.getWorld().field_72995_K).onMinecartJoinedWorld((EntityMinecart)event.getEntity());
            CapabilityMinecartDestination cap = (CapabilityMinecartDestination)event.getEntity().getCapability(CapabilityMinecartDestination.INSTANCE, null);
            if (cap != null) {
                cap.onCartJoinWorld((EntityMinecart)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            RailNetworkManager.getInstance(event.getWorld().field_72995_K).onChunkUnload(event.getChunk());
        }
    }

    @SubscribeEvent
    public void onNeighborChange(BlockEvent.NeighborNotifyEvent event) {
        if (!event.getWorld().field_72995_K) {
            RailNetworkManager.getInstance(event.getWorld().field_72995_K).markDirty(new MCPos(event.getWorld(), event.getPos()));
        }
    }

    @SubscribeEvent
    public void onPreServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            RailNetworkManager.getServerInstance().onPreServerTick();
        }
    }

    @SubscribeEvent
    public void onPostServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            RailNetworkManager.getServerInstance().onPostServerTick();
            ChunkLoadManager.INSTANCE.update();
        }
    }

    @SubscribeEvent
    public void onPreClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            RailNetworkManager.getClientInstance().onPreClientTick();
        }
    }

    public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
    }

    public void func_174959_b(BlockPos pos) {
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_184375_a(EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_190570_a(int id, boolean ignoreRange, boolean p_190570_3_, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
        if (entityIn instanceof EntityMinecart && !entityIn.field_70170_p.field_72995_K) {
            EntityMinecart cart = (EntityMinecart)entityIn;
            CapabilityMinecartDestination cap = (CapabilityMinecartDestination)entityIn.getCapability(CapabilityMinecartDestination.INSTANCE, null);
            if (cap != null) {
                cap.onCartBroken(cart);
            }
        }
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
    }
}

