/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.chunkloading;

import com.google.common.collect.ListMultimap;
import com.minemaarten.signals.Signals;
import com.minemaarten.signals.lib.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import org.apache.commons.lang3.Validate;

public class ChunkLoadManager {
    public static ChunkLoadManager INSTANCE = new ChunkLoadManager();
    public Map<Entity, ChunkLoadEntry> entries = new HashMap<Entity, ChunkLoadEntry>();

    public void init() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)Signals.instance, (ForgeChunkManager.LoadingCallback)new ForgeChunkManager.PlayerOrderedLoadingCallback(){

            public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
                tickets.forEach(ticket -> ChunkLoadManager.this.add(ticket));
            }

            public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
                return tickets;
            }
        });
    }

    private void add(ForgeChunkManager.Ticket ticket) {
        Validate.notNull((Object)ticket);
        ChunkLoadEntry oldEntry = this.entries.put(ticket.getEntity(), new ChunkLoadEntry(ticket));
        if (oldEntry != null) {
            oldEntry.dispose();
        }
    }

    public void update() {
        this.entries.values().removeIf(ChunkLoadEntry::update);
    }

    public boolean markAsChunkLoader(EntityPlayer associatedPlayer, EntityMinecart cart) {
        return this.markAsChunkLoader(associatedPlayer.func_146103_bH().getId().toString(), cart);
    }

    public boolean markAsChunkLoader(String chunkloadingPlayer, EntityMinecart cart) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestPlayerTicket((Object)Signals.instance, (String)chunkloadingPlayer, (World)cart.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        if (ticket != null) {
            ticket.bindEntity((Entity)cart);
            this.add(ticket);
            return true;
        }
        return false;
    }

    public void unmarkAsChunkLoader(EntityMinecart cart) {
        ChunkLoadEntry entry = this.entries.remove(cart);
        if (entry != null) {
            entry.dispose();
        }
    }

    public static class ChunkLoadEntry {
        private final ForgeChunkManager.Ticket ticket;
        private ChunkPos curPos;
        private Set<ChunkPos> curForced = new HashSet<ChunkPos>();

        public ChunkLoadEntry(ForgeChunkManager.Ticket ticket) {
            this.ticket = ticket;
            if (this.update()) {
                Log.warning("Chunkloading cart dead on init!");
            } else {
                Log.debug("Loaded chunkloader for cart at " + (ticket.getEntity() == null ? "[No entity]" : ticket.getEntity().func_180425_c().toString()));
            }
        }

        public boolean update() {
            if (this.ticket.getEntity() == null || this.ticket.getEntity().field_70128_L) {
                Log.warning("No or dead cart for chunkloading ticket found! Disposing...");
                this.dispose();
                return true;
            }
            ChunkPos newPos = new ChunkPos(this.ticket.getEntity().field_70176_ah, this.ticket.getEntity().field_70164_aj);
            if (!newPos.equals((Object)this.curPos)) {
                HashSet<ChunkPos> newForced = new HashSet<ChunkPos>();
                for (int x = newPos.field_77276_a - 1; x <= newPos.field_77276_a + 1; ++x) {
                    for (int z = newPos.field_77275_b - 1; z <= newPos.field_77275_b + 1; ++z) {
                        newForced.add(new ChunkPos(x, z));
                    }
                }
                this.curForced.stream().filter(pos -> !newForced.contains(pos)).forEach(pos -> ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)pos));
                newForced.stream().filter(pos -> !this.curForced.contains(pos)).forEach(pos -> ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)pos));
                this.curForced = newForced;
            }
            return false;
        }

        public void dispose() {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
    }
}

