/*
 * Decompiled with CFR 0.152.
 */
package com.eightbitforest.thebomplugin.render;

import com.eightbitforest.thebomplugin.TheBOMPluginMod;
import com.eightbitforest.thebomplugin.gui.util.GuiHelpers;
import com.eightbitforest.thebomplugin.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    private static float fontScale = -1.0f;

    public static void renderItemStackWithSmallFont(Minecraft minecraft, int x, int y, ItemStack itemStack) {
        if (itemStack != null) {
            if (fontScale == -1.0f) {
                fontScale = TheBOMPluginMod.getInstance().getConfig().textScale;
            }
            RenderUtils.renderItemStackWithSmallFont(minecraft, x, y, itemStack, Integer.toString(itemStack.func_190916_E()), 0xFFFFFF, fontScale);
        }
    }

    public static void renderItemStackWithSmallFont(Minecraft minecraft, int x, int y, ItemStack itemStack, String amount, int color, float fontScale) {
        if (itemStack != null) {
            RenderHelper.func_74520_c();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            minecraft.func_175599_af().func_180450_b(itemStack, x, y);
            minecraft.func_175599_af().func_180453_a(fontRenderer, itemStack, x, y, "");
            RenderUtils.drawItemAmount(fontRenderer, amount, x, y, color, fontScale);
            GlStateManager.func_179084_k();
            RenderHelper.func_74518_a();
        }
    }

    private static void drawItemAmount(FontRenderer fontRenderer, String amount, int x, int y) {
        RenderUtils.drawItemAmount(fontRenderer, amount, x, y, 0xFFFFFF, fontScale);
    }

    private static void drawItemAmount(FontRenderer fontRenderer, String amount, int x, int y, int color, float fontScale) {
        if (amount.length() > 5) {
            try {
                int amountNumber = Integer.parseInt(amount);
                amount = RenderUtils.shortenAmount(amount, amountNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        x = (int)((float)x + 16.0f * (1.0f - fontScale));
        y = (int)((float)y + 16.0f * (1.0f - fontScale));
        GuiHelpers.drawSmallString(fontRenderer, x, y, amount, fontScale, true, color);
    }

    private static String shortenAmount(String amount, int amountNumber) {
        return Utils.formatLong(amountNumber);
    }
}

