/*
 * Decompiled with CFR 0.152.
 */
package com.eightbitforest.thebomplugin.jei.ingredients;

import com.eightbitforest.thebomplugin.TheBOMPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredients;

public class Ingredients
implements IIngredients {
    private final Map<Class, List<List>> inputs = new IdentityHashMap<Class, List<List>>();
    private final Map<Class, List<List>> outputs = new IdentityHashMap<Class, List<List>>();

    public <T> void setInput(Class<? extends T> ingredientClass, T input) {
        this.setInputs(ingredientClass, Collections.singletonList(input));
    }

    public <T> void setInputLists(Class<? extends T> ingredientClass, List<List<T>> inputs) {
        IIngredientRegistry ingredientRegistry = TheBOMPlugin.getInstance().getIngredientRegistry();
        IIngredientHelper ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        ArrayList<List> expandedInputs = new ArrayList<List>();
        for (List<T> input : inputs) {
            List itemStacks = ingredientHelper.expandSubtypes(input);
            expandedInputs.add(itemStacks);
        }
        this.inputs.put(ingredientClass, expandedInputs);
    }

    public <T> void setInputs(Class<? extends T> ingredientClass, List<T> input) {
        IIngredientRegistry ingredientRegistry = TheBOMPlugin.getInstance().getIngredientRegistry();
        IIngredientHelper ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        ArrayList<List> expandedInputs = new ArrayList<List>();
        for (T input1 : input) {
            List itemStacks = ingredientHelper.expandSubtypes(Collections.singletonList(input1));
            expandedInputs.add(itemStacks);
        }
        this.inputs.put(ingredientClass, expandedInputs);
    }

    public <T> void setOutput(Class<? extends T> ingredientClass, T output) {
        this.setOutputs(ingredientClass, Collections.singletonList(output));
    }

    public <T> void setOutputs(Class<? extends T> ingredientClass, List<T> outputs) {
        IIngredientRegistry ingredientRegistry = TheBOMPlugin.getInstance().getIngredientRegistry();
        IIngredientHelper ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        ArrayList<List> expandedOutputs = new ArrayList<List>();
        for (T output : outputs) {
            List expandedOutput = ingredientHelper.expandSubtypes(Collections.singletonList(output));
            expandedOutputs.add(expandedOutput);
        }
        this.outputs.put(ingredientClass, expandedOutputs);
    }

    public <T> void setOutputLists(Class<? extends T> ingredientClass, List<List<T>> outputs) {
        IIngredientRegistry ingredientRegistry = TheBOMPlugin.getInstance().getIngredientRegistry();
        IIngredientHelper ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        ArrayList<List> expandedOutputs = new ArrayList<List>();
        for (List<T> output : outputs) {
            List itemStacks = ingredientHelper.expandSubtypes(output);
            expandedOutputs.add(itemStacks);
        }
        this.outputs.put(ingredientClass, expandedOutputs);
    }

    public <T> List<List<T>> getInputs(Class<? extends T> ingredientClass) {
        List<List<T>> inputs = this.inputs.get(ingredientClass);
        if (inputs == null) {
            return Collections.emptyList();
        }
        return inputs;
    }

    public <T> List<List<T>> getOutputs(Class<? extends T> ingredientClass) {
        List<List<T>> outputs = this.outputs.get(ingredientClass);
        if (outputs == null) {
            return Collections.emptyList();
        }
        return outputs;
    }

    public Map<Class, List> getInputIngredients() {
        IdentityHashMap<Class, List> inputIngredients = new IdentityHashMap<Class, List>();
        for (Map.Entry<Class, List<List>> entry : this.inputs.entrySet()) {
            ArrayList flatIngredients = new ArrayList();
            for (List ingredients : entry.getValue()) {
                flatIngredients.addAll(ingredients);
            }
            inputIngredients.put(entry.getKey(), flatIngredients);
        }
        return inputIngredients;
    }

    public Map<Class, List> getOutputIngredients() {
        IdentityHashMap<Class, List> outputIngredients = new IdentityHashMap<Class, List>();
        for (Map.Entry<Class, List<List>> entry : this.outputs.entrySet()) {
            ArrayList flatIngredients = new ArrayList();
            for (List ingredients : entry.getValue()) {
                flatIngredients.addAll(ingredients);
            }
            outputIngredients.put(entry.getKey(), flatIngredients);
        }
        return outputIngredients;
    }
}

