/*
 * Decompiled with CFR 0.152.
 */
package com.eightbitforest.thebomplugin.gui;

import com.eightbitforest.thebomplugin.TheBOMPluginMod;
import com.eightbitforest.thebomplugin.event.IInventoryChangedEventListener;
import com.eightbitforest.thebomplugin.gui.util.ItemListGuiItemStack;
import com.eightbitforest.thebomplugin.render.RenderUtils;
import com.eightbitforest.thebomplugin.util.Constants;
import com.eightbitforest.thebomplugin.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemListGui
extends Gui
implements IInventoryChangedEventListener {
    private static ItemListGui instance;
    private Minecraft minecraft;
    private TextureManager textureManager;
    private int width;
    private int height;
    private float textScale;
    private boolean isGuiOpen = false;
    private boolean isScrollbarShown = false;
    private ResourceLocation guiBackground;
    private List<ItemListGuiItemStack> baseItems;
    private int topItem = 0;
    private final int textureOffsetX = 1;
    private final int textureOffsetY = 1;
    private final int checkmarkOffsetX = 20;
    private final int checkmarkOffsetY = 2;
    private final int checkmarkX = 46;
    private final int checkmarkY = 0;
    private final int checkmarkWidth = 16;
    private final int checkmarkHeight = 16;
    private final int scrollBarStartX = 18;
    private final int scrollBarStartY = 1;
    private final int scrollBarX = 25;
    private final int scrollBarY = 0;
    private final int scrollBarWidth = 6;
    private final int scrollBarHeight = 9;

    public ItemListGui(Minecraft minecraft) {
        instance = this;
        ScaledResolution scaled = new ScaledResolution(minecraft);
        this.minecraft = minecraft;
        this.textureManager = minecraft.func_110434_K();
        this.width = scaled.func_78326_a();
        this.height = scaled.func_78328_b();
        this.textScale = TheBOMPluginMod.getInstance().getConfig().textScale;
        this.guiBackground = Constants.BOM_INGAME_GUI;
        this.baseItems = new ArrayList<ItemListGuiItemStack>();
    }

    public static boolean isGuiOpen() {
        return ItemListGui.instance.isGuiOpen;
    }

    public void render() {
        if (!ItemListGui.instance.isGuiOpen) {
            return;
        }
        this.textureManager.func_110577_a(this.guiBackground);
        int baseY = this.height / 2 - 77;
        int width = this.isScrollbarShown ? 25 : 18;
        this.func_73729_b(0, baseY, 0, 0, width, 154);
        if (this.isScrollbarShown) {
            int scrollBarOffset = 0;
            if (this.topItem != 0) {
                scrollBarOffset = (int)((float)this.topItem / (float)(this.baseItems.size() - 9) * 143.0f);
            }
            this.func_73729_b(18, baseY + 1 + scrollBarOffset, 25, 0, 6, 9);
        }
        for (int i = 0; i < Math.min(this.baseItems.size(), 9); ++i) {
            ItemListGuiItemStack stack = this.baseItems.get(i + this.topItem);
            int x = 1;
            int y = 1 + baseY + i * 16 + i * 1;
            if (stack.doesInventoryHaveEnough()) {
                RenderUtils.renderItemStackWithSmallFont(this.minecraft, x, y, stack.getCurrentStack(), "\u2714", 8647746, this.textScale);
                continue;
            }
            if (TheBOMPluginMod.getInstance().getConfig().showRemainingItemsInTracker) {
                RenderUtils.renderItemStackWithSmallFont(this.minecraft, x, y, stack.getCurrentStack(), Integer.toString(stack.getRemainingNeeded()), 0xFFFFFF, this.textScale);
                continue;
            }
            RenderUtils.renderItemStackWithSmallFont(this.minecraft, x, y, stack.getCurrentStack());
        }
    }

    public static void dismissItems() {
        ItemListGui.instance.isGuiOpen = false;
        ItemListGui.instance.baseItems.clear();
        TheBOMPluginMod.getInstance().getInventoryChangedEvent().disable();
    }

    public static void showItems(List<List<ItemStack>> items) {
        ItemListGui.instance.isGuiOpen = true;
        ItemListGui.instance.baseItems.clear();
        ItemListGui.instance.topItem = 0;
        TheBOMPluginMod.getInstance().getInventoryChangedEvent().enable();
        for (List<ItemStack> item : items) {
            ItemListGui.instance.baseItems.add(new ItemListGuiItemStack(item));
        }
        instance.onInventoryChanged(ItemListGui.instance.minecraft.field_71439_g.field_71071_by);
        ItemListGui.instance.isScrollbarShown = items.size() > 9;
    }

    @Override
    public void onInventoryChanged(InventoryPlayer inventory) {
        if (ItemListGui.instance.isGuiOpen) {
            for (ItemListGuiItemStack itemListGuiItemStack : this.baseItems) {
                itemListGuiItemStack.setInventoryAmount((IInventory)inventory);
            }
        }
    }

    public void onScroll(int direction) {
        if (this.isGuiOpen && this.isScrollbarShown) {
            this.topItem = Utils.clamp(this.topItem - direction, 0, this.baseItems.size() - 9);
        }
    }
}

