/*
 * Decompiled with CFR 0.152.
 */
package com.eightbitforest.thebomplugin.event;

import com.eightbitforest.thebomplugin.event.IInventoryChangedEventListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BOMInventoryChangedEvent {
    private List<IInventoryChangedEventListener> inventoryChangedEventListeners = new ArrayList<IInventoryChangedEventListener>();
    private boolean enable = false;
    private int timesChanged = -1;

    public void enable() {
        this.enable = true;
    }

    public void disable() {
        this.enable = false;
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.PlayerTickEvent event) {
        InventoryPlayer inventory;
        int newTimesChanged;
        if (this.enable && event.player.func_175144_cb() && this.timesChanged != (newTimesChanged = (inventory = event.player.field_71071_by).func_194015_p())) {
            this.timesChanged = newTimesChanged;
            System.out.println("Inventory changed");
            this.inventoryChanged(inventory);
        }
    }

    private void inventoryChanged(InventoryPlayer inventory) {
        for (IInventoryChangedEventListener listener : this.inventoryChangedEventListeners) {
            listener.onInventoryChanged(inventory);
        }
    }

    public void registerInventoryChangedEventListener(IInventoryChangedEventListener inventoryChangedListener) {
        this.inventoryChangedEventListeners.add(inventoryChangedListener);
    }
}

