/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.item.ItemModBlock;
import vazkii.quark.base.block.IQuarkBlock;

public class BlockQuarkButton
extends BlockButton
implements IQuarkBlock {
    private final String[] variants;
    private final String bareName;
    private final boolean wooden;

    public BlockQuarkButton(String name, boolean wooden) {
        super(wooden);
        this.wooden = wooden;
        this.bareName = name;
        this.variants = new String[]{this.bareName};
        this.func_149663_c(this.bareName);
        this.func_149711_c(0.5f);
        this.func_149672_a(wooden ? SoundType.field_185848_a : SoundType.field_185851_d);
    }

    @Nonnull
    public Block func_149663_c(@Nonnull String name) {
        super.func_149663_c(name);
        this.register(name);
        return this;
    }

    @Override
    public ItemBlock createItemInstance(ResourceLocation regName) {
        return new ItemModBlock((Block)this, regName){
            private final ItemStack button;
            {
                this.button = new ItemStack(Blocks.field_150471_bO);
            }

            public int getItemBurnTime(ItemStack itemStack) {
                return BlockQuarkButton.this.wooden ? TileEntityFurnace.func_145952_a((ItemStack)this.button) : super.getItemBurnTime(itemStack);
            }
        };
    }

    public String getBareName() {
        return this.bareName;
    }

    public String[] getVariants() {
        return this.variants;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getCustomMeshDefinition() {
        return null;
    }

    public EnumRarity getBlockRarity(ItemStack stack) {
        return EnumRarity.COMMON;
    }

    public IProperty[] getIgnoredProperties() {
        return new IProperty[0];
    }

    public IProperty getVariantProp() {
        return null;
    }

    public Class getVariantEnum() {
        return null;
    }

    protected void func_185615_a(EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        if (this.wooden) {
            worldIn.func_184133_a(player, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else {
            worldIn.func_184133_a(player, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    protected void func_185617_b(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        if (this.wooden) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 0.3f, 0.5f);
        } else {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }
}

