/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.tinkeredhegemony.compat;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import pl.asie.tinkeredhegemony.TinkeredHegemony;

@JEIPlugin
public class TinkeredHegemonyJEIPlugin
implements IModPlugin {
    private IIngredientRegistry ingredientRegistry;
    private ArrayList<ItemStack> stacksToRemove;
    private boolean disableInputRecipes;
    private boolean disableOutputRecipes;

    public void register(IModRegistry registry) {
        Configuration config = TinkeredHegemony.getConfig();
        this.disableInputRecipes = config.getBoolean("hideInputRecipes", "jei", false, "If hideDisabledItems is enabled, should recipes which take in the disabled tool as input also be disabled? (f.e. smelting)");
        this.disableOutputRecipes = config.getBoolean("hideOutputRecipes", "jei", true, "If hideDisabledItems is enabled, should recipes which take in the disabled tool as output also be disabled? (f.e. anvil)");
        if (config.getBoolean("hideDisabledItems", "jei", true, "Should disabled items be hidden in JEI?")) {
            IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
            this.ingredientRegistry = registry.getIngredientRegistry();
            this.stacksToRemove = new ArrayList();
            for (Item i : TinkeredHegemony.getDisabledItems()) {
                ItemStack wildcard = new ItemStack(i, 1, Short.MAX_VALUE);
                blacklist.addIngredientToBlacklist((Object)wildcard);
                this.stacksToRemove.add(wildcard);
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        if (this.ingredientRegistry != null && this.stacksToRemove != null && !this.stacksToRemove.isEmpty() && (this.disableInputRecipes || this.disableOutputRecipes)) {
            for (IRecipeCategory category : Lists.newArrayList((Iterable)jeiRuntime.getRecipeRegistry().getRecipeCategories())) {
                for (ItemStack stack : this.stacksToRemove) {
                    if (this.disableOutputRecipes) {
                        IFocus focusOutput = jeiRuntime.getRecipeRegistry().createFocus(IFocus.Mode.OUTPUT, (Object)stack);
                        try {
                            for (Object wrapperObj : jeiRuntime.getRecipeRegistry().getRecipeWrappers(category, focusOutput)) {
                                jeiRuntime.getRecipeRegistry().hideRecipe((IRecipeWrapper)wrapperObj, category.getUid());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!this.disableInputRecipes) continue;
                    IFocus focusInput = jeiRuntime.getRecipeRegistry().createFocus(IFocus.Mode.INPUT, (Object)stack);
                    try {
                        for (Object wrapperObj : jeiRuntime.getRecipeRegistry().getRecipeWrappers(category, focusInput)) {
                            jeiRuntime.getRecipeRegistry().hideRecipe((IRecipeWrapper)wrapperObj, category.getUid());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.ingredientRegistry = null;
        this.stacksToRemove = null;
    }
}

