/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.tinkeredhegemony;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import pl.asie.tinkeredhegemony.TinkeredHegemony;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.tools.TinkerMaterials;

public class MaterialMatcher {
    private static final Map<Item, Collection<Material>> materialMap = new HashMap<Item, Collection<Material>>();

    private static void add(Item i, Material ... materials) {
        materialMap.put(i, (Collection<Material>)ImmutableSet.copyOf((Object[])materials));
    }

    private static Material find(String name) {
        for (Material m : TinkerMaterials.materials) {
            if (!m.identifier.equals(name)) continue;
            return m;
        }
        return null;
    }

    private static Material[] get(Configuration config, String key, String name) {
        String[] names = config.getStringList(key, "materialMap", new String[]{name}, "Will match any material on this list for the head, or all materials if empty.");
        Material[] materials = (Material[])Arrays.stream(names).map(MaterialMatcher::find).filter(Objects::nonNull).toArray(Material[]::new);
        if (config.hasChanged() && TinkeredHegemony.lastSave) {
            config.save();
        }
        if (materials.length == 0) {
            TinkeredHegemony.logger.warn("Could not find material '" + name + "'!");
        }
        return materials;
    }

    static void init(Configuration config) {
        materialMap.clear();
        Material[] woodLike = MaterialMatcher.get(config, "wood", "wood");
        Material[] stoneLike = MaterialMatcher.get(config, "stone", "stone");
        Material[] ironLike = MaterialMatcher.get(config, "iron", "iron");
        Material[] goldLike = MaterialMatcher.get(config, "gold", "cobalt");
        Material[] diamondLike = MaterialMatcher.get(config, "diamond", "manyullyn");
        Material[] leatherLike = MaterialMatcher.get(config, "leather", "paper");
        MaterialMatcher.add(Items.field_151053_p, woodLike);
        MaterialMatcher.add(Items.field_151017_I, woodLike);
        MaterialMatcher.add(Items.field_151039_o, woodLike);
        MaterialMatcher.add(Items.field_151038_n, woodLike);
        MaterialMatcher.add(Items.field_151041_m, woodLike);
        MaterialMatcher.add((Item)Items.field_151031_f, woodLike);
        MaterialMatcher.add(Items.field_151049_t, stoneLike);
        MaterialMatcher.add(Items.field_151018_J, stoneLike);
        MaterialMatcher.add(Items.field_151050_s, stoneLike);
        MaterialMatcher.add(Items.field_151051_r, stoneLike);
        MaterialMatcher.add(Items.field_151052_q, stoneLike);
        MaterialMatcher.add(Items.field_151036_c, ironLike);
        MaterialMatcher.add(Items.field_151019_K, ironLike);
        MaterialMatcher.add(Items.field_151035_b, ironLike);
        MaterialMatcher.add(Items.field_151037_a, ironLike);
        MaterialMatcher.add(Items.field_151040_l, ironLike);
        MaterialMatcher.add(Items.field_151006_E, goldLike);
        MaterialMatcher.add(Items.field_151013_M, goldLike);
        MaterialMatcher.add(Items.field_151005_D, goldLike);
        MaterialMatcher.add(Items.field_151011_C, goldLike);
        MaterialMatcher.add(Items.field_151010_B, goldLike);
        MaterialMatcher.add(Items.field_151056_x, diamondLike);
        MaterialMatcher.add(Items.field_151012_L, diamondLike);
        MaterialMatcher.add(Items.field_151046_w, diamondLike);
        MaterialMatcher.add(Items.field_151047_v, diamondLike);
        MaterialMatcher.add(Items.field_151048_u, diamondLike);
        MaterialMatcher.add((Item)Items.field_151024_Q, leatherLike);
        MaterialMatcher.add((Item)Items.field_151027_R, leatherLike);
        MaterialMatcher.add((Item)Items.field_151026_S, leatherLike);
        MaterialMatcher.add((Item)Items.field_151021_T, leatherLike);
        MaterialMatcher.add((Item)Items.field_151028_Y, ironLike);
        MaterialMatcher.add((Item)Items.field_151030_Z, ironLike);
        MaterialMatcher.add((Item)Items.field_151165_aa, ironLike);
        MaterialMatcher.add((Item)Items.field_151167_ab, ironLike);
        MaterialMatcher.add((Item)Items.field_151169_ag, goldLike);
        MaterialMatcher.add((Item)Items.field_151171_ah, goldLike);
        MaterialMatcher.add((Item)Items.field_151149_ai, goldLike);
        MaterialMatcher.add((Item)Items.field_151151_aj, goldLike);
        MaterialMatcher.add((Item)Items.field_151161_ac, goldLike);
        MaterialMatcher.add((Item)Items.field_151163_ad, goldLike);
        MaterialMatcher.add((Item)Items.field_151173_ae, goldLike);
        MaterialMatcher.add((Item)Items.field_151175_af, goldLike);
    }

    @Nullable
    public static Collection<Material> get(Item i) {
        return materialMap.computeIfAbsent(i, item -> {
            ItemStack[] ingredients = (ItemStack[])ForgeRegistries.RECIPES.getValuesCollection().stream().filter(r -> r.func_77571_b().func_77973_b() == item).flatMap(r -> r.func_192400_c().stream()).flatMap(r -> Arrays.stream(r.func_193365_a())).filter(r -> !r.func_190926_b()).toArray(ItemStack[]::new);
            ImmutableList.Builder mats = new ImmutableList.Builder();
            boolean empty = true;
            for (Material m : TinkerMaterials.materials) {
                Optional match = m.matches(ingredients);
                if (!match.isPresent()) continue;
                mats.add((Object)m);
                empty = false;
            }
            if (!empty) {
                return mats.build();
            }
            TinkeredHegemony.logger.warn("Could not find material for item " + i.getRegistryName() + "!");
            return null;
        });
    }
}

