/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.leveled;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class LeveledMap<K, V> {
    protected final Map<K, V> map;
    protected final TObjectIntMap<K> levelMap = new TObjectIntHashMap();
    protected final List<Map<K, V>> levels = new ArrayList<Map<K, V>>();

    public LeveledMap(Map<K, V> map, Collection<? extends Map<K, V>> levels) {
        this.map = map;
        this.levels.addAll(levels);
    }

    public LeveledMap(int levels) {
        this(new HashMap(), IntStream.range(0, levels).mapToObj(i -> new HashMap()).collect(Collectors.toList()));
    }

    public int levels() {
        return this.levels.size();
    }

    public boolean has(K k, int level) {
        return this.levels.get(level).containsKey(k);
    }

    public V put(K k, V v, int level) {
        if (level >= this.levels() || level < 0) {
            throw new IndexOutOfBoundsException();
        }
        V prev = this.levels.get(level).put(k, v);
        if (level >= this.levelMap.get(k)) {
            this.map.put(k, v);
            this.levelMap.put(k, level);
        }
        return prev;
    }

    public V remove(K k, int level) {
        if (level >= this.levels() || level < 0) {
            throw new IndexOutOfBoundsException();
        }
        V prev = this.levels.get(level).remove(k);
        if (level == this.levelMap.get(k)) {
            this.putFirst(k, level);
        }
        return prev;
    }

    private boolean putFirst(K k, int startLevel) {
        while (--startLevel >= 0) {
            V next = this.levels.get(startLevel).get(k);
            if (next == null) continue;
            this.map.put(k, next);
            this.levelMap.put(k, startLevel);
            return true;
        }
        this.map.remove(k);
        this.levelMap.remove(k);
        return false;
    }

    public void clear() {
        this.map.clear();
        this.levelMap.clear();
        this.levels.forEach(Map::clear);
    }

    public void clear(int level) {
        if (level >= this.levels() || level < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.levels.get(level).clear();
        this.calculateMap();
    }

    private void calculateMap() {
        this.map.clear();
        this.levelMap.clear();
        for (int l = 0; l < this.levels(); ++l) {
            this.map.putAll(this.levels.get(l));
            for (K k : this.levels.get(l).keySet()) {
                this.levelMap.put(k, l);
            }
        }
    }

    public Map<K, V> getMap() {
        return this.map;
    }

    public Map<K, V> getMap(int level) {
        return this.levels.get(level);
    }
}

