/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.files.loading;

import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.FileHandler;
import ivorius.reccomplex.files.RCFiles;
import ivorius.reccomplex.files.loading.FileLoadContext;
import ivorius.reccomplex.files.loading.FileLoaderAdapter;
import ivorius.reccomplex.files.loading.FileSuffixFilter;
import ivorius.reccomplex.files.loading.LeveledRegistry;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class FileLoader
extends FileHandler {
    private final Map<String, FileLoaderAdapter> adapters = new HashMap<String, FileLoaderAdapter>();

    protected static String defaultName(Path path, String customID) {
        return customID != null ? customID : FilenameUtils.getBaseName((String)path.getFileName().toString());
    }

    public FileLoaderAdapter get(String suffix) {
        return this.adapters.get(suffix);
    }

    public FileLoaderAdapter register(FileLoaderAdapter handler) {
        if (this.adapters.containsKey(handler.getSuffix())) {
            throw new IllegalArgumentException();
        }
        return this.adapters.put(handler.getSuffix(), handler);
    }

    public void unregister(FileLoaderAdapter handler) {
        this.adapters.remove(handler.getSuffix());
    }

    public Set<String> keySet() {
        return this.adapters.keySet();
    }

    public boolean has(String id) {
        return this.adapters.containsKey(id);
    }

    public void clearFiles(LeveledRegistry.Level level) {
        this.adapters.values().forEach(h -> h.clearFiles(level));
    }

    public void clearFiles(Collection<String> suffices, LeveledRegistry.Level level) {
        this.adapters.entrySet().stream().filter(entry -> suffices.contains(entry.getKey())).forEach(entry -> ((FileLoaderAdapter)entry.getValue()).clearFiles(level));
    }

    @ParametersAreNonnullByDefault
    public int tryLoadAll(ResourceLocation resourceLocation, FileLoadContext context) {
        return this.tryLoadAll(resourceLocation, context, this.keySet());
    }

    @ParametersAreNonnullByDefault
    public int tryLoadAll(ResourceLocation resourceLocation, FileLoadContext context, Collection<String> suffices) {
        Path path = RCFiles.tryPathFromResourceLocation(resourceLocation);
        return path != null ? this.tryLoadAll(path, context, suffices) : 0;
    }

    @ParametersAreNonnullByDefault
    public int tryLoadAll(Path path, FileLoadContext context) {
        return this.tryLoadAll(path, context, this.keySet());
    }

    @ParametersAreNonnullByDefault
    public int tryLoadAll(Path path, FileLoadContext context, Collection<String> suffices) {
        int[] added = new int[1];
        RCFiles.walkFilesRecursively(path, new FileSuffixFilter(suffices), true, file -> {
            this.tryLoad((Path)file, null, context);
            added[0] = added[0] + 1;
        });
        return added[0];
    }

    /*
     * Exception decompiling
     */
    @ParametersAreNonnullByDefault
    public boolean tryLoad(ResourceLocation resourceLocation, @Nullable String customID, FileLoadContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @ParametersAreNonnullByDefault
    public boolean tryLoad(Path path, @Nullable String customID, FileLoadContext context) {
        try {
            return this.load(path, customID, context);
        }
        catch (UnsupportedOperationException e) {
            RecurrentComplex.logger.error(String.format("Reading unsupported: ?.%s", RCFiles.extension(path)), (Throwable)e);
        }
        catch (Exception e) {
            RecurrentComplex.logger.error("Error loading resource: " + path, (Throwable)e);
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean load(Path path, @Nullable String customID, FileLoadContext context) throws Exception {
        FileLoaderAdapter handler = this.get(RCFiles.extension(path));
        String id = FileLoader.defaultName(path, customID);
        return handler != null && handler.loadFile(path, id, context);
    }
}

