/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.VariableHolder;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.template.TemplateInclusion;
import vazkii.patchouli.client.book.template.VariableAssigner;
import vazkii.patchouli.common.base.PatchouliConfig;

public abstract class TemplateComponent {
    @VariableHolder
    public String group = "";
    public int x;
    public int y;
    @VariableHolder
    public String flag = "";
    @VariableHolder
    public String advancement = "";
    @SerializedName(value="negate_advancement")
    boolean negateAdvancement = false;
    @VariableHolder
    public String guard = null;
    transient boolean isVisible = true;
    transient boolean compiled = false;
    public transient JsonObject sourceObject;
    protected transient IVariableProvider<String> variables;
    protected transient IComponentProcessor processor;
    protected transient TemplateInclusion encapsulation;

    public final void compile(IVariableProvider<String> variables, IComponentProcessor processor, TemplateInclusion encapsulation) {
        if (this.compiled) {
            return;
        }
        if (encapsulation != null) {
            this.x += encapsulation.x;
            this.y += encapsulation.y;
        }
        this.variables = variables;
        this.processor = processor;
        this.encapsulation = encapsulation;
        VariableAssigner.assignVariableHolders(this, variables, processor, encapsulation);
        this.compiled = true;
    }

    public boolean getVisibleStatus(IComponentProcessor processor) {
        if (processor != null && this.group != null && !this.group.isEmpty() && !processor.allowRender(this.group)) {
            return false;
        }
        if (this.guard != null && (this.guard.isEmpty() || this.guard.equalsIgnoreCase("false"))) {
            return false;
        }
        if (!this.flag.isEmpty() && !PatchouliConfig.getConfigFlag(this.flag)) {
            return false;
        }
        if (!this.advancement.isEmpty()) {
            return ClientAdvancements.hasDone(this.advancement) != this.negateAdvancement;
        }
        return true;
    }

    public void build(BookPage page, BookEntry entry, int pageNum) {
    }

    public void onDisplayed(BookPage page, GuiBookEntry parent, int left, int top) {
    }

    public void render(BookPage page, int mouseX, int mouseY, float pticks) {
    }

    public void mouseClicked(BookPage page, int mouseX, int mouseY, int mouseButton) {
    }
}

