/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.money.net;

import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToServer;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.mods.money.net.FTBMoneyNetHandler;
import com.feed_the_beast.mods.money.net.MessageSyncShop;
import com.feed_the_beast.mods.money.shop.Shop;
import com.feed_the_beast.mods.money.shop.ShopEntry;
import com.feed_the_beast.mods.money.shop.ShopTab;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class MessageEditShopEntry
extends MessageToServer {
    private int tab;
    private int id;
    private NBTTagCompound nbt;

    public MessageEditShopEntry() {
    }

    public MessageEditShopEntry(ShopEntry e, boolean delete) {
        this.tab = e.tab.getIndex();
        this.id = e.getIndex();
        this.nbt = delete ? null : e.serializeNBT();
    }

    public NetworkWrapper getWrapper() {
        return FTBMoneyNetHandler.NET;
    }

    public void writeData(DataOut data) {
        data.writeVarInt(this.tab);
        data.writeVarInt(this.id);
        data.writeNBT(this.nbt);
    }

    public void readData(DataIn data) {
        this.tab = data.readVarInt();
        this.id = data.readVarInt();
        this.nbt = data.readNBT();
    }

    public void onMessage(EntityPlayerMP player) {
        if (FTBQuests.canEdit((EntityPlayer)player)) {
            ShopTab t = Shop.SERVER.tabs.get(this.tab);
            if (this.nbt == null) {
                t.entries.remove(this.id);
            } else {
                t.entries.get(this.id).deserializeNBT(this.nbt);
            }
            t.shop.markDirty();
            new MessageSyncShop(t.shop).sendToAll();
        }
    }
}

