/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.money.gui;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfig;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.mods.money.gui.GuiShop;
import com.feed_the_beast.mods.money.net.MessageEditShopTab;
import com.feed_the_beast.mods.money.net.MessageMoveShopTab;
import com.feed_the_beast.mods.money.shop.Shop;
import com.feed_the_beast.mods.money.shop.ShopTab;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ButtonTab
extends Button {
    public final ShopTab tab;

    public ButtonTab(Panel panel, ShopTab t) {
        super(panel, t.title, ItemIcon.getItemIcon((ItemStack)t.icon));
        this.setSize(20, 20);
        this.tab = t;
    }

    public void onClicked(MouseButton button) {
        GuiHelper.playClickSound();
        GuiShop gui = (GuiShop)this.getGui();
        if (button.isLeft()) {
            gui.selectedTab = this.tab;
            gui.refreshWidgets();
        } else if (button.isRight() && this.tab.shop.file.canEdit()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), GuiIcons.SETTINGS, () -> {
                ConfigGroup group = ConfigGroup.newGroup((String)"ftbmoney").setDisplayName((ITextComponent)new TextComponentTranslation("sidebar_button.ftbmoney.shop", new Object[0]));
                ConfigGroup g = group.getGroup("shop").getGroup("tab");
                this.tab.getConfig(g);
                new GuiEditConfig(group, (g1, sender) -> new MessageEditShopTab(this.tab, false).sendToServer()).openGui();
                gui.refreshWidgets();
            }));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]), GuiIcons.UP, () -> {
                new MessageMoveShopTab(this.tab, true).sendToServer();
                int id = this.tab.getIndex();
                if (id > 0) {
                    this.tab.shop.tabs.remove(id);
                    this.tab.shop.tabs.add(id - 1, this.tab);
                }
                gui.refreshWidgets();
            }));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]), GuiIcons.DOWN, () -> {
                new MessageMoveShopTab(this.tab, false).sendToServer();
                int id = this.tab.getIndex();
                if (id < this.tab.shop.tabs.size() - 1) {
                    this.tab.shop.tabs.remove(id);
                    this.tab.shop.tabs.add(id + 1, this.tab);
                }
                gui.refreshWidgets();
            }));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiIcons.REMOVE, () -> gui.openYesNo(I18n.func_135052_a((String)"delete_item", (Object[])new Object[]{this.tab.title}), "", () -> {
                new MessageEditShopTab(this.tab, true).sendToServer();
                this.tab.shop.tabs.remove(this.tab);
                if (gui.selectedTab == this.tab) {
                    gui.selectedTab = Shop.CLIENT.tabs.isEmpty() ? null : Shop.CLIENT.tabs.get(0);
                }
                gui.refreshWidgets();
            })));
            gui.openContextMenu(contextMenu);
        }
    }

    public WidgetType getWidgetType() {
        return ((GuiShop)this.getGui()).selectedTab == this.tab ? WidgetType.MOUSE_OVER : super.getWidgetType();
    }
}

