/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.stackie.handler;

import com.github.lunatrius.stackie.handler.ConfigurationHandler;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;

public class StackingHandler {
    protected boolean stackItems(EntityItem entityItemL, EntityItem entityItemR) {
        if (!this.areEntityItemsEqual(entityItemL, entityItemR)) {
            return false;
        }
        ItemStack itemStackL = entityItemL.func_92059_d();
        ItemStack itemStackR = entityItemR.func_92059_d();
        if (itemStackL.func_190916_E() == ConfigurationHandler.General.maximumStackSize || itemStackR.func_190916_E() == ConfigurationHandler.General.maximumStackSize) {
            return false;
        }
        int itemsIn = Math.min(ConfigurationHandler.General.maximumStackSize - itemStackL.func_190916_E(), itemStackR.func_190916_E());
        itemStackL.func_190920_e(itemStackL.func_190916_E() + itemsIn);
        itemStackR.func_190920_e(itemStackR.func_190916_E() - itemsIn);
        entityItemL.func_92058_a(itemStackL);
        entityItemR.func_92058_a(itemStackR);
        entityItemL.field_70292_b = Math.min(entityItemL.field_70292_b, entityItemR.field_70292_b);
        return itemStackR.func_190916_E() <= 0;
    }

    private boolean areEntityItemsEqual(EntityItem entityItemL, EntityItem entityItemR) {
        if (entityItemL == entityItemR) {
            return false;
        }
        if (entityItemL.field_145804_b == Short.MAX_VALUE || entityItemR.field_145804_b == Short.MAX_VALUE) {
            return false;
        }
        if (entityItemL.field_70292_b == Short.MIN_VALUE || entityItemR.field_70292_b == Short.MIN_VALUE) {
            return false;
        }
        ItemStack itemStackL = entityItemL.func_92059_d();
        ItemStack itemStackR = entityItemR.func_92059_d();
        if (itemStackL == null || itemStackR == null) {
            return false;
        }
        if (!itemStackL.func_77985_e()) {
            return false;
        }
        if (itemStackL.func_190916_E() <= 0 || itemStackR.func_190916_E() <= 0) {
            return false;
        }
        if (itemStackL.func_77973_b() == null) {
            return false;
        }
        if (itemStackL.func_77973_b() != itemStackR.func_77973_b()) {
            return false;
        }
        if (itemStackL.func_77973_b().func_77614_k() && itemStackL.func_77960_j() != itemStackR.func_77960_j()) {
            return false;
        }
        if (itemStackL.func_77942_o() != itemStackR.func_77942_o()) {
            return false;
        }
        return !itemStackL.func_77942_o() || Objects.equals(itemStackL.func_77978_p(), itemStackR.func_77978_p());
    }

    protected boolean stackExperience(EntityXPOrb entityExpOrbL, EntityXPOrb entityExpOrbR) {
        int experienceIn = Math.min(ConfigurationHandler.General.maximumExperience - entityExpOrbL.field_70530_e, entityExpOrbR.field_70530_e);
        entityExpOrbL.field_70530_e += experienceIn;
        entityExpOrbR.field_70530_e -= experienceIn;
        entityExpOrbL.field_70531_b = Math.min(entityExpOrbL.field_70531_b, entityExpOrbR.field_70531_b);
        return entityExpOrbR.field_70530_e <= 0;
    }

    protected boolean areEntitiesClose(Entity a, Entity b) {
        return this.isEqual(a.field_70165_t, b.field_70165_t) && this.isEqual(a.field_70163_u, b.field_70163_u) && this.isEqual(a.field_70161_v, b.field_70161_v);
    }

    private boolean isEqual(double a, double b) {
        return Math.abs(a - b) < ConfigurationHandler.General.distance;
    }
}

