/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.CCubesCore;
import chanceCubes.config.CCubesSettings;
import chanceCubes.util.RewardsUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;

public class NonreplaceableBlockOverride {
    public IBlockState overriddenBlock = BlockAir.func_176220_d((int)0);
    public OverrideType overrideType = OverrideType.ADD;

    public static List<NonreplaceableBlockOverride> parseStrings(String[] strings) {
        ArrayList<NonreplaceableBlockOverride> overrides = new ArrayList<NonreplaceableBlockOverride>();
        for (String string : strings) {
            NonreplaceableBlockOverride toAdd = NonreplaceableBlockOverride.parseString(string);
            if (toAdd == null) continue;
            overrides.add(toAdd);
        }
        return overrides;
    }

    @Nullable
    private static NonreplaceableBlockOverride parseString(@Nonnull String string) {
        try {
            switch (string.toCharArray()[0]) {
                case '+': {
                    return NonreplaceableBlockOverride.addBlock(string.substring(1));
                }
                case '-': {
                    return NonreplaceableBlockOverride.removeBlock(string.substring(1));
                }
                case '#': {
                    return null;
                }
            }
            return NonreplaceableBlockOverride.addBlock(string);
        }
        catch (Exception ex) {
            CCubesCore.logger.warn("Error adding block: " + ex.getMessage());
            CCubesCore.logger.warn("Could not add override for specified block \"" + string + "\", skipping.");
            return null;
        }
    }

    private static NonreplaceableBlockOverride removeBlock(String substring) {
        NonreplaceableBlockOverride output = new NonreplaceableBlockOverride();
        if (substring.matches(".*:.*:[0-9]*")) {
            IBlockState blockState;
            output.overrideType = OverrideType.REMOVE;
            String block = substring.substring(0, substring.lastIndexOf(58) - 1);
            String damage = substring.substring(substring.lastIndexOf(58) + 1);
            int damageValue = Integer.parseInt(damage);
            Block blockActual = Block.func_149684_b((String)block);
            output.overriddenBlock = blockState = RewardsUtil.getBlockStateFromBlockMeta(blockActual, damageValue);
        } else {
            IBlockState blockState;
            output.overrideType = OverrideType.REMOVE;
            Block blockActual = Block.func_149684_b((String)substring);
            output.overriddenBlock = blockState = RewardsUtil.getBlockStateFromBlockMeta(blockActual, 0);
        }
        return output;
    }

    private static NonreplaceableBlockOverride addBlock(String substring) {
        NonreplaceableBlockOverride output = new NonreplaceableBlockOverride();
        if (substring.matches(".*:.*:[0-9]*")) {
            IBlockState blockState;
            output.overrideType = OverrideType.ADD;
            String block = substring.substring(0, substring.lastIndexOf(58));
            String damage = substring.substring(substring.lastIndexOf(58) + 1);
            int damageValue = Integer.parseInt(damage);
            Block blockActual = Block.func_149684_b((String)block);
            output.overriddenBlock = blockState = RewardsUtil.getBlockStateFromBlockMeta(blockActual, damageValue);
        } else {
            IBlockState blockState;
            output.overrideType = OverrideType.ADD;
            Block blockActual = Block.func_149684_b((String)substring);
            output.overriddenBlock = blockState = RewardsUtil.getBlockStateFromBlockMeta(blockActual, 0);
        }
        return output;
    }

    public static String[] parseOverrides(List<NonreplaceableBlockOverride> overrides) {
        ArrayList<String> strings = new ArrayList<String>();
        for (NonreplaceableBlockOverride override : overrides) {
            String toAdd = NonreplaceableBlockOverride.parseOverride(override);
            if (toAdd == null) continue;
            strings.add(toAdd);
        }
        return (String[])strings.toArray();
    }

    @Nullable
    private static String parseOverride(@Nonnull NonreplaceableBlockOverride override) {
        switch (override.overrideType) {
            case ADD: {
                return "+" + override.overriddenBlock.func_177230_c().getRegistryName() + Block.func_176210_f((IBlockState)override.overriddenBlock);
            }
            case REMOVE: {
                return "-" + override.overriddenBlock.func_177230_c().getRegistryName() + Block.func_176210_f((IBlockState)override.overriddenBlock);
            }
        }
        CCubesCore.logger.error("I have no idea how this managed to fall through to the default...");
        return null;
    }

    public static void loadOverrides() {
        try {
            NonreplaceableBlockOverride.purgeOverrides();
            CCubesSettings.nonReplaceableBlocks = CCubesSettings.nonReplaceableBlocksIMC;
            block6: for (NonreplaceableBlockOverride override : CCubesSettings.nonReplaceableBlocksOverrides) {
                switch (override.overrideType) {
                    case ADD: {
                        if (!CCubesSettings.nonReplaceableBlocks.contains(override.overriddenBlock)) {
                            CCubesSettings.nonReplaceableBlocks.add(override.overriddenBlock);
                            CCubesCore.logger.info("Adding " + override.overriddenBlock.func_177230_c().getRegistryName() + ":" + override.overriddenBlock.func_177230_c().func_176201_c(override.overriddenBlock) + " to NRB array.");
                            continue block6;
                        }
                        CCubesCore.logger.info(override.overriddenBlock.func_177230_c().getRegistryName() + ":" + override.overriddenBlock.func_177230_c().func_176201_c(override.overriddenBlock) + " already exists in the NRB array, skipping.");
                        continue block6;
                    }
                    case REMOVE: {
                        if (CCubesSettings.nonReplaceableBlocks.contains(override.overriddenBlock)) {
                            CCubesSettings.nonReplaceableBlocks.remove(override.overriddenBlock);
                            CCubesCore.logger.info("Removing " + override.overriddenBlock.func_177230_c().getRegistryName() + ":" + override.overriddenBlock.func_177230_c().func_176201_c(override.overriddenBlock) + " from NRB array.");
                            continue block6;
                        }
                        CCubesCore.logger.info(override.overriddenBlock.func_177230_c().getRegistryName() + ":" + override.overriddenBlock.func_177230_c().func_176201_c(override.overriddenBlock) + " has already been removed from the NRB array, skipping.");
                        continue block6;
                    }
                }
                CCubesCore.logger.error("Something has gone horribly awry, #BlameDaemonumbra!");
            }
        }
        catch (Exception ex) {
            CCubesCore.logger.warn("Whoops, something went wrong with loading the config, replacing NRB array with safety template...");
            CCubesSettings.nonReplaceableBlocks = CCubesSettings.nonReplaceableBlocksIMC;
            CCubesSettings.nonReplaceableBlocks.addAll(CCubesSettings.backupNRB);
        }
    }

    private static void purgeOverrides() {
        ArrayList<IBlockState> blocksToRemove = new ArrayList<IBlockState>();
        for (IBlockState toRemove : CCubesSettings.nonReplaceableBlocks) {
            if (!NonreplaceableBlockOverride.noLongerExists(toRemove)) continue;
            blocksToRemove.add(toRemove);
            CCubesCore.logger.info("Removing " + toRemove.func_177230_c().getRegistryName() + ":" + toRemove.func_177230_c().func_176201_c(toRemove) + " from Overrides list.");
        }
        CCubesSettings.nonReplaceableBlocks.removeAll(blocksToRemove);
    }

    private static boolean noLongerExists(IBlockState toDetect) {
        for (NonreplaceableBlockOverride override : CCubesSettings.nonReplaceableBlocksOverrides) {
            if (override.overriddenBlock != toDetect) continue;
            return false;
        }
        return true;
    }

    public static enum OverrideType {
        ADD,
        REMOVE,
        MODIFY;

    }
}

