/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FireworkShowReward
extends BaseCustomReward {
    public FireworkShowReward() {
        super("chancecubes:Firework_Show", 0);
    }

    @Override
    public void trigger(World world, BlockPos pos, EntityPlayer player, Map<String, Object> settings) {
        RewardsUtil.executeCommand(world, player, "/time set 15000");
        this.stage1(world, pos, player);
    }

    public void stage1(final World world, final BlockPos pos, final EntityPlayer player) {
        Scheduler.scheduleTask(new Task("Firework_Show_Task_Stage_1", 200, 5){
            double angle;
            {
                super(name, delay, updateTick);
                this.angle = 0.0;
            }

            @Override
            public void callback() {
                FireworkShowReward.this.stage2(world, pos, player);
            }

            @Override
            public void update() {
                this.angle += 0.5;
                FireworkShowReward.this.spawnFirework(world, (double)pos.func_177958_n() + this.angle / 3.0 * Math.cos(this.angle), pos.func_177956_o(), (double)pos.func_177952_p() + this.angle / 3.0 * Math.sin(this.angle));
                FireworkShowReward.this.spawnFirework(world, (double)pos.func_177958_n() + this.angle / 3.0 * Math.cos(this.angle + Math.PI), pos.func_177956_o(), (double)pos.func_177952_p() + this.angle / 3.0 * Math.sin(this.angle + Math.PI));
            }
        });
    }

    public void stage2(final World world, final BlockPos pos, final EntityPlayer player) {
        Scheduler.scheduleTask(new Task("Firework_Show_Task_Stage_2", 200, 5){
            double tick;
            {
                super(name, delay, updateTick);
                this.tick = 0.0;
            }

            @Override
            public void callback() {
                FireworkShowReward.this.stage3(world, pos, player);
            }

            @Override
            public void update() {
                this.tick += 0.5;
                FireworkShowReward.this.spawnFirework(world, (double)pos.func_177958_n() + (this.tick - 20.0), pos.func_177956_o(), pos.func_177952_p() + 1);
                FireworkShowReward.this.spawnFirework(world, (double)pos.func_177958_n() + (20.0 - this.tick), pos.func_177956_o(), pos.func_177952_p() - 1);
            }
        });
    }

    public void stage3(final World world, final BlockPos pos, EntityPlayer player) {
        Scheduler.scheduleTask(new Task("Firework_Show_Task_Stage_2", 200, 3){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                FireworkShowReward.this.spawnFirework(world, pos.func_177958_n() + (RewardsUtil.rand.nextInt(10) - 5), pos.func_177956_o(), pos.func_177952_p() + (RewardsUtil.rand.nextInt(10) - 5));
            }
        });
    }

    public void spawnFirework(World world, double x, double y, double z) {
        world.func_72838_d((Entity)new EntityFireworkRocket(world, x, y, z, RewardsUtil.getRandomFirework()));
    }
}

