/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.itemfilters.filters;

import com.latmod.mods.itemfilters.api.IRegisteredItemFilter;
import com.latmod.mods.itemfilters.api.ItemFiltersAPI;
import com.latmod.mods.itemfilters.filters.ANDFilter;
import com.latmod.mods.itemfilters.filters.AlwaysTrueItemFilter;
import com.latmod.mods.itemfilters.filters.CreativeTabFilter;
import com.latmod.mods.itemfilters.filters.ModFilter;
import com.latmod.mods.itemfilters.filters.NOTFilter;
import com.latmod.mods.itemfilters.filters.ORFilter;
import com.latmod.mods.itemfilters.filters.OreDictionaryFilter;
import com.latmod.mods.itemfilters.filters.XORFilter;
import com.latmod.mods.itemfilters.integration.forestry.ForestryIntegration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;

public abstract class FilterBase
implements IRegisteredItemFilter {
    protected List<ItemStack> cachedItems = null;

    @Override
    public void getValidItems(List<ItemStack> list) {
        if (this.cachedItems == null) {
            NonNullList allItems = NonNullList.func_191196_a();
            for (Item item : Item.field_150901_e) {
                item.func_150895_a(CreativeTabs.field_78027_g, allItems);
            }
            this.cachedItems = new ArrayList<ItemStack>();
            for (ItemStack stack : allItems) {
                if (!this.filter(stack)) continue;
                this.cachedItems.add(stack);
            }
            this.cachedItems = FilterBase.compress(this.cachedItems);
        }
        if (!this.cachedItems.isEmpty()) {
            list.addAll(this.cachedItems);
        }
    }

    @Override
    public void clearCache() {
        this.cachedItems = null;
    }

    protected static List<ItemStack> compress(Collection<ItemStack> items) {
        return items.isEmpty() ? Collections.emptyList() : (items.size() == 1 ? Collections.singletonList(items.iterator().next()) : Arrays.asList(items.toArray(new ItemStack[0])));
    }

    public static void register() {
        ItemFiltersAPI.register("always_true", () -> AlwaysTrueItemFilter.INSTANCE);
        ItemFiltersAPI.register("or", ORFilter::new);
        ItemFiltersAPI.register("and", ANDFilter::new);
        ItemFiltersAPI.register("not", NOTFilter::new);
        ItemFiltersAPI.register("xor", XORFilter::new);
        ItemFiltersAPI.register("ore", OreDictionaryFilter::new);
        ItemFiltersAPI.register("mod", ModFilter::new);
        ItemFiltersAPI.register("creative_tab", CreativeTabFilter::new);
        if (Loader.isModLoaded((String)"forestry")) {
            ForestryIntegration.init();
        }
    }
}

