/*
 * Decompiled with CFR 0.152.
 */
package betterwithengineering.ie;

import betterwithengineering.BWE;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IAxle;
import betterwithmods.api.tile.IAxleTick;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.blocks.mechanical.tile.TileAxle;
import betterwithmods.module.Feature;
import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWatermill;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWindmill;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MechPower
extends Feature {
    private final ResourceLocation IE_MECH_POWER = new ResourceLocation("betterwithengineering", "MECH_POWER");

    public MechPower() {
        this.configName = "IE Mechanical Power";
        TileAxle.tickHandlers.add(new AxleRF());
    }

    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(WindmillCap.class, (Capability.IStorage)new MechStorage(), WindmillCap::new);
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity tile = (TileEntity)event.getObject();
        if (tile instanceof TileEntityWindmill) {
            event.addCapability(this.IE_MECH_POWER, (ICapabilityProvider)new WindmillCap((TileEntityWindmill)tile));
        }
        if (tile instanceof TileEntityWatermill) {
            event.addCapability(this.IE_MECH_POWER, (ICapabilityProvider)new WaterwheelCap((TileEntityWatermill)tile));
        }
    }

    public boolean hasSubscriptions() {
        return true;
    }

    public class AxleRF
    implements IAxleTick {
        public void tick(World world, BlockPos pos, IAxle axle) {
            for (EnumFacing facing : axle.getDirections()) {
                TileEntity acc = Utils.getExistingTileEntity((World)world, (BlockPos)pos.func_177972_a(facing.func_176734_d()));
                if (!(acc instanceof IRotationAcceptor) || world.field_72995_K) continue;
                IRotationAcceptor dynamo = (IRotationAcceptor)acc;
                dynamo.inputRotation((double)axle.getMechanicalOutput(facing) * BWE.ConfigManager.immersiveEngineering.mechPower.rfScale, facing.func_176734_d());
            }
        }
    }

    private static class MechStorage
    implements Capability.IStorage<WindmillCap> {
        private MechStorage() {
        }

        @Nullable
        public NBTBase writeNBT(Capability<WindmillCap> capability, WindmillCap instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<WindmillCap> capability, WindmillCap instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTTagCompound)nbt);
        }
    }

    public static class WaterwheelCap
    implements ICapabilityProvider,
    IMechanicalPower {
        private TileEntityWatermill watermill;

        public WaterwheelCap(TileEntityWatermill watermill) {
            this.watermill = watermill;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityMechanicalPower.MECHANICAL_POWER && facing != null && facing.func_176740_k().func_176722_c();
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
            }
            return null;
        }

        public int getMechanicalOutput(EnumFacing facing) {
            if (this.watermill.getFacing().equals((Object)facing) || this.watermill.getFacing().func_176734_d().equals((Object)facing)) {
                return this.watermill.perTick != 0.0 ? 1 : 0;
            }
            return 0;
        }

        public int getMechanicalInput(EnumFacing facing) {
            return 0;
        }

        public int getMaximumInput(EnumFacing facing) {
            return 0;
        }

        public int getMinimumInput(EnumFacing facing) {
            return 0;
        }

        public Block getBlock() {
            return this.watermill.func_145838_q();
        }

        public World getBlockWorld() {
            return this.watermill.func_145831_w();
        }

        public BlockPos getBlockPos() {
            return this.watermill.func_174877_v();
        }
    }

    public static class WindmillCap
    implements ICapabilitySerializable<NBTTagCompound>,
    IMechanicalPower {
        private TileEntityWindmill windmill;
        private int tick;
        private byte power;
        private boolean rain;
        private boolean thunder;

        public WindmillCap() {
        }

        public WindmillCap(TileEntityWindmill windmill) {
            this.windmill = windmill;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityMechanicalPower.MECHANICAL_POWER && facing != null && facing.func_176740_k().func_176722_c();
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
            }
            return null;
        }

        public int getMechanicalOutput(EnumFacing facing) {
            if (this.windmill == null) {
                return 0;
            }
            byte power = this.thunder ? (byte)3 : (this.rain ? (byte)2 : 1);
            if (this.tick > 600) {
                if (this.isOverworld()) {
                    this.rain = this.windmill.func_145831_w().func_72896_J();
                    this.thunder = this.windmill.func_145831_w().func_72911_I();
                }
                this.tick = 0;
            }
            if (this.windmill.getFacing().equals((Object)facing) && this.power != power) {
                this.power = power;
            }
            return this.power;
        }

        public int getMechanicalInput(EnumFacing facing) {
            return 0;
        }

        public int getMaximumInput(EnumFacing facing) {
            return 0;
        }

        public int getMinimumInput(EnumFacing facing) {
            return 0;
        }

        public Block getBlock() {
            return this.windmill.func_145838_q();
        }

        public World getBlockWorld() {
            return this.windmill.func_145831_w();
        }

        public BlockPos getBlockPos() {
            return this.windmill.func_174877_v();
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("tick", this.tick);
            tag.func_74774_a("power", this.power);
            tag.func_74757_a("rain", this.rain);
            tag.func_74757_a("thunder", this.thunder);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.tick = nbt.func_74762_e("tick");
            this.power = nbt.func_74771_c("power");
            this.rain = nbt.func_74767_n("rain");
            this.thunder = nbt.func_74767_n("thunder");
        }

        public boolean isOverworld() {
            if (this.windmill != null) {
                return this.windmill.func_145831_w().field_73011_w.func_76569_d();
            }
            return false;
        }
    }
}

