/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.scraping;

import com.google.common.collect.Lists;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.Survivalist;
import gigaherz.survivalist.scraping.MessageScraping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.tuple.Triple;

public class ItemBreakingTracker {
    public static final ResourceLocation PROP_KEY = Survivalist.location("ItemBreakingTracker");
    EntityPlayer player;
    World world;
    ItemStack[] equipmentSlots;

    @Nullable
    public static ItemBreakingTracker get(EntityPlayer p) {
        if (p.hasCapability(Handler.TRACKER, null)) {
            return (ItemBreakingTracker)p.getCapability(Handler.TRACKER, null);
        }
        return null;
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new Handler());
    }

    public void init(Entity entity, World world) {
        this.player = (EntityPlayer)entity;
        this.world = world;
    }

    public void before() {
        ArrayList equipment = Lists.newArrayList((Iterable)this.player.func_184193_aE());
        this.equipmentSlots = new ItemStack[equipment.size()];
        for (int i = 0; i < equipment.size(); ++i) {
            ItemStack stack = (ItemStack)equipment.get(i);
            this.equipmentSlots[i] = stack != null ? stack.func_77946_l() : null;
        }
    }

    public Collection<ItemStack> after() {
        if (this.equipmentSlots == null) {
            return Collections.emptyList();
        }
        ArrayList changes = Lists.newArrayList();
        ArrayList equipment = Lists.newArrayList((Iterable)this.player.func_184193_aE());
        for (int i = 0; i < equipment.size(); ++i) {
            ItemStack stack;
            ItemStack stack2 = this.equipmentSlots[i];
            if (stack2 == null || (stack = (ItemStack)equipment.get(i)) != null) continue;
            changes.add(stack2);
        }
        return changes;
    }

    public static class CombatTrackerIntercept
    extends CombatTracker {
        CombatTracker inner;
        EntityPlayer entity;

        public CombatTrackerIntercept(EntityPlayer fighterIn) {
            super((EntityLivingBase)fighterIn);
            this.inner = fighterIn.func_110142_aN();
            this.entity = fighterIn;
        }

        public void func_94547_a(DamageSource damageSrc, float healthIn, float damageAmount) {
            Handler.instance.onTrackDamage(this.entity);
            this.inner.func_94547_a(damageSrc, healthIn, damageAmount);
        }

        public int func_180134_f() {
            return this.inner.func_180134_f();
        }

        public EntityLivingBase func_94550_c() {
            return this.inner.func_94550_c();
        }

        public void func_94545_a() {
            this.inner.func_94545_a();
        }

        public ITextComponent func_151521_b() {
            return this.inner.func_151521_b();
        }

        public EntityLivingBase func_180135_h() {
            return this.inner.func_180135_h();
        }

        public void func_94549_h() {
            this.inner.func_94549_h();
        }
    }

    public static class Handler {
        final Random rnd = new Random();
        @CapabilityInject(value=ItemBreakingTracker.class)
        public static Capability<ItemBreakingTracker> TRACKER;
        public static Handler instance;
        List<Triple<ItemStack, ItemStack, ItemStack>> scrapingRegistry = Lists.newArrayList();

        public Handler() {
            instance = this;
            CapabilityManager.INSTANCE.register(ItemBreakingTracker.class, (Capability.IStorage)new Capability.IStorage<ItemBreakingTracker>(){

                public NBTBase writeNBT(Capability<ItemBreakingTracker> capability, ItemBreakingTracker instance, EnumFacing side) {
                    return new NBTTagCompound();
                }

                public void readNBT(Capability<ItemBreakingTracker> capability, ItemBreakingTracker instance, EnumFacing side, NBTBase nbt) {
                }
            }, () -> null);
            this.registerScrapoingConversions();
        }

        void registerScrapoingConversions() {
            if (ConfigManager.instance.enableToolScraping) {
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151038_n), (Object)new ItemStack(Blocks.field_150344_f), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151017_I), (Object)new ItemStack(Blocks.field_150344_f), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151053_p), (Object)new ItemStack(Blocks.field_150344_f), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151039_o), (Object)new ItemStack(Blocks.field_150344_f), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151041_m), (Object)new ItemStack(Blocks.field_150344_f), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151051_r), (Object)new ItemStack(Blocks.field_150347_e), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151018_J), (Object)new ItemStack(Blocks.field_150347_e), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151049_t), (Object)new ItemStack(Blocks.field_150347_e), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151050_s), (Object)new ItemStack(Blocks.field_150347_e), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151052_q), (Object)new ItemStack(Blocks.field_150347_e), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151037_a), (Object)new ItemStack(Items.field_151042_j), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151019_K), (Object)new ItemStack(Items.field_151042_j), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151036_c), (Object)new ItemStack(Items.field_151042_j), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151035_b), (Object)new ItemStack(Items.field_151042_j), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151040_l), (Object)new ItemStack(Items.field_151042_j), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151011_C), (Object)new ItemStack(Items.field_151043_k), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151013_M), (Object)new ItemStack(Items.field_151043_k), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151006_E), (Object)new ItemStack(Items.field_151043_k), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151005_D), (Object)new ItemStack(Items.field_151043_k), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151010_B), (Object)new ItemStack(Items.field_151043_k), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151047_v), (Object)new ItemStack(Items.field_151045_i), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151012_L), (Object)new ItemStack(Items.field_151045_i), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151056_x), (Object)new ItemStack(Items.field_151045_i), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151046_w), (Object)new ItemStack(Items.field_151045_i), (Object)new ItemStack(Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Items.field_151048_u), (Object)new ItemStack(Items.field_151045_i), (Object)new ItemStack(Items.field_151055_y)));
            }
            if (ConfigManager.instance.enableArmorScraping) {
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151021_T), (Object)new ItemStack(Items.field_151116_aA, 2), (Object)new ItemStack(Items.field_151116_aA)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151024_Q), (Object)new ItemStack(Items.field_151116_aA, 2), (Object)new ItemStack(Items.field_151116_aA)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151027_R), (Object)new ItemStack(Items.field_151116_aA, 2), (Object)new ItemStack(Items.field_151116_aA)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151026_S), (Object)new ItemStack(Items.field_151116_aA, 2), (Object)new ItemStack(Items.field_151116_aA)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Survivalist.tanned_boots), (Object)new ItemStack(Survivalist.tanned_leather, 2), (Object)new ItemStack(Survivalist.tanned_leather)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Survivalist.tanned_helmet), (Object)new ItemStack(Survivalist.tanned_leather, 2), (Object)new ItemStack(Survivalist.tanned_leather)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Survivalist.tanned_chestplate), (Object)new ItemStack(Survivalist.tanned_leather, 2), (Object)new ItemStack(Survivalist.tanned_leather)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack(Survivalist.tanned_leggings), (Object)new ItemStack(Survivalist.tanned_leather, 2), (Object)new ItemStack(Survivalist.tanned_leather)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151029_X), (Object)new ItemStack(Survivalist.chainmail, 2), (Object)new ItemStack(Survivalist.chainmail)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151020_U), (Object)new ItemStack(Survivalist.chainmail, 2), (Object)new ItemStack(Survivalist.chainmail)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151023_V), (Object)new ItemStack(Survivalist.chainmail, 2), (Object)new ItemStack(Survivalist.chainmail)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151022_W), (Object)new ItemStack(Survivalist.chainmail, 2), (Object)new ItemStack(Survivalist.chainmail)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151167_ab), (Object)new ItemStack(Items.field_151042_j, 2), (Object)new ItemStack(Items.field_151042_j)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151028_Y), (Object)new ItemStack(Items.field_151042_j, 2), (Object)new ItemStack(Items.field_151042_j)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151030_Z), (Object)new ItemStack(Items.field_151042_j, 2), (Object)new ItemStack(Items.field_151042_j)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151165_aa), (Object)new ItemStack(Items.field_151042_j, 2), (Object)new ItemStack(Items.field_151042_j)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151151_aj), (Object)new ItemStack(Items.field_151043_k, 2), (Object)new ItemStack(Items.field_151043_k)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151169_ag), (Object)new ItemStack(Items.field_151043_k, 2), (Object)new ItemStack(Items.field_151043_k)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151171_ah), (Object)new ItemStack(Items.field_151043_k, 2), (Object)new ItemStack(Items.field_151043_k)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151149_ai), (Object)new ItemStack(Items.field_151043_k, 2), (Object)new ItemStack(Items.field_151043_k)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151175_af), (Object)new ItemStack(Items.field_151045_i, 2), (Object)new ItemStack(Items.field_151045_i)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151161_ac), (Object)new ItemStack(Items.field_151045_i, 2), (Object)new ItemStack(Items.field_151045_i)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151163_ad), (Object)new ItemStack(Items.field_151045_i, 2), (Object)new ItemStack(Items.field_151045_i)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((Item)Items.field_151173_ae), (Object)new ItemStack(Items.field_151045_i, 2), (Object)new ItemStack(Items.field_151045_i)));
            }
        }

        private void onItemBroken(EntityPlayer player, ItemStack stack) {
            int scrappingLevel = EnchantmentHelper.func_77506_a((Enchantment)Survivalist.scraping, (ItemStack)stack);
            if (player.getClass().getName().equals("com.rwtema.extrautils2.fakeplayer.XUFakePlayer")) {
                return;
            }
            boolean fortune = this.rnd.nextDouble() > 0.9 / (double)(1 + scrappingLevel);
            ItemStack ret = null;
            for (Triple<ItemStack, ItemStack, ItemStack> scraping : this.scrapingRegistry) {
                ItemStack source = (ItemStack)scraping.getLeft();
                if (source.func_77973_b() != stack.func_77973_b()) continue;
                ItemStack good = (ItemStack)scraping.getMiddle();
                ItemStack bad = (ItemStack)scraping.getRight();
                ItemStack itemStack = ret = fortune ? good.func_77946_l() : bad.func_77946_l();
                break;
            }
            if (ret != null) {
                Survivalist.logger.debug("Item broke (" + stack + ") and the player got " + ret + " in return!");
                Survivalist.channel.sendTo((IMessage)new MessageScraping(stack, ret), (EntityPlayerMP)player);
                EntityItem entityitem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, ret);
                entityitem.field_70159_w = 0.0;
                entityitem.field_70179_y = 0.0;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }

        @SubscribeEvent
        public void onPlayerDestroyItem(PlayerDestroyItemEvent ev) {
            if (ev.getEntityPlayer().field_70170_p.field_72995_K) {
                return;
            }
            ItemStack stack = ev.getOriginal();
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemTool) && !(item instanceof ItemSword)) {
                return;
            }
            this.onItemBroken(ev.getEntityPlayer(), stack);
        }

        @SubscribeEvent
        public void onLivingHurt(LivingHurtEvent ev) {
            if (ev.getEntity().field_70170_p.field_72995_K) {
                return;
            }
            if (ev.getEntity() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)ev.getEntityLiving();
                ItemBreakingTracker.get(player).before();
            }
        }

        @SubscribeEvent
        public void entityJoinWorld(EntityJoinWorldEvent ev) {
            if (ev.getEntity().field_70170_p.field_72995_K) {
                return;
            }
            if (ev.getEntity() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)ev.getEntity();
                CombatTrackerIntercept interceptTracker = new CombatTrackerIntercept(player);
                ReflectionHelper.setPrivateValue(EntityLivingBase.class, (Object)player, (Object)((Object)interceptTracker), (String[])new String[]{"field_94063_bt", "combatTracker"});
            }
        }

        public void onTrackDamage(EntityPlayer player) {
            Collection<ItemStack> missing = ItemBreakingTracker.get(player).after();
            for (ItemStack broken : missing) {
                this.onItemBroken(player, broken);
            }
        }

        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> e) {
            final Entity entity = (Entity)e.getObject();
            if (!(entity instanceof EntityPlayerMP)) {
                return;
            }
            if (entity.field_70170_p == null || entity.field_70170_p.field_72995_K) {
                return;
            }
            if (entity.hasCapability(TRACKER, null)) {
                return;
            }
            e.addCapability(PROP_KEY, new ICapabilityProvider(){
                ItemBreakingTracker cap = new ItemBreakingTracker();
                {
                    this.cap.init(entity, entity.field_70170_p);
                }

                public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == TRACKER;
                }

                public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                    if (capability == TRACKER) {
                        return (T)this.cap;
                    }
                    return null;
                }
            });
        }
    }
}

