/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.io;

import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class StringDataReader
extends DataReader {
    public final String string;

    StringDataReader(@Nullable String s) {
        this.string = StringUtils.emptyIfNull(s);
    }

    public String toString() {
        return this.string;
    }

    @Override
    public boolean canRead() {
        return !this.string.isEmpty();
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    public String string(int bufferSize) {
        return this.string;
    }

    @Override
    public List<String> stringList() throws Exception {
        String s;
        BufferedReader reader = new BufferedReader(new StringReader(this.string));
        ArrayList<String> l = new ArrayList<String>();
        while ((s = reader.readLine()) != null) {
            l.add(s);
        }
        return l;
    }

    @Override
    public JsonElement json() throws Exception {
        if (this.string.equals("null")) {
            return JsonNull.INSTANCE;
        }
        if (this.string.equals("true")) {
            return JsonUtils.JSON_TRUE;
        }
        if (this.string.equals("false")) {
            return JsonUtils.JSON_FALSE;
        }
        if (this.string.length() == 2) {
            char c0 = this.string.charAt(0);
            char c1 = this.string.charAt(1);
            if (c0 == '[' && c1 == ']') {
                return new JsonArray();
            }
            if (c0 == '{' && c1 == '}') {
                return new JsonObject();
            }
            if (c0 == '\"' && c1 == '\"') {
                return JsonUtils.JSON_EMPTY_STRING;
            }
        }
        try (StringReader reader = new StringReader(this.string);){
            JsonElement jsonElement = JsonUtils.parse(reader);
            return jsonElement;
        }
    }

    @Override
    public BufferedImage image() {
        throw new IllegalStateException("Can't parse string as image!");
    }
}

