/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore;

import com.google.common.collect.Lists;
import com.tmtravlr.potioncore.PotionCoreEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;

public class PotionCoreHelper {
    public static ArrayList<EntityLivingBase> invulResetEntities = new ArrayList();
    public static final String HEAL_TAG = "Potion Core - Health Fix";
    public static final String HEAL_DELAY_TAG = "Potion Core - Health Fix Delay";
    public static ArrayList<EntityPlayerMP> playersToHeal = new ArrayList();
    public static final String JUMP_BOOST_JUMPING = "Potion Core - Jump Boost Jumping";
    public static final String JUMP_BOOST_HEIGHT_TAG = "Potion Core - Jump Boost Height";
    public static final String JUMP_BOOST_BASE_TAG = "Potion Core - Jump Boost Base";
    public static final String JUMP_BOOST_UPDATED_TAG = "Potion Core - Jump Boost Updated";
    public static float vanillaJumpBoostModifier = 0.75f;
    public static final String INVUL_PROJECTILE_TAG = "Potion Core - Projectile Invulnerability";
    public static final String INVUL_MAGIC_TAG = "Potion Core - Magic Invulnerability";
    public static final UUID TEMP_UUID = UUID.fromString("a6684e4c-f9da-4c3d-9ec1-a07ff26da4ef");
    public static boolean hasServer = false;
    public static int nextId = 1;

    public static void addPotionEffectPositive(EntityLivingBase entity) {
        int r = entity.func_70681_au().nextInt(PotionCoreEffects.GOOD_EFFECTS.size());
        Potion potion = PotionCoreEffects.GOOD_EFFECTS.get(r);
        if (potion.func_76403_b()) {
            entity.func_70690_d(new PotionEffect(potion, 1));
        } else {
            entity.func_70690_d(new PotionEffect(potion, 1200));
        }
    }

    public static void addPotionEffectNegative(EntityLivingBase entity) {
        int r = entity.func_70681_au().nextInt(PotionCoreEffects.BAD_EFFECTS.size());
        Potion potion = PotionCoreEffects.BAD_EFFECTS.get(r);
        if (potion.func_76403_b()) {
            entity.func_70690_d(new PotionEffect(potion, 1));
        } else {
            entity.func_70690_d(new PotionEffect(potion, 1200));
        }
    }

    public static int getNextId() {
        while (Potion.func_188412_a((int)nextId) != null) {
            ++nextId;
        }
        return nextId;
    }

    public static List<PotionEffect> getEffectsFromStack(ItemStack stack) {
        ArrayList effectList = Lists.newArrayList();
        if (stack != null) {
            PotionType potiontype = PotionUtils.func_185191_c((ItemStack)stack);
            if (potiontype != null) {
                effectList.addAll(potiontype.func_185170_a());
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("CustomPotionEffects", 9)) {
                NBTTagList nbttaglist = stack.func_77978_p().func_150295_c("CustomPotionEffects", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                    PotionEffect potioneffect = PotionCoreHelper.readPotionEffectFromTag(nbttagcompound);
                    if (potioneffect == null) continue;
                    effectList.add(potioneffect);
                }
            }
        }
        if (!effectList.isEmpty()) {
            return effectList;
        }
        return PotionUtils.func_185189_a((ItemStack)stack);
    }

    public static NBTTagCompound writePotionToTag(PotionEffect effect) {
        NBTTagCompound tag = new NBTTagCompound();
        if (effect == null || Potion.field_188414_b.func_177774_c((Object)effect.func_188419_a()) == null) {
            return tag;
        }
        tag.func_74778_a("Id", ((ResourceLocation)Potion.field_188414_b.func_177774_c((Object)effect.func_188419_a())).toString());
        tag.func_74768_a("Amplifier", effect.func_76458_c());
        tag.func_74768_a("Duration", effect.func_76459_b());
        tag.func_74757_a("Ambient", effect.func_82720_e());
        tag.func_74757_a("ShowParticles", effect.func_188418_e());
        return tag;
    }

    public static PotionEffect readPotionEffectFromTag(NBTTagCompound tag) {
        Potion potion = null;
        int id = -1;
        if (tag.func_150297_b("Id", 8)) {
            String idString = tag.func_74779_i("Id");
            potion = Potion.func_180142_b((String)idString);
        } else {
            id = tag.func_74771_c("Id") & 0xFF;
            potion = Potion.func_188412_a((int)id);
        }
        if (potion != null) {
            byte j = tag.func_74771_c("Amplifier");
            int k = tag.func_74762_e("Duration");
            boolean ambient = tag.func_74767_n("Ambient");
            boolean showParticles = true;
            if (tag.func_150297_b("ShowParticles", 1)) {
                showParticles = tag.func_74767_n("ShowParticles");
            }
            return new PotionEffect(potion, k, (int)j, ambient, showParticles);
        }
        return null;
    }
}

